# UBB Topic Maintenance : Perl Code

# get assigned style template!

# which forum number is this?
my $this_forum = ("forum_" . "$in{f}");
# get assigned style template!
require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$this_forum}.cgi";

&set_page_elements;

sub delete_topic {
local (@user_profile, @topic_file);
# make sure we have someone logged in
if ($username eq "") {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# user must be an admin or mod
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);

# make sure user is an admin or moderator of this forum
my $is_one = &is_admin_or_mod($in{f}, @user_profile);

if ($is_one ne "true") {
&StandardHTML($vars_wordlets_err{not_admin_or_mod});
}

if ($in{confirm} ne "yes") {
do "$vars_config{NonCGIPath}/Templates/public_confirm_delete.pl";
}  else {
&do_delete_topic;
}

} #end delete_topic

sub do_delete_topic {

require "$vars_config{CGIPath}/ubb_lib_posting.cgi";

#get topic file
my @topic_file = &OpenTopic("$in{t}", "$in{f}");
# this also sets $exact_path!

# get forum info
my @this_forum = &GetForumRecord($in{f});

# get stat line
my @stat_line = split(/\|\|/, $topic_file[0]);
my $replies = $stat_line[2]; chomp($replies);

my $subtract_posts = $replies + 1;

# delete topic file
unlink("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

# delete HTML file
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# unlink threads file
&unlink_topic_from_forum_summary($in{f}, $in{t});

# don't bother adjusting last time file--

# adjust lastnumber.file
my @last_numbers = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# adjust totals
chomp($last_numbers[0]); chomp($last_numbers[1]); chomp($last_numbers[2]);

$last_numbers[1] = $last_numbers[1] - 1;
$last_numbers[1] .= "\n";
$last_numbers[2] = $last_numbers[2] - $subtract_posts;
$last_numbers[2] .= "\n";

if ($in{t} == $last_numbers[0]) {
undef($last_numbers[3]); undef($last_numbers[4]); undef($last_numbers[5]);  undef($last_numbers[6]);
}
$last_numbers[0] .= "\n";

open(FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
print FILE @last_numbers;
close(FILE);

# clear cache
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{f});

# transition
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{f}", "$vars_wordlets{thanks_for_topic_delete}", "$this_forum[1]");

} # end do_delete_topic

sub topic_open_close {
local (@user_profile, @topic_file, $notify, $notify_wording);
local(*FILE);

# make sure we have someone logged in
if ($username eq '') {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# user must be an admin or mod
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);

# make sure user is an admin or moderator of this forum
my $is_one = &is_admin_or_mod($in{f}, @user_profile);
if ($is_one ne 'true') {
&StandardHTML($vars_wordlets_err{not_admin_or_mod});
}

#get topic file
my @topic_file = &OpenTopic("$in{t}", "$in{f}");
# this also sets $exact_path!

# get stat line
my @stat_line = split(/\|\|/, $topic_file[0]);
my $note_field = $stat_line[1]; chomp($note_line);

if ($note_field =~ /N/) {
	$notify = 'N';
}  else {
	$notify = '';
}

# adjust note field
if ($in{ubb} eq 'open_topic') {
$stat_line[1] = "$notify";

# is topic already closed?
if ($note_field !~ /X/i) { &StandardHTML("$vars_wordlets_err{topic_already_open}"); }

$notify_wording = "$vars_wordlets{topic_opened_notify}";

} else {
$stat_line[1] = "X$notify";

# is topic already closed?
if ($note_field =~ /X/i) {
&StandardHTML("$vars_wordlets_err{topic_already_closed}"); }

$notify_wording = "$vars_wordlets{topic_closed_notify}";

}

# adjust @topic_file
$topic_file[0] = join("||", @stat_line);

# update topic file
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");
&lock;
print FILE @topic_file;
&unlock;
close (FILE);
chmod(0666, "$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");

# delete current HTML page
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# clear forum page cache
&ClearSingleForumPageCache($exact_path, $in{f});

# transition
do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;
&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}", "$notify_wording", "$stat_line[4]");


} # end topic_open_close

sub transfer_topic {
local(@user_profile, $hop_to_options, $subject, @old_forum, @new_forum, @topic_file, @new_topic_file, @forumcounter, $last_topic_number, $total_post_count, $total_topic_count, $topic_replies, $topic_posts, @newforumcount, $last_topic_number_n, $total_post_count_n, $total_topic_count_n, $hyphen_date, $post_time);

# make sure we have someone logged in
if ($username eq "") {
&StandardHTML(qq!$vars_wordlets_err{not_logged_in}<P> <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=login">$vars_wordlets{login_now}</A>!); }

# user must be an admin or mod
#verify cookie id
@user_profile = &verify_id_num($username, $password, $user_number);

# make sure user is an admin or moderator of this forum
my $is_one = &is_admin_or_mod($in{f}, @user_profile);

if ($is_one ne 'true') {
&StandardHTML($vars_wordlets_err{not_admin_or_mod});
}

if ($in{ubb} eq 'transfer_topic') {
#validate
my @ValidateArray = ("f", "t", "transfer_to", "move_type");
&Validate(@ValidateArray);
}

#get topic file
@topic_file = &OpenTopic("$in{t}", "$in{f}");
@new_topic_file = @topic_file;
chomp($topic_file[0]);
my @stat_line = split(/\|\|/, $topic_file[0]);
$subject = $stat_line[4];

# make sure topic has not already been transferred before:
if ($stat_line[7] ne '') {
&StandardHTML("$vars_wordlets_err{already_transferred}");
exit;
}

if ($in{ubb} eq 'transfer') {
$hop_to_options = &hop_to_list;
do ("$vars_config{NonCGIPath}/Templates/public_move_topic.pl");
exit;
} else {


# do the transfer--

# can't transfer to categories!
unless ($in{transfer_to}  > 0) { &StandardHTML($vars_wordlets_err{cant_move_to_category}); }

# get info on old forum
@old_forum = &GetForumRecord($in{f});
$topic_replies = $stat_line[2]; chomp($topic_replies);
$topic_posts = $topic_replies + 1;

# get info on new forum
@new_forum = &GetForumRecord($in{transfer_to});

# update stats for old forum

# get forum post count
@forumcounter = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
$last_topic_number = $forumcounter[0]; chomp($last_topic_number);
$total_topic_count = $forumcounter[1]; chomp($total_topic_count);
$total_post_count = $forumcounter[2]; chomp($total_post_count);


if ($in{move_type} eq 'delete') {

# update old lastnumber file

$total_topic_count--;
$total_post_count = $total_post_count - $topic_posts;

if ($last_topic_number == $in{t}) {
undef($forumcounter[3]); undef($forumcounter[4]);
undef($forumcounter[5]); undef($forumcounter[6]);
} else {
chomp($forumcounter[3]); chomp($forumcounter[4]); chomp($forumcounter[5]); chomp($forumcounter[6]);
}

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$last_topic_number\n");
print FILE ("$total_topic_count\n");
print FILE ("$total_post_count\n");
print FILE ("$forumcounter[3]\n");
print FILE ("$forumcounter[4]\n");
print FILE ("$forumcounter[5]\n");
print FILE ("$forumcounter[6]\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# delete old forum threads file
unlink("$vars_config{NonCGIPath}/$exact_path/forum_$in{f}.threads");

# delete old topic
unlink("$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");


} else {

# update topic file in old forum

if ($stat_line[1] =~ /N/) {
	$stat_line[1] = 'NX';
}  else {
	$stat_line[1] = 'X';
}

$stat_line[7] = qq!$vars_wordlets{transfer_note} <A HREF="$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{transfer_to}">$new_forum[1]</A>.!;

# adjust @topic_file
$topic_file[0] = join("||", @stat_line);
$topic_file[0] .= "\n";

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");
lock;
print FILE @topic_file;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$in{t}.cgi");



} # if/else deleting old topic

# delete old forum cache file
&ClearSingleForumPageCache($exact_path, $in{f});

# delete old topic HTML
unlink("$vars_config{NonCGIPath}/cache-$cache_cookie/ubb_files/forums/$exact_path/$in{t}.cgi");

# determine exact path for new forum
if ($new_forum[6] eq 'private') {
$exact_path = "Forum$in{transfer_to}/private-$new_forum[7]";
} else {
$exact_path = "Forum$in{transfer_to}";
}

# get forum post count
local($last_topic_number_n, $total_topic_count_n, $total_post_count_n, $new_topic_number);

if (-e "$vars_config{NonCGIPath}/$exact_path/lastnumber.file") {
@newforumcount = &OpenFileAsArray("$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
$last_topic_number_n = $newforumcount[0]; chomp($last_topic_number_n);
$total_topic_count_n = $newforumcount[1]; chomp($total_topic_count_n);
$total_post_count_n = $newforumcount[2]; chomp($total_post_count_n);

}  else {
$total_post_count_n = 0; $last_topic_number_n = 0; $total_topic_count_n = 0;
}

my @rev_topic_file = reverse(@topic_file);
my $last_post = $rev_topic_file[0];
my @get_dt = split(/\|\|/, $last_post);
$hyphen_date = $get_dt[3];
$post_time = $get_dt[4];

# see if we need to create lasttime file
unless (-e "$vars_config{NonCGIPath}/$exact_path/lasttime.file") {

open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lasttime.file");
&lock;
print FILE ("$hyphen_date\n");
print FILE ("$post_time\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lasttime.file");

} # if we need to create lasttime file

# add transferred topic posts to forum totals
$total_post_count_n = $total_post_count_n + $topic_posts;
$total_topic_count_n = $total_topic_count_n + 1;

if ($last_topic_number_n > 0) {
$last_topic_number_n++;
$new_topic_number = sprintf("%6d", $last_topic_number_n);
$new_topic_number =~tr/ /0/;
}  else {
$new_topic_number = "000001";
}

# add topic to new forum location
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/$new_topic_number.cgi");
&lock;
print FILE @new_topic_file;
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/$new_topic_number.cgi");

# update last number file
open (FILE, ">$vars_config{NonCGIPath}/$exact_path/lastnumber.file");
&lock;
print FILE ("$new_topic_number\n");
print FILE ("$total_topic_count_n\n");
print FILE ("$total_post_count_n\n");
&unlock;
close (FILE);
chmod (0666, "$vars_config{NonCGIPath}/$exact_path/lastnumber.file");

# unlink threads file in new forum
unlink("$vars_config{NonCGIPath}/$exact_path/forum_$in{transfer_to}.threads");

# clear cache:
&ClearSummaryCache;
&ClearSingleForumPageCache($exact_path, $in{transfer_to});

do "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
&set_page_elements;

if ($in{move_type} eq 'keep') {

&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=get_topic&f=$in{f}&t=$in{t}", "$vars_wordlets{topic_transferred}", "$subject");

}  else {

&Transition("$vars_config{CGIURL}/ultimatebb.cgi?ubb=forum&f=$in{f}", "$vars_wordlets{topic_transferred}", "$old_forum[1]");
}

} # if/else transfer/transfer_topic

} # end transfer_topic

# DANGER: Do not remove the next line!
1;