#!/usr/bin/perl

# script used to upgrade from UBB 5 to UBB6

# this script allows you to import all old settings to new UBB6 format
# this script should be run before setting up UBB6

#use CGI ':standard';
use CGI::Carp qw(fatalsToBrowser carpout);
use CGI qw(:cgi-lib :standard);

print qq%Content-type: text/html\n\n%;

eval {

# Get the script location: UNIX / or Windows /
($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");
# Get the script location: Windows \
($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

require "UltBB.setup";

};

if ($@) {
print "Error including required files: $@\n";
print "Make sure these files exist, permissions are set properly, and paths are set correctly.  You should only running this script if you are trying to upgrade from UBB5 to UBB6.  Do not use this script if you are upgrading from a freeware or DEMO edition of the UBB.";
exit;
}

# grab other old-format vars files
require "ubb_library.pl";
require "Date.pl";

&GetDateTime;
# check to make sure we have not already upgraded!
if (-e "$MembersPath/public_names.cgi") {
print "Board already upgraded.  Nothing to do.";
exit;
}

my @digit = ('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9');
srand(time);
my $num1 = rand(@digit); my $num2 = rand(@digit);
my $num3 = rand(@digit); my $num4 = rand(@digit);
my $num5 = rand(@digit); my $num6 = rand(@digit);
my $num7 = rand(@digit); my $num8 = rand(@digit);
my $random_pw = ("$digit[$num1]" . "$digit[$num2]" . "$digit[$num3]" . "$digit[$num4]" . "$digit[$num5]" . "$digit[$num6]" . "$digit[$num7]" . "$digit[$num8]");



open (FILE, ">$VariablesPath/vars_config.cgi") or die("Unable to open vars_config.cgi file for writing.");
print FILE qq!\%vars_config = (\n!;
print FILE qq!CGIPath => "$CGIPath",\n!;
print FILE qq!NonCGIPath => "$NonCGIPath",\n!;
print FILE qq!MembersPath => "$MembersPath",\n!;
print FILE qq!VariablesPath => "$VariablesPath",\n!;
print FILE qq!CGIURL => "$CGIURL",\n!;
print FILE qq!NonCGIURL => "$NonCGIURL",\n!;
print FILE qq!cache_pw => "$random_pw",\n!;
print FILE qq!Cookie_Number => "$LastLoginJulian",\n!;
print FILE qq!BBName => "$BBName",\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_config.cgi");

# convert display vars

open (FILE, ">$VariablesPath/vars_display.cgi") or die("Unable to open vars_display.cgi file for writing.");
print FILE qq!\%vars_display = (\n!;
print FILE qq!HomePageURL => "$HomePageURL",\n!;
print FILE qq!PrivacyURL => "$PrivacyURL",\n!;
print FILE qq!MyHomePage => "$MyHomePage",\n!;
print FILE qq!BBEmail => q~$BBEmail~,\n!;
print FILE qq!ContactURL => "$ContactURL",\n!;
print FILE qq!forum_intro => q~~,\n!;
print FILE qq!ContactLinkType => "$ContactLinkType",\n!;
print FILE qq!DaysPruneDefault => "$DaysPruneDefault",\n!;
print FILE qq!YourCopyrightNotice => q~$YourCopyrightNotice~,\n!;
print FILE qq!CategoryView => "$CategoryView",\n!;
print FILE qq!CategoriesOnly => "$CategoriesOnly",\n!;
print FILE qq!ForumDescriptions => "$ForumDescriptions",\n!;
print FILE qq!ShowPrivacyLink => "$ShowPrivacyLink",\n!;
print FILE qq!showcopytype => "$showcopytype",\n!;
print FILE qq!AllowSignature => "$AllowSignature",\n!;
print FILE qq!AllowSignatureImage => "$AllowSignatureImage",\n!;
print FILE qq!ForumTotalOption => "$ForumTotalOption",\n!;
print FILE qq!ReverseThreads => "$ReverseThreads",\n!;
print FILE qq!DisplayMemberTotal => "$DisplayMemberTotal",\n!;
print FILE qq!NewestMemberWelcome => "yes",\n!;
print FILE qq!AllowIcons => "$AllowIcons",\n!;
print FILE qq!InlineFrame => "$InlineFrame",\n!;
print FILE qq!ForumDisplayMax => "$ForumDisplayMax",\n!;
print FILE qq!HTMLDisplayMax => "$HTMLDisplayMax",\n!;
print FILE qq!HotIcons => "$HotIcons",\n!;
print FILE qq!HotCount => "$HotCount",\n!;
print FILE qq!MembersOnlyAccess => "NO",\n!;
print FILE qq!author_location => "yes",\n!;
print FILE qq!author_reg_date => "yes",\n!;
print FILE qq!author_post_total => "yes",\n!;
print FILE qq!ShowMods => "$ShowMods",\n!;
print FILE qq!homepage_icon_link => "yes",\n!;
print FILE qq!user_ratings => "feature_top",\n!;
print FILE qq!EmailBlock => "$EmailBlock"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_display.cgi");


# convert email vars

open (FILE, ">$VariablesPath/vars_email.cgi") or die("Unable to open vars_email.cgi file for writing.");
print FILE qq!\%vars_email = (\n!;
print FILE qq!UseEmail => "$UseEmail",\n!;
print FILE qq!SMTPEmail => "$SMTPEmail",\n!;
print FILE qq!SendMailLocation => "$SendMailLocation",\n!;
print FILE qq!EmailServer => "$EmailServer",\n!;
print FILE qq!email_format => "html",\n!;
print FILE qq!UBBFriendUSE => "$UBBFriendUSE"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_email.cgi");

# convert forum vars
@old_forums = &OpenForumsFile;
@forums = @old_forums;

#write to new vars_forums.cgi file
open (FILE, ">$VariablesPath/vars_forums.cgi") or die("Unable to open vars_forums.cgi file for writing.");

foreach(@old_forums) {
chomp($_);
@this_forum = split(/\|/, $_);

$this_forum[15] = "date";

# adjust @this_forum
$newforumline = join("|^|", @this_forum);

print FILE "$newforumline\n";
}

close (FILE);
chmod(0777, "$VariablesPath/vars_forums.cgi");

# update categories file
if (-e "$NonCGIPath/categories.file") {
@cats = &OpenFile("$NonCGIPath/categories.file");

open (FILE, ">$NonCGIPath/categories.file") or die("Unable to open categories.file file for writing.");
foreach(@cats) {
chomp($_);
@this_cat = split(/\|\|\|/, $_);

# adjust @this_cat
$newcatline = join("|^|", @this_cat);
print FILE "$newcatline\n";
}
close (FILE);
chmod(0777, "$NonCGIPath/categories.file");

}  # end categories.file update

# add NEW last_number.cgi member file
my @members = &OpenFile("$MembersPath/memberslist.cgi");
my @rev_mems = reverse(@members);
my $last_member = $rev_mems[0];
($name, $num) = split(/\|\!\!\|/, $last_member); chomp($num);

open (FILE, ">$MembersPath/last_number.cgi") or die("Unable to create last_number.cgi file in Members directory.");
print FILE "$num\n";
close (FILE);
chmod(0777, "$MembersPath/last_number.cgi");

# convert registration vars

open (FILE, ">$VariablesPath/vars_registration.cgi") or die("Unable to open vars_registration.cgi file for writing.");
print FILE qq!\%vars_registration = (\n!;
print FILE qq!location_field_use => "OPT",\n!;
print FILE qq!occupation_field_use => "OPT",\n!;
print FILE qq!picture_field_use => "OPT",\n!;
print FILE qq!homepage_field_use => "OPT",\n!;
print FILE qq!interests_field_use => "OPT",\n!;
print FILE qq!custom1_field_use => "DEL",\n!;
print FILE qq!custom2_field_use => "DEL",\n!;
print FILE qq!custom3_field_use => "DEL",\n!;
print FILE qq!custom4_field_use => "DEL",\n!;
print FILE qq!customfield1 => qq~~,\n!;
print FILE qq!customfield2 => qq~~,\n!;
print FILE qq!customfield3 => qq~~,\n!;
print FILE qq!customfield4 => qq~~,\n!;
print FILE qq!icq_field_use => "OPT",\n!;
print FILE qq!aim_field_use => "OPT",\n!;
print FILE qq!signature_field_use => "OPT",\n!;
print FILE qq!EmailVerify => "$EmailVerify",\n!;
print FILE qq!EmailCheck => "$EmailCheck",\n!;
print FILE qq!COPPACheck => "$COPPACheck",\n!;
print FILE qq!COPPAType => "$COPPAType",\n!;
print FILE qq!ModerateRegs => "$ModerateRegs",\n!;
print FILE qq!OnRegsNotifyAdmin => "$OnRegsNotifyAdmin",\n!;
print FILE qq!SuspendRegister => "$SuspendRegister",\n!;
print FILE qq!DisplayRegistration => "$DisplayRegistration",\n!;
print FILE qq!RegsAdminEmail => q~$RegsAdminEmail~,\n!;
print FILE qq!BBRules => q~$BBRules~,\n!;
print FILE qq!COPPAWording => q~$COPPAWording~,\n!;
print FILE qq!COPPAInstructions => q~COPPAInstructions~\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_registration.cgi");

# convert misc vars

open (FILE, ">$VariablesPath/vars_misc.cgi") or die("Unable to open vars_misc.cgi file for writing.");
print FILE qq!\%vars_misc = (\n!;
print FILE qq!ReplyQuote => "$ReplyQuote",\n!;
print FILE qq!BBStatus => "$BBStatus",\n!;
print FILE qq!BBClosedMessage => q~$BBClosedMessage~,\n!;
print FILE qq!censorwords => q~$censorwords~,\n!;
print FILE qq!MemberMinimum => "$MemberMinimum",\n!;
print FILE qq!AdminTitle => q~$AdminTitle~,\n!;
print FILE qq!ModeratorTitle => q~$ModeratorTitle~,\n!;
print FILE qq!MemberTitle => q~$MemberTitle~,\n!;
print FILE qq!JrMemberTitle => q~$JrMemberTitle~,\n!;
print FILE qq!Censor => "$Censor",\n!;
print FILE qq!EditOption => "ON",\n!;
print FILE qq!EditWording => "$EditWording",\n!;
print FILE qq!IP => "$IP",\n!;
print FILE qq!EnglishSubjectCheck => "$EnglishSubjectCheck",\n!;
print FILE qq!edit_public_names => "YES",\n!;
print FILE qq!FloodCheck => "$FloodCheck",\n!;
print FILE qq!FloodCheckSpan => q~$FloodCheckSpan~\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_misc.cgi");

# convert search vars

open (FILE, ">$VariablesPath/vars_search.cgi") or die("Unable to open vars_search.cgi file for writing.");
print FILE qq!\%vars_search = (\n!;
print FILE qq!AllowSearch => "$AllowSearch",\n!;
print FILE qq!AllowTotalSearch => "$AllowTotalSearch",\n!;
print FILE qq!IndexMethod => "$IndexMethod"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_search.cgi");

# convert time vars

open (FILE, ">$VariablesPath/vars_time.cgi") or die("Unable to open vars_time.cgi file for writing.");
print FILE qq!\%vars_time = (\n!;
print FILE qq!TimeZone => "$TimeZone",\n!;
print FILE qq!TimeZoneOffset => "$TimeZoneOffset",\n!;
print FILE qq!DateFormat => "$DateFormat",\n!;
print FILE qq!TimeFormat => "$TimeFormat"\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_time.cgi");

# update mods!
require "$VariablesPath/mods.file";

open (FILE, ">$VariablesPath/vars_mods.cgi") or die("Unable to open vars_mods.cgi file for writing.");

foreach(@old_forums) {

chomp($_);
@this_forum = split(/\|/, $_);
undef(@forum_mods);

$Moderator = ("Forum" . "$this_forum[8]" . "Moderator");
$Moderator = $$Moderator;

if ($Moderator ne '') {
# split up Mod var
@mods = split(/\|\|\^\|\|/, $Moderator);
foreach $mod(@mods) {
chomp($mod);
$mod_number = &GetUserNumber($mod);
push(@forum_mods, $mod_number);
}

$mod_line = join("||^||", @forum_mods);
print FILE ('$Forum' . $this_forum[8] . 'Moderator = ' . '"' . $mod_line . '";' . "\n");
} # if there are mods for forum

}

print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_mods.cgi");

mkdir ("$NonCGIPath/styles", 0777);
chmod(0777, "$NonCGIPath/styles");


# move vars_style_1 to members/styles dir, if necessary
unless (-e "$NonCGIPath/styles/vars_style_1.cgi") {
local($key);
# move file to proper directory...
local(%vars_style);
require "$VariablesPath/vars_style_1.cgi";
open(FILE, ">$NonCGIPath/styles/vars_style_1.cgi");
print FILE qq!\%vars_style = (\n!;
foreach $key(keys %vars_style) {
print FILE qq!$key => q~$vars_style{$key}~,\n!;
}
print FILE qq!);\n!;
print FILE qq!1;\n!;
close(FILE);
chmod(0777, "$NonCGIPath/styles/vars_style_1.cgi");
}



# import old style
require "$VariablesPath/Styles.file";

$Header =~ s/~/\\~/;
$Footer =~ s/~/\\~/;
$HeaderInsert =~ s/~/\\~/;

unless (-e "$NonCGIPath/styles/vars_style_2.cgi") {
open (FILE, ">$NonCGIPath/styles/vars_style_2.cgi") or die("Unable to create vars_style_2.cgi file.");
print FILE qq!\%vars_style = (\n!;
print FILE qq!BGColor => q^$BGColor^,\n!;
print FILE qq!TextColor => q^$TextColor^,\n!;
print FILE qq!LinkColor => q^$LinkColor^,\n!;
print FILE qq!ActiveLinkColor => q^$ActiveLinkColor^,\n!;
print FILE qq!VisitedLinkColor => q^$VisitedLinkColor^,\n!;
print FILE qq!TableBorderColor => q^$TableBorderColor^,\n!;
print FILE qq!TableStripTextColor => q^$TableStripTextColor^,\n!;
print FILE qq!TableColorStrip => q^$TableColorStrip^,\n!;
print FILE qq!TimeColor => q^$TimeColor^,\n!;
print FILE qq!AltColumnColor1 => q^$AltColumnColor1^,\n!;
print FILE qq!AltColumnColor2 => q^$AltColumnColor2^,\n!;
print FILE qq!CategoryStripColor => q^$CategoryStripColor^,\n!;
print FILE qq!CategoryStripTextColor => q^$CategoryStripTextColor^,\n!;
print FILE qq!CopyrightTextColor => q^$CopyrightTextColor^,\n!;
print FILE qq!BBTitleFontColor => q^$BBTitleFontColor^,\n!;
print FILE qq!hr_color => q^$CopyrightTextColor^,\n!;
print FILE qq!FontFace => q^$FontFace^,\n!;
print FILE qq!TableWidth => q^$TableWidth^,\n!;
print FILE qq!TextSize => q^$TextSize^,\n!;
print FILE qq!FDTextSize => q^$FDTextSize^,\n!;
print FILE qq!PageBackground => q^$PageBackground^,\n!;
print FILE qq!BBTitle => q^$BBTitle^,\n!;
print FILE qq!BBTopic => q^$BBTopic^,\n!;
print FILE qq!BBReply => q^$BBReply^,\n!;
print FILE qq!search_graphic => q^searchhead.gif^,\n!;
print FILE qq!profilegif => q^$profilegif^,\n!;
print FILE qq!edit_icon => q^edit_ubb6.gif^,\n!;
print FILE qq!reply_with_quote_icon => q^quote_ubb6.gif^,\n!;
print FILE qq!homepage_icon => q^homepage.gif^,\n!;
print FILE qq!forum_summ_on => q^on.gif^,\n!;
print FILE qq!forum_summ_off => q^off.gif^,\n!;
print FILE qq!table_border_display => q^1^,\n!;
print FILE qq!new_topic_folder => q^closedb.gif^,\n!;
print FILE qq!old_topic_folder => q^closed.gif^,\n!;
print FILE qq!hot_new_topic_folder => q^hotclosedb.gif^,\n!;
print FILE qq!hot_old_topic_folder => q^hotclosed.gif^,\n!;
print FILE qq!old_locked_folder => q^yellockfolder.gif^,\n!;
print FILE qq!new_locked_folder => q^redlockfolder.gif^,\n!;
print FILE qq!ubb_friend => q^ubbfriend.gif^,\n!;
print FILE qq!ubb_friend_mini => q^ubb_friend_mini.gif^,\n!;
print FILE qq!close_topic => q^close_topic.gif^,\n!;
print FILE qq!open_topic => q^open_topic.gif^,\n!;
print FILE qq!move_topic => q^move_topic.gif^,\n!;
print FILE qq!delete_topic => q^delete_topic.gif^,\n!;
print FILE qq!prev_topic => q^prev_topic.gif^,\n!;
print FILE qq!next_topic => q^next_topic.gif^,\n!;
print FILE qq!priv_message => q^priv_message.gif^,\n!;
print FILE qq!user_ratings_1 => q^user_ratings_1.gif^,\n!;
print FILE qq!user_ratings_2 => q^user_ratings_2.gif^,\n!;
print FILE qq!user_ratings_3 => q^user_ratings_3.gif^,\n!;
print FILE qq!user_ratings_4 => q^user_ratings_4.gif^,\n!;
print FILE qq!user_ratings_5 => q^user_ratings_5.gif^,\n!;
print FILE qq!Header => q~$Header~,\n!;
print FILE qq!Footer => q~$Footer~,\n!;
print FILE qq!HeaderInsert => q~$HeaderInsert~,\n!;
print FILE qq!mailgif => q^$mailgif^,\n!;
print FILE qq!thisCharset => q^ISO-8859-1^,\n!;
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$NonCGIPath/styles/vars_style_2.cgi");

# update style_sets file
open (FILE, ">>$VariablesPath/vars_style_sets.cgi") or die("Unable to open vars_style_sets.cgi file for writing.");
print FILE qq!My UBB|^|2\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_style_sets.cgi");

# update template_match file

open (FILE, ">$VariablesPath/vars_template_match.cgi") or die("Unable to open vars_template_match.cgi file for writing.");
print FILE qq!\%template_match = (\n!;
print FILE qq!summary_page => "2",\n!;
print FILE qq!transition => "2",\n!;
print FILE qq!profile => "2",\n!;
print FILE qq!ubb_code => "2",\n!;
print FILE qq!search => "2",\n!;
print FILE qq!faq => "2",\n!;
print FILE qq!registration => "2",\n!;
print FILE qq!email => "1",\n!;
print FILE qq!private_message => "2",\n!;

foreach $forum(@forums) {
chomp($forum);

@each_forum = split(/\|/, $forum);

$forumnum = ("forum_" . "$each_forum[8]");
print FILE qq!$forumnum => "2",\n!;
}
print FILE qq!);\n!;
print FILE qq!1;\n!;
close (FILE);
chmod(0777, "$VariablesPath/vars_template_match.cgi");
} # add new style sheet - imported from old UBB

# finish by deleting old files:
unlink ("$CGIPath/Date.pl");
unlink ("$CGIPath/ubb_library2.pl");
unlink ("$CGIPath/announce.cgi");
unlink ("$CGIPath/archive.cgi");
unlink ("$CGIPath/cpanel.cgi");
unlink ("$CGIPath/cpanel2.cgi");
unlink ("$CGIPath/cpanel3.cgi");
unlink ("$CGIPath/cpanel4.cgi");
unlink ("$CGIPath/edit.cgi");
unlink ("$CGIPath/forumdisplay.cgi");
unlink ("$CGIPath/mail-lib.pl");
unlink ("$CGIPath/postings.cgi");
unlink ("$CGIPath/register_lib.pl");
unlink ("$CGIPath/search.cgi");
unlink ("$CGIPath/ubbmail.cgi");
unlink ("$NonCGIPath/controlpanel.html");
unlink ("$NonCGIPath/forumterms.html");
unlink ("$NonCGIPath/faq.html");
unlink ("$NonCGIPath/ubbcode.html");

# setup new directories
mkdir ("$NonCGIPath/cache-$random_pw", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files/summary", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files/summary");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files/forums", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files/forums");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files/forum_page", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files/forum_page");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files/misc", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files/misc");
mkdir ("$NonCGIPath/cache-$random_pw/ubb_files/counter", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/ubb_files/counter");

mkdir ("$MembersPath/user_ratings", 0777);
chmod(0777, "$MembersPath/user_ratings");
mkdir ("$MembersPath/user_raters", 0777);
chmod(0777, "$MembersPath/user_raters");
mkdir ("$MembersPath/user_posts", 0777);
chmod(0777, "$MembersPath/user_posts");

mkdir ("$MembersPath/pm_users", 0777);
chmod(0777, "$MembersPath/pm_users");
mkdir ("$MembersPath/pm_sent", 0777);
chmod(0777, "$MembersPath/pm_sent");
mkdir ("$MembersPath/pm_topics", 0777);
chmod(0777, "$MembersPath/pm_topics");
mkdir ("$MembersPath/pm_info", 0777);
chmod(0777, "$MembersPath/pm_info");
mkdir ("$MembersPath/pm_ignore", 0777);
chmod(0777, "$MembersPath/pm_ignore");
mkdir ("$MembersPath/pm_buddy", 0777);
chmod(0777, "$MembersPath/pm_buddy");

mkdir ("$NonCGIPath/cache-$random_pw/search_index", 0777);
chmod(0777, "$NonCGIPath/cache-$random_pw/search_index");

unless (-d "$NonCGIPath/cache-$random_pw/ubb_files") {
print "Error: We cannot create a new subdirectory in your UBB Non CGI Directory.  Please check your permissions on that directory.  It should be set to mode 777.  We cannot process until this permissions problem is fixed.";
exit;
}
unless (-d "$MembersPath/pm_info") {
print "Error: We cannot create a new subdirectory in your UBB Members Directory.  Please check your permissions on that directory.  It should be set to mode 777.  We cannot process until this permissions problem is fixed.";
exit;
}

unless (-d "$NonCGIPath/BanLists") {
mkdir ("$NonCGIPath/BanLists", 0777);
chmod(0777, "$NonCGIPath/BanLists");
}

unless (-e "$MembersPath/public_names.cgi") {
open(FILE, ">$MembersPath/public_names.cgi");
print FILE "";
close(FILE);
chmod(0666, "$MembersPath/public_names.cgi");
}


# on screen confirmation
print qq~Conversion From UBB5 to UBB6 Completed!  If you have archives to convert, be sure to run the Archive Import option in the Miscelleous Section of your control panel.  Otherwise, your old archives will not be included in UBB6.  You can now access your UBB Control panel at <A HREF="$CGIURL/cp.cgi">$CGIURL/cp.cgi</A>~;


exit(0);
