#!/usr/bin/perl

# Ultimate Bulletin Board (UBB), Version 6
# Official Release Date for UBB6: March 15, 2001

# First version of UBB created May 7, 1996 (by Ted O'Neill).
# This entire program is copyright Infopop Corporation, 2001.
# For more info on the Ultimate Bulletin Board and other Infopop
# Products/Services, visit: http://www.infopop.com

# Program Author: Ted O'Neill, with assistance from Michael Farris, Dave Dreezer
# Special Thanks to: Rosemary O'Neill, Mark Badolato, Charles Capps, Graeme, Jesus de la Garza, Joe Siegler, Hal, Brett Harris, Kristi Miller, Celeste Combs, everyone who beta-tested, and all of our support moderators!

# UBB6 is dedicated to Edward Kriz.

# You may not distribute this program in any manner, modified or otherwise, without the express, written written consent from Infopop Corporation.

# You may make modifications, but only for your own use and within the confines of the UBB License Agreement (see our website for that).

# You may not distribute "hacks" for the UBB without approval from Infopop.

# Note: if you modify ANY code within the UBB, we at Infopop Corporation cannot offer you support-- thus modify at your own peril :)

#use strict;
use Fcntl ':flock';
use CGI::Carp qw(fatalsToBrowser carpout);
use CGI qw(:cgi-lib :standard);
#use vars qw(%vars_config %vars_misc %vars_registration %vars_forums %vars_styles %vars_display %vars_style %vars_email %vars_time %vars_search %common_words %vars_wordlets %vars_wordlets_err %vars_wordlets_email %vars_wordlets_img %vars_wordlets_date @ubber %vars_pm %GotTime @memberslist @login @session $username $password $last_login_dt $session_login_dt $last_login_j $session_login_j $days_prune $InfopopCopyright $ThisHTML %in %ProfileNumber $memlistopen $CurrentTab %template $template %template_match $Hiddens $Legend $LoginWording $LastLoginTime $MainButtonsLine $TableWidth2 $ContactLine $pubname $user_topic_view $user_number $direct_to $exact_path $TBT $TBB $Header $Footer $EmailHeader $show_logout $instant_jscript %weights $title_wording @memberslist_array $memlistopen $version $version_number $cache_cookie %member_profile $masterCharset);

undef(@ubber); undef(@login); undef(@session); undef($username);
undef($password); undef($last_login_dt); undef($session_login_dt);
undef($last_login_j); undef($session_login_j);
undef($days_prune); undef($ThisHTML); undef(%ProfileNumber); undef($memlistopen);
undef($Hiddens); undef($LastLoginTime); undef($TableWidth2); undef($pubname);
undef($user_topic_view); undef($user_number);
undef($exact_path); undef($Header); undef($Footer); undef($show_logout);
undef(@memberslist_array); undef($memlistopen); undef(%member_profile); undef($cache_cookie); undef(%in);

eval {

# Get the script location: UNIX / or Windows /
($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1");
# Get the script location: Windows \
($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1");

# modify the path for vars_config.cgi if VariablesPath differs from CGIPath:

require "vars_config.cgi";

# no need to ever touch these statements:

require "$vars_config{VariablesPath}/vars_display.cgi";
require "$vars_config{VariablesPath}/vars_misc.cgi";
require "$vars_config{VariablesPath}/vars_email.cgi";
require "$vars_config{VariablesPath}/vars_time.cgi";
require "$vars_config{VariablesPath}/vars_search.cgi";
require "$vars_config{VariablesPath}/vars_pm.cgi";
require "$vars_config{VariablesPath}/vars_registration.cgi";
require "$vars_config{VariablesPath}/vars_template_match.cgi";
require "$vars_config{VariablesPath}/vars_wordlets.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_err.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_img.cgi";
require "$vars_config{VariablesPath}/vars_wordlets_date.cgi";
require "ubb_lib.cgi";
require "ubb_lib_time.cgi";
require "$vars_config{NonCGIPath}/Templates/public_common.pl";
};

if ($@) {
#use Data::Dumper;
#print qq%Content-type: text/html\n\n%;
$masterCharset = "ISO-8859-1" unless $masterCharset;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);
print "<pre>Error including required files: $@ $!\n";#, Dumper \%vars_registration;
print "Make sure these files exist, permissions are set properly, and paths are set correctly.</pre>";
exit;
}

ReadParse();

my $templatefile, $summary;
#if we've gotten this far, we have template_matches
if(($in{ubb} =~ m/^(newtopic|submit_new_topic|get_topic|reply|submit_new_reply|get_ip|delete_topic|close_topic|open_topic|next_topic|transfer|transfer_topic|edit_post|submit_edit|forum)$/) && ($in{f} =~ m/^\d+$/)) {
	my $forumnumber = "forum_"  . $in{f};
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{$forumnumber}.cgi";
} elsif($in{ubb} =~ m/^(recent_user_posts|get_daily|search|do_search)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{search}.cgi";
} elsif($in{ubb} =~ m/^(get_pm|private_message|submit_private_message|pm_prune|pm_delete|pm_reply|submit_pm_reply|ignore_list|buddy_list|do_ignore|do_buddy|update_ignore|update_buddy)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{private_message}.cgi";
} elsif($in{ubb} =~ m/^(faq)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{faq}.cgi";
} elsif($in{ubb} =~ m/^(get_profile|edit_profile|my_profile|my_rating_list|edit_my_profile|rate_member)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{profile}.cgi";
} elsif($in{ubb} =~ m/^(agree|coppa_agree|register_page|underage_register_page|show_coppa_form|submit_registration|login)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{registration}.cgi";
} elsif($in{ubb} =~ m/^(ubb_code_page)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{ubb_code}.cgi";
} elsif($in{ubb} =~ m/^(email|send_topic|lost_password|find_lost)$/) {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{email}.cgi";
} else {
	$templatefile = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{summary_page}.cgi";
	$summary = 1;
} #endelse

do $templatefile;

# If we grabed a template file, reassign the character set
# Otherwise, $masterCharset is called in from ubb_lib
$masterCharset = $vars_style{thisCharset} if $vars_style{thisCharset};


$cache_cookie = $vars_config{cache_pw};

$template = \%template;


# set main buttons options
$MainButtonsLine = &MainButtonOptions;  # in ubb_lib.pl

# set date/time
&GetDateTime;

# counter
&hit_me;

# for misc actions --
my $doer;
if(($template_match{summary_page} ne $template_match{transition}) && ($in{f} ne "")) {
	#one last fix - we need to load the transition template if it's set differently from the summary_page template, which we already loaded
	$doer = "$vars_config{NonCGIPath}/styles/vars_style_$template_match{transition}.cgi";
}

do $doer if($doer && ($summary == 1));

# standard argument
my $ubb = $in{ubb};
my $skip_cookie_check;
my $logoff;


# is forum closed?
if ($vars_misc{BBStatus} ne 'ON') {
&set_page_elements;
#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);


&StandardHTML("$vars_misc{BBClosedMessage}"); exit;
}

if ($ubb eq 'clearcookies') {
require "$vars_config{CGIPath}/ubb_lib_misc.cgi";
&clear_cookies; exit;
} #end clearcookies

if ($ubb eq 'forum_pw_check') {
require "$vars_config{CGIPath}/ubb_forum.cgi";
&forum_pw_check; exit;
} #end forum_pw_check

# perform user login?
if ($ubb eq 'do_login') {
$skip_cookie_check = 'true';

require "$vars_config{CGIPath}/ubb_lib_2.cgi";

my @user_info = &verify_id("$in{username}", "$in{password}");
my $pubname = $user_info[0];
my $dp = $user_info[1];
my $profile_number = $user_info[2];
my $mod_q = $user_info[3]; chomp($mod_q);

if ($vars_display{MembersOnlyAccess} eq 'YES') {
if ($mod_q eq 'Q') {
	# user is registered but not approved!

#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

&StandardHTML("$vars_wordlets_err{awaiting_approval}");
	exit;
}
}

if ($dp eq '') { $dp = "$vars_display{DaysPruneDefault}"; }

my $cookie = cookie(-name=> "ubber$vars_config{Cookie_Number}", -value=> [$in{username}, $in{password}, $pubname, $dp, $profile_number], -path=> '/', -expires=> '+2y');
$username = $in{username};
#print header(-cookie=>[$cookie]);
print header(
	-cookie=>[$cookie],
	-charset => "$masterCharset");

# display refer page
my $clean_cgi = quotemeta($vars_config{CGIURL});
if (($in{refer} ne '') && ($in{refer} !~ /logoff$/) && ($in{refer} !~ /cookies$/) && ($in{refer} !~ /find_lost$/) && ($in{refer} !~ /password$/) && ($in{refer} =~ /^$clean_cgi/) ) {

# take viewer back to topic
&set_page_elements;
&Transition("$in{refer}", "$vars_wordlets{thanks_for_login}", "$in{refer}");
exit;
} else {
$ubb = '';
}
} # end do login

# perform user logoff?
if ($ubb eq 'logoff') {
$skip_cookie_check = 'true';
my $cookieA = cookie(-name=> "ubber$vars_config{Cookie_Number}", -value=> ['', ''], -path=> '/', -expires=> '-2y');
my $cookieB = cookie(-name=> "session$vars_config{Cookie_Number}", -value=> ['', ''], -path=> '/', -expires=> '-2y');
my $cookieC = cookie(-name=> "forumpw$vars_config{Cookie_Number}", -value=> ['', ''], -path=> '/', -expires=> '-2y');
#print header(-cookie=>[$cookieA, $cookieB, $cookieC]);
print header(
	-cookie=>[$cookieA, $cookieB, $cookieC],
	-charset => "$masterCharset",);



# confirm logoff
&set_page_elements;
&StandardHTML($vars_wordlets{logged_off}); exit;

} # end logoff

# retrieve cookies!
@ubber = cookie("ubber$vars_config{Cookie_Number}");
if ($ubber[0] ne '') { $username = $ubber[0]; }
if ($ubber[1] ne '') { $password = $ubber[1]; }
if ($ubber[2] ne '') { $pubname = $ubber[2]; }
if ($ubber[3] ne '') { $user_topic_view = $ubber[3]; }
if ($ubber[4] ne '') { $user_number = $ubber[4]; }

#make sure the user is not forging his cookie to get into a protected area
if (($vars_display{MembersOnlyAccess} eq 'YES') && (@ubber)) {
	my @checkTheProfile = &verify_id_num_2($username,$password,$user_number);
	unless($checkTheProfile[4] =~ /Write/) {
		print header(-charset => "$masterCharset",);
		&StandardHTML($vars_wordlets{user_not_approved});
	}
}

@login = cookie("login$vars_config{Cookie_Number}");
if ($login[0] ne '') { $last_login_dt = $login[0]; }
if ($login[1] ne '') { $last_login_j = $login[1]; }

@session = cookie("session$vars_config{Cookie_Number}");
if ($session[0] ne '') { $session_login_dt = $session[0]; }
if ($session[1] ne '') { $session_login_j = $session[1]; }

# in case this is a new visitor!
if ($last_login_dt eq '') { $last_login_dt = 'NEW'; }

# set login cookie, if necessary

if ($skip_cookie_check ne 'true') {

if ($session_login_dt eq '') {

# set session cookie:
# this is a temp cookie that stores previous last login

my $cookie1 = cookie(-name=> "session$vars_config{Cookie_Number}", -value=> [$last_login_dt, $last_login_j], -path=> '/');

# set new last login
my $cookie2 = cookie(-name=> "login$vars_config{Cookie_Number}", -value=> [$GotTime{LastLoginDT}, $GotTime{LastLoginJulian}], -path=> '/', -expires=> '+1y');

my $cookie3;

# reconfirm user data- in case profile details were changed
if ($username ne '') {
my @this_profile = &verify_id_num_2($username, $password, $user_number);
chomp($this_profile[1]); chomp($this_profile[0]); chomp($this_profile[21]); chomp($this_profile[15]);
if ($this_profile[15] eq '') { $this_profile[15] = "$this_profile[0]"; }
$cookie3 = cookie(-name=> "ubber$vars_config{Cookie_Number}", -value=> [$this_profile[0], $this_profile[1], $this_profile[15], $this_profile[21], $user_number], -path=> '/', -expires=> '+2y');
}

#print header(-cookie=>[$cookie1, $cookie2, $cookie3]);
print header(
	-cookie=>[$cookie1, $cookie2, $cookie3],
	-charset => "$masterCharset");

}  else {

unless (($ubb eq 'submit_registration') || ($ubb eq 'edit_profile')) {

#print qq%Content-type: text/html\n\n%;
print header(
	-charset => "$masterCharset",
	-type => "text/html",
	);

}

}
} #if not do_login

# members only acess check
if ($vars_display{MembersOnlyAccess} eq 'YES') {
if (($username eq '') || ($logoff eq 'true')) {
unless ( ($ubb eq 'agree') || ($ubb eq 'coppa_agree') || ($ubb eq 'register_page') || ($ubb eq 'underage_register_page') || ($ubb eq 'submit_registration')  || ($ubb eq 'lost_password') || ($ubb eq 'find_lost') ) {
&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_login.pl";
exit;
} } }

# all ubb options:

# forum summary
if ($ubb eq '') {
require "$vars_config{CGIPath}/ubb_forum_summary.cgi";
&forum_summary; exit;
}

if ($ubb eq 'login') {
&set_page_elements;
do "$vars_config{NonCGIPath}/Templates/public_login.pl";
exit;
}

if ($ubb eq 'agree') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
&do_agree; exit;
} #end agree

if ($ubb eq 'coppa_agree') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
&coppa_agree; exit;
} #end coppa_agree

if ($ubb eq 'register_page') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
&register_page; exit;
} #end register_page

if ($ubb eq 'underage_register_page') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
&underage_register_page; exit;
} #end underage_register_page


if ($ubb eq 'show_coppa_form') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
if ($vars_registration{COPPAType} eq 'COPPADenied') {
  &StandardHTML("$vars_wordlets_err{age_deny}");
}  else {

require "$vars_config{NonCGIPath}/styles/vars_style_$template_match{registration}.cgi";

&set_page_elements;

my $COPPAInstructions = &ConvertReturns($vars_registration{COPPAInstructions});
do "$vars_config{NonCGIPath}/Templates/public_reg_confirm_kid.pl";
}

exit;
} #end show_coppa_form

if ($ubb eq 'submit_registration') {
require "$vars_config{CGIPath}/ubb_registration.cgi";
&submit_registration; exit;
} #end submit_reg

if ($ubb eq 'forum') {

if ($in{f} =~ /CAT:/) {
my ($j, $cat_number);
($j, $cat_number) = split(/:/, $in{f});
$in{category} = $cat_number;
require "$vars_config{CGIPath}/ubb_forum_summary.cgi";
&forum_summary;
}  else {
require "$vars_config{CGIPath}/ubb_forum.cgi";
&get_forum;
}
exit;
} # end forum

if ($ubb eq 'newtopic') {
require "$vars_config{CGIPath}/ubb_new_topic.cgi";
&new_topic_page; exit;
} #end newtopic

if ($ubb eq 'submit_new_topic') {
require "$vars_config{CGIPath}/ubb_new_topic.cgi";
&submit_new_topic; exit;
} #end submit_new_topic

if ($ubb eq 'get_topic') {
require "$vars_config{CGIPath}/ubb_get_topic.cgi";
&get_topic($in{f}, $in{t}); exit;
} #end get_topic

if ($ubb eq 'reply') {
require "$vars_config{CGIPath}/ubb_new_reply.cgi";
&reply_page; exit;
} #end reply

if ($ubb eq 'submit_new_reply') {
require "$vars_config{CGIPath}/ubb_new_reply.cgi";
&submit_new_reply; exit;
} #end submit_new_reply

if ($ubb eq 'get_profile') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&get_profile; exit;
} #end get_profile

if ($ubb eq 'edit_profile') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&edit_profile; exit;
} #end edit_profile

if ($ubb eq 'get_pm') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&get_pm; exit;
} #end get_pm

if ($ubb eq 'private_message') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&private_message; exit;
} #end private_message

if ($ubb eq 'submit_private_message') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&submit_pm; exit;
} #end submit_pm

if ($ubb eq 'pm_prune') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_prune; exit;
} #end pm_prune

if ($ubb eq 'pm_delete') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_delete; exit;
} #end pm_delete

if ($ubb eq 'pm_reply') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_reply; exit;
} # end pm_reply

if ($ubb eq 'submit_pm_reply') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&submit_pm_reply; exit;
} #end submit_pm_reply

if ($ubb eq 'ignore_list') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_list('ignore'); exit;
} #end ignore_list

if ($ubb eq 'buddy_list') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_list('buddy'); exit;
} #end buddy_list

if ($ubb eq 'do_ignore') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_do_list('ignore'); exit;
} #end do_ignore

if ($ubb eq 'do_buddy') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_do_list('buddy'); exit;
} #end do_buddy

if ($ubb eq 'update_ignore') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_update_list('ignore'); exit;
} #end update_ignore

if ($ubb eq 'update_buddy') {
require "$vars_config{CGIPath}/ubb_pm.cgi";
&pm_update_list('buddy'); exit;
} #end update_buddy

if ($ubb eq 'my_profile') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&my_profile; exit;
} #end my_profile

if ($ubb eq 'my_rating_list') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&my_rating_list; exit;
} #end my_rating_list

if ($ubb eq "recent_user_posts") {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&recent_user_posts; exit;
} #end recent_user_posts

if ($ubb eq 'get_ip') {
require "$vars_config{CGIPath}/ubb_get_topic.cgi";
&get_ip; exit;
} #end get_ip

if ($ubb eq 'delete_topic') {
require "$vars_config{CGIPath}/ubb_topic_maint.cgi";
&delete_topic; exit;
} #end delete_topic

if (($ubb eq 'close_topic') || ($ubb eq 'open_topic')) {
require "$vars_config{CGIPath}/ubb_topic_maint.cgi";
&topic_open_close; exit;
} #end close_topic/open_topic

if ($ubb eq 'next_topic') {
require "$vars_config{CGIPath}/ubb_get_topic.cgi";
&next_topic; exit;
} #end next_topic


if ($ubb eq 'email') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&email_user; exit;
} #end email

if ($ubb eq 'edit_my_profile') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&edit_my_profile; exit;
} #end edit_my_profile

if (($ubb eq 'transfer') || ($ubb eq 'transfer_topic')){
require "$vars_config{CGIPath}/ubb_topic_maint.cgi";
&transfer_topic; exit;
} #end transfer

if ($ubb eq 'edit_post') {
require "$vars_config{CGIPath}/ubb_edit_post.cgi";
&edit_post; exit;
} #end edit_post

if ($ubb eq 'submit_edit') {
require "$vars_config{CGIPath}/ubb_edit_post.cgi";
&submit_edit; exit;
} #end submit_edit

if ($ubb eq 'rate_member') {
require "$vars_config{CGIPath}/ubb_profile.cgi";
&rate_member; exit;
} #end rate_member

if ($ubb eq 'get_daily') {
require "$vars_config{CGIPath}/ubb_search.cgi";
&get_daily; exit;
} #end get_daily

if ($ubb eq 'search') {
require "$vars_config{CGIPath}/ubb_search.cgi";
&search; exit;
} #end search

if ($ubb eq 'do_search') {
require "$vars_config{CGIPath}/ubb_search.cgi";
if  ( ($vars_search{IndexMethod} eq 'PERFORUM')  && ($in{search_forum} eq 'ALL') )  {
&do_search_2;
}  else {
&do_search;
}
exit;
} #end do_search

if ($ubb eq 'send_topic') {
require "$vars_config{CGIPath}/ubb_friend.cgi";
&send_topic; exit;
} #end send_topic

if ($ubb eq 'faq') {
require "$vars_config{CGIPath}/ubb_lib_misc.cgi";
&faq; exit;
} #end faq

if ($ubb eq 'ubb_code_page') {
require "$vars_config{CGIPath}/ubb_lib_misc.cgi";
&ubb_code_page; exit;
} #end ubb_code_page

if ($ubb eq 'lost_password') {
require "$vars_config{CGIPath}/ubb_lib_misc.cgi";
&lost_password; exit;
} #end lost_password

if ($ubb eq 'find_lost') {
require "$vars_config{CGIPath}/ubb_lib_misc.cgi";
&find_lost; exit;
} #end find_lost

# default error-- obviously they do not know where they are going
&StandardHTML("$vars_wordlets_err{dead_end}");

exit(0); # comply with SafePerl


