#!/usr/bin/perl

#
### CHECK UBB SCRIPT - WRITE/DELETE FUNCTIONS ##
#
# Ultimate Bulletin Board is copyright Infopop Corporation (formerly Madrona Park, Inc.), 1997, 1998, 1999, 2000, 2001.
#
#       ------------ ubb6_test.cgi -------------
#
#  This script tests file user permissions
#
#  T H I S  I S  A N   U N S U P P O R T E D  S C R I P T 
#
# Infopop Corporation (formerly Madrona Park, Inc.) offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the UBB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.infopop.com
#
###############################################################
#
# I N S T R U C T I O N S
# 1) transfer this script to your UBB CGI directory
# 2) call it with your web browser i.e. http://www,mydomain.com/mycgi/ubb6_test.cgi
# 3) use the options to check standard function used by UBB
# 4) you may test other directories by manually editing in a path
#  
#
###############################################################


# Do NOT modify anything below this line

$ubb_help_url = 'http://www.ultimatebb.com/cgi-bin/ubb6help00.cgi';

@filestocheck = ('vars_config.cgi','cp_cache.cgi','cp_email.cgi','cp_forums.cgi','cp_index.cgi','cp_lib.cgi','cp_license.cgi','cp_prune.cgi','cp_styles.cgi','cp_users.cgi','cp_wordlets.cgi','ubb_edit_post.cgi','ubb_forum.cgi','ubb_forum_summary.cgi','ubb_friend.cgi','ubb_get_topic.cgi','ubb_lib.cgi','ubb_lib_mail.cgi','ubb_lib_misc.cgi','ubb_lib_posting.cgi','ubb_lib_time.cgi','ubb_new_reply.cgi','ubb_new_topic.cgi','ubb_pm.cgi','ubb_profile.cgi','ubb_registration.cgi','ubb_search.cgi','ubb_setup.cgi','Modules/MIME/Lite.pm','Modules/Net/SMTP.pm');
@filestocheck_UBBDemo = ('vars_config.cgi','cp_cache.cgi','cp_email.cgi','cp_forums.cgi','cp_index.cgi','cp_lib.cgi','cp_prune.cgi','cp_styles.cgi','cp_users.cgi','cp_wordlets.cgi','ubb_edit_post.cgi','ubb_forum.cgi','ubb_forum_summary.cgi','ubb_get_topic.cgi','ubb_lib.cgi','ubb_lib_misc.cgi','ubb_lib_posting.cgi','ubb_lib_time.cgi','ubb_new_reply.cgi','ubb_new_topic.cgi','ubb_profile.cgi','ubb_registration.cgi','ubb_search.cgi','ubb_setup.cgi');
@variablesfiles = ('vars_config.cgi','vars_display.cgi','vars_email.cgi','vars_forums.cgi','vars_misc.cgi','vars_mods.cgi','vars_pm.cgi','vars_registration.cgi','vars_search.cgi','vars_style_1.cgi','vars_style_sets.cgi','vars_template_match.cgi','vars_time.cgi','vars_wordlets.cgi','vars_wordlets_cp.cgi','vars_wordlets_email.cgi','vars_wordlets_err.cgi');



$this_script_name = "ubb6_test.cgi";
$testversion= '2.0';
###############################################################

print ("Content-type: text/html\n\n");

use strict;
use Fcntl ':flock'; 
use CGI ':standard';
use CGI::Carp qw(fatalsToBrowser carpout);
use CGI qw(:cgi-lib);
use File::Basename;
use vars qw(%in %vars_config $DirToCheck $commandtype $manual_DirToCheck $ThisScriptDir $OrigDirToCheck $errortype $Existence_Check_Result $anyerrormessage $errorlabel $Existence_Check_Result $DirNotFound $DirToCheck_ReadWrite $variablefile @filestocheck $variable_file_status $filename $read_write_status $CGIPath $NonCGIPath $MembersPath $VariablesPath $OrigDirToCheck $serverspec $dirwritetest_check $testrequired_check $checkreadwrite_check $checkabsolutes_check  $testversion $OS $pathmessage $help $ThisScriptDir @data $mode @variablesfiles $errormessage $servertype $version @filestocheck_UBBDemo $ubb_help_url $servertype $unknown $junk $this_script_name $warning);



  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
if ($ENV{'REQUEST_METHOD'} !~ /POST/i) {

	if ($ENV{'QUERY_STRING'} ne '') {

		($in{'action'},$DirToCheck,$commandtype) = &decode_query($ENV{'QUERY_STRING'}); # check for q and p commands

		$DirToCheck =~ s/\\/\//g; # leaning toothpicks

		if ( ($in{'action'} eq 'set_manual_paths') || ($commandtype eq 'o') ) {

			$manual_DirToCheck = $DirToCheck; # save value

			&getinfo; # get all standard ENV info but this will overwrite $DirtoCheck

			$DirToCheck = $manual_DirToCheck;
			$DirToCheck =~ s/\\/\//g; # leaning toothpicks
			$DirToCheck =~ s/\s+$//sg; # rem leading and trailing spaces
			$DirToCheck =~ s/^\s+//sg;

			if ($DirToCheck =~ /(.*)/){ # untaint
				$DirToCheck = $1;	
			}

			&CheckBadChars($DirToCheck); # no funny characters or commands
			&print_headers;
  			&print_test_form;
 			exit(0);	

		} # end if
	}
	else {
		&getinfo; # decode $ENV variables	
		$DirToCheck =~ s/\\/\//g; # leaning toothpicks
		&print_headers;
  		&print_test_form;
 		exit(0);
	}

}# end if


else { # this is POST of data from form
	&getinfo; # basic info from ENV
	&ReadParse(); # parse using same system as UBB
	$DirToCheck = $in{'absolutepath'}; # take input from form 
}

# clean up and check path supplied

$DirToCheck =~ s/\s+$//sg; # rem leading and trailing spaces
$DirToCheck =~ s/^\s+//sg;
	if ($DirToCheck =~ /(.*)/){ # untaint
		$DirToCheck = $1;	
	}
&CheckBadChars($DirToCheck); # no funny characters or commands


$ThisScriptDir = &getThisScriptDir();# get *this* CGI Script Directory path
$OrigDirToCheck = $DirToCheck; # keep a copy of this global va



&print_headers;
&print_table_top;

if($DirToCheck eq '') { # a missing path or PERLIS did not provide any path to check for
  $errortype = 'paths';
  &parse_help('paths');
  &print_result_row ('Path Missing!','There is no absolute path to check','Click back to enter an absolute path manually and submit again','paths','solution:');
  &print_table_bottom;
  #print "</table>";  #end code
  exit;
}

# or continue with selected tests

# Always Test for Existence of Directory selected

($Existence_Check_Result,$anyerrormessage,$errortype,$errorlabel) = &checkDirExistence($DirToCheck); # does it exist?
&print_result_row ('Path',$Existence_Check_Result,$anyerrormessage,$errortype,$errorlabel);


# Option 1. Test for R/W/Append, Mkdir/Rmdir in the directory selected

if ($in{'action'} eq 'dirwritetest') { # test read, write, append delete, mkdir, rmdir

  unless ($DirNotFound){ # $DirNotFound means the directory doesn't exist so don't bother with this test
	($DirToCheck_ReadWrite,$anyerrormessage,$errortype,$errorlabel)= &checkdirReadWrite($DirToCheck);
	  &print_result_row ('Directory Read/Write?',$DirToCheck_ReadWrite,$anyerrormessage,$errortype,$errorlabel);
  }# end unless

}# end of option 1  directory write test




# OPTION 2. Test for Required files *in the directory* selected

if ($in{'action'} eq 'testrequired') { # check each library or config file for availability
 	
 	&isThisFreeware(); # change @filestocheck to match Freeware 'requires'

	foreach $variablefile(@filestocheck){	
	  undef($anyerrormessage);
	  undef($errortype);
	  undef($errorlabel);
	  ($variable_file_status,$anyerrormessage,$errortype,$errorlabel) = &checkRequired_Files($variablefile);	
	  &print_result_row ($variablefile,$variable_file_status,$anyerrormessage,$errortype,'');
	}
} # end Option 2


# OPTION 3. Test for R/W, of 4 variable files *in the directory* selected
if ($in{'action'} eq 'checkreadwrite') {

 foreach $filename(@variablesfiles){
 	undef($read_write_status);
 	undef($anyerrormessage);
 	undef($errortype);
 	undef($errorlabel); 	
 	($read_write_status,$anyerrormessage,$errortype,$errorlabel) = &check_variable_file_readwrite($filename);
	&print_result_row ($filename,$read_write_status,$anyerrormessage,$errortype,$errorlabel);
 }	
} # end Option 3


# Option 4. Test Absolute paths in a vars_config,cgi *if found*.

if ($in{'action'} eq 'checkabsolutes') { # check absolute paths if defined in vars_config,cgi

eval(require "vars_config.cgi");

 if ($@){
 	 $anyerrormessage = "Are you sure you are looking in the directory where vars_config,cgi is ?";
 	 $errortype = "paths";
 	 $errorlabel = "comment:";
  	 &print_result_row ('vars_config,cgi','not found in this directory',$anyerrormessage,'paths',$errorlabel);
 }
 
 else { # continue only if there's no problem with the 'require' vars_config,cgi

	if (-e "$vars_config{'CGIPath'}/ultimatebb.cgi"){
  	  &print_result_row ('CGI Directory Path OK','There is a correct path in general settings',$errormessage,$errortype);
	 }
	else {
 	  &print_result_row ('CGI Directory Path','has not been defined sucessfully in the control panel',$errormessage,'paths');	
	}

	if ($vars_config{'NonCGIPath'} ne '') {
	($DirToCheck_ReadWrite,$anyerrormessage)= &checkdirReadWrite($vars_config{'NonCGIPath'});
 	   &print_result_row ('NonCGI Directory Path OK',$DirToCheck_ReadWrite,$anyerrormessage,$errortype);
	}
	else {
 	   &print_result_row ('NonCGI Directory Path','has not been defined sucessfully in the control panel',$anyerrormessage,'paths');	
	}

	if ($vars_config{'MembersPath'} ne '') {
  	  ($DirToCheck_ReadWrite,$anyerrormessage)= &checkdirReadWrite($vars_config{'MembersPath'});
  	  &print_result_row ('Members Directory Path OK',$DirToCheck_ReadWrite,$anyerrormessage,$errorlabel);
	}
	else {
 	  &print_result_row ('Members Directory Path','has not been defined sucessfully in the control panel',$anyerrormessage,'paths');	
	}
	
	
	if (-e "$vars_config{'VariablesPath'}/vars_config.cgi"){
  	  &print_result_row ('Variables Directory Path Found','There is a correct path in general settings',$anyerrormessage,$errortype);
	 }
	else {
 	  &print_result_row ('Variables Directory Path','has not been defined sucessfully in the control panel',$errormessage,'paths');	
	}
	

 } # end else continue if ...
	
} # end check absolute paths check


&print_result_row ('Next Action:',"<a href=javascript:history.go(-1)>go back</a>  &#149;  <a href=$ENV{'SCRIPT_NAME'}?q=0&p=$OrigDirToCheck>more tests with this path</a>  &#149; <a href=$ENV{'SCRIPT_NAME'}>full reset</a>",'','nohelp');

&print_table_bottom;


# END 

exit(0);

##############################################
# S U B R O U T I N E S  #1

sub error {
 my $message = shift;	
 print "</p>$message<p>\n\n";	
}



sub print_test_form {

eval{require "ubb_lib.cgi"};
if ($] < 5.004) {
	$warning = "<b>Warning:</b> UBB6 will NOT work without Perl 5.004 or higher";
}

	
print <<"EOF";	

<body bgcolor="#FFFFFF">
<form method="post" action="$ENV{'SCRIPT_NAME'}" name="testperms">
<table border=0 cellpadding=0 cellspacing=0 width="95%"align=center><TR><td bgcolor="#000000">
  <table width="100%" cellspacing="1" cellpadding="4" border=0>
    <tr bgcolor class="rowcolor"> 
      <td colspan="2"><b><font color="#FFFFFF" class="title">UBB6 Permissions &amp; 
        Paths Diagnostic Script</font></b></td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef"  align="right">UBB&nbsp;Version</td>
      <td width="80%" bgcolor="#FFFFFF">$version &nbsp;</td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef"  align="right">Perl&nbsp;Version</td>
      <td width="80%" bgcolor="#FFFFFF">$]&nbsp; $warning</td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef"  align="right">Server&nbsp;Type</td>
      <td width="80%" bgcolor="#FFFFFF">$serverspec &nbsp;</td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef" align="right">check&nbsp;path:</td>
      <td width="80%" bgcolor="#FFFFFF"> 
        <input type="text" name="absolutepath" size="60" value="$DirToCheck">
      </td>
    </tr>
        <tr>
      <td width="20%" bgcolor="#efefef" align="right">1.</td>
      <td width="80%" bgcolor="#FFFFFF">
        <input type="radio" name="action" value="dirwritetest"$dirwritetest_check>
        check permission to write new files in this directory</td>
    </tr>
    <tr>
      <td width="20%" bgcolor="#efefef" align="right">2.</td>
      <td width="80%" bgcolor="#FFFFFF">
        <input type="radio" name="action" value="testrequired"$testrequired_check>
        check for the 'required' files in both the CGI and <u>this</u> directory</td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef" align="right">3.</td>
      <td width="80%" bgcolor="#FFFFFF"> 
        <input type="radio" name="action" value="checkreadwrite"$checkreadwrite_check>
        check my read/write permissions on all the variables files </td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef" align="right">4.</td>
      <td width="80%" bgcolor="#FFFFFF">
        <input type="radio" name="action" value="checkabsolutes"$checkabsolutes_check>
        check my absolute paths in general settings if available </td>
    </tr>
    <tr> 
      <td width="20%" bgcolor="#efefef">&nbsp;</td>
      <td width="80%" bgcolor="#FFFFFF">
        <input type="submit" name="Submit" value="Submit">
        <input type="reset" name="reset" value="Reset">
      </td>
    </tr>
    <tr class="rowcolor"> 
      <td width="20%"align="right"><font color="#FFFFFF">version $testversion</font></td>
      <td width="80%" align="right"><font color="#FFFFFF">&copy; 2001 Infopop 
        Corporation All Rights Reserved</font></td>
    </tr>
  </table>
  </TD></TR></TABLE>
</form>
</body>
</html>

EOF
	
}


## develperms subroutines

sub getThisScriptDir { # get working directory of cgi script 

my $ThisScriptDir;

if ($ENV{'PATH_TRANSLATED'}){
$ThisScriptDir = dirname($ENV{'PATH_TRANSLATED'});	
}
elsif ($ENV{'SCRIPT_FILENAME'}){
$ThisScriptDir = dirname($ENV{'SCRIPT_FILENAME'});	
}
else {
$ThisScriptDir = $DirToCheck;	
}

$ThisScriptDir =~ s/\\/\//g; # leaning toothpicks
return $ThisScriptDir;
	
}# end SR





sub getinfo {
	
if ($ENV{'SERVER_SOFTWARE'} =~ /IIS/){ 
	$serverspec = $ENV{'SERVER_SOFTWARE'};
	$DirToCheck = dirname($ENV{'PATH_TRANSLATED'});
	$OS = 'WIN';
} 

elsif ($ENV{'SERVER_SOFTWARE'} =~ /win32/i){
	$serverspec = $ENV{'SERVER_SOFTWARE'};
	$DirToCheck = dirname($ENV{'SCRIPT_FILENAME'});
	$OS = 'WIN';
} 


elsif ($ENV{'SERVER_SOFTWARE'} =~ /Unix/i){
	$serverspec = $ENV{'SERVER_SOFTWARE'};
	$DirToCheck = dirname($ENV{'SCRIPT_FILENAME'});
	$OS = 'NIX';
} 

elsif ($ENV{'SERVER_SOFTWARE'} =~ /linux/i){
	$serverspec = $ENV{'SERVER_SOFTWARE'};
	$DirToCheck = dirname($ENV{'SCRIPT_FILENAME'});
	$OS = 'NIX';
}

elsif ($ENV{'PERLHOST'} =~ /perlis/i){
	  $serverspec = $ENV{'PERLHOST'};
	  $pathmessage = "<p>Sorry! There is not enough information in the environmental variables to do this test.<p>\n\n"; 	
	  $pathmessage .= "<p> You must edit in a full path in the box below</p>\n\n";
	  $OS = 'WIN';
} 

else {
	if ($ENV{'SERVER_SOFTWARE'}){
	  $serverspec = $ENV{'SERVER_SOFTWARE'};	
	}
	else {
	  $serverspec = 'server type not recognized';
	}

	if ($ENV{'SCRIPT_FILENAME'}){
	   $DirToCheck = dirname($ENV{'SCRIPT_FILENAME'});
	}
	elsif($ENV{'PATH_TRANSLATED'}){
	   $DirToCheck = dirname($ENV{'PATH_TRANSLATED'});
	}
	else {	
	  $pathmessage = "<p>Sorry! There is not enough information in the environmental variables to do this test."; 	
	  $pathmessage .= "You must edit in a full path in the box above";
	}  

	if ($DirToCheck =~/\:/) { # look for colon in path
	$OS = 'WIN';
	}
	elsif (($DirToCheck =~/^\//)) {
	$OS = 'NIX';		
	}
	else {
	$OS = 'unknown';		
	}

}

if ($serverspec =~/IIS/){
	$servertype = 'IIS';	
}
elsif ($serverspec =~ /Apache/){
	$servertype = 'Apache';	
}
else {
	$servertype='unknown';	
}

	
}# end SR


sub print_headers {

print <<"EOF";	

<html>
<head>
<title>UBB6 Paths and Permissions Test</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<style type="text/css">
<!--
b {  font-family: Arial, Helvetica, sans-serif; font-size: 10pt}
td { font-family: Arial, Helvetica, sans-serif; font-size: 10pt }
p { font-family: Arial, Helvetica, sans-serif; font-size: 10pt }
.rowcolor {  background-color: #666699}
.title {  font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 11pt}
.sidebar {  font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10pt}
-->
</style></head>	
<body bgcolor="#FFFFFF" text="#000000" link="#0033CC" vlink="#666666" alink="#FF6600">
EOF
	
}


sub print_table_top {

print <<"EOF";	
<table border=0 cellpadding=0 cellspacing=0 width="95%" align="center"><TR><td bgcolor="#000000">
<table width="100%" cellspacing="1" cellpadding="4" border=0>
    <tr class="rowcolor"> 
      <td colspan="3"><b><font color="#FFFFFF" class="title">Checking $DirToCheck
      </font></b></td>
    </tr>
    
EOF


} # end SR

sub print_table_bottom {

print <<"EOF";	

    <tr class="rowcolor"> 
      <td align=right><font class="sidebar" color="#FFFFFF">version $testversion</font></td>
     <td align="right"colspan=2><font color="#FFFFFF"> &copy; 2001 Infopop 
        Corporation All Rights Reserved</font></td>
    </tr>
 </table>
 </td></tr></table>  
 </body></html>
 
EOF


} # end SR



sub print_result_row {
	
my $heading = shift;
my $result = shift;
my $errormessage = shift;
my $errortype = shift;
my $errorlabel = shift;

if ($errortype eq '') { ############# FIX
	$help = 'OK'
}
else {
	$help = &parse_help($errortype);	
}	

if ($errorlabel eq ''){
	$errorlabel = 'error:';	
}

print <<"EOF";	
   <tr> 
      <td bgcolor="#efefef" align="right" width=20%><font class="sidebar">$heading</font></td>
      <td bgcolor="#FFFFFF">$result</td>
<td bgcolor="#FFFFFF">$help</td>
    </tr>
    
EOF
	

unless ($errormessage eq '') {

print <<"EOF";	

   <tr> 
      <td bgcolor="#efefef" align="right" width=20%><font class="sidebar">$errorlabel</font></td>
      <td bgcolor="#FFFFFF">$errormessage</td>
      <td bgcolor="#FFFFFF">&nbsp;</td>
    </tr>
EOF
		
	
} #  end unless errormessage ..

}  #end SR


sub checkDirExistence { # check for path existence

	my $DirToCheck = shift;
	my $result;
	my $localerrormessage;
	my $localerrortype;
	my $localerrorlabel;

if (-d $DirToCheck) { 
	$result ="Path exists and is a directory";
}
else {
	$result = "Path does NOT exist or is not a directory";
	$DirNotFound++; # set global error flag that this test is going nowhere!!
	$localerrortype = 'paths';
	$localerrormessage = 'Click back and enter a correct absolute path';
	$localerrorlabel = 'solution:';

}
return ($result,$localerrormessage,$localerrortype,$localerrorlabel);
}# end SR



sub checkdirReadWrite {
	
	$DirToCheck = shift; # let this be global
	my $result;
	my $localerrormessage;
	my $localerrortype;
	my $localerrorlabel;
	
	my $yeswriteable =0; # 0 is 'not writeable'
	my $errorflag = 0;  # 0 is 'no error found
	
	
	
if (open TESTFILE, ">$DirToCheck/0UBBtestTQW.cgi"){
	$result = "Write, ";
	$yeswriteable++;
} 
else {
	$result = "NOT Writeable,";
	$errorflag++;
}
close (TESTFILE);


if  ($yeswriteable >= 1) {  # only check the read, append, delete if it's writeable

	if (open TESTFILE, "$DirToCheck/0UBBtestTQW.cgi"){
	  $result .= "Read, ";
	}
 	else {
	  $result .= "NOT Readable,";
	  $errorflag++;
	}

	close (TESTFILE);

	if (open TESTFILE, ">>$DirToCheck/0UBBtestTQW.cgi"){
	$result .= "Append,";
	}
	else { 
	  $result .= "Append FAILED,";
	  $errorflag++;
	} 
	
        close (TESTFILE);
 
 	if (unlink("$DirToCheck/0UBBtestTQW.cgi")){
	$result .=" Deleted OK,";
	}
	else {
	  $result .=" Delete FAILED";
	  $errorflag++;
	}


	unless ($DirToCheck eq $ThisScriptDir) { # don't test mkdir in cgi directory
 	 if (mkdir("$DirToCheck/0UBBtestmkdir", 0777)){
	   $result .=" <br>[MakeDir, ";
	 }
	 else {
	  $result .=" <br>[MakeDir FAILED, ";
	  $errorflag++;
	 }
 	 if (rmdir("$DirToCheck/0UBBtestmkdir")){
	  $result .=" RemDir: OK]";
	 }
	 else {
	   $result .= " RemDir FAILED]";
	   $errorflag++;
	 }

	}# end 'unless' exception for the CGI directory
	
}# end if 'yeswriteable' is > 0


else { # end if NOT writeable
	$localerrormessage = $!;			
}


if ($errorflag >= 1) {
	($localerrormessage,$localerrorlabel) = &parse_error($localerrormessage);
	$localerrortype = 'readwrite';
	#$localerrorlabel = 'problem';
}

return ($result,$localerrormessage,$localerrortype,$localerrorlabel); # $localerrormessage will be undef if successful

}# end checkdirReadWrite


sub checkRequired_Files { # check requires
	my $FileToCheck = shift;
	my $result= "$FileToCheck is missing in this directory or has not been uploaded in ASCII";
	my $localerrormessage = '';
	my $localerrortype;
	my $localerrorlabel; 

		
	unless(-e "$DirToCheck/$FileToCheck") {
		$localerrormessage .= "file not found in $DirToCheck  ";
	}
	unless ((-r "$DirToCheck/$FileToCheck") || ($localerrormessage ne '')) {
		$localerrormessage .= 'file not readable, ';
	}
	unless ((-T "$DirToCheck/$FileToCheck") || ($localerrormessage ne '')) {
		$localerrormessage .= 'file not uploaded in ASCII';
	}


 	if ($localerrormessage ne '') {
	$localerrortype = 'requires' ;
	}
	else {
 	$result = "found";
	}

   return ($result,$localerrormessage,$localerrortype,$localerrorlabel); # $localerrormessage if any
 }# end SR



sub check_variable_file_readwrite {

my $filetocheck = shift;

my $readwritestatus = 'not tested';
my $filereadOK;
my $localerrormessage;
my $localerrortype;
my $localerrorlabel;
my $result;

	if (open VARIABLEFILE, "$DirToCheck/$filetocheck") {
 	   @data = <VARIABLEFILE>;
 	   close (VARIABLEFILE);
	   $readwritestatus = "Read";
	   $filereadOK++;
	}
	else {
	   $result = "NOT Readable</font>";
	   $localerrormessage = "Are you checking in the correct directory?";	
	     unless (-e "$DirToCheck/$filetocheck") {
	       $readwritestatus = "isn't found in $DirToCheck";
		  $localerrortype = 'paths';
	       
	     }
        }# end else	

     
        
       	if ($filereadOK) { # only continue if file was readable

		if (open VARIABLEFILE, ">$DirToCheck/$filetocheck") {
 	   	  print VARIABLEFILE @data; # @data exists from earlier openforRead
 	   	  close (VARIABLEFILE);
	   	  $readwritestatus .= "/Write:OK";
		}
		else {
	   	  $readwritestatus .= "/NOT writeable";
	   	  $localerrormessage .= $!;	
		  #$localerrormessage = &parse_error($localerrormessage);
		  $localerrortype = 'readwrite';
		}
	}#  end if fileread OK
	
return ($readwritestatus,$localerrormessage,$localerrortype,'problem:');
	
}# end SR


## end subs.pl subroutines

sub parse_error {

my $errormessage = shift;
my $errorlabel;

if ($OS =~ /nix/i) {

	$mode = sprintf"%1o",((stat($DirToCheck))[2] & 07777);

	if (($mode == 755) && ($DirToCheck eq $ThisScriptDir)){ # i.e. this is the cgi dir we're checking
		$errormessage = "The mode is $mode which is normal for a CGI directory. It should not be writeable";
		$errorlabel = 'comment:';
	}
	else {
		$errormessage = "Perl cannot write new files. Directory permissions are now $mode";	
		$errorlabel = 'problem:';
	}
}

elsif($OS =~ /WIN/i) {

	if ($DirToCheck eq $ThisScriptDir) {
		$errormessage = " Your cgi directory can be Non-Writeable ONLY if the 4 variables files are made RWXD by IUSR_$ENV{'COMPUTERNAME'}.  See advanced help.";
		$errorlabel = 'warning:';
	return ($errormessage,$errorlabel);
	}
	
	elsif($ENV{'COMPUTERNAME'}){
		$errormessage .= " IUSR_$ENV{'COMPUTERNAME'} requires RWXD permissions";
		$errorlabel = 'problem:';
	}
	else {
		$errormessage .= " NT file permissions require RWXD by PERL";	
		$errorlabel = 'problem:';
	}	

}

else {
	$errormessage = " permission denied [no further information from the server]";	
	$errorlabel = 'problem:';
}


sub isThisFreeware {
  eval{require "ubb_lib.cgi"};
	if ($version =~ /DEMO/) {
	 @filestocheck = @filestocheck_UBBDemo;
	}
}# end SR


return ($errormessage,$errorlabel);
	
} # end SR

sub parse_help { # format help message
my $errortype = shift;

if ($errortype eq 'nohelp'){
	return '&nbsp;';
}
else {
	return "<A HREF=$ubb_help_url?OS=$OS&server=$servertype&errortype=$errortype TARGET=\"_$errortype\">help<a/>";
}

}# end SR


sub CheckBadChars { # check for | , ; .. or >< character hack attempts
	my $checkthis = shift;
		if($checkthis =~ /\||\;|<|>|\.\.|%/){ # 
		  die(&error("Invalid characters in your path.") );
		}	
return 1;
} # end SR


sub decode_query {
	my $querystring = shift;
	my($command,$path) = split(/&/,$querystring);

	if ($command =~ /^(q=|o=)/) {
	($commandtype,$command) = split(/=/,$command);
	}
	else {
	$unknown++;	
	}

	if ($path =~ /^p=/) {
	($junk,$path) = split(/=/,$path);
	}
	else {
	$unknown++;	
	}

 if ($unknown) {
 	&error("Unknown or corrupt query. Click <A HREF=$this_script_name>here</p>");
	 exit(0);	
 }

 if ($command == 1) {
 	$command = "dirwritetest";
 	$dirwritetest_check = ' checked';	
 }
 elsif ($command == 2)  {
  	$command = "testrequired";		
	$testrequired_check = ' checked';
 }
 elsif ($command == 3)  {
 	$command = "checkreadwrite";	
 	$checkreadwrite_check = ' checked';
 }
 elsif ($command == 4)  {
 	$command = "checkabsolutes";
 	$checkabsolutes_check = ' checked';	
 }
 elsif ($command == 0)  {
 	$command = "set_manual_paths";
 }
 else {
   	&error("Unknown or corrupt query: Command out of range. Click <A HREF=$this_script_name>here</p>");	
	exit(0);
 }

return ($command,$path,$commandtype);

} # end SR


exit(0);