#!/usr/bin/perl 
#
#--------------------------------------
# The Freshmeat.Net headline grabber script.
#
# Written by Srijith.K 
# (http://www.srijith.net) (email : webmaster@srijith.net)
# 
# Proxy support sample code provided by Michael Schmitz. 
# 
# It would really boost me if you can drop me a mail if you are using this script.
#
# Last Modified : 02/10/2000 (dd/mm/yyyy)
# Version 2.10
# License : GPL
#
#-------------------------------------- 
#
# Usage : (1) Change the first line of script to point to the perl interpreter. 
#         (2) Change the variables defined below IF REQUIRED
#	  (3) Enjoy.
#-------------------------------------- 

############# Modules used(to 'get' the backend file & for file manipulation) ########

use strict;
use LWP::UserAgent;
use CGI;


######################## Some initilisation needed for your comfort #################
my $updatefile="update.txt";     	# The file storing the time of last update
my $localfile = "freshmeat.out";  	# The local file where the headlines are stored
my $update_interval=30;          	# The interval in minutes at which the file is fetched fresh from server
my $print_descriptions=1;               # Should print description of each software ?? 1=Yes, 0=No
my $use_proxy=0;                        # Proxy to connect to internet ?? 1=yes, 0=no
my $proxy_server="server:port";         # The proxy server. If $user_proxy is set to 0, leave this variable blank
######################################################################################



################ ~~~~~~~~ DON'T EDIT IF YOU DON'T KNOW WHAT YOU ARE DOING ~~~~~~~~ #############
############ ~~~ EDITING WITHOUT KNOWLEDGE OF PERL IS INJURIOUS TO SCRIPT HEALTH ~~~~ ###########

# Few intialisations
my $query=new CGI;
my $update_file_content="";
my $current_time=time;           # The current time


# Print the header
&print_header;

# Check the age of the local file
&check_localfile_age;

my $freshmeat = $update_file_content->param('freshmeat');
my $update_interval_sec=$update_interval*60;
my $new_update_time=$freshmeat + $update_interval_sec;

if($current_time>$new_update_time)
{
  # Ok.. File is too old.. Fetch new file from server
  # and update the age of the local file
  &update_localfile;
  &update_localfile_age;
}

#&print_news($print_descriptions);
&print_news;
&print_footer;

exit(0);

#-------------------------- End of main code body --------------------

#-----------------------Below are the sub functions ------------------

# Function to check the local file's age
sub check_localfile_age
{
  open(UPDATE, $updatefile) || die "Error opening update log file!\n";
  flock(UPDATE,2);
  $update_file_content = new CGI("UPDATE");
  flock(UPDATE,8);
  close(UPDATE);
}


# Function to update local file 
sub update_localfile 
{
  # The $url points to the XML/text/anyother file that stores the headlines.
  my $url = 'http://freshmeat.net/backend/announcements.txt' ;
  my $ua=new LWP::UserAgent;
  if($use_proxy)
  {
    $ua->proxy('http',$proxy_server);
  }
  my $request=new HTTP::Request('GET',$url);
  my $response=$ua->request($request);
  if(!$response->is_success)
  {
    # Trouble fetching file from server.. !!
    print "Can't get Freshmeat backend file from the server.";
    exit (-1) ; 
  }

  my $document=$response->content;
  my @document = split /\n/, $document;
  
  # Save into local file
  open(LOCALFILE,">$localfile") || die "Cannot open the local file for write\n";
  flock(LOCALFILE,2);
  my $line="";
  foreach $line (@document)
  {
    print LOCALFILE "$line\n";
  } 
  flock(LOCALFILE,8);
  close(LOCALFILE);
}


# Function to update the local file's age
sub update_localfile_age
{
  # Update the update_time and save into file
  $update_file_content->param('freshmeat',$current_time);
  open(UPDATE,">$updatefile") || die "Error opening counter file!\n";
  flock(UPDATE, 2);  # locks the file - 2 to lock, 8 to unlock
  $update_file_content->save("UPDATE");
  flock(UPDATE, 8); # unlock file
  close(UPDATE);
}


# Function to print the news grabbed
sub print_news
{
 # my $print_descriptions=$_;
  my $document="";
  #Open the local file and print the headlines
  open (LOCALFILE,"<$localfile");
  flock(LOCALFILE,2);
  while(<LOCALFILE>)
  {
    $document=$document.$_;
  }
  flock(LOCALFILE,8);
  close(LOCALFILE);
  
  my @document = split /\n/, $document;
  $document =~ s/%%/ / ;
  @document = split /%%/, $document ;

  for (my $counter1 =0; $counter1<$#document+1;$counter1=$counter1+1)
  {
    print "\n";
    ( my @news_array ) = split /\n/, $document[$counter1] ;
    my $counter2=$counter1+1;
    print "<FONT COLOR=red>$counter2</FONT> <a href=\"$news_array[11]\">\n<big>$news_array[1]</big></a><br>\n";
    print "Category : $news_array[5] department<br>\n";
    print "On: $news_array[3] <br>\n";
    print "Author : $news_array[4]<br>\n";

    if($print_descriptions)
    {
      print "Description : $news_array[6]<br>\n";
    }
    print "<BR>";
  }
}


# Function to prin the header
sub print_header
{
    print $query->header;
    print $query->start_html(-title=>'News Grabber');
    print <<HTML;
      <BODY bgColor=#ffffff link=#000080 text=#000000 vLink=#000080><FONT face="Verdana, Arial" size=2>
      <TABLE border=0 cellPadding=0 cellSpacing=0 width="100%">
      <TBODY>
      <TR>
      <TD bgColor=#000000>
      <TABLE border=0 cellPadding=4 cellSpacing=1 width="100%">
      <TBODY>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B>Backend News Project</B></CENTER></FONT></TD></TR>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B><a href="http://www.freshmeat.net">Freshmeat.Net</a> News</B></CENTER></FONT></TD></TR>
      <TR bgColor=#fffff>
      <TD><FONT face="Verdana, Arial" size=2>
HTML

}


# Function to print the footer
sub print_footer
{
    print <<HTML;
      </TD></TR>
      <TR bgColor=#b0bb9d>
      <TD><FONT face="Verdana, Arial" size=2>
      <CENTER><B>THE END 
      </B></CENTER></FONT></TD></TR></TBODY></TABLE></TD></TR></TBODY></TABLE>
      <CENTER></CENTER></FONT></FONT></B>
      </CENTER></BODY></HTML>
HTML
}


# -------------------------------- END OF ALL THE SCRIPTS -----------------------
