VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Listener for Windows V2.04a                                                   (c) 1997/1998 Listen$oft"
   ForeColor       =   &H00000000&
   Height          =   4605
   Icon            =   VBTERM.FRX:0000
   Left            =   1875
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   3915
   ScaleWidth      =   9300
   Top             =   3060
   Width           =   9420
   Begin CommonDialog OpenLog 
      CancelError     =   -1  'True
      Color           =   &H00C0C0C0&
      DefaultExt      =   "LOG"
      DialogTitle     =   "Open Communications Log File"
      Filename        =   "*.log"
      Filter          =   "*.log"
      Left            =   120
      Top             =   900
   End
   Begin MSComm MSComm1 
      InBufferSize    =   8192
      Interval        =   1000
      Left            =   120
      RThreshold      =   1
      Settings        =   "4800,n,8,1"
      Top             =   420
   End
   Begin TextBox Term 
      BorderStyle     =   0  'None
      Height          =   516
      Left            =   768
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   480
      Width           =   1116
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Status - "
      Height          =   192
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   732
   End
   Begin Line Line1 
      BorderColor     =   &H00808080&
      BorderWidth     =   3
      X1              =   0
      X2              =   7320
      Y1              =   240
      Y2              =   240
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Height          =   255
      Left            =   960
      TabIndex        =   1
      Top             =   0
      Width           =   9375
   End
   Begin Menu MFile 
      Caption         =   "&File"
      Begin Menu MOpenLog 
         Caption         =   "&Open Log File..."
      End
      Begin Menu MCloseLog 
         Caption         =   "&Close Log File"
         Enabled         =   0   'False
      End
      Begin Menu M3 
         Caption         =   "-"
      End
      Begin Menu Bar2 
         Caption         =   "-"
      End
      Begin Menu MFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu MPort 
      Caption         =   "&CommPorts"
      Begin Menu MOpen 
         Caption         =   "PD204 Port &Open"
         Checked         =   -1  'True
      End
      Begin Menu MSettings 
         Caption         =   "PD204 Port &Settings..."
      End
      Begin Menu MBar1 
         Caption         =   "-"
      End
      Begin Menu NPhone 
         Caption         =   "&Notify Pager Phone Number..."
      End
   End
   Begin Menu MProp 
      Caption         =   "&PD204 Port Advanced Settings"
      Begin Menu MInputLen 
         Caption         =   "&InputLen..."
      End
      Begin Menu MRThreshold 
         Caption         =   "&RThreshold..."
      End
      Begin Menu MSThreshold 
         Caption         =   "&SThreshold..."
      End
      Begin Menu MParRep 
         Caption         =   "P&arityReplace..."
      End
      Begin Menu MDTREnable 
         Caption         =   "&DTREnable"
      End
      Begin Menu Bar3 
         Caption         =   "-"
      End
      Begin Menu MHCD 
         Caption         =   "&CDHolding..."
      End
      Begin Menu MHCTS 
         Caption         =   "CTSH&olding..."
      End
      Begin Menu MHDSR 
         Caption         =   "DSRHo&lding..."
      End
   End
   Begin Menu About 
      Caption         =   "&About Listener"
   End
End
'--------------------------------------------------
' VBTerm - Demonstration program for the MSComm
' communications custom control.  Demonstrates the
' functionality of the control in the context of a
' terminal program.
'
' Copyright (c) 1992, Crescent Software, Inc.
' by Don Malin and Carl Franklin.
'--------------------------------------------------
DefInt A-Z

Option Explicit
                        
Dim Ret                 'Scratch integer
Dim Temp$               'Scratch string
Dim hLogFile            'Handle of open log file
Dim Num$                'Notify Pager Phone Number
Dim capcodes            'Count of Monitored Capcodes
Dim a$                  'Collects Pagers.Ini lines
Dim z$                  'Used to read Pagers.Ini
Dim Newline$            'Used to flag new line of Pagers.Ini
Dim i                   'Used to build Capcode$ Table
Dim j                   'Utility variable
Dim capcode$(250)       'Contains Capcodes of Interest
Dim secret$(250)        'Contains Secret Pager Code to quality capcode
Dim PagersIni$          'Default location of Pagers.Ini
Dim NotifyIni$          'Default location of Notify.Ini
Dim stack$(1000)        'Holds Messages from PD203 for Analysis
Dim stackctr            'Number of Messages in the Stack
Dim ric$                'Capcode to search for in Pagers.Ini Table
Dim Timestamp$          'Timestamp of message of interest
Dim Message$            'Message of interest
Dim stacklength         'Length of stacked message
Dim x                   'Handle for SHELL to Pager Engine
Dim worka$              'Work Area A
Dim Wait                'Determines Wait after a Pageout Request
Dim NextPage$           'Used to collect a new line of pagout data
Dim KeepBackColor       'Used to remember default background color
Dim PageOuts            'Count of Pageouts during this run

Sub About_Click ()
    On Local Error Resume Next

    '--- Display the blurb.
    MsgBox "Listener for Windows V2.04a (c)1997/1998 Listen$oft"

End Sub

Sub Form_Load ()

    'Initialize some default values

    PageOuts = 0                            'Initialize Count of Pageouts
    Num$ = "???-????"                       'Default Notify Pager Number
    NotifyIni$ = "notify.ini"               'Default Notify Ini File
    PagersIni$ = "pagers.ini"               'Default Pagers.Ini file
    NextPage$ = ""                          'Start with an empty Pageout
    
    '--- Load the Notify.Ini Phone Number

    '--- Display event messages in label
    Label1.Caption = "Loading " + NotifyIni$ + "..."

    Open NotifyIni$ For Input As #1

    'Get and assemble an input line up to the carriage return
    a$ = ""
    Newline$ = "N"
    While (Not EOF(1) And Newline$ = "N")
      z$ = ""
      z$ = Input$(1, #1)
      If Len(z$) <> 0 Then
          Select Case Asc(z$)
              Case 10
              Case 13
                  Newline$ = "Y"
              Case Else
                  a$ = a$ + z$
                  z$ = ""
          End Select
      End If

      If Len(a$) <> 0 And Newline$ = "Y" Then
          If Left$(a$, 1) = "#" Then
              Newline$ = "N"
              a$ = ""
          End If
      End If
        
    Wend
      
    If Len(a$) <> 0 Then Num$ = a$: a$ = ""
    If Num$ = "???-????" Then Num$ = ""

    If Num$ <> "" Then Label1.Caption = "Pager Notification Number Selected: " + Num$
    If Num$ = "" Then Label1.Caption = "Pager Notification Disabled"

    Close #1

    Label1.Caption = "Finished Loading " + PagersIni$ + "..."
    


    'Load Capcodes that we wish to monitor
    
    '--- Display event messages in label
    Label1.Caption = "Loading " + PagersIni$ + "..."

    capcodes = 0
    Open PagersIni$ For Input As #1
    For i = 1 To 250
      'Get and assemble an input line up to the carriage return
      a$ = ""
      Newline$ = "N"
      While (Not EOF(1) And Newline$ = "N")
        z$ = ""
        z$ = Input$(1, #1)
        If Len(z$) <> 0 Then
            Select Case Asc(z$)
                Case 10
                Case 13
                    Newline$ = "Y"
                Case Else
                    a$ = a$ + z$
                    z$ = ""
            End Select
        End If

        If Len(a$) <> 0 And Newline$ = "Y" Then
            If Left$(a$, 1) = "#" Then
                Newline$ = "N"
                a$ = ""
            End If
        End If
        
      Wend
      
      If Not EOF(1) And Len(a$) <> 0 Then capcode$(i) = Left$(a$, 7): secret$(i) = Mid$(a$, 9, 3): capcodes = i: a$ = ""
      Label1.Caption = "Capcode Selected: " + capcode$(capcodes) + " " + secret$(capcodes)
      
    Next i
    Close #1

    Label1.Caption = "Finished Loading " + PagersIni$ + "..."
    
    'Open the PD203 Port to begin monitoring.

    MSComm1.PortOpen = 1
 
    Label1.Caption = "Capcodes=" + Str$(capcodes) + " Notify Pager Number is: " + Num$ + " (Use CommPorts Menu To Change It)"

End Sub

Sub Form_Resize ()
   
   '--- Resize the Term (display) control and
   '    status bar.
   Line1.X2 = ScaleWidth
   Term.Move 0, Line1.Y2 + 15, ScaleWidth, ScaleHeight - Line1.Y2 + 15
   
End Sub

Sub Form_Unload (Cancel As Integer)
    Dim T&

    If MSComm1.PortOpen Then
       '--- Wait 10 seconds for data to be transmitted
       T& = Timer + 10
       Do While MSComm1.OutBufferCount
          Ret = DoEvents()
          If Timer > T& Then
             Select Case MsgBox("Data cannot be sent", 34)
                '--- Abort
                Case 3
                   Cancel = True
                   Exit Sub
                '--- Retry
                Case 4
                   T& = Timer + 10
                '--- Ignore
                Case 5
                   Exit Do
             End Select
          End If
       Loop

       MSComm1.PortOpen = 0
    End If

    '--- If log file is open, flush and close it
    If hLogFile Then MCloseLog_Click

    End

End Sub

Sub MCloseLog_Click ()

   '--- Close the log file.
   Close hLogFile
   hLogFile = 0
   MOpenLog.Enabled = True
   MCloseLog.Enabled = False
   Form1.Caption = "MSComm Terminal"

End Sub

'--- Toggle DTREnabled property
'
Sub MDTREnable_Click ()
    
    MSComm1.DTREnable = Not MSComm1.DTREnable
    MDTREnable.Checked = MSComm1.DTREnable

End Sub

Sub MFileExit_Click ()
    
    '--- Use Form_Unload since it has code to check
    '    for un sent data and open log file
    Form_Unload Ret

End Sub

'--- Display the value of the CDHolding property.
'
Sub MHCD_Click ()
    
    If MSComm1.CDHolding Then
        Temp$ = "True"
    Else
        Temp$ = "False"
    End If
    MsgBox "CDHolding = " + Temp$

End Sub

'--- Display the value of the CTSHolding property.
'
Sub MHCTS_Click ()
    
    If MSComm1.CTSHolding Then
        Temp$ = "True"
    Else
        Temp$ = "False"
    End If
    MsgBox "CTSHolding = " + Temp$

End Sub

'--- Display the value of the DSRHolding property.
'
Sub MHDSR_Click ()
    
    If MSComm1.DSRHolding Then
        Temp$ = "True"
    Else
        Temp$ = "False"
    End If
    MsgBox "DSRHolding = " + Temp$

End Sub

'*************************************************
'Sets the InputLen property. The InputLen property
'determines how many bytes of data are read each
'time Input is used to retreive data from the
'input buffer. Setting InputLen to 0 specifies that
'the entire contents of the buffer should br read.
'*************************************************
'
Sub MInputLen_Click ()
    On Error Resume Next

    Temp$ = InputBox$("Enter New InputLen:", "InputLen", Str$(MSComm1.InputLen))
    If Len(Temp$) Then
        MSComm1.InputLen = Val(Temp$)
        If Err Then MsgBox Error$, 48
    End If

End Sub

'--- Toggles the state of the port (open or closed).
'
Sub MOpen_Click ()
    On Error Resume Next
    Dim OpenFlag

    MSComm1.PortOpen = Not MSComm1.PortOpen
    If Err Then MsgBox Error$, 48
    
    OpenFlag = MSComm1.PortOpen
    MOpen.Checked = OpenFlag
 
End Sub

Sub MOpenLog_Click ()
   Dim replace
   On Error Resume Next
   
   '--- Get Log File name from the user
   OpenLog.DialogTitle = "Open Communications Log File"
   OpenLog.Filter = "Log Files (*.LOG)|*.log|All Files (*.*)|*.*"
   
   Do
      OpenLog.Filename = ""
      OpenLog.Action = 1
      If Err = CDERR_CANCEL Then Exit Sub
      Temp$ = OpenLog.Filename

      '--- If file already exists, do they want to
      '    overwrite or add to it.
      Ret = Len(Dir$(Temp$))
      If Err Then
         MsgBox Error$, 48
         Exit Sub
      End If
      If Ret Then
         replace = MsgBox("Replace existing file - " + Temp$ + "?", 35)
      Else
         replace = 0
      End If
   Loop While replace = 2

   '--- User picked "Yes" button - Delete file.
   If replace = 6 Then
      Kill Temp$
      If Err Then
         MsgBox Error$, 48
         Exit Sub
      End If
   End If

   '--- Open the log file
   hLogFile = FreeFile
   Open Temp$ For Binary Access Write As hLogFile
   If Err Then
      MsgBox Error$, 48
      Close hLogFile
      hLogFile = 0
      Exit Sub
   Else
      '--- Seek to the end so we append new data
      Seek hLogFile, LOF(hLogFile) + 1
   End If

   Form1.Caption = "MSComm Terminal - " + OpenLog.Filetitle
   MOpenLog.Enabled = False
   MCloseLog.Enabled = True

End Sub

'*************************************************
'Sets the ParityReplace property. The
'ParityReplace property holds the character that
'will replace any incorrect characters that are
'received due to a parity error.
'*************************************************
'
Sub MParRep_Click ()
    On Error Resume Next

    Temp$ = InputBox$("Enter Replace Character", "ParityReplace", Form1.MSComm1.ParityReplace)
    Form1.MSComm1.ParityReplace = Left$(Temp$, 1)
    If Err Then MsgBox Error$, 48

End Sub

'*************************************************
'Sets the RThreshold property.  The RThreshold
'property determines how many bytes can arrive at
'the receive buffer before the OnComm event is
'triggered and the CommEvent property is set to
'MSCOMM_EV_RECEIVE
'*************************************************
'
Sub MRThreshold_Click ()
    On Error Resume Next

    Temp$ = InputBox$("Enter New RThreshold:", "RThreshold", Str$(MSComm1.RThreshold))
    If Len(Temp$) Then
        MSComm1.RThreshold = Val(Temp$)
        If Err Then MsgBox Error$, 48
    End If

End Sub

'*************************************************
'The OnComm event is used for trapping
'communications events and errors.
'*************************************************
'
Static Sub MSComm1_OnComm ()
    Dim EVMsg$
    Dim ERMsg$
    
    '--- Branch according to the CommEvent Prop..
    Select Case MSComm1.CommEvent
        '--- Event messages
        Case MSCOMM_EV_RECEIVE
            Showdata Term, (MSComm1.Input)
        Case MSCOMM_EV_SEND
            
        Case MSCOMM_EV_CTS
            EVMsg$ = "Change in CTS Detected"
        Case MSCOMM_EV_DSR
            EVMsg$ = "Change in DSR Detected"
        Case MSCOMM_EV_CD
            EVMsg$ = "Change in CD Detected"
        Case MSCOMM_EV_RING
            EVMsg$ = "The Phone is Ringing"
        Case MSCOMM_EV_EOF
            EVMsg$ = "End of File Detected"

        '--- Error messages
        Case MSCOMM_ER_BREAK
            EVMsg$ = "Break Received"
        Case MSCOMM_ER_CTSTO
            ERMsg$ = "CTS Timeout"
        Case MSCOMM_ER_DSRTO
            ERMsg$ = "DSR Timeout"
        Case MSCOMM_ER_FRAME
            EVMsg$ = "Framing Error"
        Case MSCOMM_ER_OVERRUN
            ERMsg$ = "Overrun Error"
        Case MSCOMM_ER_CDTO
            ERMsg$ = "Carrier Detect Timeout"
        Case MSCOMM_ER_RXOVER
            ERMsg$ = "Receive Buffer Overflow"
        Case MSCOMM_ER_RXPARITY
            EVMsg$ = "Parity Error"
        Case MSCOMM_ER_TXFULL
            ERMsg$ = "Transmit Buffer Full"
        Case Else
            ERMsg$ = "Unknown error or event"
    End Select
    
    If Len(EVMsg$) Then
        '--- Display event messages in label
        Label1.Caption = EVMsg$
        EVMsg$ = ""
    ElseIf Len(ERMsg$) Then
        '--- Display error messages in an alert
        '    message box.
        Beep
        Ret = MsgBox(ERMsg$, 1, "Press Cancel to Quit, Ok to ignore.")
        ERMsg$ = ""
        '--- If Cancel (2) was pressed
        If Ret = 2 Then
            MSComm1.PortOpen = 0    'Close the port and quit
        End If
    End If

End Sub

Sub MSettings_Click ()
    
    '--- Show the communications settings form
    ConfigScrn.Show

End Sub

'*************************************************
'Sets the SThreshold property. The SThreshold
'property determines how many characters (at most)
'have to be waiting in the output buffer before
'the CommEvent property is set to EV_SEND and the
'OnComm event is triggered.
'*************************************************
'
Sub MSThreshold_Click ()
    On Error Resume Next
    
    Temp$ = InputBox$("Enter New SThreshold Value", "SThreshold", Str$(MSComm1.SThreshold))
    If Len(Temp$) Then
        MSComm1.SThreshold = Val(Temp$)
        If Err Then MsgBox Error$, 48
    End If

End Sub

Sub NDial_Click ()
    On Local Error Resume Next
    Static Num$
    
    '--- Get a number from the user.
    Num$ = InputBox$("Enter Phone Number:", "Dial Number", Num$)
    If Num$ = "" Then Exit Sub
    
    '--- Open the port if it isn't already
    If Not MSComm1.PortOpen Then
       MOpen_Click
       If Err Then Exit Sub
    End If
    
    '--- Dial the number
    MSComm1.Output = "ATDT" + Num$ + Chr$(13) + Chr$(10)

End Sub

Sub NPhone_Click ()
    

    '--- Display event messages in label
    Label1.Caption = "Changing that Funky Phone Number..."
    
    On Local Error Resume Next

    '--- Get a number from the user.
    Num$ = InputBox$("Enter Notify Pager Phone Number or Null to Disable Pageout Feature:", "Dial Number", Num$)
    If Num$ = "" Then Label1.Caption = "Pageout Notification Disabled"
    If Num$ = "" Then Exit Sub
    
    '--- Display the new Notify Phone Number in label
    Label1.Caption = "Notify Pager Phone Number Changed to: " + Num$
    
End Sub

'**************************************************
'Adds data to the Term control's .Text property.
'Also filters control characters such as Back Space
'Charriage Return and Line Feed, and writes data to
'an open log file.
'
'Back Space chars. delete the character to the left,
'either in the .Text property, or the passed string.
'Line Feed characters are appended to all Charriage
'Returns.  The size of the Term control's Text
'property is also monitored so that it never
'excedes 16384 characters.
'**************************************************
'
Static Sub Showdata (Term As Control, Dta$)
    On Error Resume Next
    Dim Nd, i

    'Parse the Datastream for each new input line

    For i = 1 To Len(Dta$)

      a$ = Mid$(Dta$, i, 1)
      j = Asc(a$)

      If j <> 10 And j <> 13 Then
        NextPage$ = NextPage$ + a$
      Else
        If Len(NextPage$) > 10 Then
         ' NextPage$ = Date$ + " " + Time$ + " " + NextPage$ PD203 Implementation
          NextPage$ = NextPage$

    'Put the message on the Stack for processing

           stackctr = stackctr + 1

           If stackctr > 1000 Then
             stackctr = stackctr - 1
             Label1.Caption = "Stack Space Exceeded-Contact Listen$oft Technical Support at 1-800-WE-HEARU"
           End If

           stack$(stackctr) = NextPage$
           NextPage$ = ""

           If stackctr < 1000 Then
             ric$ = Mid$(stack$(stackctr), 19, 7)
             Label1.Caption = "RIC = " + ric$ + " PageOuts = " + Str$(PageOuts) + " Stackctr = " + Str$(stackctr) + " Last Message: " + stack$(stackctr)
           End If

        End If

      End If

    Next i

    '--- Make sure the existing text doesn't get
    '    too large.
    Nd = Len(Term.Text)
    If Nd >= 16384 Then
       Term.Text = Mid$(Term.Text, 4097)
       Nd = Len(Term.Text)
    End If

    '--- Point to the end of Term's data
    Term.SelStart = Nd

    '--- Filter/handle Back Space characters
    Do
       i = InStr(Dta$, Chr$(8))
       If i Then
          If i = 1 Then
             Term.SelStart = Nd - 1
             Term.SelLength = 1
             Dta$ = Mid$(Dta$, i + 1)
          Else
             Dta$ = Left$(Dta$, i - 2) + Mid$(Dta$, i + 1)
          End If
       End If
    Loop While i

    '--- Elliminate Line Feeds (put back below)
    Do
       i = InStr(Dta$, Chr$(10))
       If i Then
          Dta$ = Left$(Dta$, i - 1) + Mid$(Dta$, i + 1)
       End If
    Loop While i

    '--- Make sure all Charriage Returns have a
    '    Line Feed
    i = 1
    Do
       i = InStr(i, Dta$, Chr$(13))
       If i Then
          Dta$ = Left$(Dta$, i) + Chr$(10) + Mid$(Dta$, i + 1)
          i = i + 1
       End If
    Loop While i

    '--- Add the filtered data to .Text
    Term.SelText = Dta$

    '--- Log data to file if requested
    If hLogFile Then
       i = 2
       Do
          Err = 0
          Put hLogFile, , Dta$
          If Err Then
             i = MsgBox(Error$, 21)
             If i = 2 Then
                MCloseLog_Click
             End If
          End If
       Loop While i <> 2
    End If

    '--- If there are any messages in the Stack, let see if we want
    '--- To page out for any of them
    If Wait > 0 Then Wait = Wait - 1: ric$ = Mid$(stack$(stackctr), 19, 7): Label1.Caption = "RIC = " + ric$ + " PageOuts = " + Str$(PageOuts) + " Stackctr = " + Str$(stackctr) + " Wait now Contains: " + Str$(Wait)
    While (stackctr > 0 And Wait = 0)
      
      stacklength = Len(stack$(stackctr))
      ric$ = Mid$(stack$(stackctr), 19, 7)
      Timestamp$ = Left$(stack$(stackctr), 18)
      Message$ = Mid$(stack$(stackctr), 29, stacklength - 29 + 1)
        
      For i = 1 To capcodes
       If capcode$(i) = ric$ Then
          Label1.Caption = "Capcode " + ric$ + " Matched - Page Out Here"
          worka$ = capcode$(i) + "*" + secret$(i) + "*"
          Wait = 50
          
          PageOuts = PageOuts + 1

          Term.SelText = "Notify: " + stack$(stackctr)

          If Num$ <> "" Then x = Shell("pager.exe ATDT" + Num$ + ",,,,,,,," + worka$, 8)
        End If
      Next i

      If stackctr > 0 Then stackctr = stackctr - 1
      If Wait = 0 Then
        Label1.Caption = "RIC = " + ric$ + " PageOuts = " + Str$(PageOuts) + " Stackctr = " + Str$(stackctr)
      Else
        Label1.Caption = "RIC = " + ric$ + " PageOuts = " + Str$(PageOuts) + " Stackctr = " + Str$(stackctr) + " Pager Notification In Progress, Wait=" + Str$(Wait)
      End If

    Wend



End Sub

'*************************************************
'Key strokes trapped here are sent to the Comm
'control where they are echoed back via the
'OnComm/MSCOMM_EV_RECEIVE event, and displayed
'through the ShowData procedure.
'*************************************************
'
Sub Term_KeyPress (KeyAscii As Integer)
    
    '--- If the port is openned,
    If MSComm1.PortOpen Then
       '--- Send the key stroke to the port
       MSComm1.Output = Chr$(KeyAscii)
       '--- Unless Echo is on, there is no need to
       '    let the Text control display the key.
       If Not Echo Then KeyAscii = 0
    End If

End Sub

