 
#include <stdio.h> 
#include <conio.h> 
#include <dos.h> 
 
/* copyrighted material, no commercial use granted in whole or part. */ 
/* it can be freely distributed however */ 
 
/* hardcoded pocsag options */ 
#define MSGLEN 3000             /* max message length: ascii or bcd */ 
#define BITERR 2                /* max bit errors in idle, or sync */ 
#define HEURBITS 64             /* heuristic: bit size window */ 
#define HEURMIN  4              /* heuristic: nth minimum bit time */ 
#define HEURNOISE 100           /* heuristic: noise bit rate (in ticks) */ 
#define HEURSIMULAR .95         /* heuristic: window bit rate simularity */ 
 
/* specific pocsag defines */ 
#define MSFRM   0x7cd2          /* sync codeword: 0x7cd215d8 */ 
#define LSFRM   0x15d8          /* sync LSB */ 
#define MSIDLE  0x7a89          /* idle codeword: 0x7a89c197 */ 
#define LSIDLE  0xc197          /* idle LSB */ 
 
/* command line options */ 
static int brate;                          /* bit rate, 0 means auto */ 
static int sport = 1;                      /* serial port no: [1,2,3 or 4] */ 
static int cwords, raw, invert, bcdshow;   /* operational flags */ 
static int batch; 
 
/* pocsag specific */ 
static int flagaddr, msaddr, lsaddr, funcva; /* message meta data */ 
static int errcnt, totcnt;                   /* message error count */ 
static unsigned char uc[MSGLEN];             /* message content in ascii */ 
static unsigned char ub[MSGLEN];             /* message content in bcd */ 
static int ubi, uci, uc_i, uc_k;             /* state info for a message */ 
static int s1, s2;                           /* perceived codeword */ 
static int syncit;                           /* set to resync decoder */ 
static int noise;                            /* channel only noise? */ 
static int cw;                               /* number of codeword on */ 
 
int ones(int h)                 /* returns # of ones in 16 bit word */ 
{ 
  int i,nb; 
  for (nb=i=0; i<16; i++, h=h>>1) 
    if ((h & 1) == 1) nb++; 
  return(nb); 
} 
 
void print_msg()                /* print out the retained message */ 
{ 
  static char bcd[16] =  
    { '0','1','2','3','4','5','6','7','8','9','?','u',' ','-',')','(' }; 
  int i, k; 
  if (bcdshow)                             /* show bcd? */ 
    for (k=0,i=0; i<ubi; i++,k++) { 
      if (!batch && k >= 61) { k=0; printf("<\n               "); } 
      putchar(bcd[ub[i]]); 
      } 
  else                                     /* show ascii? */ 
    for (k=0,i=0; i<uci; i++) { 
      if (!batch && k >= 61) { k=0; printf("<\n               "); } 
      if (uc[i] == '\\') { k+=2; printf("\\\\"); } 
      else if (uc[i] < ' ') { k+=2; printf("\\%c",uc[i]+'0'); } 
      else { putchar(uc[i]); k++; } 
      } 
  if (batch) putchar('\n'); 
  else printf("<\n"); 
} 
 
void cw_idle()                  /* idle codeword found, perform clean up */ 
{ 
  if (!cwords) { 
    if (!flagaddr && ubi == 0) { totcnt=errcnt=0; return; } 
    if (errcnt) putchar('+');                               /* any errors? */ 
    else putchar(' '); 
    if (!flagaddr) printf("NO ADDR  %d/%02d:",errcnt,totcnt);  
    else printf("%02x%04x %d %d/%02d:",msaddr,lsaddr,funcva,errcnt,totcnt);  
    print_msg(); 
    } 
  totcnt = errcnt = flagaddr = ubi = uci = uc_k = uc_i = 0;  /* clear meta */ 
} 
 
void ecc()                      /* perform error correction on codeword */ 
{ 
  int i, k, b[31], t1,t2; 
  for (t2=s2,i=0; i<15; i++) { t2 = t2 >> 1; b[i] = t2 & 1; } 
  for (t1=s1,i=15; i<31; i++) { b[i] = t1 & 1; t1 = t1 >> 1; } 
  totcnt++;                            /* count up codewords in message */ 
  if ((k=bch(b)) == 0) return;         /* 0 = no errors detected, return */ 
  if (k != 1) errcnt++;                /* 1,2 = 1,2 corrected errors */ 
  if (cwords) printf(" %d>", k);       /* note, 2 might me in error tho */ 
  if (k < 0) return;                   /* -1 = uncorrected error, return */ 
  for (s1=0,i=30; i>14; i--) { s1 = s1 << 1; s1 = s1 | b[i]; } 
  for (s2=0,i=14; i>=0; i--) { s2 = s2 | b[i]; s2 = s2 << 1; } 
} 
 
void cw_put(int frame)          /* decode codeword */ 
{ 
  int i, k, n, t1, t2; 
  if (BITERR >= ones(s1^MSIDLE) + ones(s2^LSIDLE)) {  /* idle codeword? */ 
    cw_idle();                                        /* so, print message */ 
    if (cwords) printf("*%04x%04x", s1,s2);           /* then return */ 
    return;  
    } 
  ecc();                                      /* ecc the codeword */ 
  if (!(s1 & 0x8000)) {                       /* address codeword? */ 
    cw_idle();                                /* so, print prior message */ 
    if (cwords) printf("-%04x%04x", s1,s2); 
    msaddr = s1 >> 10;                        /* determine msg's address */ 
    lsaddr = (s1 << 6) + (s2 >> 10); 
    lsaddr = (lsaddr & 0xfff8) | frame;       /* note frame# is part of it! */ 
    funcva = (s2 >> 11) & 3;                  /* save source address */ 
    flagaddr = 1;                             /* set new msg flag */ 
    return;                                   /* then return */ 
    } 
  if (cwords) printf(" %04x%04x", s1,s2);     /* message codeword? */ 
  for (i=k=n=0,t1=s1,t2=s2; n<20; n++) {      /* decode message into bufs */ 
    t1 = t1 << 1; 
    uc_k = uc_k >> 1; 
    k = k << 1; 
    if (t1 & 0x8000) { uc_k = uc_k | 0x40; k++; }  /* ascii is flipped! eek */ 
    if (t2 & 0x8000) t1++; 
    t2 = t2 << 1; 
    if (++i == 4) { ub[ubi++] = k; i = k = 0; }               /* bcd */ 
    if (++uc_i == 7) { uc[uci++] = uc_k; uc_i = uc_k = 0; }   /* ascii */ 
    } 
} 
 
void frame_sync(int gin)        /* take a bit, give a bit */ 
{ 
  static int n; 
 
  s1 = s1 << 1;                      /* update the current 16 bit word */ 
  if ((s2 & 0x8000) != 0) s1++; 
  s2 = s2 << 1; 
  if (gin) s2++; 
 
  if (cw <= 0) {                     /* not yet in a batch? */ 
    if (n++ == 15) {                 /* anyway, every 16 bits */ 
      n=0;  
      if (raw && !noise) printf("%04x ", s2);                  /* print it? */ 
      if (cw < 0) if (++cw == 0) { cw_idle(); printf("$\n"); } /* give up */ 
      } 
    if (BITERR >= ones(s1^MSFRM) + ones(s2^LSFRM)) {           /* sync? */ 
      if (n!=0 && cw<0) printf(" [Improperly aligned bit on %d]\n",n); 
      n=0;  
      cw=1;                          /* start batch */ 
      syncit=1;                      /* works wonders */ 
      if (raw) putchar('\n'); 
      } 
    } 
  else {                             /* in batch? */ 
    if (n++ == 31) {                 /* 32 bit codeword ready? */ 
      n=0;  
      cw_put((cw-1) >> 1);                    /* decode it */ 
      if (cw == 8 && cwords) putchar('\n'); 
      if (cw == 16 && cwords) printf("<\n"); 
      if (cw++ == 16) cw=-3;                  /* last codeword of batch */ 
      } 
    } 
} 
 
void help()                   /* our copyright, don't modify top line */ 
{ 
  printf("\ 
POCSAG v1.0 (c) 1998 punkANARCHIST\n\ 
 -i    Invert incoming raw data stream\n\ 
 -h    Print this help screen\n\ 
 -n    Print numeric messages instead of ascii\n\ 
 -r    Trace the raw data stream\n\ 
 -c    Trace the codewords\n\ 
 -u    Turn on batch mode\n\ 
 -b#   Set baud rate (AUTO)\n\ 
 -p#   Set equal to 1,2,3,4 for comm port (1)\n"); 
  exit(0); 
} 
 
void commandline(char *argv[])   /* process the command line */ 
{ 
  for (argv++; *argv != 0; argv++) { 
    char *c = *argv; 
    if (*c++ != '-') help(); 
    for (; *c != 0; c++) { 
      if (*c == 'i') invert = 1; 
      else if (*c == 'r') raw = 1; 
      else if (*c == 'c') cwords = 1; 
      else if (*c == 'u') batch = 1; 
      else if (*c == 'n') bcdshow = 1; 
      else if (*c == 'p') { sport = atoi(c+1); break; } 
      else if (*c == 'b') { brate = atoi(c+1); break; } 
      else help(); 
      } 
    }  
  if (sport < 1 || sport > 4) help(); 
  if (brate < 0) help(); 
 
  if (invert) printf("[inverting] "); 
  if (raw) printf("[raw] "); 
  if (cwords) printf("[cwords] "); 
  if (batch) printf("[batch] "); 
  printf("%s, port %d, baud rate ",(bcdshow? "numeric":"ascii"),sport); 
  if (brate) printf("%d\n", brate); 
  else printf("AUTO\n"); 
} 
 
#define BUFLEN 15000                       /* size of timing data buffer */ 
static unsigned int fdata[BUFLEN];         /* frequency data */ 
static volatile unsigned int cpstn = 0;    /* current position in fdata[] */ 
 
void main(int argc, char *argv[]) 
{ 
  unsigned int j,hn=0,k,s,n,i=0; 
  double dt=200,ave=0,aveold=0,xct,exc=0.0,clk=0.0,ww=HEURSIMULAR; 
  static int h[HEURMIN]; 
 
  commandline(argv);                       /* parse the command line */ 
  initbch();                               /* initialize BCH tables */ 
  initdecoder(sport);                      /* initialize hardware */ 
  set8253();                               /* set up 8253 timer chip */ 
  set8250();                               /* set up 8250 UART */ 
  if (brate) dt = 1.0/(brate*839.22e-9);   /* dt is the num of ticks/bit */ 
 
  while (kbhit() == 0) if (i != cpstn) { 
    s = ((fdata[i] & 0x8000)==0) ^ invert; 
    k = (fdata[i] & 0x7fff); 
    clk += k; 
    xct = exc + 0.5 * dt;          /* exc is current boundary */ 
    while ( clk >= xct ) { 
      frame_sync(s);               /* send raw bit stream to first unit */ 
      clk = clk - dt; 
      } 
    if (syncit) { syncit = 0; exc = clk; }  /* sync stream if commanded */ 
    else exc = exc + 0.020 *(clk - exc);    /* else do this trix */ 
    if(++i >=BUFLEN) i = 0;                 /* update index into fdata[] */ 
 
    ave += k/ (float) HEURBITS;             /* do noise/auto baud heuristic */ 
    for (j=0; j<HEURMIN; j++) if (k < h[j]) {      /* find nth minimum */ 
      for (s=HEURMIN-1; s>j; s--) h[s] = h[s-1]; 
      h[j] = k; 
      break; 
      } 
    if (++hn == HEURBITS) {                                /* matured? */ 
      if (h[HEURMIN-1] < HEURNOISE) {                      /* guess noise */ 
	if (raw && !noise && cw==0) printf("<-noise-> ");  
	noise = 1;  
	} 
      else { 
	noise = 0;                                /* check if in preamble */ 
	if (brate == 0 && cw == 0 && ((int) ave*ww) == ((int) aveold*ww)) { 
	  dt = ave;                               /* yeah! so change bps */ 
	  exc = clk;                              /* sync to it too */ 
	  if (raw) printf("(%d) ", (int) (1.0/(dt*839.22e-9))); 
	  } 
	} 
      aveold = ave;                  /* do a new heuristic interation */ 
      ave = 0; 
      for (j=0; j<HEURMIN; j++) h[j] = 9999; 
      hn = 0;  
      } 
    } 
  uninitdecoder();                   /* restore the hardware to old state */ 
} 
 
/*---------------------------------*/ 
/* begin lowlevel decoding library */ 
/*---------------------------------*/ 
 
/* low level decoding effort */ 
static void interrupt (*oldfuncc)();       /* vector to old comm interrupt */ 
static int comport;                        /* comm port address */ 
static unsigned int irqv, irqmask;         /* old irq vector & mask */ 
 
void interrupt comint()         /* the interrupt */ 
{ 
  unsigned int d1,d2,tick,dtick; 
  static unsigned int ltick; 
  outportb(0x43, 0x00);         /* latch counter until we read it */ 
  d1 = inportb(0x40);           /* get low count */ 
  d2 = inportb(0x40);           /* get high count */ 
  tick  = (d2 << 8) + d1;       /* get difference btw current and last */ 
  dtick = ltick - tick;         /* increments every 840 ns */ 
  ltick = tick;                         /* remember for the next int */ 
  if ((inportb(comport+6) & 0xF0) > 0)  /* record the polarity */ 
       dtick = dtick | 0x8000; 
  else dtick = dtick & 0x3fff; 
  fdata[cpstn] = dtick;         /* put freq in fdata array */ 
  cpstn++;                      /* increment data buffer pointer */ 
  if (cpstn>=BUFLEN) cpstn=0;   /* make sure cpstn doesnt leave array */ 
  inportb(comport+2);           /* clear IIR */ 
  inportb(comport+5);           /* clear LSR */ 
  inportb(comport+6);           /* clear MSR */ 
  inportb(comport);             /* clear RX */ 
  outportb(0x20, 0x20);         /* this is the END OF INTERRUPT SIGNAL */ 
} 
 
set8253()                       /* setup timer, use #0, the dos counter */ 
{ 
  outportb(0x43, 0x34);         /* set ctr 0 to mode 2, binary */ 
  outportb(0x40, 0x00);         /* this gives us the max count */ 
  outportb(0x40, 0x00); 
} 
 
set8250()                       /* sets up the 8250 UART; read comport */ 
{ 
  outportb(comport+3, 0x00);    /* set IER on 0x03f9 */ 
  outportb(comport+1, 0x08);    /* enable MODEM STATUS INTERRUPT */ 
  outportb(comport+4, 0x0a);    /* push up RTS, DOWN DTR */ 
  inportb(comport+5);           /* clear LSR */ 
  inportb(comport);             /* clear RX */ 
  inportb(comport+6);           /* clear MSR */ 
  inportb(comport+2);           /* clear IID */ 
  inportb(comport+2);           /* clear IID - again to make sure */ 
} 
 
initdecoder(int sport)          /* setup serial and timer ports */ 
{ 
  irqmask = inportb (0x21);           /* get INT mask */ 
  if ((sport == 1) | (sport == 3)) { 
    irqv = 0x0c;                      /* modify IRQ4 */ 
    outportb(0x21, irqmask & 0xef);   /* enable IRQ4 int */ 
    if (sport == 1) comport=0x3f8;  
    else comport = 0x3e8; 
    } 
  else { 
    irqv = 0x0b;                      /* modify IRQ3 */ 
    outportb(0x21, irqmask & 0xf7);   /* enable IRQ3 int */ 
    if (sport == 2) comport = 0x2f8;  
    else comport = 0x2e8; 
    } 
  oldfuncc = getvect(irqv);           /* save COM vector */ 
  setvect(irqv, comint);              /* capture COM vector */ 
} 
 
uninitdecoder() 
{ 
  outportb (0x21, irqmask);     /* disable the IRQ interrupt */ 
  setvect (irqv, oldfuncc);     /* restore old COM1 Vector */ 
} 
 
/*--------------------------------------------------*/ 
/* begin BCH error detection and correcting library */ 
/* (the following is not our code.  Although we     */ 
/*  have altered it heavily, it is still            */ 
/*  copyrighted by the original author and no       */ 
/*  unauthorized commerical use was granted by him  */  
/*--------------------------------------------------*/ 
 
static int n = 31; 
static int ato[32], iof[32]; 
 
initbch() 
{ 
  int i, mask, m = 5; 
  int p[6]; 
  p[0] = p[2] = p[5] = 1; p[1] = p[3] = p[4] =0; 
  mask = 1; 
  ato[m] = 0; 
  for (i = 0; i < m; i++) { 
    ato[i] = mask; 
    iof[ato[i]] = i; 
    if (p[i] != 0) ato[m] ^= mask; 
    mask <<= 1; 
  } 
  iof[ato[m]] = m; 
  mask >>= 1; 
  for (i = m + 1; i < n; i++) { 
    if (ato[i - 1] >= mask) 
      ato[i] = ato[m] ^ ((ato[i - 1] ^ mask) << 1); 
    else ato[i] = ato[i - 1] << 1; 
    iof[ato[i]] = i; 
  } 
  iof[0] = -1; 
} 
 
bch(int recd[31]) 
{ 
  int i, j, q; 
  int elp[3], s[5], s3; 
  int count = 0, serr = 0; 
  int loc[3], err[3], reg[3]; 
  int aux, length = 31; 
 
  for (i = 1; i <= 4; i++) { 
    s[i] = 0; 
    for (j = 0; j < length; j++) 
      if (recd[j] != 0) s[i] ^= ato[(i * j) % n]; 
    if (s[i] != 0) serr = 1; 
    s[i] = iof[s[i]]; 
    }; 
  if (!serr) return 0; 
  if (s[1] != -1) { 
    s3 = (s[1] * 3) % n; 
    if ( s[3] == s3 ) { recd[s[1]] ^= 1; return 1; } 
    if (s[3] != -1) aux = ato[s3] ^ ato[s[3]]; 
    else aux = ato[s3]; 
    elp[0] = 0; 
    elp[1] = (s[2] - iof[aux] + n) % n; 
    elp[2] = (s[1] - iof[aux] + n) % n; 
    for (i = 1; i <= 2; i++) reg[i] = elp[i]; 
    count = 0; 
    for (i = 1; i <= n; i++) { 
      q = 1; 
      for (j = 1; j <= 2; j++) 
	if (reg[j] != -1) { 
	  reg[j] = (reg[j] + j) % n; 
	  q ^= ato[reg[j]]; 
	  } 
      if (!q) { loc[count] = i % n; count++; } 
      } 
    if (count == 2) { 
      for (i = 0; i < 2; i++) recd[loc[i]] ^= 1; 
      return 2; 
      } 
    } 
  return -1; 
} 
 
