#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include <FeatureMgr.h>

/* copyrighted material, no commercial use granted in whole or part. */
/* it can be freely distributed however */

#include "pop.h"
#define BUFLEN 5000                /* size of timing data buffer */

#define PMSR   *((Word*) 0xfffff44a)

#define UART   *((Word*) 0xfffff900)
#define GPIO   *((Word*) 0xfffff902)

#define IVR    *((Byte*) 0xfffff300)
#define IMR    *((DWord*) 0xfffff304)
#define IWR    *((DWord*) 0xfffff308)
#define ISR    *((DWord*) 0xfffff30c)
#define IPR    *((DWord*) 0xfffff310)

#define TCR2   *((Word*) 0xfffff60c)
#define PRE2   *((Word*) 0xfffff60e)
#define CNT2   *((Word*) 0xfffff614)

/*--- variables ---*/

#define PERIOD 1.6307e-6       /* 1.6197 */

/* options */
static int brate = 1200;     /* bit rate (there is no auto for pop) */
static int raw = 0;          /* trace the raw data stream */
static int invert = 0;       /* invert incoming raw data stream */
static int bcdshow = 0;      /* do numeric rather than ascii */

/* globals */
static double dt;
static struct f_t {
  DWord oldIvr;
  volatile unsigned short n;
  volatile unsigned short ltick;
  volatile unsigned short data[BUFLEN];
  } *f;

/*--- level 4 pilot interrupt handler ---*/

inthandler() 
{
DWord jmpto, *a;
struct f_t *f;
unsigned short i, j;

asm ("intcode:");
asm ("link.w %a6,#-16");
asm ("movem.l %d0-%d7/%a0-%a5,-(%a7)");

a = (DWord*) (((DWord) IVR)<<2);
f = (struct f_t *) *a;
jmpto = f->oldIvr;

if (ISR & 4) {                              /* if UART int */
  if (GPIO & 0x8000) {
    i = CNT2;
    j = i - f->ltick;
    f->ltick = i;
    if (GPIO & 0x4000) j |= 0x8000;         /* high or low */
    else j &= ~0x8000;
    f->data[f->n] = j;
    f->n += 1;
    if (f->n >= BUFLEN) f->n = 0;
    GPIO &= ~0x8000;
    }
  asm ("movem.l (%a7)+,%d0-%d7/%a0-%a5");
  asm ("unlk %a6");
  asm ("rte");
  }

asm ("movem.l (%a7)+,%d0-%d7/%a0-%a5");
asm ("unlk %a6");

asm ("move.l -8(%a7),-4(%a7)");
asm ("add.l #-4,%a7");
asm ("rts");
}

/*--- begin pilot code ---*/

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
EventType e; short err;                      /* Event stuff */
FormType *pfrm;                              /* pointer to a form */
DWord *IvrPtr, a, oldiwr, oldimr;
Word oldpmsr;

if (cmd) return 0;                       /* conocal */
FrmGotoForm(kidfMain);                   /* get it rolling */

if (!brate) brate = 1200;                /* just in case */
f = MemPtrNew(sizeof (struct f_t));      /* need to do this now for mn() */
f->n = 0;

while(1) {
  EvtGetEvent(&e, 0);
  if (SysHandleEvent(&e)) continue;
  if (e.eType == frmLoadEvent) 
    FrmSetActiveForm(pfrm=FrmInitForm(e.data.frmLoad.formID));
  else if (e.eType == frmOpenEvent) {
    FrmDrawForm(pfrm);
    FntSetFont(1);
    WinDrawInvertedChars("  Pop  ",7,0,0);
    WinDrawLine(0,11,160,11);
    initbch();                                  /* initialize BCH tables */
    printf("BPS is set at %d\n", brate);
    if (raw) printf("Raw mode is on\n");
    }
  else if (e.eType == keyDownEvent) {
    if (e.data.keyDown.chr==pageUpChr) {
      if (brate==512) brate=1200;
      else if (brate==1200) brate=2400;
      else { 
        printf("Raw mode is now %s\n", (raw=!raw) ? "on":"off");
        brate=512;
        }
      printf("BPS is now %d\n", brate);
      }
    else if (e.data.keyDown.chr==pageDownChr) {
      dt = 1.0/(brate*PERIOD);                    /* assuming 16.67mhz/27 */

      IvrPtr = (DWord*) (((DWord) (IVR))<<2);     /* lamearama */
      *IvrPtr = (DWord) f;

      IvrPtr = (DWord*) (((DWord) (IVR+4))<<2);   /* intercept level 4 int */
      asm ("lea intcode(%%pc),%0" : "=a" (a));
      f->oldIvr = *IvrPtr;
      *IvrPtr = a;

      oldimr = IMR;
      oldiwr = IWR;
      oldpmsr = PMSR;

      TCR2 |= 0x0100;
      PRE2 = 26; 

      UART = 0x8080;
      GPIO = 0x403f;
      PMSR &= ~0x80;
      IWR &= ~0x4;                 /* disable uart wakeup */
      IMR = 0xffffff;
      IMR &= ~0x4;                 /* unmask uart int */

      printf("Decoding enabled\n");
      while (IPR & 0x40) ;
      while(1) {
       if (IPR & 0x40) break;
       mn();
       }
      printf("Decoding stopped\n");
/*
      printf("Decoding stopped %08x\n", IPR);
*/

      TCR2 &= ~0x0100;
      PRE2 = 2;

      PMSR = oldpmsr;
      IMR = oldimr;
      IWR = oldiwr;
      UART = 0;                    /* disable */
      *IvrPtr = f->oldIvr;
      }
    }
  else if (e.eType == appStopEvent) break;
  else if (e.eType == nilEvent) ;
  else FrmHandleEvent(pfrm, &e);
  }
return 0;
}

/*--- begin pocsag code ---*/

/* hardcoded pocsag options */
#define MSGLEN 1000             /* max message length: ascii or bcd */
#define BITERR 2                /* max bit errors in idle, or sync */
#define HEURBITS 64             /* heuristic: bit size window */

/* specific pocsag defines */
#define MSFRM   0x7cd2          /* sync codeword: 0x7cd215d8 */
#define LSFRM   0x15d8          /* sync LSB */
#define MSIDLE  0x7a89          /* idle codeword: 0x7a89c197 */
#define LSIDLE  0xc197          /* idle LSB */

/* pocsag specific */
static int flagaddr, msaddr, lsaddr, funcva; /* message meta data */
static int errcnt, totcnt;                   /* message error count */
static unsigned char uc[MSGLEN];             /* message content in ascii */
static unsigned char ub[MSGLEN];             /* message content in bcd */
static int ubi, uci, uc_i, uc_k;             /* state info for a message */
static int s1, s2;                           /* perceived codeword */
static int syncit;                           /* set to resync decoder */
static int cw;                               /* number of codeword on */

/*--- 32 bit codeword decoding ---*/

int ones(int h)                 /* returns # of ones in 16 bit word */
{
  int i,nb;
  for (nb=i=0; i<16; i++, h=h>>1)
    if ((h & 1) == 1) nb++;
  return(nb);
}

void print_msg()     /* print out the message in ub[], uc[], ubi, uci */
{
  char ln[50];
  static char bcd[16] = 
    { '0','1','2','3','4','5','6','7','8','9','?','u',' ','-',')','(' };
  int i, k;

  if (errcnt)
    sprintf(ln,"+%02x%04x %d %d/%02d: ",msaddr,lsaddr,funcva,errcnt,totcnt); 
  else sprintf(ln," %02x%04x %d %d/%02d: ",msaddr,lsaddr,funcva,errcnt,totcnt);

  if (bcdshow) {                            /* show bcd? */
    for (k=0; k<ubi;) {
      for (i=(k==0?16:0); i<25 && k<ubi; i++,k++) ln[i] = bcd[ub[k]];
      ln[i] = 0;
      printf("%s<\n", ln);
      }
    }
  else {                                    /* show ascii? */
    for (k=0; k<uci;) {
      for (i=(k==0?16:0); i<25 && k<uci; i++,k++) 
        if (uc[k] < ' ' || uc[k]>=127) ln[i] = '_'; else ln[i] = uc[k];
      ln[i] = 0;
      printf("%s<\n", ln);
      }
    }
}

void cw_idle()              /* idle codeword found!, clean up variables */
{
  if (flagaddr) print_msg();
  totcnt = errcnt = flagaddr = ubi = uci = uc_k = uc_i = 0;  /* clear meta */
}

void ecc()                 /* perform ecc on codeword in s1,s2 */
{
  int i, k, b[31], t1,t2;
  for (t2=s2,i=0; i<15; i++) { t2 = t2 >> 1; b[i] = t2 & 1; }
  for (t1=s1,i=15; i<31; i++) { b[i] = t1 & 1; t1 = t1 >> 1; }
  totcnt++;                            /* count up codewords in message */
  if ((k=bch(b)) == 0) return;         /* 0 = no errors detected, return */
  if (k != 1) errcnt++;                /* 1,2 = 1,2 corrected errors */
  if (k < 0) return;                   /* -1 = uncorrected error, return */
  for (s1=0,i=30; i>14; i--) { s1 = s1 << 1; s1 = s1 | b[i]; }
  for (s2=0,i=14; i>=0; i--) { s2 = s2 | b[i]; s2 = s2 << 1; }
}

void cw_put(int frame)          /* decode codeword */
{
  int i, k, n, t1, t2;
/*  printf("%02d %04x%04x\n", frame, s1,s2);  */
  if (BITERR >= ones(s1^MSIDLE) + ones(s2^LSIDLE)) {  /* idle codeword? */
    cw_idle();                                        /* so, print message */
    return; 
    }
  ecc();                                      /* ecc the codeword */
  if (!(s1 & 0x8000)) {                       /* address codeword? */
    cw_idle();                                /* so, print prior message */
    msaddr = s1 >> 10;                        /* determine msg's address */
    lsaddr = (s1 << 6) + (s2 >> 10);
    lsaddr = (lsaddr & 0xfff8) | frame;       /* note frame# is part of it! */
    funcva = (s2 >> 11) & 3;                  /* save source address */
    flagaddr = 1;                             /* set new msg flag */
    return;                                   /* then return */
    }
  for (i=k=n=0,t1=s1,t2=s2; n<20; n++) {      /* decode message into bufs */
    t1 = t1 << 1;
    uc_k = uc_k >> 1;
    k = k << 1;
    if (t1 & 0x8000) { uc_k = uc_k | 0x40; k++; }  /* ascii is flipped! eek */
    if (t2 & 0x8000) t1++;
    t2 = t2 << 1;
    if (++i == 4) { ub[ubi++] = k; i = k = 0; }               /* bcd */
    if (++uc_i == 7) { uc[uci++] = uc_k; uc_i = uc_k = 0; }   /* ascii */
    }
}

/*--- stream decoding ---*/

static double ave=0, aveold=0;

void frame_sync(int gin)        /* take a bit, give a bit */
{
  static int n;

  s1 = s1 << 1;                      /* update the current 16 bit word */
  if ((s2 & 0x8000) != 0) s1++;
  s2 = s2 << 1;
  if (gin) s2++;

  if (cw <= 0) {                     /* not yet in a batch? */
    if (n++ == 15) {                 /* anyway, every 16 bits */
      n=0; 
      if (raw) printf("%04x\n", s2);
      if (cw < 0) if (++cw == 0) { cw_idle(); printf("$\n"); } /* give up */
      }
    if (BITERR >= ones(s1^MSFRM) + ones(s2^LSFRM)) {
      if (n!=0 && cw<0) printf(" [Improperly aligned bit on %d]\n",n);
      n=0; 
      cw=1;
      syncit=1;                      /* works wonders */
      }
/*
    if (ones(s2^0x5555)==0) printf("pre %04d\n", (int) aveold);
*/
    }
  else {                             /* in batch? */
    if (n++ == 31) {                 /* 32 bit codeword ready? */
      n=0; 
      cw_put((cw-1) >> 1);                    /* decode it */
      if (cw++ == 16) cw=-3;                  /* last codeword of batch */
      }
    }
}

/*-- BCH ecc decoding stuff ---*/

static int n = 31;
static int ato[32], iof[32];

initbch()
{
  int i, mask, m = 5;
  int p[6];
  p[0] = p[2] = p[5] = 1; p[1] = p[3] = p[4] =0;
  mask = 1;
  ato[m] = 0;
  for (i = 0; i < m; i++) {
    ato[i] = mask;
    iof[ato[i]] = i;
    if (p[i] != 0) ato[m] ^= mask;
    mask <<= 1;
  }
  iof[ato[m]] = m;
  mask >>= 1;
  for (i = m + 1; i < n; i++) {
    if (ato[i - 1] >= mask)
      ato[i] = ato[m] ^ ((ato[i - 1] ^ mask) << 1);
    else ato[i] = ato[i - 1] << 1;
    iof[ato[i]] = i;
  }
  iof[0] = -1;
}

bch(int recd[31])
{
  int i, j, q;
  int elp[3], s[5], s3;
  int count = 0, serr = 0;
  int loc[3], err[3], reg[3];
  int aux, length = 31;

  for (i = 1; i <= 4; i++) {
    s[i] = 0;
    for (j = 0; j < length; j++)
      if (recd[j] != 0) s[i] ^= ato[(i * j) % n];
    if (s[i] != 0) serr = 1;
    s[i] = iof[s[i]];
    };
  if (!serr) return 0;
  if (s[1] != -1) {
    s3 = (s[1] * 3) % n;
    if ( s[3] == s3 ) { recd[s[1]] ^= 1; return 1; }
    if (s[3] != -1) aux = ato[s3] ^ ato[s[3]];
    else aux = ato[s3];
    elp[0] = 0;
    elp[1] = (s[2] - iof[aux] + n) % n;
    elp[2] = (s[1] - iof[aux] + n) % n;
    for (i = 1; i <= 2; i++) reg[i] = elp[i];
    count = 0;
    for (i = 1; i <= n; i++) {
      q = 1;
      for (j = 1; j <= 2; j++)
	if (reg[j] != -1) {
	  reg[j] = (reg[j] + j) % n;
	  q ^= ato[reg[j]];
	  }
      if (!q) { loc[count] = i % n; count++; }
      }
    if (count == 2) {
      for (i = 0; i < 2; i++) recd[loc[i]] ^= 1;
      return 2;
      }
    }
  return -1;
}

int mn()
{
static unsigned int hn=0,k,s,i=0;
static double xct,exc=0.0,clk=0.0;
int b;

for (b=0; i != f->n && b<100; b++) {
  s = ((f->data[i] & 0x8000)==0) ^ invert;
  k = (f->data[i] & 0x7fff);
  clk += k;
  xct = exc + 0.5 * dt;          /* exc is current boundary */
  while ( clk >= xct ) {
    frame_sync(s);               /* send raw bit stream to first unit */
    clk = clk - dt;
    }
  if (syncit) { syncit = 0; exc = clk; }  /* sync stream if commanded */
  else exc = exc + 0.040 *(clk - exc);    /* else do this trix */
  if(++i >=BUFLEN) i = 0;                 /* update index buffer */

/*
  ave += k/ (float) HEURBITS;
  if (++hn == HEURBITS) { 
    aveold = ave;
    ave = 0;
    hn = 0; 
    }
*/
  }
}


