/*
 *      fir_filters.h -- digital filter routines
 *
 *	Copyright (C) 1996  
 *          Thomas Sailer (sailer@ife.ee.ethz.ch, hb9jnx@hb9w.che.eu)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  The digital filter routines. This is the most performance critical
 *  part of the fax demodulator. These routines are separated to facilitate
 *  optimizing them (i.e. writing them in assembler and carefully
 *  hand scheduling instructions).
 *
 *  Note that float_fir_symm and float_fir_symm_hilbert do the same as
 *  float_fir. They expect however that the coefficients have even symmetry
 *  (float_fir_symm, coeff[i] == coeff[n-1-i]) or odd symmetry
 *  (float_fir_symm_hilbert, coeff[i] == -coeff[n-1-i]). Depending on the CPU 
 *  architecture, these routines may just be aliases for float_fir, or exploit
 *  symmetry of the coefficients. Neither routine should assume any symmetry
 *  in state.
 */

/* ---------------------------------------------------------------------- */

#ifndef _FIR_FILTERS_H
#define _FIR_FILTERS_H

/* ---------------------------------------------------------------------- */

#define __FP static __inline__

/* ---------------------------------------------------------------------- */
/* 
 * architecture defines
 * ARCH_X86
 * ARCH_SPARC
 */
/* ---------------------------------------------------------------------- */

#ifdef ARCH_X86
#include "fir_x86.h"
#elifdef ARCH_SPARC
#include "fir_sparc.h"
#else
#include "fir_generic.h"
#endif

/* ---------------------------------------------------------------------- */
#endif /* _FIR_FILTERS_H */
