/*
 *      soundif.h -- access Linux/Solaris sound driver
 *
 *	Copyright (C) 1996  
 *          Thomas Sailer (sailer@ife.ee.ethz.ch, hb9jnx@hb9w.che.eu)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* ---------------------------------------------------------------------- */

#ifndef _SOUNDIF_H
#define _SOUNDIF_H

/* ---------------------------------------------------------------------- */

extern int soundif_fd;
extern char soundif_name[256];

/* ---------------------------------------------------------------------- */

void soundif_stop(void);
int soundif_start(int sample_rate, int mode);

/* ---------------------------------------------------------------------- */

#define SOUNDIF_PUTVAL(p,v) (((short *)p) = v)
#define SOUNDIF_PUTVALINC(p,v) (((short *)p)++ = v)
#define SOUNDIF_PUTVALDEC(p,v) (((short *)p)-- = v)
#define SOUNDIF_GETVAL(p) (((short *)p))
#define SOUNDIF_GETVALINC(p) (((short *)p)++)
#define SOUNDIF_GETVALDEC(p) (((short *)p)--)
#define SOUNDIF_VALSIZE 2 

/* ---------------------------------------------------------------------- */

#endif /* _SOUNDIF_H */
