/*
 *      xgraphif.h -- invoke xgraph to display traces
 *
 *	Copyright (C) 1996  
 *          Thomas Sailer (sailer@ife.ee.ethz.ch, hb9jnx@hb9w.che.eu)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* ---------------------------------------------------------------------- */

#ifndef _XGRAPHIF_H
#define _XGRAPHIF_H

/* ---------------------------------------------------------------------- */

#define XGM_DEFAULT 0
#define XGM_MOVE 1
#define XGM_DRAW 2

/* ---------------------------------------------------------------------- */

extern int xgraph_fd;

/* ---------------------------------------------------------------------- */

int xgraph_open(const char *argv[]);
void xgraph_close(void);
void xgraph_newset(const char *setname);
void xgraph_newdata(int mode, float x, float y);
void xgraph_settitle(const char *title);

/* ---------------------------------------------------------------------- */

#endif /* _XGRAPHIF_H */

