// CI-5 Command Layer 
// For all products
// FILENAME read_id.cpp
// READ ID
// 9-23-98
// Optoelectronics Inc.// All rights reserved
//
// Finished for OptoCom on 11-11-98

// NOTE: This function does nothing more
// than make sure the device is responding.
// Although it loads the response buffer
// with valid data, we are not parsing it
// here, because we already have valid
// data that was obtained from the get_id
// function while searching for the device
// in the beginning. Any calls to this 
// function should only be used for keeping
// a loop alive. That is, making sure we
// don't lose contact with a device while
// waiting for user input or something like
// that. Also, it is better to use the
// read_status function wherever it is available.
// This function is here for those devices 
// which do not support read_status

int read_id(void)
{

	// Local variables

	int result;

// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x09;
	 command[6] = 0xFD;
	 command[7] = 0xFF;



// Command is now ready to send.


	 Send_command();
 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 
// Extract ID code from response buffer



       id[0] = response[4];
       id[1] = response[5];
       id[2] = response[6];



   // If we have found the OptoCom, set the global
   // variable 'device' to OPTOCOM.

	   if ( (id[0] == 0x50) && (id[1] == 0x54) && (id[2] == 0x43) )
	   {
		   device = OPTOCOM;
	   }
	   if ( (id[0] == 0x35) && (id[1] == 0x33) && (id[2] == 0x35) )
	   {
		   device = OPTOSCAN;
	   }


	 return SUCCESS;
}


// CI-5 Command Layer 
// Used only by Search for product function
// FILENAME read_id.cpp
// GET ID
// 10-16-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

// NOTE: Must be this way because we cannot use Send_command()
// when searching for a product, since there is never a SUCCESS
// followed by a TIMEOUT, to reset the count in timeout();


int get_id(void)
{

	// Local variables

	int result;
	unsigned char tens;
	unsigned char ones;
		

// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x09;
	 command[6] = 0xFD;
	 command[7] = 0xFF;



// Command is now ready to send.


	 
  result = comm_loop();

   if (result == TIMEOUT)
   {
	   return TIMEOUT;
   }
   		
        // Test to see which product it is
        // With a valid Read ID response, the first byte should
		// always be at 4, and the last should always be at 6.
		// We must check to see
		// which address worked so we will know how to extract the
		// ID code, and other version info. Some products have more
		// version info than others.
		


// Extract ID code from response buffer



       id[0] = response[4];
       id[1] = response[5];
       id[2] = response[6];



   // If we have found the OptoCom, set the global
   // variable 'device' to OPTOCOM.

	   if ( (id[0] == 0x50) && (id[1] == 0x54) && (id[2] == 0x43) )
	   {
		   device = OPTOCOM;
	   }
	   if ( (id[0] == 0x35) && (id[1] == 0x33) && (id[2] == 0x35) )
	   {
		   device = OPTOSCAN;
	   }


   return SUCCESS;


}