// Get Input Function
// Pass it an x,y coordinate of where to place
// the input field. It returns DONE if valid
// input is complete, or the normal error codes
//
// Finished for OptoCom on 11-11-98


int get_input(int x, int y)
{

	// Local Variables
	int result;
	int a;
    char key;

start:
	for (;;)
	{

		// Step one: Read ID to find out if we lost communication
		// Must use ID and not status since not all devices support
		// the status command, and we want this to be accessible
		// in all situations.
		
		// Actually, it's faster - added 6-14-99
		
		result = read_id();
        // Check for timeout
		if (result == TIMEOUT)
		{
		   return TIMEOUT;
		}

		// Show cursor
		  gotoxy(pos + x, y);
		  cprintf("_");

		// Step two: Call get_serial_digit to poll for character
		key = Get_serial_digit();

		if (key == ESCAPE)
		{
			// Clear input field
			gotoxy(x,y);
			cprintf("                    ");
			// clear pos variable
			pos = 0;

			return ESCAPE;
		}
		// Check for request to exit program
		if (key == NORMAL_EXIT)
		{
			return NORMAL_EXIT;
		}

		// If it didn't return an escape or normal exit, or zero
		// That means the array was updated with a new
		// character, so we must now update the display
		
		if (key) // Only update display if a key was pressed
		{
			// See if the input error was cleared
			if (input_error == 0)
			{
				// Clear error message
				gotoxy(x - 22, y + 1);
				cprintf("                        ");
			}


		    // Clear field from left to pos - 1
                   
		    for (a = x; a <= (x +(pos -1)); a++)
			{           
			     gotoxy(a,y);
			     cprintf(" ");
			}
		
		    // Clear field from right to pos + 1

		  for (a = x + 20; a >= (x + (pos + 1)); a--)
		  {
			   gotoxy(a,y); 
		       cprintf(" ");
		  } 

		  // Show contents of key buffer
		  gotoxy(x,y);
		  cprintf("%s", key_buf);
		  // Show cursor
		  gotoxy(pos + x, y);
		  cprintf("_");

		}
		
		
		// After updating the display
		if (key == ENTER) 
		{
			// First make sure the user entered
			// something before hitting enter
			if(strlen(key_buf) == 0)
			{
				// If they didn't, show an
				// error message
				
				// input_error is a global error flag
				// that gets cleared the next time a character
				// is entered in the get_serial_digit function
				
				// Set error flag
				input_error = 1;
				// Set color to Red
				textcolor(RED);
				// Go to error field location
		        gotoxy(x - 22, y + 1);
				// Display text
		        cprintf("You must enter something");
				// Reset color to White
			    textcolor(WHITE);
			    // Start all over
				goto start;
			}

			// Clear input field before returning
			gotoxy(x,y);
			cprintf("                    ");
			return DONE;
		}

	} // end of for(;;) loop
}





// Get Serial Digit Function
// This function will get one character and add it to the end of
// the global key_buf array. It is for multithreaded character entry.
// variables pos and serial_number are global
// returns: NORMAL_EXIT, ESCAPE, ENTER, or zero if no key entered
//
// Finished for OptoCom on 11-11-98

int Get_serial_digit(void)
{
	// Local variables
	
	char key;


	// Get character from keyboard
	key = read_kb();

	// Check for CTRL-X
    if (key == CTRL_X) 
	{
		return NORMAL_EXIT;
	}

	if (key == ESCAPE) // check for ESCAPE
	{
	   return ESCAPE;
	}

	// Check for normal character
	if ((key >= 0x20) && (key <=0x7E))
	{
	    // If there was previously an error
		if (input_error)
		{
			// Clear the error flag
		    input_error = 0;
		}

		// Store the keystroke in the buffer
		key_buf[pos] = key;
		pos++;
						
		if (pos > 12) // make sure we don't go
		{             // out of bounds
    	    pos = 12;
		}

		// Terminate string
		key_buf[pos] = NULL;

        // Return the character pressed
		return key;
		   	
	}

	// If it was the backspace key
    if (key == 0x08) 
	{
		// Decrement the pointer
	   	pos--;

		if (pos < 0) // make sure we don't go out
		{            // of bounds
			pos = 0;
		}

		// Terminate string
		key_buf[pos] = NULL;
		// Return the key that was pressed
		return key;
	}

	// If it was the enter key
	if (key == ENTER)
	{
		// Terminate string with null first
		key_buf[pos] = NULL;
		// Clear pos variable
		pos = 0;
		// Then tell calling function we are done
		return ENTER;
	}

	return 0; // No character entered
}




// Function READ_KB()
// Checks to see if there is a character waiting to 
// be retrieved from the software keyboard buffer.
// If there is no keystroke waiting, it returns a zero.
//
// Finished for OptoCom on 11-11-98

int read_kb(void)
{
   // Local variable
	
   int key;


   // is there another keystroke in the buffer?
   if (kbhp != kbtp)  
   {
	   key = keybuffer[kbtp]; // get keystroke from buffer
	   kbtp++;                // point to next keystroke in buffer
	 
        return key;
   }
   

   return 0;
}

// Function SCAN_KB()
// Checks to see if there is a character waiting to 
// be retrieved from the hardware keyboard buffer.
// If there is a keystroke, it puts it into the software buffer
// If there is no keystroke waiting, it returns a zero.

void scan_kb(void)
{
 
	// Local variable
	int temp_kbhp;
	int key;

	// If there is a keystroke waiting in the hardware buffer
    if(bioskey(1))
    {
		// Get keystroke from hardware buffer  
	    key = bioskey(0);

		// If it is an extended character
	    // such as alt - something, or a function key
	    if ( ((key & 0xFF) == 0) || ((key & 0xFF) == 0x00FF) )
        
		{ 
	        // Right shift to move extended code
	        // into proper place,
		    key = key >> 8;

		    // Move code above standard ASCII table
		    key = key + 127; 
	  }

	  keybuffer[kbhp] = key; // store current keystroke in buffer
      
	  
	  // Increment pointer if buffer is not full
          
	  // To check for full buffer

	  // Make temporary copy of head pointer
	  temp_kbhp = kbhp;
        
	  // Decrement copy of head pointer once
	  temp_kbhp--;
	  
	  // if they are not equal, the buffer is not full
	  if (kbtp != temp_kbhp)
	  {
		  // So, point to next location
	      kbhp++;
	  }
		 
   }
}



