// CI-5 Command Layer 
// 
// FILENAME modes.cpp
// ENABLE DCS MODE
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_DCS_mode(void)
{
	// Local variables
	int attempts = 0;

start:
    // Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x11;
     command[6] = 0x00; // DCS MODE
	 command[7] = 0xFD;
     command[8] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it
	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good
	  
	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

return FATAL_ERROR; // If we get here, something is really wrong.
}




// CI-5 Command Layer 
// 
// FILENAME modes.cpp
// ENABLE LTR MODE
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_LTR_mode(void)
{
	// Local variables
	int attempts =0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x11;
	 command[6] = 0x01;
	 command[7] = 0xFD;
     command[8] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it

	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good

	  
	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

return FATAL_ERROR; // If we get here, something is really wrong.
}


// CI-5 Command Layer 
// 
// FILENAME modes.cpp
// ENABLE AM MODE
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_AM_mode(void)
{
	// Local variables
	int attempts =0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x06;
	 command[5] = 0x02;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it

	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good

	 if (response[2] == 0xFB)
	 {
		 return GOOD;
	 }

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

return FATAL_ERROR; // If we get here, something is really wrong.
}

// CI-5 Command Layer 
// 
// FILENAME modes.cpp
// ENABLE NFM MODE
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_NFM_mode(void)
{
	// Local variables
	int attempts =0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x06;
	 command[5] = 0x05;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it

	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good

	  
		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.
}

// CI-5 Command Layer 
// 
// FILENAME modes.cpp
// ENABLE WFM MODE
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_WFM_mode(void)
{
	// Local variables
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x06;
	 command[5] = 0x06;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it

	 Send_command();
 		 
	// Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 // Make sure the response is good

	  
		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

return FATAL_ERROR; // If we get here, something is really wrong.
}

// CI-5 Command Layer
// FILENAME audio.cpp
// ENABLE REMOTE VOLUME/SQUELCH
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_remote_volume_squelch_mode(void)
{
	// Local variables
	int attempts =0;

start:
		
     // Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x13;
     command[6] = 0x01; // Enable remote mode
	 command[7] = 0xFD;
     command[8] = 0xFF;
    
     // Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


     // At this point, we know we have success

	 // Using result code, parse the data.



		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}


// CI-5 Command Layer 
// FILENAME audio.cpp
// ENABLE LOCAL VOLUME/SQUELCH
// 10-8-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for OptoCom on 11-11-98

int Enable_local_volume_squelch_mode(void)
{
	// Local variables
	int attempts = 0;
		
start:
     // Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x13;
     command[6] = 0x00; // Enable local mode
	 command[7] = 0xFD;
     command[8] = 0xFF;
    
	// Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


     // At this point, we know we have success

	 // Using result code, parse the data.



		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}

int Switch_Optocom_mode(void)
{
	// Local Variables

	int result;
	int attempts = 0;

start:
	// If we are in Optocom mode
	if (device == OPTOCOM)
	{
		// Load command buffer
	    command[0] = 0xFE;
	    command[1] = 0xFE;
	    command[2] = address;  // global
	    command[3] = 0xE0;
	    command[4] = 0x7F;
	    command[5] = 0xD2;
	    command[6] = 0x15;
	    command[7] = 0x31;
	    command[8] = 0x48;
	    command[9] = 0x78;
	    command[10] = 0x60; 
	    command[11] = 0x01; // Enable OS535 emulation
	    command[12] = 0xFD;
	    command[13] = 0xFF;
	}

	if (device == OPTOSCAN)
	{
		// Load command buffer
	    command[0] = 0xFE;
	    command[1] = 0xFE;
	    command[2] = address;  // global
	    command[3] = 0xE0;
	    command[4] = 0x7F;
	    command[5] = 0xD2;
	    command[6] = 0x15;
	    command[7] = 0x31;
	    command[8] = 0x48;
	    command[9] = 0x78;
	    command[10] = 0x60; 
	    command[11] = 0x00; // Return to normal
	    command[12] = 0xFD;
	    command[13] = 0xFF;
	}

	// Set expected response length
	 // See spec manual
	 expected = 4;

	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }
	
	     // if good
		 if (response[2] == 0xFB)
		 {
			 // read id to update info
			 result = read_id();
	         if (result == TIMEOUT)
			 {
		         return TIMEOUT;
			 }

	         return SUCCESS;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

// If we get here, something is wrong
	return FATAL_ERROR;
}


// Enable Scan Mode

int Enable_scan_mode(void)
{

	 // Local variables
	 int attempts = 0;

start:
     // Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x18;
     command[6] = 0x01; // Enable scan mode
	 command[7] = 0xFD;
     command[8] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


     // At this point, we know we have success

	 // Using result code, parse the data.



		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}


// Disable Scan Mode

int Disable_scan_mode(void)
{

	// Local variables
	int attempts = 0;

start:
     // Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x18;
     command[6] = 0x00; // Disable scan mode
	 command[7] = 0xFD;
     command[8] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


     // At this point, we know we have success

	 // Using result code, parse the data.



		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}

int Store_operating_parameters(void)
{

	// Local variables
	int attempts = 0;

start:

	// Load the command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0xD3;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Set expected response length
	 // See spec manual
	 expected = 4;


	 // Command is now ready to send, so send it
    
	 Send_command();

	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }


     // At this point, we know we have success

	 // Using result code, parse the data.



		 if (response[2] == 0xFB)
		 {
			 return GOOD;
		 }

		if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}


return FATAL_ERROR; // If we get here, something is really wrong.


}

int Read_mode(void)
{   
	// Local variables
	int attempts;
    
	start:

	// Load command buffer
	command[0] = 0xFE;
	command[1] = 0xFE;
	command[2] = address; // global
	command[3] = 0xE0;
	command[4] = 0x4;
	command[5] = 0xFD;
	command[6] = 0xFF;

	// Set expected response length
	 // See spec manual
	 expected = 5;

	//  Command is now ready to send, so send it
	Send_command();

	// Check to see if timeout occurred

	if (count >= TIMEOUT_VALUE)
	{
		return TIMEOUT;
	}

	//  Check for error response
	if (response[2] == 0xFA) 
	{
		//Try up to 3 times per call
		attempts = attempts + 1;
		if (attempts > 3) 
		{
			return BAD;
		}
        
		goto start;
	}
   
	//  Parse Response
	if (response[3] == 2)
	{
		mode = AM;
		return SUCCESS;
	}
    
	if (response[3] == 5)
	{
		mode = NFM;
		return SUCCESS;
	}

	if (response[3] == 6)
	{
		mode = WFM;
		return SUCCESS;
	}
    
	   //If we get here, something really went wrong
	   return FATAL_ERROR;
   
}
