 // Product Layer
// Optocom Direct Frequency Entry
// FILENAME odfe.cpp
// 10-29-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for Optocom on 11-19-98

int Optocom_direct_frequency_entry(void)
{

	// Local Variables

	int result; 
	char key;
    int a;
	int b;
	long temp_freq;

	// Store time into last_dtmf_call so there will be
	// something there. This keeps the program from
	// inserting a space into the buffer the first
	// time through the loop.

	last_dtmf_call = clock();

	// Clear DTMF buffer pointer 
	dtmf_buffer_pointer = 0;

	// Clear DTMF buffer 
	// (Borrowing the 'result' variable)

	for (result = 0; result <=20; result++)
	{
		dtmf_buffer[result] = NULL;
	}

	// Clear screen
	clr_ol_fields();

// Read frequency
result = Read_frequency();
if (result == TIMEOUT)
{	
	return TIMEOUT;
}

// Read mode
result = Read_mode();
if (result == TIMEOUT)
{	
	return TIMEOUT;
}

// Store current frequency temporarily
temp_freq = n_frequency;

// Check for cellular
result = Check_cellular();
if (result == TIMEOUT)
{
	return TIMEOUT;
}
	
// Restore previous frequency
result = Write_frequency(temp_freq);
if (result == TIMEOUT)
{
	return TIMEOUT;
}

// Read initial status
result = Read_status();
if (result == TIMEOUT)
{
	return TIMEOUT;
}


// Check first Store and Scan memory, and set
// Store and Scan "On" radio button appropriately.
// If there is nothing in memory zero, it must be
// disabled.

// Read memory zero to see if it is empty


result = Read_memory(0);
if (result == TIMEOUT)
{
    return TIMEOUT;
}

if (n_frequency == 0)
{
	MemoryZeroEmpty = 1;
}
else
{
	MemoryZeroEmpty = 0;
}



// Initialize screen
 initialize_screen();

	// This loop will iterate until a timeout or
	// the user requests to exit the program


    for(;;)
	{

		// READ SECTION
		
		result = reads();
		if (result == TIMEOUT)
		{
			return TIMEOUT;
		}


		// DISPLAY UPDATE SECTION

		    
        // Display frequency
        // only if not in entry mode

		update_display();


		// Handle keyboard entry
		result = keyboard_entry();
		if (result == TIMEOUT)
		{
			return TIMEOUT;
		}

		
        // KEYBOARD SCAN SECTION
		result = scan_keys();
		if (result == TIMEOUT)
		{
			return TIMEOUT;
		}

		if (result == NORMAL_EXIT)
		{
			return NORMAL_EXIT;
		}

    } // end for(;;)  

} // end function



void clr_ol_fields(void)
{
	// This function clears the screen whenever needed

	// Local Variable
	int x;
    int y;

// Top portion of screen

	for (y = 5; y <= 9; y++)
	{
		for (x = 2; x <= 78; x++)
		{
			gotoxy(x,y);
		    cprintf(" ");
		}
	}


// Bottom portion of screen

    for (y = 11; y <= 20; y++)
	{
		for (x = 2; x <= 78; x++)
		{
			gotoxy(x,y);
		    cprintf(" ");
		}
	}

// DTMF Section
	for (x = 2; x <=78; x++)
	{
		gotoxy(x,22);
		cprintf(" ");
	}

}


void initialize_screen(void)
{

	/// Footer fields

    // Create Emulation field
    Field lblEmulation("Emulation",5,24,LIGHTMAGENTA);
	
	// Highlight control letter
	lblEmulation.Highlight('m',YELLOW);
	
	// Display current Emulation
	if (device == OPTOCOM)
	{
		fldEmulation.Text("Optocom");
	}
	
	if (device == OPTOSCAN)
	{
		fldEmulation.Text("OS535  ");
	}

	
	
	// Create Store and Scan label
	Field lblStoreScan("Store and Scan",28,24,LIGHTMAGENTA);
	// Highlight control letter
	lblStoreScan.Highlight('o',YELLOW);

	if (scan_mode)
	{
		fldStoreScan.Text("On");
	}
	else
	{
		fldStoreScan.Text("Off");
	}

	// Create MemoryZeroAlert field
	Field fldMemoryZeroAlert("", 48,24, LIGHTRED);

	if (MemoryZeroEmpty)
	{
		fldMemoryZeroAlert.Text("Memory Zero is Empty");
	}
	else
	{
		fldMemoryZeroAlert.Text("");
	}



	/// Upper fields

	// Create Controls field
    Field lblControls("Controls",3,5,LIGHTGREEN);
	
	// Create Exit information fields
	Field lblExit1("CTRL-X",3,7,LIGHTGRAY);
	Field lblExit2("To Exit",3,8,LIGHTGRAY);

	// Create Change frequency field
	Field lblChng_freq("Change Frequency",13,5,LIGHTMAGENTA);
	// Highlight control letter
	lblChng_freq.Highlight('F',YELLOW);

	// Create Narrow FM label field
    Field lblNarrow_FM("Narrow FM Mode",13,6,LIGHTMAGENTA);
	// Highlight control letter
	lblNarrow_FM.Highlight('N',YELLOW);

	// Create Wide FM label field
    Field lblWide_FM("Wide FM Mode",13,7,LIGHTMAGENTA);
	// Highlight control letter
	lblWide_FM.Highlight('W',YELLOW);

	// Create AM label field
	Field lblAM("AM Mode",13,8,LIGHTMAGENTA);
	// Highlight control letter
	lblAM.Highlight('A',YELLOW);

	// Create Relay label field
	Field lblRelayToggle("Toggle Tape Relay",13,9,LIGHTMAGENTA);
	// Highlight control letter
	lblRelayToggle.Highlight('T',YELLOW);

	// Create Toggle CTCSS label field
	Field lblToggle_CTCSS("Toggle CTCSS/DCS or LTR",40,5,LIGHTMAGENTA);
    // Highlight control letter
	lblToggle_CTCSS.Highlight('/',YELLOW);

	// Create Toggle speaker label field
	Field lblToggle_speaker("Toggle Speaker",40,6,LIGHTMAGENTA);
	// Highlight control letter
	lblToggle_speaker.Highlight('S',YELLOW);

	// Create Clear DTMF label field
	Field lblClear_DTMF("Clear DTMF Buffer",40,7,LIGHTMAGENTA);
	// Highlight control letter
	lblClear_DTMF.Highlight('D',YELLOW);

	// Create Volume control label field
	Field lblVolCtl("Remote/Local Volume Control",40,8,LIGHTMAGENTA);
	// Highlight control letters
	lblVolCtl.Highlight('R',YELLOW);
	lblVolCtl.Highlight('L',YELLOW);

	
	/// Lower Section

	// Top Row 
    Field lblFrequency("Frequency",10,12,mainfields);
	lblCTCSS.Text("CTCSS");
	Field lblMode("Mode",31,12,mainfields);
	Field lblSpeaker("Speaker",64,12,mainfields);
	
	// Second Row
	Field lblSignal("Signal Strength",7,15,mainfields);
	Field lblSigdBm("-",9,16,WHITE);
	Field lblSigdBm2("dBm",15,16,WHITE);
	Field lblVolSql("Volume/Squelch",26,15,mainfields);
	lblDCS.Text("DCS");
	Field lblModulation("Modulation",63,15,mainfields);

	// Third Row
	Field lblSquelch("Squelch Status",8,18,mainfields);
	Field lblRelay("Tape Relay",28,18,mainfields);
    Field lblLTR("LTR",48,18,DARKGRAY);

	
	/// DTMF Section

	// Create DTMF label field
	Field lblDTMF("DTMF:",3,22,WHITE);



	/// Initialize fields

	// Speaker Control
	if(speaker_control)
	{
		fldSpeaker.Text(" On ");
		//cprintf(" On  ");
	}
	else
	{
		fldSpeaker.Text("Muted");
		//cprintf("Muted");
	}

	// Tape Control
    if (tape_control)
	{
		fldTape_control.Text("On ");
		//cprintf("On ");
	}
	else
	{
		fldTape_control.Text("Off");
		//cprintf("Off");
	}

	// NRZ Mode 
	if (nrz_mode == DCS)
	{
        lblLTR.Color(DARKGRAY);
	    lblDCS.Color(mainfields);
	}

	if (nrz_mode == LTR)
	{
		lblLTR.Color(mainfields);
		lblDCS.Color(DARKGRAY);
	}




return;

}


int reads(void)
{
	// Local variables
	int result = 0;

		// Read Status
		result = Read_status();
        // Check for timeout
		if (result == TIMEOUT)
		{
			return TIMEOUT;
		}

	    // Read frequency
	   	result = Read_frequency();
	    if (result == TIMEOUT)
		{ 
	       return TIMEOUT;
		}
	
		// Read Volume Setting
		result = Read_volume_setting();
		// Check for timeout
		if (result == TIMEOUT)
		{
		    return TIMEOUT;
		}

		// Read Squelch Setting
		result = Read_squelch_setting();
		// Check for timeout
		if (result == TIMEOUT)
		{
		    return TIMEOUT;
		}

		// Read mode if in store and scan mode
		if (scan_mode)
		{
			result = Read_mode();
			if (result == TIMEOUT)
			{
				return TIMEOUT;
			}
		}

		// Check signal Strength
		// only if squelch is open
		if (squelch_status)
		{
			result = Read_signal_strength();
			// Check for timeout
			if (result == TIMEOUT)
			{
				return TIMEOUT;
			}


				/////////////////////////////////////////////////
				// TONE READ SECTION
				/////////////////////////////////////////////////


				// Check for active CTCSS.
				// The ctcss_active variable is
				// derived and set from the 
				// read_status function

				if (ctcss_active)
				{
					// Read the CTCSS tone
					result = Read_CTCSS();
					// Check for timeout
					if (result == TIMEOUT)
					{
						return TIMEOUT;
					}
					
				}
				
				// If the nrz_mode is DCS
				// nrz_mode is derived and set from the
				// read_status function
				if (nrz_mode == DCS)
				{
					// Check for the presence
					// of a DCS tone

					// If NRZ is active it means we have 
					// an active DCS tone.
					// The nrz_active variable is
	     			// derived and set from the 
					// read_status function

					if (nrz_active)
					{
						// Read the DCS tone
						result = Read_DCS();
						// Check for timeout
						if (result == TIMEOUT)
						{
							return TIMEOUT;
						}

					}
				} // end if (nrz_mode == DCS)

				// If nrz_mode is LTR
				// nrz_mode is derived and set from the
				// read_status function
				if (nrz_mode == LTR)
				{
					// Next, check for LTR data
					
					// If NRZ is active it means we have 
					// active LTR data.
					// The nrz_active variable is
	     			// derived and set from the 
					// read_status function

					if (nrz_active)
					{
						// Read the LTR data
						result = Read_LTR_data();
						// Check for timeout
						if (result == TIMEOUT)
						{
							return TIMEOUT;
						}

					}
				}

				

				// Check for pending DTMF digit
				if (dtmf_pending)
				{
					// Read the digit
					result = Read_DTMF_digit();
					// Check for timeout
    				if (result == TIMEOUT)
					{
					   return TIMEOUT;
					}

					// Update DTMF buffer

					// Get current time
					now = clock();

					// Have 2 seconds or more elapsed since the
					// last call to this function?
					// If so, insert a space into the buffer

					if(((now - last_dtmf_call) / CLK_TCK) > 2)
					{
						// Make temp copy of current digit
						temp_dtmf_digit = dtmf_digit;
						// Replace current digit with space
						dtmf_digit = ' ';
						// Insert space into buffer
						dtmf();
						// Now place real current digit back into dtmf_digit
						dtmf_digit = temp_dtmf_digit;
						// Place digit in buffer
						dtmf();
					}
					// Otherwise, just put the new digit in the buffer
					else
					{
						dtmf();
					}

				}
		}
}

void update_display(void)
{
		if (!entry)
		{
			fldFrequency.Text(frequency);
		}

		// Display the current mode

		gotoxy(29,13);
		if (mode == NFM)
		{ 
			fldMode.Text("Narrow FM");
		}
		if (mode == WFM)
		{
			fldMode.Text("Wide FM");
		}
		if (mode == AM)
		{
			fldMode.Text("   AM    ");
		}

		// Display Emulation
		if (device == OPTOCOM)
		{
			fldEmulation.Text("Optocom");
		}
		else
		{
			fldEmulation.Text("OS535");
		}
		// Display Audio status

		gotoxy(65,16);
		if(audio_status)
		{
			fldModulation.Text("Present");
		}
		else
		{
			fldModulation.Text(" None  ");
		}


		// Display Volume/Squelch control status

		gotoxy(30,16);
		if (volume_squelch_control_status)
		{
			fldLR.Text("Remote");
		}
		else
		{
			fldLR.Text("Local");
		}
		

		// Display Volume setting
		fldVol.Text(volume_setting);
		
		// Display Squelch setting
		fldSql.Text(squelch_setting);
		
		// Display Volume or Squelch control
		// indicator arrow

		// If we are in remote mode
		if (volume_squelch_control_status)
		{
			// If we are in Volume adjust mode

			if (volume_squelch_control_indicator == VOLUME)
			{
				// Show arrow under the volume side
				
				gotoxy(27,17);
			    cprintf("%c", 24);
				// Remove arrow from the squelch side
				gotoxy(38,17);
			    cprintf(" ");
			}
			
			// if we are in Squelch adjust mode
			if (volume_squelch_control_indicator == SQUELCH)
			{
				// Show arrow under the squelch side
			
			   gotoxy(38,17);
			    cprintf("%c", 24);
				// Remove arrow from the volume side
				
				gotoxy(27,17);
			    cprintf(" ");
			}
			
		} // end if (volume_squelch_control_status)
        
		// If we are in local mode
		else
		{
			// Remove indicator from both sides
			
			gotoxy(27,17);
			cprintf(" ");
			gotoxy(38,17);
			cprintf(" ");
		}

		// Display Signal Strength
		// only if squelch is open
		if (squelch_status)
		{
			fldSignal.Color(WHITE);
			fldSignal.Text(signal);
		}
		
		else
		{
			fldSignal.Color(DARKGRAY);
			fldSignal.Text("---");
		}

		// Display Squelch Status

		if (squelch_status)
		{
			fldSquelch.Text(" Open ");
		}
		if (!squelch_status)
		{
			fldSquelch.Text("Closed");
		}

		
		// If in scan mode, show
		// speaker status
		if (scan_mode)
		{
			if (speaker_control)
			{
				gotoxy(65,13);
				cprintf(" On  ");
			}
			else
			{
				gotoxy(65,13);
				cprintf("Muted");
			}

		}

		// Update Tone section
if (ctcss_active)
{
	// Display CTCSS tone
	fldCTCSS.Color(WHITE);
	fldCTCSS.Text(ctcss);
	// Turn Hz label to White
	lblHz.Color(WHITE);

}
// If the CTCSS tone is not currently active
else
{
   // Remove the CTCSS tone from the display
	// but only if nrz_mode is DCS
	if(nrz_mode==DCS)
	{
		fldCTCSS.Color(DARKGRAY);
		fldCTCSS.Text("-----");
		

		lblHz.Color(DARKGRAY);
	}
}


// If the nrz_mode is DCS
// nrz_mode is derived and set from the
// read_status function
if (nrz_mode == DCS)
{
	// Remove the LTR 
	// data field from the screen
	
	lblLTR.Remove();
	fldArea.Remove();
	fldGoto.Remove();
	fldHome.Remove();
	fldId.Remove();
	fldFree.Remove();
	
	// Check for the presence
	// of a DCS tone

	// If NRZ is active it means we have 
	// an active DCS tone.
	// The nrz_active variable is
	// derived and set from the 
	// read_status function

	if (nrz_active)
	{
		// Display the DCS tone
		fldDCS.Color(WHITE);
		fldDCS.Text(dcs);
	}
	// If the DCS tone is not currently active
	else
	{
		// Remove the DCS tone from the display
		fldDCS.Color(DARKGRAY);
		fldDCS.Text("---");
	}
} // end if (nrz_mode == DCS)

// If nrz_mode is LTR
// nrz_mode is derived and set from the
// read_status function
if (nrz_mode == LTR)
{
	// Remove DCS data
	// field from screen,
	fldDCS.Remove();
	
	// Remove CTCSS data field from screen.
    fldCTCSS.Remove();

	// Make CTCSS header field grey
    lblCTCSS.Color(DARKGRAY);
   
	// Show LTR Data field descriptions
	lblLTR.Show();

	
	// Next, check for LTR data
	
	// If NRZ is active it means we have 
	// active LTR data.
	// The nrz_active variable is
	// derived and set from the 
	// read_status function

	if (nrz_active)
	{

		// Display the LTR data
		fldArea.Text(ltr_area);
		fldGoto.Text(ltr_goto);
		fldHome.Text(ltr_home);
		fldId.Text(ltr_id);
		fldFree.Text(ltr_free);
	}
	// If there is no LTR data at the moment
	else
	{
		// Remove the LTR data from the display
		fldArea.Color(DARKGRAY);
		fldArea.Text("-");
		
		fldGoto.Color(DARKGRAY);
		fldGoto.Text("--");
		
		fldHome.Color(DARKGRAY);
		fldHome.Text("--");
		
		fldId.Color(DARKGRAY);
		fldId.Text("---");
		
		fldFree.Color(DARKGRAY);
		fldFree.Text("--");
   
	}
}

		// Display DTMF Buffer
		
		textcolor(WHITE);
		gotoxy(9,22);
		cprintf("%s", dtmf_buffer);

}

int keyboard_entry(void)
{
	// Local variables
	int result = 0;
	int key = 0;
	int a;
	int b;
	int decimal = 0;
	int frequency_error = 0;
	
		// If entry = 1, user wants to input a new freq

        if (entry)
        {
			// Set text color to white
			textcolor(WHITE);
			// Show cursor
		    gotoxy(pos + 8, 13);
		    cprintf("_");


	     key = Get_serial_digit();

		 // Check for escape
		 if (key == ESCAPE)
		 {
			 entry = 0;
		     pos = 0;
			 // Clear error message if any
		     gotoxy(5, 14);
			 cprintf("                        ");

			 goto end_input;
		 }


            // Only update display if a key was pressed
            if (key) 
			{
			   // See if the input error was cleared
			   if (input_error == 0)
			   { 
				  // Clear error message
				  gotoxy(5, 14);
				  cprintf("                        ");
			   } 

               // Clear field from left to pos - 1
                   
		      for (a = 8; a <= (8 +(pos -1)); a++)
			  {            
			      gotoxy(a,13);
			      cprintf(" ");
			  }
		
		      // Clear field from right to pos + 1

		      for (a = 8 + 20; a >= (8 + (pos + 1)); a--)
			  {
			      gotoxy(a,13); 
		          cprintf(" ");
			  }  

		      // Show contents of key buffer
		      gotoxy(8,13);
		      cprintf("%s", key_buf);
		  
		      // Show cursor
		      gotoxy(pos + 8, 13);
		      cprintf("_");
 
			} // End if (key)
		
		    // After updating the display
		    if (key == ENTER) 
			{ 
			   // First make sure the user entered
			   // something before hitting enter
			   if (strlen(key_buf) == 0)
			   { 
				  // If they didn't, show an
				  // error message
				
				  // input_error is a global error flag
				  // that gets cleared the next time a character
				  // is entered in the get_serial_digit function
				
				  // Set error flag
				  input_error = 1;
				
				  // Set color to Red
				  textcolor(RED);
				
 				  // Go to error field location
		          gotoxy(5, 14);
				
				  // Display text
		          cprintf("You must enter something");
				
				  // Reset color to White
			      textcolor(WHITE);
			    
				  // input remains 1 because we're not done
			   }
			   // If the buffer length was not zero
			   else
			   {
				   // now convert and validate

				   // Scan for position of decimal, if any

				   // First, clear decimal flag, to prevent
				   // erroneous reading from the last frequency
				   // entered
				   
				   decimal = 0;
		       
				   for (a = 0; key_buf[a] != NULL; a++)
				   { 
		               if (key_buf[a] == '.')
					   { 
			              // Set flag indicating presence of a decimal
			              decimal = 1;
			              break;
					   } 
				   }

	               // If user entered a decimal
	               if (decimal)
				   {
		              // Replace NULL's after decimal with zeroes
		              // Up to the 6th decimal place
		              for (b = a+1; b <= a+6; b++)
					  {
		                  if (key_buf[b] == 0)
						  { 
			                 key_buf[b] = '0';
						  } 
					  } 
				   }
	             
				   // If user did not enter a decimal
	               else
				   {
					   // If user entered more than 4 digits,
					   // and no decimal, display error

					   if (a > 4)
					   {
						  // display message
					      gotoxy(5,14);
					      textcolor(RED);
					      cprintf("Frequency out of range");
					      textcolor(WHITE);
					      // Clear field
					      gotoxy(8,13);
					      cprintf("             ");
					      // set error flag
					      frequency_error = 1;
						  goto end_input;
					   }

					   // Add the decimal manually
		               key_buf[a] = '.';

		               // Fill NULL's after decimal with zeroes
		               // Up to the 6th decimal place
		               for (b = a+1; b <= a+6; b++)
					   {
		                   if (key_buf[b] == 0)
						   { 
			                  key_buf[b] = '0';
						   } 
					   }
				   } 


	               // Variable 'a' now points to the location of the decimal,
	               // so we can get rid of it (the decimal, not variable a),
	               // by shifting the characters to the right of the decimal
	               // over one to the left.

	               for(b = a; key_buf[b] != NULL; b++)
				   { 
		              key_buf[b] = key_buf[b+1];
				   }

	
	               // Make the conversion from ASCII to LONG
	               n_frequency = atol(key_buf);
	

	               // Clear key_buf manually to ensure integrity
                   for (a = 0; a <=12; a++)
				   {
		               key_buf[a] = NULL;
				   }
	
	               // Validate the entry to make sure it's usable

                   // Clear frequency error flag
                   frequency_error = 0;

	

		           // 25-520, 760-823.995, 849-868.995, 894-1300

		           if (n_frequency < 25000000)
				   {
		               // display message
					   gotoxy(5,14);
					   textcolor(RED);
					   cprintf("Frequency out of range");
					   textcolor(WHITE);
					   // Clear field
					   gotoxy(8,13);
					   cprintf("             ");
					   // set error flag
					   frequency_error = 1;
				   }

		           if ((n_frequency > 520000000) && ( n_frequency < 760000000))
				   {

			           // display message
					   gotoxy(5,14);
					   textcolor(RED);
					   cprintf("Frequency out of range");
					   textcolor(WHITE);
					   // Clear field
					   gotoxy(8,13);
					   cprintf("             ");
					   // set error flag
					   frequency_error = 1;
				   }

		           if ((n_frequency > 823995000) && (n_frequency < 849000000))
				   {
			           // display message
					   gotoxy(5,14);
					   textcolor(RED);
					   cprintf("Frequency out of range");
					   textcolor(WHITE);
					   // Clear field
					   gotoxy(8,13);
					   cprintf("             ");
					   // set error flag
					   frequency_error = 1;
				   }

		           if ((n_frequency > 868995000) && (n_frequency < 894000000))
				   {
					   // display message
					   gotoxy(5,14);
                       textcolor(RED);
					   cprintf("Frequency out of range");
					   textcolor(WHITE);
					   // Clear field
					   gotoxy(8,13);
					   cprintf("             ");
					   // set error flag
					   frequency_error = 1;
				   }

		           if (n_frequency > 1300000000)
				   {
					   // display message
					   gotoxy(5,14);
					   textcolor(RED);
					   cprintf("Frequency out of range");
					   textcolor(WHITE);
					   // Clear field
					   gotoxy(8,13);
					   cprintf("             ");
					   // set error flag
					   frequency_error = 1;
				   }

				   // Skip this section if there is already an error
				   if (!frequency_error)
                   {
					   // Check for even multiple of 5khz or 12.5khz

		               if ((n_frequency % 5000) != 0) // if not evenly
					   {                      // divisible by 5000

			              if ((n_frequency % 12500) != 0) // if not evenly
						  {                        // divisible by 12500
				             // display message
						     gotoxy(5,14);
						     textcolor(RED);
					         cprintf("Invalid multiple");
						     textcolor(WHITE);

						     // Clear field
						     gotoxy(8,13);
						     cprintf("             ");
						     // set error flag
					         frequency_error = 1;
                          }
					   } 
				   }

	 

                   // As long as there were no errors detected,
	               // we can load the new frequency

                   if (!frequency_error)
                   {
					   	// Start by setting unit to Narrow FM
                     	result = Enable_NFM_mode();
                        // Check for timeout
                        if (result == TIMEOUT)
						{ 
	                       return TIMEOUT;
						} 

                     	// set mode variable to indicate NFM
	                    mode = NFM;
					     
					   	// Check to see if it needs to be in Wide FM
                       	// 88 - 108 MHz 
	                    if ((n_frequency >= 88000000) && (n_frequency <= 108000000))
						{
		                   // Set wideband FM mode
		                   result = Enable_WFM_mode();
		                   // Check for timeout
		                   if (result == TIMEOUT)
						   { 
		                      return TIMEOUT;
						   } 

		                   // set mode variable to indicate WFM
		                   mode = WFM;
						} 

	                    // Check to see if it needs to be in AM
	                    // 109 - 130 MHz
 
	                    if ((n_frequency >= 109000000) && (n_frequency <= 130000000))
						{
		                   // Set AM mode
	                       result = Enable_AM_mode();
		                   // Check for timeout
		                   if (result == TIMEOUT)
						   { 
		                      return TIMEOUT;
						   }

		                   // set mode variable to indicate AM
		                   mode = AM;
						}

			result = Write_frequency(n_frequency);
                        if (result == TIMEOUT)
						{
	                       return TIMEOUT;
						}

 			            // Clear input field
			            gotoxy(8,13);
			            cprintf("                    ");
			
			            // Set input to 0 to say we are done
				        entry = 0;
				   }     
				
               } // end else 
           } // end if (key == ENTER)
       
} // end if (entry)
      
end_input:
////////////////////////////////////////////////////////////////////        
     
return 0;

}

int scan_keys(void)
{
	//Local variables
	int key = 0;
	int result = 0;
	int v; // numeric volume
	int s; // numeric squelch

	// See if a key has been hit
		
		key = read_kb();
		// if no key, just exit function
		if (key == 0)
		{
			return 0;
		}

		// Check for request to exit program
		if (key == CTRL_X)
		{
			return NORMAL_EXIT;
		}
			 
		// Check for mode change to Narrow FM
		if ((key == 'n') || (key == 'N'))
		{
			// If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			// Only do the following if it
			// is not already in NFM mode
			if (mode != NFM)
			{
				// Set unit to Narrow FM mode
			    result = Enable_NFM_mode();
				// Check for timeout
				if (result == TIMEOUT)
				{ 
		            return TIMEOUT;
				}

				// Set mode indicator to NFM				
				mode = NFM;
				return 0;
			} // end if (mode != NFM)
		} // end if ((key == 'n') || (key == 'N'))

		// Check for mode change to Wide FM
		if ((key == 'w') || (key == 'W'))
		{
			// If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			// Only do the following if it
			// is not already in WFM mode
		    if (mode != WFM)
			{
				// Set unit to Wide FM mode
			    result = Enable_WFM_mode();
				// Check for timeout
			    if (result == TIMEOUT)
				{ 
		            return TIMEOUT;
				}
				
				// Set mode indicator to WFM
				mode = WFM;
				return 0;
			} // end if (mode != WFM)
		} // end if ((key == 'w') || (key == 'W'))

		// Check for mode change to AM
		if ((key == 'a') || (key == 'A'))
		{
			// If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			// Only do the following if it is
			// not already in AM mode
			if (mode != AM)
			{
				// Set unit to AM mode
				result = Enable_AM_mode();
				// Check for timeout
				if (result == TIMEOUT)
				{
					return TIMEOUT;
				}

				// Set mode indicator to AM				 
				mode = AM;
				return 0;
			} // end if (mode != AM)
		} // end if ((key == 'a') || (key == 'A'))

		// Check for tape control toggle
		if ((key == 't') || (key == 'T'))
		{
			// If the tape pause relay is on
			if (tape_control)
			{
				// Turn the tape pause relay off
			    result = Disable_tape_recorder();
				// Check for timeout
			    if (result == TIMEOUT)
				{ 
		            return TIMEOUT;
				}
				gotoxy(32,19);
				cprintf("Off");
			}
			// If the tape pause relay is off
			else
			{
				// Turn the tape pause relay on
				result = Enable_tape_recorder();
				// Check for timeout
				if (result == TIMEOUT)
				{ 
		            return TIMEOUT;
				}
				gotoxy(32,19);
				cprintf("On ");
				return 0;
			}
		} // end if ((key == 't') || (key == 'T'))
			 
		// Check for volume/squelch remote mode command
		if ((key == 'r') || (key == 'r'))
		{
		    // If we are not already in Remote mode
		    if (!volume_squelch_control_status)
			{
			    // Set unit to remote mode
			    result = Enable_remote_volume_squelch();
				// Check for timeout
				if (result == TIMEOUT)
				{ 
			        return TIMEOUT;
				}
				
				// Set Volume to same level it was in Local mode
				result = Write_volume(atoi(volume_setting));
				// Check for timeout
				if (result == TIMEOUT)
				{ 
			       return TIMEOUT;
				}
				
				// Set Squelch to same level it was in Local mode
				result = Write_squelch(atoi(squelch_setting));
				// Check for timeout
				if (result == TIMEOUT)
				{ 
		            return TIMEOUT;
				}

			} // end if (!volume_squelch_control_status)
			return 0;
		} // end if ((key == 'r') || (key == 'r'))

		 // Check for volume/squelch local mode command
		 if ((key == 'l') || (key == 'L'))
		 {
			 // If we are in Remote mode
		 	 if (volume_squelch_control_status)
			 {
			   	 // Set unit to local mode
				 result = Enable_local_volume_squelch();
				 // Check for timeout
				 if (result == TIMEOUT)
				 { 
		             return TIMEOUT;
				 }
			 } // end if (volume_squelch_control_status)
			 return 0;
		 } // end if ((key == 'l') || (key == 'L'))

		 // Check for left arrow key
		 if (key == LEFT)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // Set volume/squelch mode to volume
				 volume_squelch_control_indicator = VOLUME;
			 }
			 return 0;
		 }

		 // Check for right arrow key
		 if (key == RIGHT)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // Set volume/squelch mode to squelch
				 volume_squelch_control_indicator = SQUELCH;
			 }
			 return 0;
		 }

		 // Check for up arrow key
		 if (key == UP)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // If volume/squelch mode is volume
				 if (volume_squelch_control_indicator == VOLUME)
				 {
					 // Get current volume setting
					 // from volume_setting variable
					 // and store in int v variable
					 v = atoi(volume_setting);
					 // Add one to v
					 v = v + 1;
					 // If we were already at max
					 // we will now be at 100,
					 if (v > 99)
					 {
						 // so keep v at max,
						 // but don't send it repeatedly.
						 v = 99;
					 }
					 // If we were not already at max
					 // and did not go to 99, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_volume(v);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 }
					 return 0;
				 } // end if (volume_squelch_control_indicator == VOLUME)


				 // If volume/squelch mode is squelch
				 if (volume_squelch_control_indicator == SQUELCH)
				 {
					 // Get current squelch setting
					 // from squelch_setting variable
					 // and store in int s variable
					 s = atoi(squelch_setting);
					 // Add one to s
					 s = s + 1;
					 // If we were already at max
					 // we will now be at 99,
					 if (s > 99)
					 {
						 // so keep s at max,
						 // but don't send it repeatedly.
						 s = 99;
					 }
					 // If we were not already at max
					 // and did not go to 99, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_squelch(s);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 } 
				 } // end if (volume_squelch_control_indicator == SQUELCH)
			 } // end if (volume_squelch_control_status)
			 return 0;
		 } // end if (key == UP)

		 // Check for shift+up arrow key
		 if (key == SHIFT_UP)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // If volume/squelch mode is volume
				 if (volume_squelch_control_indicator == VOLUME)
				 {
					 // Get current volume setting
					 // from volume_setting variable
					 // and store in int v variable
					 v = atoi(volume_setting);
					 // Add one to v
					 v = v + 10;
					 // If we are now above max,
					 if (v > 99)
					 {
						 // keep v where it was,
						 // but don't send it repeatedly.
						 v = v - 10;
					 }
					 // If we are not above max, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_volume(v);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 }
					 return 0;
				 } // end if (volume_squelch_control_indicator == VOLUME)

				 // If volume/squelch mode is squelch
				 if (volume_squelch_control_indicator == SQUELCH)
				 {
					 // Get current squelch setting
					 // from squelch_setting variable
					 // and store in int s variable
					 s = atoi(squelch_setting);
					 // Add one to s
					 s = s + 10;
					 // If we are now above max,
					 if (s > 99)
					 {
						 // keep s where it was,
						 // and don't send it again.
						 s = s - 10;
						 
					 }
					 // If we are not above max, then send
					 // the new value now.
					 else 
					 { 
						 // Send new value
						 result = Write_squelch(s);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 } 
				 } // end if (volume_squelch_control_indicator == SQUELCH)
			 } // end if (volume_squelch_control_status)
			 return 0;
		 } // end if (key == SHIFT_UP)
				 
		 // Check for down arrow key
		 if (key == DOWN)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // If volume/squelch mode is volume
				 if (volume_squelch_control_indicator == VOLUME)
				 {
					 // Get current volume setting
					 // from volume_setting variable
					 // and store in int v variable
					 v = atoi(volume_setting);
					 // Subtract one from v
					 v = v - 1;
					 // If we were already at minimum
					 // we will now be at -1,
					 if (v < 0)
					 {
						 // so keep v at minimum,
						 // but don't send repeatedly.
						 v = 0;
					 }
					 // If we were not already at minimum,
					 // and did not go to -1, then send,
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_volume(v);
						 // Check for timeout
					     if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 } 
					 }
					 return 0;
				 } // end if (volume_squelch_control_indicator == VOLUME)

				 // if volume/squelch mode is squelch
			     if (volume_squelch_control_indicator == SQUELCH)
				 {
				     // Get current squelch setting
					 // from squelch_setting variable
					 // and store in int s variable.
					 s = atoi(squelch_setting);
					 // Subtract one from s
					 s = s - 1;
					 // If we were already at minimum
					 // we will now be at -1,
					 if (s < 0)
					 {
						 // so keep s at minimum,
						 // but don't send repeatedly.
						 s = 0;
					 }
					 // If we were not already at minimum
					 // and did not go to -1, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_squelch(s);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 }
				 } // end if (volume_squelch_control_indicator == SQUELCH)
			 } // end if (volume_squelch_control_status)
			 return 0;
		 } // end if (key == DOWN)

		 // Check for shift+down arrow key
		 if (key == SHIFT_DOWN)
		 {
			 // If we are in remote mode
			 if (volume_squelch_control_status)
			 {
				 // If volume/squelch mode is volume
				 if (volume_squelch_control_indicator == VOLUME)
				 {
					 // Get current volume setting
					 // from volume_setting variable
					 // and store in int v variable.
					 v = atoi(volume_setting);
					 // Subtract one from v
					 v = v - 10;
					 // If we are now below zero,
					 if (v < 0)
					 {
						 // keep v where it was
						 // but don't send repeatedly.
						 v = v + 10;
					 }
					 // If we are not below zero, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_volume(v);
						 // Check for timeout
					     if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 } 
					 }
					 return 0;
				 } // end if (volume_squelch_control_indicator == VOLUME)
				 
				 // if volume/squelch mode is squelch
				 if (volume_squelch_control_indicator == SQUELCH)
				 {
					 // Get current squelch setting
					 // from squelch_setting variable
					 // and store in int s variable
					 s = atoi(squelch_setting);
					 // Subtract one from s
					 s = s - 10;
					 // If we are now below zero,
					 if (s < 0)
					 {
						 // keep s where it was
						 // but don't send repeatedly.
						 s = s + 10;
					 }
					 // If we are not below zero, then send
					 // the new value now.
					 else 
					 {
						 // Send new value
						 result = Write_squelch(s);
					     // Check for timeout
						 if (result == TIMEOUT)
						 {  
		                     return TIMEOUT;
						 }
					 }
				 } // end if (volume_squelch_control_indicator == SQUELCH)
			 } // end if (volume_squelch_control_status)
			return 0;
		 } // end if (key == SHIFT_DOWN)

		 // Check for request to enter new frequency
		 if ((key == 'f') || (key == 'F'))
		 {
			 // If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			// Clear existing frequency 
			gotoxy(8,13);
			cprintf("             ");
			
			// set flag
			entry=1;
			return 0;
		 }

		 // Check for NRZ mode change 
		 if (key == '/') 
		 {
			 // If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			 // If the unit is in OPTOSCAN mode
			 // exit immediately
			 if (device == OPTOSCAN)
			 {	
				 return 0;
			 }
			 
			 // If the unit is in DCS mode
			 if (nrz_mode == DCS)
			 {
				 // Set unit for LTR mode
				 result = Enable_LTR_mode();
				 // Check for timeout
			     if (result == TIMEOUT)
				 {
				     return TIMEOUT;
				 }
				
				 // Change NRZ fields
				 // back to LTR configuration
                 textcolor(DARKGRAY);
                 gotoxy(48,15);
                 cprintf("DCS");
	             textcolor(mainfields);
                 gotoxy(48,18);
                 cprintf("LTR");
				 textcolor(WHITE);
			 }
			 // If the unit is not in DCS mode
			 else
			 {
				 // If the unit is in LTR mode
				 if (nrz_mode == LTR)
				 {
					 // Set unit for DCS mode
				     result = Enable_DCS_mode();
					 // Check for timeout
			         if (result == TIMEOUT)
					 {
				         return TIMEOUT;
					 }

					 // Change NRZ fields
					 // back to DCS configuration
					 textcolor(DARKGRAY);
                     gotoxy(48,18);
                     cprintf("LTR"); 
					 textcolor(mainfields);
                     gotoxy(48,15);
                     cprintf("DCS");
					 gotoxy(47,12);
                     cprintf("CTCSS");
					 textcolor(WHITE);
				 }
			 }
			 return 0;
		 } // end if (key == '/')


		 // Check for request to empty DTMF buffer
		 if ((key == 'd') || (key == 'D'))
		 {
			 // Clear dtmf pointer
	         dtmf_buffer_pointer = 0;

			 // Clear DTMF buffer 
          	
	
			 for (temp = 0; temp <=69; temp++)
			 {
		         dtmf_buffer[temp] = NULL;
			 }

			 // Clear DTMF field
			 for (temp = 9; temp <=78; temp++)
			 {
		         gotoxy(temp,22);
		         cprintf(" ");
			 } 
           return 0;
		 } // end if (key == 'd') 


		 // Check for request to toggle speaker audio
		 if ((key == 's') || (key == 'S'))
		 {
			 // If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			 // If speaker is currently on
			 if (speaker_control)
			 {
				 // Turn speaker off
                 result = Disable_speaker_audio();
				 // Check for timeout
			     if(result == TIMEOUT)
				 {
				    return TIMEOUT;
				 }
				// Indicate change on screen
				 gotoxy(65,13);
		         cprintf("Muted");
			 }
			 // If speaker is currently off
			 else
			 {
				 // Turn speaker on
				 result = Enable_speaker_audio();
				 // Check for timeout
				 if (result == TIMEOUT)
				 {
					 return TIMEOUT;
				 }
				 gotoxy(65,13);
		         cprintf(" On  ");
			 }
			 return 0;
		 } // end if ((key == 's') || (key == 'S'))

		 // Toggle emulation mode
		 if ((key == 'm') || (key == 'M'))
		 {
			 // If in Store and Scan mode
			// exit immediately
			if (scan_mode)
			{
				return 0;
			}

			 // If unit is in LTR decode mode
			 // exit immediately
			 if (nrz_mode==LTR)
			 {
				 return 0;
			 }

			result = Switch_Optocom_mode();
			if (result == TIMEOUT)
			{
				 return TIMEOUT;
			}
			return 0;
		 }
         
		 // Toggle store and scan mode
		 if ((key == 'o') || (key == 'O'))
		 {

		 if (scan_mode)
			 {
				
				 scan_mode=0;

				 result = Disable_scan_mode();
				if (result == TIMEOUT)
				{
					 return TIMEOUT;
				}	
				result = Store_operating_parameters();
				if (result == TIMEOUT)
				{
					 return TIMEOUT;
				}

			/*	// Update speaker status display
				if (speaker_control)
				{
					gotoxy(65,13);
					cprintf("Xuted");
				}
				else
				{
					gotoxy(65,13);
					cprintf(" On  ");
				}
*/
				// Update Store and Scan field
				fldStoreScan.Text("Off");
				return 0;
			 }
			 else
			 {	
				 // Do not allow enabling of scan mode
				 // if in os535 mode
				 if (device == OPTOSCAN)
				{
					return 0;
				}
			     scan_mode=1;
				// Enable Store and Scan mode
		 		result = Enable_scan_mode();
				if (result == TIMEOUT)
				{
					 return TIMEOUT;
				}
				result = Store_operating_parameters();
				if (result == TIMEOUT)
				{
					 return TIMEOUT;
				}
				// Update Store and Scan field
				fldStoreScan.Text("On");
				return 0;
			 }
		 }
}