// CI-5 Layer
// READ STATUS
// FILENAME: readstat.cpp
//
// Optoelectronics Inc.
// 10-16-98
// All Rights Reserved
//
// Finished for OptoCom on 11-11-98

int Read_status(void)
{

	// Local Variables

	int nrz_mode0 = 0;
	int nrz_mode1 = 0;
	int nrz_mode2 = 0;
	int attempts = 0;

start:
	// Load command buffer

	 command[0] = 0xFE;
	 command[1] = 0xFE;
	 command[2] = address;  // global
	 command[3] = 0xE0;
	 command[4] = 0x7F;
	 command[5] = 0x05;
	 command[6] = 0xFD;
     command[7] = 0xFF;

	 // Command is now ready to send, so send it

	 Send_command();
	 
	 // Check to see if timeout occurred
	 if (count >= TIMEOUT_VALUE)
	 {
		 return TIMEOUT;
	 }

	 //Check for error response
	 if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}

	 // Mask with appropriate hex value to isolate
	 // desired value

	 //   0    0     0     0    0     0     0     0

	 // 128   64    32    16    8     4     2     1 
	 // 0x80  0x40  0x20  0x10  0x08  0x04  0x02  0x01
     
	 
	 // 0x01 = 00000001
	 // 0x02 = 00000010
	 // 0x04 = 00000100
	 // 0x08 = 00001000
	 // 0x10 = 00010000
	 // 0x20 = 00100000
	 // 0x40 = 01000000
	 // 0x80 = 10000000
	 
	 if (device == OPTOCOM)
	 {
		 // for this application, S1 is position 4, S2 is 5, S3 is 6,
		 // and S4 is 7

		  volume_squelch_control_status = response[4] & 0x01;

		  dtmf_pending = response[4] & 0x02; 
	 	 
		  dtmf_overrun = response[4] & 0x04;

		  squelch_status = response[4] & 0x10;
	  		 
		  ctcss_active = response[4] & 0x20;

		  nrz_active = response[4] & 0x40;

		  tape_control = response[5] & 0x01;
		  
		  speaker_control = response[5] & 0x02;

		  search_window = response[5] & 0x04;

		  audio_status = response[5] & 0x10;

		  search_mode = response[5] & 0x20;

		  scan_mode = response[5] & 0x40;

		  frequency_received = response[6] & 0x01;
		  
		  mode_received = response[6] & 0x02;

		  pipeline_received = response[6] & 0x04;

		  nrz_mode0 = response[7] & 0x01;

		  nrz_mode1 = response[7] & 0x02;

		  nrz_mode2 = response[7] & 0x04;

		  if ( (nrz_mode0 == 0) && (nrz_mode1 == 0) && (nrz_mode2 == 0) )
		  {
			  nrz_mode = DCS;
		  }

		  if ( (nrz_mode0 == 1) && (nrz_mode1 == 0) && (nrz_mode2 == 0) )
		  {
			  nrz_mode = LTR;
		  }

	 }	  


if (device == OPTOSCAN)
{
       dtmf_pending = response[4] & 0x02;
       dtmf_overrun = response[4] & 0x04;
       squelch_status = response[4] & 0x10;
       ctcss_active = response[4] & 0x20;
       nrz_active = response[4] & 0x40;
       tape_control = response[5] & 0x01;
       speaker_control = response[5] & 0x02;
       search_window = response[5] & 0x04;
       audio_status = response[5] & 0x10;
}


return 0;
}
