// TIMEOUT ROUTINE
// For Product layers
// FILENAME: timeout.cpp
// Optoelectronics Inc.
// 10-2-98
//
// Finished for OptoCom on 11-6-98
//
// This function is a high-level timeout routine
// for all the CI-5 calls. It looks at consecutive
// results, comparing the current result to the 
// previous one. If it sees two timeouts in a row,
// it increments its counter, and displays a message
// to alert the user that there is an intermittent
// connection. If it gets a success right after a 
// timeout, then it displays the message, and
// clears the count. If it gets a timeout right 
// after a success, it displays the message, and 
// increments the count. If it gets a success right
// after a success, it clears the intermittent display,
// and does not increment the count.
// Any time a function wants to send a command, it does
// so by calling the send_command function. The send_command
// function sets up loop that will send the command 
// repeatedly until one of two things happen. Either 
// a success code is returned, or the count exceeds a
// preset amount. That way, if there is an intermittent
// connection, and the unit gets a timeout, then a success,
// then perhaps another timeout, the user will know there
// is an intermittent, but the program will not immediately
// begin looking for the Optocom again, as it would do
// if there were not a way to look for intermittent connections.
// If the count variable exceeds the preset limit, then the
// Optocom is assumed to be disconnected or turned off, or
// that something else is wrong, so the program begins looking
// for it again. The user would know at that point that something
// went wrong...


void timeout(int result)
{

	// If we have two timeouts in a row

	if ((result == TIMEOUT) && (previous == TIMEOUT))
	{
		// Increment the count
		count++; 
        // Display Intermittent Alert message
	/*	gotoxy(3,20);
		textcolor(RED);
        cprintf("* Intermittent Alert *");
	*/	
		// Display temporary Intermittent message
	/*	gotoxy(61,3);
		textcolor(LIGHTRED);
	    cprintf("Intermittent");
		textcolor(WHITE);
	*/	// Set intermittent message variable to true
	//	intermittent_message_showing = TRUE;
		// Beep
	/*	sound(220);
	    delay(35);
	    nosound(); */
	}

	// If there is a timeout right after a success
	// it means that it just went intermittent
	if ((result == TIMEOUT) && (previous == SUCCESS))
	{
		// Increment the count
		count++; 
		// Display Intermittent Alert message
	  /*gotoxy(3,20);
		textcolor(RED);
        cprintf("*                    *");*/
	/*	
		// Display temporary Intermittent message
		gotoxy(61,3);
		textcolor(LIGHTRED);
	    cprintf("Intermittent");
		textcolor(WHITE);
		*/// Set intermittent message variable to true
	//	intermittent_message_showing = TRUE;
		// Beep
	/*	sound(220);
	    delay(35);
	    nosound();*/
	}

    // If there is a success right after a timeout
	// it means that it just came back online from 
	// being intermittent
	if ((result == SUCCESS) && (previous == TIMEOUT))
	{
		// Display Intermittent Alert message
		/*gotoxy(3,20);
		textcolor(RED);
        cprintf("* I t r i t n  A e t *");*/
		/*
		// Display temporary Intermittent message
		gotoxy(61,3);
		textcolor(LIGHTRED);
	    cprintf("Intermittent");
		textcolor(WHITE);
		*/// Set intermittent message variable to true
	//	intermittent_message_showing = TRUE;
		// Beep
		/*sound(220);
	    delay(35);
	    nosound();*/
		// Clear the count because the problem appears
		// to be over now
		count = 0;
	}

	// If there is a success right after a success
	// it means that all is well, and the intermittent
	// message can be removed, and the flag can be cleared
	if ((result == SUCCESS) && (previous == SUCCESS))
	{
		// Clear message if needed
		/*gotoxy(3,20);
		textcolor(WHITE);
        cprintf("                      ");*/
		/*if (intermittent_message_showing)
		{
			gotoxy(61,3);
			cprintf("            ");
			intermittent_message_showing = FALSE;
		}*/
	}

	// Update previous variable with current one before returning
	previous = result;
}



