// CI-5 Command Layer
// FILENAME: writefrq.cpp
// Write Frequency
//
// 10-5-98
// Optoelectronics Inc.
// All rights reserved
//
// Finished for Optocom on 11-6-98

int Write_frequency(long freq)
{

	// Local Variables
    int hz;
	int ten_hz;
	int hundred_hz;
	int khz;
	long ten_khz;
	long hundred_khz;
	long mhz;
	long ten_mhz;
	long hundred_mhz;
	long ghz;
    long remainder;
	int result;
	int attempts = 0;


	// Validate incoming frequency

	// Note: This check is to make this
	// function reusable. In this program,
	// it should never return a fatal error,
	// since the frequency is checked before
	// it is sent to this function
	// If you use this function elsewhere, be
	// sure to either handle the fatal error 
	// condition that this function can return,
	// or be certain to check your frequency
	// before sending it into this function.
	// It would be best to have both checks in
	// place, but I chose not to write the code
	// that would handle the fatal error. 


		// 25-520, 760-823.995, 849-868.995, 894-1300

		if (freq < 25000000) 
		{
			return FATAL_ERROR;
		}

		if ((freq > 520000000) && ( freq < 760000000))
		{
			return FATAL_ERROR;
		}

		if ((freq > 823995000) && (freq < 849000000))
		{
			return FATAL_ERROR;
		}

		if ((freq > 868995000) && (freq < 894000000))
		{
			return FATAL_ERROR;
		}

		if (freq > 1300000000)
		{
			return FATAL_ERROR;
		}
	
        // Check for even multiple of 5khz or 12.5khz

		if ((freq % 5000) != 0) // if not evenly 
		{                       // divisible by 5000

			if ((freq % 12500) != 0) // if not evenly 
			{                        // divisible by 12500
				return FATAL_ERROR;
			}
		}


		
	    // Convert from long to hex format for transmission

        ghz =       freq / 1000000000;
	    remainder = freq % 1000000000;

	    hundred_mhz = remainder / 100000000;
	    remainder =        freq % 100000000;
     
	    ten_mhz = remainder / 10000000;
	    remainder =    freq % 10000000;

	    mhz =  remainder / 1000000;
        remainder = freq % 1000000;

	    hundred_khz = remainder / 100000;
	    remainder =        freq % 100000;

	    ten_khz = remainder / 10000;
	    remainder =    freq % 10000;

        khz =  remainder / 1000;
	    remainder = freq % 1000;

        hundred_hz = remainder / 100;
	    remainder =       freq % 100;

	    ten_hz = remainder / 10;
	    hz =          freq % 10;

	    // Shift appropriate bytes left and mask

	    ghz = ghz << 4;
	    ghz = ghz & 0xF0;

	    ten_mhz = ten_mhz << 4;
	    ten_mhz = ten_mhz & 0xF0;

	    hundred_khz = hundred_khz << 4;
	    hundred_khz = hundred_khz & 0xF0;

	    khz = khz << 4;
	    khz = khz & 0xF0;

	    ten_hz = ten_hz << 4;
	    ten_hz = ten_hz & 0xF0;

start:	 
	    // Prepare ten hz and one hz

	    command[5] = (ten_hz | hz);

 	    // Prepare 1khz, 100hz

	    command[6] = (khz | hundred_hz);

	    // Prepare 100khz, 10khz

	    command[7] = (hundred_khz | ten_khz);

	    // Prepare 10mhz, 1 mhz

	    command[8] = (ten_mhz | mhz);

	    // Prepare 1ghz, 100mhz

	    command[9] = (ghz | hundred_mhz);

	    // Fill in the rest of the command

	    command[0] = 0xFE;
	    command[1] = 0xFE;
	    command[2] = address; // global
	    command[3] = 0xE0;
	    command[4] = 0x05;
        command[10] = 0xFD;
	    command[11] = 0xFF;

        // Command is now ready to send, so send it
 
        Send_command();
      
        // Check to see if timeout occurred
	    if (count >= TIMEOUT_VALUE)
		{
		    return TIMEOUT;
		}

	    // See if response is valid

		if (response[2] == 0xFB)
		{
		    return GOOD;
		}

	if (response[2] == 0xFA)
	{
		// Try up to three times
		attempts = attempts + 1;
		if (attempts >3)
		{	
			return BAD;
		}

		goto start;
	}
	
	// If we are here, something is really wrong.
		return FATAL_ERROR; 
}
