program WinPlay;
{Bringt WinPlay 1.4(Patch LFN) das Positionieren bei}
{$K-}
uses WinProcs,WinTypes,Win31,WUtils,MMSystem;
var
 w: HWnd;
 hwave: Word;
 hook: HHook;
 Mausefalle: Boolean;
 ThisTask: THandle;

const
 AppName='WinPlay3-Starter';
 HitRect: TRect=(
  left: 6;
  top: 97;
  right: 156;
  bottom: 106);

procedure ShowRect(x: Integer);
 var
  R: TRect;
  dc: hdc;
  br: HBrush;
 begin
  dc:=GetDC(w);
  CopyRect(R,HitRect);
  x:=max(R.left,min(R.right,x));	{begrenzen}
  R.right:=x;
  br:=CreateSolidBrush($0000FF);
  FillRect(dc,R,br);
  DeleteObject(br);
  CopyRect(R,HitRect);
  R.left:=x;
  br:=CreateSolidBrush($FFFFFF);
  FillRect(dc,R,br);
  DeleteObject(br);
  ReleaseDC(w,dc);
 end;

procedure Movefp(by: LongInt);
 var
  fp,fs: LongInt;
 begin
  fp:=_llseek(5,0,1);	{Momentanposition}
  if fp=0 then exit;
  fs:=_llseek(5,0,2);	{Dateilnge}
  Inc(fp,by);
  if fp<0 then fp:=0;
  if fp>fs then fp:=fs;
  _llseek(5,fp,0);
  if hWave<>0 then WaveOutReset(hWave);
 end;

function MyHook(code: Integer; wParam: Word; lParam: LongInt):LongInt; export;
 var
  msgp: PMsg absolute lParam;
  pt: TPoint;
  fp: LongInt;
 begin
  case msgp^.message of
   WM_Quit: begin
    UnhookWindowsHookEx(hook);
    PostAppMessage(ThisTask,WM_Quit,0,0);
   end;
   WM_LButtonDown: if msgp^.hwnd=w then begin
    LongInt(pt):=msgp^.lParam;
    if PtInRect(HitRect,pt) then begin
     PostMessage(w,WM_Command,$71,0);	{Taste PLAY}
     SetCapture(w);
     ShowRect(pt.x);
     Mausefalle:=true;
    end;
   end;
   WM_LButtonUp: if Mausefalle then begin
    SetCapture(0);
    Mausefalle:=false;
    LongInt(pt):=msgp^.lParam;
    if PtInRect(HitRect,pt) then begin
     fp:=_llseek(5,0,2);	{Dateilnge}
     if fp>=0 then begin
      fp:=fp*(pt.x-HitRect.left)div(HitRect.right-HitRect.left);
      _llseek(5,fp,0);
      if hWave<>0 then WaveOutReset(hWave);
     end else MessageBeep(0);	{keine Datei}
    end;
   end;
   WM_MouseMove: begin
    SetCursor(LoadCursor(0,IDC_Arrow));
    if Mausefalle then ShowRect(TPoint(msgp^.lparam).x);
   end;
   WM_KeyDown: begin		{funktioniert leider nicht, wieso?}
    SetFocus(GetDlgItem(w,$72));	{PAUSE-Taste fr SPACE fokussieren}
    case wParam of	{selbstdefinierte Ressource}
     VK_Left: Movefp(-$1000);		{Stckel zurck}
     VK_Right: Movefp($1000);		{Stck vorwrts}
    end;
   end;
  end;
  MyHook:=CallNextHookEx(hook, code,wparam,lparam);
 end;

const
 wf: TPcmWaveFormat=(
  wf: (
   wFormatTag: WAVE_Format_PCM;
   nChannels: 1;
   nSamplesPerSec: 22050;
   nAvgBytesPerSec: 22050;
   nBlockAlign: 1);
  wBitsPerSample: 8);
var
 pi1,pi2: TFarProc;
 s: TS255;
 WP3inst,WP3task: THandle;
 Msg: TMsg;

procedure StartWinplay3;
 begin
  lstrcpy(s,'WINPLAY3.EXE ');
  lstrcat(s,CmdLine);
  WP3inst:=WinExec(s,CmdShow);	{Alles durchreichen}
 end;

begin
 if HPrevInst<>0 then StartWinplay3
 else begin
  repeat
   WaveOutOpen(@hWave,Word(WAVE_Mapper),PWaveFormat(@wf),0,0,0);
   WaveOutClose(hwave);
   if hwave=0
   then case MessageBox(0,'Kann Wave-Ausgabe nicht ffnen;'#10+
     'Wiedergabe an neuer Position erfolgt zeitverzgert!',
     AppName,MB_IconInformation or MB_AbortRetryIgnore or MB_DefButton3) of
    IDAbort: exit;
    IDRetry: continue;
   end;
  until true;

  StartWinplay3;

  w:=FindWindow('Windows Layer III Player',nil);
  if w=0 then begin
   MessageBox(0,'FATAL: WinPlay3 startet nicht!',AppName,MB_OK);
   exit;
  end;
  ThisTask:=GetCurrentTask;
  WP3task:=GetWindowTask(w);
  SetFocus(GetDlgItem(w,$72));	{PAUSE-Taste fr SPACE fokussieren}
  pi1:=MakeProcInstance(@MyHook,HInstance);
  hook:=SetWindowsHookEx(WH_GetMessage,THookProc(pi1),HInstance,WP3task);
  while GetMessage(Msg,0,0,0) do;
  FreeProcInstance(pi1);
 end;
end.
