
/***************
**
**  merge.c
**  last revised: april 12, 1992
**
**  Merge merges two *optimized* dictionaries to one sorted dictionary.
**
**  Usage: merge <filename> [-f filename] [-o outfile]
**
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote.
**
**  Copyright (C)1992, Zabkar
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>


FILE *outfile;
FILE *infile1, *infile2;


/***************
 haltusage()
 prints correct usage and exits
****************/

void haltusage()
{
  fprintf(stderr,
  "Merge version 1.00 alpha, Copyright (C)1992 Zabkar\n"\
  "DESPERATE password-cracker 1.0 alpha using HADES engine by Remote.\n\n"\
  "Usage: merge <wordfile> [-f wordfile] [-o outfile]\n\n"\
  "\t-f: read from 'wordfile' instead of stdin\n"\
  "\t-o: write to 'outfile' instead of stdout\n\n"\
  "WARNING: all wordfiles must be optimized, or you'll get unpredictable "\
  "results\n\n"\
  "no -f specified: wordfile read from stdin\n"\
  "no -o specified: output written to stdout\n");
  exit(0);
}


/***************
 mergelist()
 merges sorted files inf1 with inf2 and writes result to file of.
***************/

void mergelists(FILE *inf1, FILE *inf2, FILE *of)
{
    char word1[9], word2[9];
    int r1, r2, s;

    r1 = fscanf(inf1, "%s", word1);
    r2 = fscanf(inf2, "%s", word2);

    while ((r1 > 0) && (r2>0))
    {
        s = strcmp(word1, word2);
        if (s <= 0)
        {
            fprintf(of, "%s\n", word1);
            r1 = fscanf(inf1, "%s", word1);
        }
        if (s > 0)
        {
            fprintf(of, "%s\n", word2);
            r2 = fscanf(inf2, "%s", word2);
        }
        if (!s)
            r2 = fscanf(inf2, "%s", word2);
    }

    if (r1 > 0 || r2 > 0)         /* any more words in either file? */
      if (r1 <= 0)
          {
          fprintf(of, "%s\n", word2);
          while (fscanf(inf2, "%s", word2) >= 0)
              fprintf(of, "%s\n", word2);
          }
      else
          {
          fprintf(of, "%s\n", word1);
          while (fscanf(inf1, "%s", word1) >= 0)
              fprintf(of, "%s\n", word1);
          }
}







/***************
 main()
 main function of merge
****************/

main(char argc, char **argv)
{
  char f1name[80], f2name[80], oname[80];
  int i;

  strcpy(f2name, "");
  strcpy(oname, "");

  if (argc < 2)
     haltusage();
  else
  {
    strcpy(f1name, argv[1]);
    for (i=2; i<argc; i++)
    {
      switch(argv[i][0])
      {
      case '-': switch(toupper(argv[i][1]))
		  {
            case 'F' : if (strlen(argv[i]) > 2)
                 strcpy(f2name, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
                 strcpy(f2name, argv[++i]);
			       break;
            case 'O' : if (strlen(argv[i]) > 2)
                 strcpy(oname, &argv[i][2]);
			       else if (argc < (i+2))
                 haltusage();
			       else
				 strcpy(oname, argv[++i]);
			       break;
            default  : haltusage();
		  }
          break;
      default : haltusage();
      }
    }
  }

  infile1 = fopen(f1name, "rt");
  if (!infile1)
    {
    fprintf(stderr, "merge: %s: Couldn't open file\n", f1name);
    exit(0);
    }

  if (strcmp(f2name,""))
    infile2 = fopen(f2name, "rt");
  else
    infile2 = stdin;

  if (!infile2)
    {
    fprintf(stderr, "merge: %s: couldn't open file\n", f2name);
    exit(0);
    }

  if (strcmp(oname, ""))
    outfile = fopen(oname, "wt");
  else
    outfile = stdout;

  if (!outfile)
    {
    fprintf(stderr, "%s: could't create file\n", oname);
    exit(0);
    }

  mergelists(infile1, infile2, outfile);

  fclose(infile1);
  fclose(infile2);
  fclose(outfile);

  }

/* EOF MERGE.C */


