/***************
**
**  pwd.c
**  last revised: april 10, 1992
**
**  implementation of password-functions.
**  Written for DESPERATE password-cracker with HADES encryption engine by
**  Remote. (thanx to SMail and Minix 1.5.10)
**
**  Copyright (C)1992, Zabkar
**
**  root@waves.hacktic.nl (Zabkar)
**  root@room101.hacktic.nl (Remote)
**
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "pwd.h"

FILE *_pw_file;


/***************
 getpwent()
 gets next password-entry from passwordfile
***************/

struct passwd *getpwent(void)
  {
   static struct passwd temp;
   int r;

   if ((_pw_file == NULL) && (!pw_openfile(NULL)))
      return NULL;
   r = fscanf(_pw_file, "%[^:]:%[^:]:%d:%d:", temp.pw_name,
      temp.pw_passwd, &(temp.pw_uid), &(temp.pw_gid));
   if (!fscanf(_pw_file, "%[^:]:", temp.pw_gecos))
      strcpy(temp.pw_gecos, "");
   r += fscanf(_pw_file, "%[^:]:", temp.pw_dir);
   if (!fscanf(_pw_file, "%[^:\n] ", temp.pw_shell))
      strcpy(temp.pw_shell,"");

   if (r==5)
      return &temp;
   else
      return NULL;
   }



/***************
 getpwuid()
 gets password-entry of the user with uid=id
***************/

struct passwd *getpwuid(int id)
  {
  struct passwd *temp;

  if (setpwent())
     return NULL;
  while ((temp = getpwent()) != NULL)
     if (temp->pw_uid == id)  {
	 setpwent();
	 return temp;
	 }
  setpwent();
  return NULL;
  }



/***************
 getpwnam()
 gets password-entry of user with username name
***************/

struct passwd *getpwnam(char *name)
  {
  struct passwd *temp;

  if (setpwent())
     return NULL;
  while ((temp = getpwent()) != NULL)
     if (strcmp(temp->pw_name, name) == 0)  {
	setpwent();
	return temp;
	}
  setpwent();
  return NULL;
  }



/***************
 setpwent()
 seeks the beginning of the passwordfile
***************/

int setpwent(void)
  {
  if (_pw_file == NULL)
     pw_openfile(NULL);
  return fseek(_pw_file, 0L, SEEK_SET);
  }



/***************
 endpwent()
 seeks the end of the passwordfile
***************/

int endpwent(void)
  {
  int temp;

  temp = fclose(_pw_file);
  _pw_file = NULL;

  return temp;
  }



/***************
 pwd_openfile()
 causes the file with filename 'name' to be the passwordfile from
 which all other functions get their information.
***************/

int pw_openfile(char *name)
  {
  if (name == NULL)
    name = getenv("PASSWD");
  if (name == NULL)
    name = "\\etc\\passwd";
  return (_pw_file = fopen(name, "r")) != NULL;
  }


/* EOF PWD.C */
