PAGE 58,132
;==============================================================================
TITLE SIWVID.ASM - Soft-ICE/W Video driver template
;
; This file is a template and a specification for writing a vxd video driver
; for Soft-ICE/W.  When Soft-ICE/W first starts up it looks in the directory
; where WINICE.EXE is located for a file named SIWVID.386.  If it is found
; Soft-ICE/W automatically loads it and calls it to switch video modes
; between text and graphics modes.
;
; A stub routine is provided for each of the entry points that the video vxd
; might have to provide code for.  Other than initialization all the real
; work is done in two routines, one to save the screen and switch to text mode
; and one to restore the screen.  The following entry points are defined:
;
;  Real mode init   	This is the real mode initialization portion of the
;			VxD called by Windows before switching to protected
;			mode.  At this point video bios calls can be made.
;			The only restriction is that this portion can pass
;			only a single DWORD value to the protected mode
;			portion of the VxD.
;
;  CRITICAL_INIT	This is the first level of protected mode
;			initialization in the VxD.  At this point the video
;			vxd should finish up whatever initialization is 
;			required.
;
;  SIWVID_GetVersion   	This VxD service will be called by Soft-ICE/W to 
;			determine if a video VxD is loaded.  This service does
;			nothing more than return version 1.0 and does not need
;			to be modified.
;
;  SIWVID_Setup		This service is called by Soft-ICE/W immediately after
;			the GetVersion service.  Its only purpose is to pass
;			some pointers that the video VxD might require.  The
;			following values are passed:
;
;			 - A linear address that can be used to access any
;			   physical memory location.
;
;			 - A linear address of an 8x16 rom font that can be
;			   used for 25 line mode.	
;
;			 - A linear address of an 8x8 rom font that can be
;			   used for 44 and 50 line mode.	
;
;			 - A linear address of an 8000 byte save buffer.  
;			   This buffer can be used to save the contents of
;			   video memory and is passed so the VxD does not
;			   have to waste 8000 bytes defining its own save
;			   buffer.
;
;  SIWVID_SaveScreen	This routine is called when Soft-ICE/W is ready to
;			pop up.  This routine must do the following:
;
;			 - Save the current video state for later restoring
;			   (The current video state can be either graphics
;			   or text (DOS BOX)).
;
;			 - Save the 8K of video memory that Soft-ICE/W will
;			   use in text mode.
;
;			 - Switch the video board into the appropriate text
;			   mode (25, 44, or 50 line mode).
;
;  SIWVID_RestoreScreen	This routine is called when Soft-ICE/W is ready to
;			pop down.  This routine must restore the video to the
;			state saved by SaveScreen.
;
;  SIWVID_Debug         This routine is callable from a 16 bit windows or DOS
;			program.  It can be used to debug SIWVID.386 using
;			Soft-ICE/W on a serial terminal or a monochrome 
;			monitor.  A DOS/Windows program is included that calls
;			this entry point.  All the routine does is a call
;			to SaveScreen followed by a call to RestoreScreen.
;			
;
;  The first four entry points above are called once and only once and they
;  are called in the order that they are documented.  The next two routines
;  are called when soft-ice/w needs to pop up but they will not be called
;  prior to the initialization routines.  The SaveScreen and RestoreScreen
;  are called as a pair, that is 1 call to SaveScreen will always be followed
;  by 1 call to RestoreScreen.  The last entry point is used only for 
;  debugging purposes and does not need to be modified.	
;
;
;   (C) Copyright Nu-Mega Technologies Inc. 1994
;
;   Date:	12-Jan-1994
;==============================================================================

.386p

;==============================================================================
;			      I N C L U D E S
;==============================================================================

.XLIST

	INCLUDE VMM.INC


;==============================================================================
;		   V X D   S E R V I C E S   D E C L A R A T I O N
;==============================================================================
SIWVID_Device_ID equ 7a5fh

Create_SIWVID_Service_Table EQU 1   ; SIWVID.386 service table created

Begin_Service_Table SIWVID
	SIWVID_Service SIWVID_GetVersion, LOCAL
	SIWVID_Service SIWVID_Setup, LOCAL
	SIWVID_Service SIWVID_SaveScreen, LOCAL
	SIWVID_Service SIWVID_RestoreScreen, LOCAL
End_Service_Table SIWVID

.LIST

;==============================================================================
;		 V I R T U A L	 D E V I C E   D E C L A R A T I O N
;==============================================================================
Declare_Virtual_Device SIWVID, 1, 0, SIWVID_Control, SIWVID_Device_ID,,SIWVID_Debug,SIWVID_Debug

VxD_LOCKED_DATA_SEG

db '(C) Copyright Nu-Mega Technologies Inc. 1994',0

;==============================================================================
; Values passed from Soft-ICE/W during setup.
;==============================================================================
; linear address that maps any physical address
MapPhysical dd 0			

; linear address of fonts that soft-ice/w obtains from the rom before
; starting windows.  The 8x16 can be used for 25 line text mode while the
; 8x8 is used for 44 and 50 line text mode.
Font8x16 dd 0
Font8x8	 dd 0

; address of 8000 byte save buffer.  This is passed so the VxD doesn't have
; to waste an addition 8000 bytes defining a save buffer.
SaveBufferAddress  dd 0			

VxD_LOCKED_DATA_ENDS

VxD_LOCKED_CODE_SEG


;==============================================================================
; 		C O N T R O L   D I S P A T C H   P R O C E D U R E
;==============================================================================
BeginProc SIWVID_Control
	Control_Dispatch Sys_Critical_Init, <SIWVID_Critical_Init>
	
	clc
	ret
EndProc SIWVID_Control


;==============================================================================
; 		S Y S   C R I T I C A L   I N I T   P R O C E D U R E
;
; This is the only VxD Control message that SIWVID processes.  At this point
; do any protected mode initialization required.  This routine is called
; prior to any services being called.
;
; INPUT:   EDX	value passed from real mode init if any
;
; OUTPUT:  carry clear for success, carry set to abort VxD load
;
;==============================================================================
BeginProc SIWVID_Critical_Init
	clc
	ret
EndProc SIWVID_Critical_Init



;==============================================================================
; 		G E T   V E R S I O N   S E R V I C E
;
; This routine is called once by Soft-ICE/W to determine if a SIW video driver
; is loaded.  It does not have to be altered.
;==============================================================================
BeginProc SIWVID_GetVersion, SERVICE
	mov	eax,100h		; return version 1.0
	clc				; return success
	ret
EndProc SIWVID_GetVersion


;==============================================================================
; 			S E T U P   S E R V I C E
;
; This routine is called once by Soft-ICE/W (after SYS_CRITICAL_INIT) and
; passes a linear address that can be used to address any physical memory.
; Just add this address to any physical address before accessing memory.
;
; INPUT  EDX - Linear address that maps any physical address
;	 ESI - Linear address of 8x16 rom font (for 25 line mode) 
;	 EDI - Linear address of 8x8 rom font (for 44 and 50 line mode)
;	 EBX - Linear address of 8000 byte video memory save buffer
; OUTPUT NONE
;==============================================================================
BeginProc SIWVID_Setup, SERVICE
	mov	MapPhysical,edx		; save for addressing video memory
	mov	Font8x16,esi		; save address of 8 x 16 font
	mov	Font8x8,edi		; save address of 8 x 8 font
	mov	SaveBufferAddress,ebx   ; video memory save buffer
	ret
EndProc SIWVID_Setup



;==============================================================================
; 			S A V E   S C R E E N   S E R V I C E
;
; This routine is called when Soft-ICE/W is ready to pop up.  This routine
; must do the following:
;	- Save the current video state for later restoring (The current video
;	  state can be either graphics or text (DOS BOX))
;	- Save the 4K of video memory that Soft-ICE/W will use in text mode
;	- Switch the video board into the appropriate text mode 
;	  (25, 44, or 50 line mode)
;
; INPUT  EDX - Text Mode (25, 44, or 50)
; OUTPUT NONE
;==============================================================================
BeginProc SIWVID_SaveScreen, SERVICE
	ret
EndProc SIWVID_SaveScreen


;==============================================================================
;		R E S T O R E   S C R E E N   S E R V I C E
;
; This routine is called when Soft-ICE/W is ready to pop down.  This routine
; must restore the video to the state saved by SaveScreen.
;
; INPUT  NONE
; OUTPUT NONE
;==============================================================================
BeginProc SIWVID_RestoreScreen, SERVICE
	ret
EndProc SIWVID_RestoreScreen



;==============================================================================
; 		  D E B U G G I N G   E N T R Y   P O I N T
;
; This routine is called by the DOS or Windows program TESTVID.EXE and can be
; used to debug your SIWVID.386.  This routine does not need to be modified.
;==============================================================================
BeginProc SIWVID_Debug
	mov	edx,25
	call	$SIWVID_SaveScreen

	call	$SIWVID_RestoreScreen
	ret
EndProc SIWVID_Debug


VxD_LOCKED_CODE_ENDS


;==============================================================================
; 			R E A L   M O D E   I N I T   
;
; Do any real mode mode initialization required.  A single DWORD value can
; be passed from here to the protected mode portion of the VxD.
;
; INPUT:   CS=DS=ES	code/data segment	
;	   SI		environment segment
;	   AX		VMM version number
;	   BX		flags
;	   EDX          reference data from int 2fh response or zero
;
; OUTPUT   AX		exit code 0-success
;				  1-error don't load this VxD
;				  2-fatal error - abort loading windows
;	   BX		ptr to list of pages to exclude (0 if none)	
;	   SI		ptr to instance data items (0 if none)
;	   EDX		value that can be passed to protected mode portion
;==============================================================================

VxD_REAL_INIT_SEG

BeginProc SIWVID_init
	xor	ax,ax			; return success
	xor	si,si			; NO instance data
	xor	bx,bx			; NO excluded pages

	ret
EndProc SIWVID_init


VxD_REAL_INIT_ENDS

	END SIWVID_init
