{$M 32768,0,655360}
{$i aflags.inc}

uses XCmdLine, UString, UEXE, DOS, IOError, XCrt;

const
      NewHeader:TEXEHEader = (
        ID:          $5A4D;
        LastPage:    0;
        SumPages:    0;
        RelocEntries:$0000;
        HeaderSize:  $0002;
        MinMem:      0;
        MaxMem:      $FFFF;
        SS:          $FFF0;
        SP:          $0000;
        CheckSum:    $0000;
        IP:          $0100;
        CS:          $FFF0;
        RelocOffset: $001C;
        Res1:        $0000;
        Res2:        $4850;
        Res3:        $5841
      );

      MAX_BUF = 16384;

      Version = '1.01';

type
     TBuf = array[1..MAX_BUF] of byte;

var bOverWrite:boolean;

procedure Syntax;
begin
  writeln ('<> Syntax: COM2EXE filespec1 [filespec2 [filespec3 [...]]] [options]');
  writeln ('<>         Wildcards are allowed.');
  writeln ('<>');
  writeln ('<> Possible options:');
  writeln ('<>    /?, /H  -  show this help screen');
  writeln ('<>    /O      -  overwrite without asking');
  halt (1);
end;

procedure ConvertFile (SIn, SOut:string);
var fin, fout:file;
    BytesRead:word;
    Buf:TBuf;
    NewFileSIze:longint;
begin
  write ('<> Creating ', SOut, ' from ', SIn, ' ');

  assign (fin, SIn);
  reset (fin, 1);
  NewFileSize := FileSize (fin) + 32;

  assign (FOut, SOut);
  rewrite (FOut, 1);

  NewHeader.SumPages := NewFileSize div 512;
  NewHeader.LastPage := NewFileSize mod 512;
  if NewHeader.LastPage > 0 then
    inc (NewHeader.SumPages);
  NewHeader.MinMem := NewFileSize;
  blockwrite (FOut, NewHeader, 32);

  repeat
    blockread (FIn, Buf, MAX_BUF, BytesRead);
    CheckIOError (ioresult, SIn);
    blockwrite (FOut, Buf, BytesRead);
    CheckIOError (ioresult, SOut);
  until (BytesRead < MAX_BUF);

  close (FOut);
  close (fin);

  writeln (' done');
end;

procedure CheckFile (FName:string);
var f:file;
    Head:TEXEHeader;
    io:integer;
    OutFile:string;
    c:char;
    FSize:longint;
begin
  assign (f, FName);
  reset (f, 1);
  io := ioresult;
  if io = 0 then
  begin
    FSize := FileSize (f);
    blockread (f, Head, EXE_HEADER_SIZE);
    close (f);

    OutFIle := MakeExtension (FName, 'EXE');

    if (FSize > $0000FFFF) then
      writeln ('<> Sorry, ', FName, ' is too large to be a COM file')
    else
    if (FSize >= $0000FFE0) then
      writeln ('<> Sorry, ', FName, ' is too large to be converted')
    else
    if (Head.ID = $5A4D) or (Head.ID = $4D5A) then
      writeln ('<> Sorry, ', FName, ' is already an EXE file.')
    else
    if upstring (FName) = upstring (OutFile) then
      writeln ('<> I have some troubles creating ', OutFile, ' from ', FName, ' ;-)')
    else
    begin
      assign (f, OutFile);
      reset (f, 1);
      if ioresult = 0 then
      begin
        close (f);
        if (not bOverWrite) then
        begin
          write ('<> The outputfile ', OutFile, ' already exists - overwrite [y/n]? ');
          repeat
            c := upcase (readkey);
          until (c = 'Y') or (c = 'N');
          writeln (c);
        end;
        if (bOverWrite) or
           ((not bOverWrite) and (c = 'Y')) then
          ConvertFile (FName, OutFile)
        else
          writeln ('<> Skipping ', FName);
      end
      else
        ConvertFile (FName, OutFile);
    end;
  end
  else
  begin
    write ('<> ');
    NoteIOError (io);
    writeln (' - ', FName);
  end;
end;

procedure SearchFiles (Where, What:TCmdString);
var sr:SearchRec;
begin
  findfirst (concat (where, what), $3F, sr);
  while doserror = 0 do
  begin
    if (sr.attr and Directory = 0) and
       (sr.attr and VolumeID = 0) and
       (sr.name[1] <> '.') then
      CheckFile (sr.name);
    findnext (sr);
  end;
end;

var i:byte;
    sd:DirStr;
    sn:NameStr;
    se:ExtStr;
begin
  writeln;
  writeln ('<>Ĵ COM2EXE ', Version, ' (c) 1998 by PHaX ');
  writeln;

  if (CmdLine.NonOptionStringCount = 0) or
     (CmdLine.IsFlag ('?')) or
     (CmdLine.IsFlag ('h')) then
    Syntax;
  bOverWrite := CmdLine.IsFlag ('o');

  for i:=1 to CmdLine.NonOptionStringCount do
  begin
    fsplit (CmdLine.NonOptionString (i), sd, sn, se);
    SearchFiles (sd, concat (sn, se));
  end;
end.
