

              jumps
              p386
              radix 10h
              model small

        ; Scram! b5
        ; Copyright (c) 1996 by Bushwoelie^Moonshine and Stonehead^TPiNC.
        ; Re-released with source by STN.

        scram segment use16 'CODE'
              assume cs:scram,ds:scram,es:scram,ss:scram

              include stone.mac

              org 100

      scram_b equ $     ; start of the decryptor at once
        zooi: inc si
              push bp
              inc bx
              dec bx
              pop cx
              dec di
              push bp
              sbb bh,bh
              pop di

            ; ^^ The code above works, and looks compiled as "FUCKYOU".
            ;    Of course I tried in HIEW which texts were valid
            ;    code. The same txt in lowercase, for example, would
            ;    crash immediately.

              mov ax,7000
              push ax
              popf
              pushf
              pop ax
              and ax,7000
              jnz short thru1   ; Just a 286 test ripped from the
              showstr warn386   ; Borland example files. :)
              int 20
      warn386 db 'no 386!$'
      initjmp equ $+1
       thru1: mov bp,offset start
              nebelbomb
              jmp bp

              comment ~
              The code above is used twice: Scram itself starts with
              it and a scrambled file does so too - but the BP register
              is patched with the INITJMP variable then of course.
              The decryptor continues below this comment, "offset start"
              is the Scram! main routine start. ~

;            .radix 10d
;          d1 db 13,10,"Point reached!",13,10,"$"
;          d2 db "Point 2 reached!",13,10,"$"
;          d3 db "Point 3 reached!",13,10,"$"
;          d4 db "Point 4 reached!",13,10,"$"
;          d5 db "Point 5 reached!",13,10,"$"
;            .radix 16d             ; use showstr for this!

; The remarks above are for testing. If we didn't know whether Scram!
; was crashing due to one trick, we put everywhere between the code a
; "showstr d1" command (of course only where this was allowed, calling
; int21 where SP is tricky causes a crash) to see where the bug was.

      antidbg equ $           ; here start the junk

              cli

              mov sp,offset xor1_e
              mov si,sp
              sub si,2
              std             ; set direction
        xor1: lodsw           ; this is the first decryption layer..
              xor ah,0
              org $-1
        xor1b db 0
        ; What does ORG $-1 do? It just tells TASM to start compiling
        ; the next command one byte before the current position. The
        ; 0 byte and db 0 command are thus on the same place.
              ror al,2
              push ax         ; reverse stosw
              cmp byte ptr [xor1_b],0CC ; check for an "int 3" opcode
              je gbye1        ; on @gbye1, there's a HLT. This command,
                              ; in combination with the interrupt flag
                              ; turned off by CLI, causes a crash.
              cmp si,offset xor1_b
              ja xor1

              jmp $+2         ; against prefetch queue, needed when you
                              ; use a decryption loop with STD.

       xor1_b equ $           ; start first layer of encrypted code

              cld             ; clear direction
              mov sp,0fffe    ; restore SP

              sti
              call between    ; returns to HEH

              ; your computer should never reach the two commands below,
              ; "between" is not a real call, it will just pop back the
              ; pushed value. between can be found 200 lines below this,
              ; it jumps back to the heh label.

              mov dx,0DEADh   ; fake code
              mov dx,0CAFE    ; more trash values.. :)

         heh: xor al,al
              out dx,al       ; out 3c6,00 = screen black!
                              ; This trick is also used in Fds0ft-CRP
                              ; and cIPHATOR v4.6.

              nebelbombsmall  ; a rose-macro! see stone.mac
                              ; yeah, this is from my lame period..
       thru3: mov dx,3C6
              in al,dx        ; is the screen black?
              cmp al,00
              jne thru3       ; then.. endless loop
                              ; this caused incompatibility, removed later!!

              nebelbomb

              mov dx,3C6
              push cs         ; for retf later
              mov cx,2        ; for loop

              loop thru2      ; never proceed in a debugger: trace!
       gbye1: hlt             ; hard crash (when cli, not sti)
              db 80h          ; trash..
       thru2: push offset hoho; for retf later

              mov al,0FF
              out dx,al       ; screen back

              mov ah,0Dh      ; cup386 v3.0b + diskcache = crash
              int 21          ; works against loading in softice too..

              push ds
              mov bp,offset timer
              lds bx,[bp]
              mov ax, ds:[bx]
       thru4: cmp ax, ds:[bx]
              jz thru4        ; endless loop for cup386 v3.0b
              pop ds

              ; ^^ The value of the clock timer is ALWAYS stored at
              ;    the address 0040:006c. It was an old CUP bug that
              ;    STI was never called inside CUP386 => no clock updates.

              retf            ; jump to the previous pushes segment / offset

    int1adres dw 0004,0000    ; ofs:seg for LES
        timer dw 006c,0040    ; ofs:seg for LDS

;  

      regged: mov bp,offset reg_b
              xor dx,dx
    regloop1: xor ah,ah
              mov al,byte ptr [bp]
              xor ax,bp
              add dx,ax
              inc bp
              cmp bp,offset reg_e
              jne regloop1  ; control checksum over the registered-string

              mov ax,0000
              org $-2
       regsum dw 0000
        bye2: cmp dx,ax
              je thru5             ; checksum wrong?....

              mov bp,offset hacked ; then something is gonna happen.. :)
              mov cx,7
       thru7: xor byte ptr [bp],43
              inc bp
              loop thru7
              jmp $+2
              showstr hacked    ; write hacked on screen
          el: jmp el            ; endless loop

       hacked db "lamer!$"
       thru5: retn

;  

        hoho: ;mov sp,0fffe    ; again, set back!

              push cs cs
              pop  ds es
              call regged

              mov al,0AAh
              out 64,al       ; keyb off (usual: al=0ADh, but this is not
                              ; detected as a keyb trap in CUP 3.2 :))
              mov al,0AE
              out 64,al       ; keyb on

      comment ~
      Theory about keyboard ports.

      Also in Mess 7, there were lots of keyboard problems. Users reported
      that their keyboard was locked after running the Mess decryptor.
      Most encryptors use this kind of ports (you'll see as well OUT 60,F5
      in for example Alec and SuckStop) to lock the keyboard. Port 20 is
      really outdated, I've never seen this port really locking the
      keyboard. In Mess 8 I decided to abandon all keyboard commands.
      No Mess versions have had keyboard traps since then.
      Anyway, this four commands above crash. Why? I asked this to Rose
      personally on the TPiNC party in April 1997. He answered that he
      knew the problem, but he didn't know what it was either. Instead,
      he said he solved it in HS by putting the OUT 64,ADh far away from
      the OUT 64,AEh. So if you ever decide to use this shitty ports,
      you know what to do. :) ~

      ;
      ; the ideas list: decryptor: int 1/3

      comment ~
      This anti debugging idea is based on the fact that debuggers like
      Turbo Debugger and tracers like UNP T *need* interrupt 1 and 3 to
      do their work with the old 8086 trap flag. ~

      ; db 0F1h  ; smi command, trashes debuggers (and win95 too..)

      comment ~
      The SMI command askes the processor information about the SMM
      mode. Protected mode does not like this command, it makes your
      Windows usually crash. Hendrix, the author of GTR, had to invest
      some energy to find out that he had to emulate this SMI command
      to unpack Merlin's PCrypt 3.50. I did not use it yet in Scram! b5. ~

      ; add something with TF

      comment ~
      Or called the Running Line, see Radfaq or 40Hex. Something outdated
      against generic tracers like CUP and GTR, but it still fucks up
      debuggers, among them WinIce. However, there seems to be a bug
      in Win95 that interrupt 1 sometimes IS, sometimes is NOT called
      one extra time after clearing the trap flag. Therefore the
      running line *might* cause trouble in Win95. ~

      ; jumps to cs:100h to fuck UNCOM

      comment ~
      Many generic COM unpackers of 1996 were based on the idea that
      putting a breakpoint on cs:100 is enough to unpack a com file.
      As you can see with RCC, it is not. RCC jumps x times to this
      address - Rose's only stupidity is that he does this in a CALL,
      so it's easy to detect that SP=0FFFCh instead of 0FFFEh. The
      automatic mode of Decay checks this, in the interactive mode you
      can stop on any SP value at CS:100h. (Protect! leaves 3 extra words
      on the stack, thus fucking some automatic COM unpackers.) ~

      ; hook 0:0, jmp far cs:100
      ;                mov     eax,dr0       ; privilege instruction!
      ;                mov     dr0,eax       ; cup3.0b without /d stops :)

      comment ~
      In the newest CUP386 you can find full hardware breakpoint
      emulation. This is absolutely great, nowhere else to find in
      a PC debugger, and I used it to debug my DECAY unpacker. The trick
      above does not work anymore because of this newer CUP feature. ~

      comment ~
      Here is a place to tell you something what Scram! b5 does not. It
      does not fuck generic language unpackers like UPC, TEU or Intruder.
      This can be done by checking int21 (even with TEU, there are only
      6 possible mutations anyway), or by copying an initialize routine
      of a standard language library, thus giving a false trigger to the
      unpacker. Another thing is that Scram! does not turn off hardware
      breakpoints, something easy for a 386-scrambler (xor eax,eax
      mov dr7,eax). I didn't know this one year ago, now I got my own
      DRx-using generic com unpacker. Strange world. ~

      ;

              push es
              mov bp,offset int1adres
              les bx,[bp]
              mov ax, es:[bx]
              push ax         ; save int 1
              mov ax, es:[bx+2]
              push ax

              mov ax, offset int1h
              mov es:[bx], ax ; set int 1
              mov ax, cs
              mov es:[bx+2], ax         ; in Mess, I put this kind
                                        ; of interrupt hooking in a
              push cs                   ; subroutine.
              pop  es

              mov si,offset scram_e
              mov di,si
              mov cx,0000     ; length variable in decryptor
              org $-2
   FileLength dw 0
              shr cx, 1       ; word algorithm

              mov dx, 'bw'    ; in Mess I used random values, much better.
                              ; It looks like ORG $-2, random dw 'bw'
              mov bx, 'st'

       iloop: int 1           ; use int 1 for the main decryption commands :)
              loop iloop

              mov bp,offset int1adres
              les bx,[bp]     ; the dword address [bp] => a new ES and BX

              pop ax
              mov es:[bx+2], ax ; restore int 1
              pop ax
              mov es:[bx], ax
              pop es

              mov si, offset move_b
              mov di, offset scram_e
              add di, [filelength]
              mov cx, (move_e-move_b)
              mov bp,di
              rep movsb       ; write mover after the decrypted code

              jmp bp          ; jump to mover

       move_b equ $           ; this is the mover
              mov si,offset scram_e
              mov di,100
              mov cx,filelength
              rep movsb       ; move the decrypted code to cs:100
              xor ax,ax       ; all registers to zero
              push ax ax ax ax ax ax
              pop  bx cx dx bp si di
              push 100        ; jump to entrypoint cs:100
              ret
       move_e equ $

       xor1_e equ $

        reg_b equ $           ; copyright text..
              db 0Dh,0Ah,0Dh,0Ah
              db "Scram! 5 by STN97, unregged."
              db 0Dh,0Ah
        reg_e equ $

       int1h: lodsw
              rol ax, 3
      ;       xor ax, dx
              xchg ah, al
      ;       xor ax, bx       ; who codes the most difficult
      ;       xor dx, bx       ; decryption algorithm? ;)
      ;       inc dx
      ;       dec bx
      ;       xor bx, cx
              stosw
              iret

              ; here we are again :)

     between: pop dx             ; This decryptor code is placed behind
              mov dx,offset heh  ; to make it weird :)
              push dx

              into            ; CUP int 0 handling is bad
              mov dx,3C6

              retn
                              ; ^ BIG bug!
              comment ~
              The INTO command is used to call INT 4 if the overflow
              flag in the flags register is on, otherwise it does
              nothing (like a NOP.) When I coded Scram 5,
              I thought this command called INT 0. Strangely, this
              code sequence runs perfectly! So it seems that DOS'
              internal INT 0 jumps to its own INT 4.
              Due to this tricky things, this trick is anti-ALL tracers.
              But it isn't very compatible too I think.. I replaced
              it with INT 4 hooking in Mess 9, but this was traced again
              by CUP.. ~


      scram_e equ $              ; end decryptor
  scramlength equ (offset scram_e - offset scram_b) ; length decryptor

;  

  CryptBuffer proc

              in al,40                ; set some last variables
              mov [xor1b],al

              mov cx, scramlength
              mov di, offset buffer
              mov si, offset scram_b
              cld
              rep movsb               ; copy the decryptor to cs:buffer

              mov si,di         ; the file body is right after it
              mov dx, 'bw'      ; the file body ENcryption algorithm
              mov bx, 'st'
              mov cx, [filelength]
              shr cx,1

      sprong: lodsw
      ;       xor     ax, bx
              xchg    ah, al    ; no int 1 here, of course :)
      ;       xor     ax, dx
              ror     ax, 3
      ;       xor     dx, bx
      ;       inc     dx
      ;       dec     bx
      ;       xor     bx, cx
              stosw
              loop    sprong

              call CryptLayer1         ; crypt layer 1 before write

              retn
         endp CryptBuffer

    ; Scram! works like this: the places where a layer of encryption begins
    ; and starts are marked with an EQU label. Only when MESS.COM is runned,
    ; just before writing the decryptor to the output file, all layers are
    ; copied to and encrypted in the file buffer.

;  

    newxor1_b dw 0
    newxor1_e dw 0

  CryptLayer1 proc       ; crypt the only internal layer of the decrypto
                         ; in the buffer..

              xor ax,ax
              push cs
              pop  ds

              mov si,offset xor1_b              ; some offsets should be
              add si,offset newscram-100h       ; relative.. we're
              mov [newxor1_b],si                ; crypting a copy of
              mov si,offset xor1_e              ; the decryptor at cs:100h,
              add si,offset newscram-100h       ; in the buffer (cs:5000h)
              mov [newxor1_e],si
              sub si,2
              mov di,si
              cli
              std        ; backwards direction

         x1b: lodsw                      ; encrypt first PUSH/LODS layer
              rol al,2
              xor ah,xor1b
              stosw
              cmp di,[newxor1_b]
              ja x1b
              cld
              sti

              retn
         endp CryptLayer1

;  

     CheckReg proc                   ; make a checksum over the
                                     ; copyright string
              mov bp,offset reg_b
              xor dx,dx
     regloop: xor ah,ah
              mov al,byte ptr cs:[bp]
              xor ax,bp
              add dx,ax
              inc bp
              cmp bp,offset reg_e
              jne regloop

              mov [regsum], dx       ; put it in the decryptor

              mov bp,offset hacked   ; encrypt the "lamer!$" text
              mov cx,7
       thru6: xor byte ptr cs:[bp],43
              inc bp
              loop thru6

              retn
         endp Checkreg


;  

      start:  mov word ptr [initjmp], offset antidbg ; patch entry!

              call CheckReg                     ; do this first

              call IniFile                      ; which file to scram?
              call Header

              showstr  WhatFile                 ; screen handling
              showstrz FileName                 ; showstr.. is a macro
              showstr  CrLf                     ;   to put things on screen

              showstr AccessFile

              lea dx, FileName
              mov ax, 3D02
              int 21          ; open inputfile
              jc Error
              mov [FileHandle], ax
              showstr DoneString

              mov al, 02
              mov bx, [FileHandle]
              xor cx, cx
              xor dx, dx
              call FPoint     ; goto end of inputfile

              mov [FileLength], ax

              cmp ax, 50000d  ; if bigger than 50000 bytes, error
              ja Err5

              ; Scram puts the COM file and the decryptor in
              ; the rest of the memory. Scram is a COM file,
              ; therefore taking 65535 bytes (64kB) of memory.
              ; High above in the 65500, some bytes are used for
              ; the stack. Low in the 64 kB segment, there's the
              ; compiled Scram! code you read now. Between is about
              ; 50 kB "buffer" space, considered that Scram's compiled
              ; code does not exceed 14 kB. Even Mess v1.17 is 9 kB
              ; big, so this was quite a boundary. But this big buffer
              ; is obsolete anyway. Files of about 60kB can't be
              ; Scram!med. Mess can handle them: Mess uses another
              ; segment for COM encrypting (an even better solution
              ; would be encrypting in stages, like the Mess/EXE
              ; encrypting.)

              mov ax, [FileLength]
              lea dx, HexSize
              call binhex

              ; The Binhex procedure is buggy. In Mess 1.04 I replaced
              ; it with a procedure which puts a register in decimals
              ; on the screen.

              showstr WhatSize
              showstr BackUpMsg

              ; In this Scram! b5, a backup file is created and copied
              ; from the original. Later, the original will be read into
              ; memory (the big "buffer" too) and overwritten.
              ; In Mess, I decided this was another mistake. Now I rename
              ; the original to a BAK extension, read it in stages into
              ; a much smaller buffer, and write it in stages to a new
              ; created file with the old original name.

              lea dx, BakName
              mov ax, 3C02
              mov cx, 00100000b
              int 21          ; create bakfile
              jc Error

              mov [BakHandle], ax

              xor al,al
              xor cx,cx
              xor dx,dx
              mov bx, [FileHandle]
              call FPoint     ; goto start of inputfile

              mov bx, [FileHandle]
              mov cx, [FileLength]
              mov dx, offset buffer
              mov ax, 3f00
              int 21          ; read inputfile for bakfile
              jc Error

              mov bx, [BakHandle]
              mov cx, [FileLength]
              mov dx, offset buffer
              mov ax, 4000h
              int 21          ; write bakfile
              jc Error

              mov bx, [BakHandle]
              mov ah, 3e
              int 21          ; close bakfile
              jc Error

              showstr DoneString
              showstr WhatBackup
              showstrz BakName
              showstr CrLf

              mov ax, [FileLength]    ; Due to the encryption algorithm
              and ax, 1               ; in words, this may NOT be odd
              jz NoAddByte

              mov ax, [FileLength]    ; What a byte waste.. Is this me ??
              inc ax
              mov [FileLength], ax

   NoAddByte: xor al, al
              mov bx, [FileHandle]
              xor cx, cx
              xor dx, dx
              call FPoint

              mov bx, [FileHandle]
              mov cx, [FileLength]
              mov dx, scramlength+offset buffer  ; the decryptor is stored
              mov ax, 3f00                       ; at offset buffer
              int 21          ; read inputfile in buffer
              jc Error

              showstr EncryptMsg

              call CryptBuffer  ; encrypt buffer

              showstr DoneString

              mov al, 00h
              mov bx, [FileHandle]
              xor cx, cx
              xor dx, dx
              call FPoint     ; to begin outputfile

              showstr WriteMsg

              mov bx, [FileHandle]
              mov cx, [FileLength]
              add cx, scramlength
              mov dx, offset buffer
              mov ax, 4000
              int 21          ; write buffer with encrypted file body
              jc Error        ; and decryptor to output file

              mov bx, [FileHandle]
              mov ah, 3e
              int 21          ; close outputfile
              jc Error

              showstr DoneString
              exit

      FPoint: mov ah, 42h
              int 21          ; move file pointer
              jc Error
              ret

              ; ^^ Another unstructured sub somewhere just within the
              ;    code. Hint: in particular with big asm proggies,
              ;    divide your program in .INC files and macro's
              ;    I did this in Mess v10.2, the source had really
              ;    become a "mess".

              comment ~
              If you're ever gonna do a programming course, be prepared
              to very stupid teachers. At least, you'll think so the
              first weeks. All they'll do is re-learning you a coding
              language. That's very irritating. If you get used to
              structured coding NOW, you'll need much less work to
              get used to the teacher's "academic" way of coding. That
              way is sometimes stupid indeed, but coding in a team on
              huge programs is quite different from programs you code
              in your own. Your code must be clear for everyone. This
              code is definitely not (code of December 1996). In the
              meantime, I released Decay and Mow with their source
              code. Those programs are far better to read than this
              one. At last, you'll NEED "academic" coding.
              It is you who gains from brightness. ~

     IniFile: mov di, offset FileName
              mov si, 82              ; commandline is (with COM files)
              mov al, [si-2]          ; on DS:80:
              cmp al, 0               ; byte ptr DS:[80] length cmdline
              je NoCmd                ; byte ptr DS:[81] cmdline, often
              lodsb                   ; starting with a space..
              cmp al, 0dh
              je NoCmd
              cmp al, 20              ; space or <enter>
              je NoCmd
        cmd1: mov [di], al
              inc di
              lodsb
              cmp al, 20
              je cmd2
              cmp al, 0dh
              jne cmd1

        cmd2: mov byte ptr [di], 0

              mov ax, 1211h               ; uppercase in FileName
              lea si, FileName
              lea di, FileName
              int 2fh

              lea si, FileName
              mov cx, 128d-5d             ; 128d - Ext - . - 0
                                          ; d means decimal, h means hex
                                          ; You can set default with .radix
    PuntLoop: lodsb
              cmp al, '.'     ; is there a '.' in the file name?
              je MetPunt      ; yes
              cmp al, 0
              je ZonderPunt   ; nope
              loop PuntLoop
  ZonderPunt: dec si          ; nope
              mov di,si
              mov eax, 'MOC.' ; then make an extension: .COM
              stosd           ; store extension and nulbyte
              xor eax,eax
              stosb
     MetPunt: lea si, FileName   ; with a '.'
              lea di, BakName
              mov cx, 128d-5d             ; 128d - Ext - . - 0
              lodsb

     BakLoop: cmp al, '.'   ; name backup filename
              je NaBakName
              stosb
              lodsb
              loop BakLoop  ; while not '.' store character

   NaBakName: mov eax, 'KAB.' ;.BAK
              stosd
              xor eax,eax
              stosb
              ret      ; store BAK extension after the file name

       NoCmd: call Header
              showstr Usage
              exit

     ; ------------------------------------------------------

       Error: push ax
              lea dx, HexErr
              call binhex
              showstr FailString
              showstr ErrorMsg
              pop ax

              mov bl,al

              cmp ax, 2
              jne Err2        ; file open errors
              ; Argh. In Mess, this error system is replaced with
              ; a more flexible "string system": a counter is updated
              ; during the program and there's a special error message
              ; for each counter value. Are you wondering how to make
              ; an array in asm? Make an index row first, like
              ; row dw offset thing1, offset thing2, offset thing3, ..
              ; After that you can reach the offset of element bx-1 with
              ; shl bx,2
              ; mov ax,[offset row+bx]
              showstr Err2msg
              jmp ErrExit
        Err2: cmp ax, 3
              jne Err3
              showstr Err3msg
              jmp ErrExit
        Err3: cmp ax, 4
              jne Err4
              showstr Err4msg
              jmp ErrExit
        Err4: cmp ax, 5
              jne ErrUn
              showstr Err5msg
              jmp ErrExit     ; other errors
        Err5: showstr Err6msg ; too big
              jmp ErrExit
       ErrUn: showstr ErrUMsg
     ErrExit: showstr CrLf
              mov ah,4c
              mov al,bl
              int 21

      Header: cls             ; I love those macro's.

              push es
                xor di,di
                mov ax,0b800h     ; The text video segment
                mov es,ax         ; (in fact, the 80x25 screen)
                mov cx,11d*80d
                lea si,logo
                rep movsw         ; put the logo on screen
              pop es
              ; By indenting the code between PUSH..POP I didn't forget
              ; the POP.

              mov ah,2
              sub bh,bh
              mov dh,11d
              xor dl,dl
              int 10h
              ; ^^ Undocumented code.. After  a year, I really
              ;    didn't know what it does. Lesson: use comments.
              ;    Because I'm guiding you thru this code, I had to
              ;    comment it again. This is cursor setting.
              ret

      binhex: push ax bx cx dx
               mov bx,dx
               mov dl,ah
               mov cl,4
               shr dl,cl
               call bh10     ; This kind of code is ripped straight
               mov dl,ah     ; from RAMSPY, it was the shortest code
               and dl,15d    ; I had in 1996 to put a register value
               call bh10     ; on screen. Mess does this in decimals,
               mov dl,al     ; this is hexadecimal.
               shr dl,cl
               call bh10
               mov dl,al
               and dl,15d
               call bh10
              pop dx cx bx ax
              ret

      bh10:   cmp dl,10d
              jb bh11
              add dl,7
      bh11:   add dl,'0'
              mov [bx],dl
              inc bx
              ret

      ;

              .radix 10d      ; Should be in an include file of course.
   logo_width equ 80
   logo_depth equ 11
  logo_length equ 1760
   logo label byte
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8
              db '',8,'[',8,'(',7,'C',15,')',7,' ',7,'S',9,'t',3,'o',7
              db 'n',11,'e',15,'h',11,'e',7,'a',3,'d',9,'^',4,'T',9,'P',11
              db 'i',15,'N',11,'C',9,' ',7,'9',7,'7',7,']',8,'',8,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0
              db '',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,' ',0,'',9,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0
              db '',9,'',9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9
              db '',9,'',9,'',9,'',9,' ',0,'',11,'',11,'',11,''
              db 11,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0,''
              db 9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,''
              db 9,'',9,' ',0,'',9,'',9,'',9,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0,''
              db 9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,' ',0,'',11,'',11,'',11,'',11,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,'',9
              db '',9,'',9,'',9,' ',0,' ',0,' ',0,'',9,'',9,'',9
              db '',9,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' ',0
              db '',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,'',9
              db '',9,'',9,'',9,' ',0,'',9,'',9,'',9,' ',0,'',9
              db '',9,'',9,'',9,' ',0,'',11,'',11,'',11,'',11,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,'',9,''
              db 9,'',9,'',9,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,' ',0,' ',0,''
              db 9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' ',0,' '
              db 0,' ',0,'',9,'',9,'',9,'',9,' ',0,'',9,''
              db 9,'',9,'',9,' ',0,'',9,'',9,'',9,' ',0,'',9,''
              db 9,'',9,'',9,' ',0,'',11,'',11,'',11,'',11,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9
              db '',9,'',9,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9
              db '',9,'',9,' ',0,'',9,'',9,'',9,' ',0,'',9,'',9
              db '',9,'',9,' ',0,'',11,'',11,'',11,'',11,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,''
              db 9,'',9,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' '
              db 0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,''
              db 9,'',9,' ',0,'',9,'',9,'',9,' ',0,'',9,'',9,''
              db 9,'',9,' ',0,'',11,'',11,'',11,'',11,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9
              db '',9,' ',0,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0
              db '',9,'',9,'',9,'',9,' ',0,' ',0,'',9,'',9,'',9
              db '',9,' ',0,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9
              db '',9,' ',0,'',9,'',9,'',9,' ',0,'',9,'',9,'',9
              db '',9,' ',0,'',11,'',11,'',11,'',11,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,'',9,'',9,'',9,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,''
              db 9,'',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0,''
              db 9,'',9,'',9,'',9,' ',0,' ',0,' ',0,'',9,'',9,''
              db 9,'',9,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,'',11,'',11,'',11,'',11,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' ',0,' '
              db 0,'',9,'',9,'',9,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9
              db '',9,'',9,'',9,'',9,'',9,'',9,'',9,' ',0,'',9
              db '',9,'',9,'',9,' ',0,' ',0,' ',0,'',9,'',9,'',9
              db '',9,' ',0,'',9,'',9,'',9,'',9,' ',0,' ',0,' ',0
              db '',9,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,'',9,'',9,'',9,' ',0,'',9,'',9,'',9,'',9,' '
              db 0,'',11,'',11,'',11,'',11,' ',0,' ',0,' ',0,' ',0,' '
              db 0,' ',0,' ',0,'',8,'[',8,'V',7,'e',7,'r',7,'s'
              db 7,'i',7,'o',7,'n',7,' ',7,'',12,'5',12,']',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,'',8,''
              db 8,'',8,'',8


        Usage db " Usage: SCRAM! <Filename>", 10, 13
              db " There are currently two versions of Scram!.",13,10
              db "  Watch out for the BushWoelie release, that will strike this version!"
              db "$"

         ; The Bushwoelie release came much later. Together with ACP,
         ; my old friend Bush spread Scram! v0.7a1 and v0.8a1 via the
         ; #ucf2000(efnet) and #cracking channel. Those Scram! versions
         ; were nice but sometimes incompatible with other programs. (This
         ; Scram! b5 is a compatibility timebomb too, btw. Even the newer
         ; Mess 7 would get the Stefan Esser MESSR comment "works not".)
         ; Anyway, Bush gave up Scram! coding after the TPiNC party. He
         ; didn't finish his school year properly either. Using Linux and
         ; Memphis, he probably now shares the opinion that "DOS sucks."
         ; Anyway, he had fun coding and he's been a creative trend setter.

   AccessFile db " Opening file..             $"
    BackupMsg db " Backing up file..          $"
   EncryptMsg db " Encrypting file..          $"
     WriteMsg db " Writing file..             $"

     WhatFile db " File: $"
     WhatSize db " Size: "
      HexSize db "     "
              db " bytes",13,10,"$"
   WhatBackup db " Backup: $"

         CrLf db 13, 10, "$"

   DoneString db "Done.", 13, 10, "$"
   FailString db "Failed!", 13, 10, "$"

     ErrorMsg db " Errorcode: "
       HexErr db "     "
              db 13,10,"$"

      Err2msg db "  - File not found!$"
      Err3msg db "  - Path not found!$"
      Err4msg db "  - Too many files open!$"
      Err5msg db "  - Access denied!$"
      Err6msg db " File is too big!", 13, 10, "$"
      ErrUMsg db "  - Unknown error!$"

       hidden db 13,10,13,10
              db "Hidden text? Nope ;]  Happy tracing and coding in 97!  CU STN."

   FileHandle dw ?
    BakHandle dw ?
      AddByte db ?              ; using a ? instead of a 0 means that
                                ; tasm makes the file much smaller.. try
     FileName db 128 dup (?)    ; this with masm Ralph ;)
      BakName db 128 dup (?)

     newscram equ $

       buffer db 50000d dup (?) ; Buffer for the COM file, which could
                                ; not be bigger than 50 kB. Mess reads the
                                ; COM file in a new segment of 64 kB,
                                ; so the com file size can be 64 kB -
                                ; stack size - decryptor size there.

        scram ends
              end zooi          ; ready. thanks 4 reading ;)  Merry XMas!
