{
  -----------------------------------------------
  QUICK & DIRTY Detection for CSCRYPT
  Copyright (c) 1997 by Stefan Esser / Prometheus
  -----------------------------------------------

  Construction of this Mutation Engine is:

  Constant IP: Protector's CODE
  Entrypoint : Polymorph Decryptor of Protector's CODE
  Somewhere  : JMP / CALL / IRET / RETF .... to Constant IP

  All we have to do, to detect this engine, is to find JMPs / CALLs
  to this Constant IP and 'MOVs' that fill in the Constant IP adress
  into one of the registers

  My comments on CSCRYPT:
  -------------------
  MtE - nice but weak
  -------------------
  NICE because it generates much junk code and encryption is complexer
  than simple xor or add operations.
  WEAK because it returns to a constant IP.

  ---------------------------------
  Protector - incompatible and weak
  ---------------------------------
  INCOMPATIBLE because it tests if Bit 12 of DR6 can be toggled.
  This works fine with AMD CPUs, but have you ever tried to toggle this
  Bit on iNTEL or Cyrix CPUs? I guess not! Maybe some of them are com-
  patible too, but those I tested it on are not.
  WEAK because I found a way to remove CSCRYPT with one or two Software
  Breakpoints.
}
Var
     Source   : File;
     IP       : word;
     CS       : integer; { negative segment <> f.e.: COM2EXE files }
     Head     : word;
     I        : integer;
     Counter  : integer;
     Counter2 : Integer;
     Imagest  : longint;
     FoundIt  : boolean;
     ComFile  : boolean;

     z, a, b,
     c, d, e  : Byte;

     Buffer   : array[0..799] of byte; { 800 bytes should be enough }

procedure Error;
begin
  Writeln('CSCRYPT was not detected in this file!');
  halt;
end;

procedure GetImageBytes;{ Read 800 Bytes from the Entrypoint of EXE or COM }
begin
  Assign(Source, paramstr(1));
  Reset(Source, 1);
  Imagest:=0;
  Blockread(Source, Head, 2);
  if (head=$4d5a)or(head=$5a4d) then begin
    Seek(Source, 8);
    Blockread(Source, Head, 2);
    Seek(Source, $14);
    Blockread(Source, IP, 2);
    If (IP<>$3C4)and(IP<>$5ea) then begin
      Close(Source);
      error;
    end;
    Blockread(Source, CS, 2);
    Imagest:=longint(CS)*16+IP+longint(head)*16;
    ComFile:=False;
  end;

  if (imagest=0) and (lo(head)=$e9) then begin
    Seek(Source, 1);
    Blockread(Source, imagest, 2);
    inc(imagest, 3);
    ComFile:=true;
  end else begin
    Close(Source);
    Error;
  end;

  Seek(Source, Imagest);
  Blockread(Source, Buffer, 800, Counter); { Counter is here used as dummy }
  Close(Source);
end;

procedure Scan(value : word); { Search for 'MOVs' REG, value }
var vlo, vhi:byte;
begin
   vlo:=lo(value);
   vhi:=hi(value);

   { Is MOV reg8/16, lo(value)/value ?  }

   If (c=vlo) and (b>=$b0) and (b<=$bf) then begin

     { Is MOV reg16, value ? }

     if (b>=$B8) and (d=vhi) then foundit:=true
     else begin

       { MOV reg8, lo(value)
         MOV reg8, hi(value) }

       if (d=b+4) and (e=vhi) then foundit:=true;

       { MOV reg8, hi(value)
         MOV reg8, lo(value) }

       if (z=b+4) and (a=vhi) then foundit:=true;

     end;
   end;

   { Is  LEA reg16, [value] ? -- 8D | ?? | lo(value) | hi(value) }

   if (a=$8d) and (c=vlo) and (d=vhi) then foundit:=true;
end;

begin
  writeln('CSCRYPT Mutation Engine Detecter');
  writeln('Copyright (c) 1997 by Prometheus');
  writeln;
  if paramcount=0 then begin
    Writeln('usage:   CSCDET file.ext');
    halt;
  end;

  GetImageBytes;

  foundit:=false;
  i:=3;
  repeat

   z:=buffer[i-3];
   a:=buffer[i-2];
   b:=buffer[i-1];
   c:=buffer[i];
   d:=buffer[i+1];
   e:=buffer[i+2];

   { is JMP near / CALL near? }

   If (b in [$E8, $E9]) then begin

      { Normal protected files }

      If ComFile then Counter:= - ($327 + i + 2)
                 else Counter:= - ($3c4 + i + 2 - $1a);
      If (c=lo(counter)) and (d=hi(counter)) then foundit:=true;

      { Password protected files }

      If ComFile then Counter2:= - ($54B + i + 2)
                 else Counter2:= - ($5ea + i + 2 - $1a);
      If (c=lo(counter2)) and (d=hi(counter2)) then foundit:=true;

   end;

   If NOT ComFile then Scan($1a)    { EXE - both variants equal }
   else begin
     Scan(imagest + $100 - $327);   { COM - without password }
     If not foundit then
     Scan(imagest + $100 - $54B);   { COM - with password }
   end;

   inc(i);
  until (I=798) or foundit;

  if not foundit then error;

  Writeln('CSCRYPT was detected in this file!');

end.
