
; 
;
;  Six-2-Four - a 4Kb intro packer - The decompression part.
;
;  Copyright (c) Kim Holviala a.k.a Kimmy/PULP Productions 1997
;
; 


IDEAL

MODEL TINY

P486


CODESEG
STARTUPCODE

; Mark the start of the overlay ---------------------------------------------

        DB      '@@'


; Offsets to important internal values --------------------------------------

        DW      OFFSET eoff - start + 2
        DW      OFFSET ll - start + 1
        DW      OFFSET hl1 - start + 1
        DW      OFFSET hl2 - start + 1
        DW      OFFSET hf2 - start + 1


; Copy decompressor & data to 8000h -----------------------------------------

start:

        DB      'PULP'                  ; A little copyright-note....
        add     sp,7

        cld                             ; Just to be sure

        mov     di,8000h                ; Copy decompressor (& data) here
        mov     si,OFFSET decompress-12 ; Start of the data to copy
        mov     ch,30h                  ; Copy about 20 Kb's

        push    di                      ; Address for the ret

        rep movsw

        ret                             ; Jump to decompression (8000h)


; Decompress the data -------------------------------------------------------

decompress:
        xor     bp,bp                   ; Initialize regs

        mov     si,OFFSET data_start-decompress+8000h ; Start of the data
        mov     di,100h                 ; Destination offset

        push    di                      ; Push 100h for the final ret


; Main loop -----------------------------------------------------------------

main_loop:
eoff:   cmp     di,6000h                ; EOF?
        jae     quit                    ; Yepp -> Return to 100h

        call    get_bit                 ; Compressed/uncompressed data next?
        jc      compressed


; Handle uncompressed data --------------------------------------------------

        mov     cl,8                    ; Uncompressed -> Get next 8 bits
        cwd                             ; No fix-ups (clear dx)

        call    get_data                ; Get byte

        xchg    ax,bx                   ; Store the byte
        stosb

        jmp     main_loop               ; Loop


; Handle compressed data ----------------------------------------------------

compressed:

ll:     mov     dl,9h                   ; Maximum number of bits in a row

bit_loop:
        call    get_bit                 ; Loop until CF = 0
        jnc     c_getpos

        inc     cx                      ; Increase lenght

        dec     dx                      ; Max number of bits read?
        jnz     bit_loop                ; Nope -> Keep reading

        call    get_huffman             ; Yepp -> Get huffman-coded lenght
        mov     cx,bx                   ; Lenght must be in cx

c_getpos:
        jcxz    lenght_1                ; Lenght 1? -> Do something else....

        push    cx                      ; Save lengt
        call    get_huffman             ; Get huffman-coded position
        pop     cx                      ; Restore lenght

c_copy:
        push    si                      ; Save old source

        mov     si,di                   ; Calculate new source offset
        sub     si,bx

        inc     cx                      ; Fix lenght

        rep movsb                       ; Copy duplicate data

        pop     si                      ; Restore source offset

        jmp     main_loop               ; Loop

lenght_1:
        mov     cl,4                    ; Get 4 bits of data for position
        cwd                             ; Fix-up value 
        inc     dx                      ; (dx = 1)

        call    get_data                ; Get data

        jmp     c_copy                  ; Go back to loop


; Get one bit of data -------------------------------------------------------

; Returns:
;     CF - Value of the bit

gb_next_byte:
        lodsb                           ; Get one byte

        mov     ah,1                    ; Mark the end of data
        xchg    bp,ax                   ; Move it to bp

get_bit:
        shr     bp,1                    ; Get bit to CF
        jz      gb_next_byte            ; No more bits left in dx?

quit:
        ret


; Get huffman-coded number --------------------------------------------------

; Returns:
;     bx - The number

get_huffman:
hl1:    mov     cx,3                    ; Assume 3 bits for the number
        cwd                             ; Fix-up value
        inc     dx                      ; (dx = 1)

        call    get_bit                 ; Get huffman bit
        jnc     get_data                ; Was 0 -> Values were correct

hl2:    mov     cl,5                    ; Was 1 -> 5 bits for the number
hf2:    mov     dl,17                   ; Fix-up value


; Get n bits of data --------------------------------------------------------

; Input:
;     cx - Number of bits wanted
;     dx - Fix-up value to be added to the result

; Returns:
;     bx - The requested number

get_data:
        xor     bx,bx

gd_loop:
        call    get_bit                 ; Get bit
        rcl     bx,1                    ; Store it

        loop    gd_loop                 ; Loop

        add     bx,dx                   ; Fix the value

        ret


; Start of the compressed data ----------------------------------------------

data_start:


END


