;new loader for packed EXE files
;must be converted to a typed constant for insertion to MM

CODE    SEGMENT PARA PUBLIC

        ORG   0                ;will be a unique segment as loader

        ASSUME  CS:CODE,DS:nothing

        PUBLIC  NewLoader, LoadTable, OrigIp

;****************************************************** NewLoader

;procedure NewLoader
;  Loader for packed EXE files
;  Note: do not use stack before relocating

NewSegFlag   EQU  0FFFFh

NewLoader    PROC FAR

        JMP SHORT  Relocate    ;two bytes

OrigIp  DW     0               ;patched in by PACK
OrigCs  DW     0               ;patched in by PACK
ProgDS  DW     0               ;location to save program's initial DS
ProgES  DW     0               ;location to save program's initial DS

Relocate:
        MOV    ProgDS,DS       ;save DS
        MOV    ProgES,ES       ;save ES
        MOV    BX,ES           ;store base program address in BX
        ADD    BX,0010H        ;offset for PSP

        MOV    AX,CS
        MOV    DS,AX           ;point DS:SI to LoadTable
        MOV    SI,offset LoadTable
        CLD                    ;go forward

NewLoad:
        LODSW                  ;next word from load table
        CMP    AX,NewSegFlag   ;start of new segment following?
        JNZ    DoFixup         ;no, do the fixup

        LODSW                  ;get new segment
        CMP    AX,NewSegFlag   ;flag for end of table?
        JZ     Done            ;yes, we're done

        ADD    AX,BX           ;add base segment to one in load table
        MOV    ES,AX           ;save new segment in ES
        LODSW                  ;get fixup offset

DoFixup:
        MOV    DI,AX           ;fixup offset into index register
        ADD    ES:[DI],BX      ;add program base address to fixup word

        JMP    NewLoad         ;do it again

Done:
        MOV    ES,ProgES       ;get original ES and DS back
        MOV    DS,ProgDS

        MOV    AX,BX
        ADD    AX,OrigCs       ;relocate origcs
        PUSH   AX              ;return segment on stack
        MOV    AX,OrigIP       ;get origip
        PUSH   AX              ;return address on stack
        RET                    ;return to original startup code

        even                   ;keep LoadTable on word boundary for speed
LoadTable  LABEL BYTE          ;start of LoadTable

NewLoader      ENDP

CODE    ENDS

        END
