; TPINC.ML (808:1108/1.6)  TPINC.ML 
; Ber. : 344 van 358
; From : Kevin Tseng                808:1108/1.666  Fri 29 Nov 96 09:24
; To   : All                                        Fri 29 Nov 96 23:34
; Subj : shrink2.asm
;



;-1;usage
;0;ok
;rr_msg_1       db      'Unable to open input file',13,10,'$'           ; err1
;rr_msg_2       db      'Unable to create output file',13,10,'$'        ; err2
;rr_msg_3       db      'Unable to read input file',13,10,'$'           ; err3
;rr_msg_4       db      'Unable to write to output file',13,10,'$'      ; err4
;rr_msg_5       db      'Input file is too large to process',13,10,'$'  ; err5
;rr_msg_6       db      'Unable to compress input file enough',13,10,'$'; err6
;7;help_dox

PAGE  59,132

;---------------------------- SHRINK 2.0 by Kevin Tseng

;== Macro Clean_Process =======================================================

clean_process   macro   endloc
local cx_4c,cx_ok
        ;
        ;       define  ;;[_end_main:] as end of program
        ;               ;;[done:]      as end of tsr
        ;
        ;       input   loc: endloc
        ;               ah=4ch or 31h
        ;               al=error level
        ;              (dx=para for ah=31h)
        ;
                ;;cmp     ah,31h
                ;;jne     cx_4c
                ;;mov     cx,(offset _end_main-done)
                ;;lea     di,done
                ;;jmp     short cx_ok
cx_4c:
                mov     cx,(offset endloc-100h)
                mov     di,100h
cx_ok:
                shr     cx,1
                inc     cx
                ;       cx,7f80h        ;(32640=(65536(64k)-256(0100h))/2)

                mov     bl,0b4h        ;mov ah,?
                mov     bh,ah
                mov     bp,bx
                mov     bl,al           ;bl=al=error level
                cli
                mov     sp,0100h-10     ;8+2=10
                sti
                xor     si,si          ;;si=0
                push    si
                mov     ax,21cdh        ;int 21h
                mov     [si],ax
                or      si,0100h        ;si=(0|100h)=100h  ;PSP;
                sub     si,8            ;2+2+2+2=8
                push    si
                mov     ax,0abf3h       ;rep stosw ;use cx
                mov     [si],ax
                mov     [si+2],bp
                mov     ax,0d888h       ;mov al,bl
                mov     [si+4],ax
                mov     ax,0c390h       ;nop ;ret
                mov     [si+6],ax
                push    cs
                pop     es
                xor     ax,ax
                cld
                ret
                endm    ;clean_process for .com 4ch, 31h end

;-----------------------------------------------------------------------------;

.286;.486p

shrink          segment byte public use16
                assume  cs:shrink, ds:shrink

                org     100h
start: ;---------------------;
                jmp     main ;

;---------------------- com_sfx ----------------------------------------------;

sfx: com_sfx:
                push    ax ;-;-------------------------------------------;
                pushf ;-;----;                                           ;
                cld ;---;                                                ;
                                                                         ;
                mov     si,offset sfx_into                               ;
                                                                         ;
               ;mov     di,(30000-sfx_into_size) ;-;                     ;
                                                   ;                     ;
                mov     di,si    ;          ;------;                     ;
                mov     ax,cs    ;          ;                            ;
                add     ax,1000h ; next 64k ;                            ;
                mov     es,ax    ;          ;                            ;
                                                                         ;
                push    es ;---------------------------------------;     ;
                                                                   ;     ;
                push    di ;-------------------------------------;-;     ;
                                                                 ; ;     ;
                mov     cx,sfx_into_size                         ; ;     ;
                rep     movsb                                    ; ;     ;
                                                                 ; ;     ;
                mov     cx,word ptr ds:shrink_size               ; ;     ;
                mov     si,offset end_of_sfx                     ; ;     ;
                                                                 ; ;     ;
               ;mov     di,30000 ;--------------------------;    ; ;     ;
                                                            ;    ; ;     ;
                rep     movsb                               ;    ; ;     ;
                                                            ;    ; ;     ;
               ;retn ;--------------------------------------;----; ;     ;
                                                            ;      ;     ;
                retf ;--------------------------------------;------;     ;
                                                            ;            ;
shrink_size     dw      0                                   ;            ;
rle_key         dw      0                                   ;            ;
                                                            ;            ;
;---------------------------------------------------------- ;            ;
                                                            ;            ;
sfx_into:                                                   ;            ;
               ;mov     si,30000 ;-------------;------------;            ;
                                               ;                         ;
                mov     si,offset end_of_sfx ;-;                         ;
                                                                         ;
                mov     cx,word ptr ds:shrink_size ;                     ;
                mov     ah,byte ptr ds:rle_key     ;                     ;
                                                                         ;
                push    ds es ;                                          ;
                pop     ds es ; ds=es;es=ds                              ;
                                                                         ;
                mov     di,100h                                          ;
                push    di ;--------------------------;                  ;
sfx_loop: ;----------------------------------------;  ;                  ;
                lodsb                              ;  ;                  ;
                cmp     al,ah                      ;  ;                  ;
                je      short sfx_chk_rlekey       ;  ;                  ;
                mov     bl,al                      ;  ;                  ;
sfx_nodup:                                         ;  ;                  ;
                stosb                              ;  ;                  ;
go_sfx_loop:                                       ;  ;                  ;
                loop    sfx_loop ;-----------------;  ;                  ;
                                                      ;                  ;
                pop     bx ;-------;------------------;                  ;
                                   ;                                     ;
                popf ;-------;-----;-------------------------------------;
                pop     ax ;-;     ;
                                   ;
                push    es ;---------;-;
                                   ; ; ;
                push    bx ;-----;-;-; ;
                                 ;     ;
                mov     bx,cx ;  ;     ;
                mov     si,cx    ;     ;
                mov     di,cx    ;     ;
                                 ;     ;
                push    es ;     ;     ;
                pop     ds ;ds=es;     ;
                                 ;     ;
               ;retn ;-----------;     ;
                                       ;
                retf ;-----------------;
sfx_chk_rlekey:
                lodsb
                or      al,al ; dup count = 0 mean dup char = rlekey
                                   ; Ŀ
                jz      sfx_rlekey ;  buf: (lost rlekey) of 1.0 fixed 
                                   ;  by reset al back to rlekey (ah) 
                                   ; 
                dec     cx
                xchg    al,bl ; al = bl = dup char
sfx_dup:                      ; bl = al = dup count
                stosb
                dec     bl
                jnz     sfx_dup

                              ; Ŀ
                mov     bl,al ;  buf: (lost dup char) of 1.0 fixed 
                              ;  by reset bl back to dup char      
                              ; 

                jmp     short go_sfx_loop
sfx_rlekey:
                dec     cx    ; fix cx by -1
                mov     al,ah ; reset al=ah=rlekey
                jmp     short sfx_nodup

end_of_sfx      equ     ($)
sfx_size        equ     (end_of_sfx-start) ;equ
sfx_into_size   equ     (end_of_sfx-sfx_into)

;- shrink2.doc ---------------------------------------------------------------;

shrink2doc        equ     $
db '--------------------------------------------------------------------',13,10
db '                                                                    ',13,10
db '            SHRINK 2.0   Copyright (c) 1988-95   Kevin Tseng        ',13,10
db '                                                                    ',13,10
db '                        Program Compression Utility                 ',13,10
db '                                 09/03/95                           ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db 'Using SHRINK 2.0:                                                   ',13,10
db '                                                                    ',13,10
db '   This utility compresses .COM files without affecting the way you ',13,10
db '   run them.  Its compression scheme is simple and will work on     ',13,10
db '   _all_ files, but may produce impressive results depending on the ',13,10
db '   particular file.  If SHRINK 2.0 is unable to compress the file,  ',13,10
db '   it will abort without doing anything.  Otherwise, it will        ',13,10
db '   overwrite the old file with the smaller, compressed file.  Note  ',13,10
db '   that this will save only disk space, not memory.                 ',13,10
db '   The larger the program is, the better chance SHRINK 2.0 has to   ',13,10
db '   compress it...                                                   ',13,10
db '                                                                    ',13,10
db '   NOTE that SHRINK 2.0 is _100%_ compatible with every program.    ',13,10
db '   _3_FATAL_bugS in original_SHRINK_1.0 by Thomas_G._Hanlin_III     ',13,10
db '   had been fixed.                                                  ',13,10
db '                                                                    ',13,10
db '   The average compression rate seems to be around 7% for files that',13,10
db "   SHRINK 2.0 is able to compress, but I've seen compression rates  ",13,10
db '   of 46% and higher.  It depends entirely on the program.          ',13,10
db '                                                                    ',13,10
db '   To use SHRINK 2.0, just type "SHRINK2 filename" (without the     ',13,10
db '   quotes), where "filename" is the name of the .COM file to shrink.',13,10
db '   SHRINK 2.0 will only work properly on .COM files, so if you do   ',13,10
db '   not type a file extension, ".COM" is assumed.  If SHRINK 2.0 can ',13,10
db '   compress the file, it will do so in place, modifying the file you',13,10
db '   specified... so be sure to make a backup copy of the file before ',13,10
db '   SHRINKing it, in case something goes wrong.                      ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db 'Distributing SHRINK 2.0:                                            ',13,10
db '                                                                    ',13,10
db '   The SHRINK 2.0 utility is protected by copyright, and may be     ',13,10
db '   distributed only according to the following limitations:         ',13,10
db '                                                                    ',13,10
db '   1) No price may be charged, other than a disk copying/mailing    ',13,10
db '   fee.                                                             ',13,10
db '                                                                    ',13,10
db '   2) The utility and documentation must be included together, in   ',13,10
db '   unmodified form.  This includes the SHRINK2.COM and SHRINK2.DOC  ',13,10
db '   files.                                                           ',13,10
db '                                                                    ',13,10
db '   Programs compressed with SHRINK 2.0 may be distributed without   ',13,10
db '   royalties or licensing.  Please do not distribute a compressed   ',13,10
db "   program without the author's permission, however, as this may    ",13,10
db '   result in a violation of his copyright.                          ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db '                                                                    ',13,10
db 'Tech Notes:                                                         ',13,10
db '                                                                    ',13,10
db '   The SHRINK 2.0 utility works by compressing a COM-format         ',13,10
db '   executable file, using the inefficient but simple _SHRINK2_ Run  ',13,10
db '   Length Encoding compression scheme to turn the code into an      ',13,10
db '   encoded data stream.  The flag used for _SHRINK2_ RLE is chosen  ',13,10
db '   by scanning the file for the least-frequently-used character, for',13,10
db '   maximum efficiency.  The encoded program is written back to disk ',13,10
db '   under the original file name, with a relocating decoder attached ',13,10
db '   to the start of the file.                                        ',13,10
db '                                                                    ',13,10
db '   When the .COM file executes, control passes to the relocating    ',13,10
db '   decoder, which relocates itself (and the encoded data) higher in ',13,10
db '   memory.  It then decodes the program into the same place it would',13,10
db '   have been loaded if it were not encoded... resets the registers  ',13,10
db '   and flags to their original form... and starts the program just  ',13,10
db '   as if there had never been any encoding.                         ',13,10
db '                                                                    ',13,10
db '   Why did I choose _SHRINK2_ RLE compression?  I did so for a      ',13,10
db "   number of reasons.  One, it's fast, both for encoding and        ",13,10
db '   decoding.  The SHRINK 2.0 utility imposes no noticeable loss of  ',13,10
db "   speed on executing a program.  Two, it's simple, which keeps it  ",13,10
db '   small.  With RLE compression, this decoder is quite tiny, which  ',13,10
db '   is insignificant.  Other coding schemes might be more efficient, ',13,10
db '   but would have a far greater amount of overhead to overcome.     ',13,10
db "   Since no compression method I've seen appears to be terribly     ",13,10
db '   effective on .COM files anyway, _SHRINK2_ RLE is good enough.    ',13,10
db '                                                                    ',13,10
db '   assume [RLE flag] = [ff],                                        ',13,10
db '   [input data stream] = [c3 01 01 01 01 01 02 02 ff]               ',13,10
db '   --------------------- [-- ^^^^^^^^^^^^^^ -- -- ^^]               ',13,10
db '   [output data stream]: [c3 01 ff 05 02 02 ff 00] --               ',13,10
db '   --------------------- [-- ^^^^^^^^ -- -- ^^^^^] --               ',13,10
db '   data length < 2 is not encoded,                                  ',13,10
db '   data length = 0 mean [input data] = [RLE flag]                   ',13,10
db '                                                                    ',13,10
db '--------------------------------------------------------------------',13,10
db 0;end of doc
shrink2docsize    equ     $-shrink2doc

;=============================================================================;

filename        db      128 dup(?) ;; #128 for i21ah60

;- stack area ----------------------------------------------------------------;

stack_buf       dw      68 dup (0) ;;#136
stack_top       dw      ?          ;;

;- data  area ----------------------------------------------------------------;

originalsize$   db      ' Original Size: $'
compressedsize$ db      '  Compressed Size: $'
;expandedsize$   db      '  Expanded Size: $'
;decodersize$    db      '  Decoder Size: $'

eff             db      0Dh, ' Effecient  : '
eff_12          dw      '00' ;3030h
eff_3           db      '0 %',32 dup(' ')
                db      0Dh, 0Ah, '$'

fatalerr        db      13,10,' '
                db      'Fatal error: $'

err_msg_1       db      'Unable to open input file',13,10,'$'           ; err1
err_msg_2       db      'Unable to create output file',13,10,'$'        ; err2
err_msg_3       db      'Unable to read input file',13,10,'$'           ; err3
err_msg_4       db      'Unable to write to output file',13,10,'$'      ; err4
err_msg_5       db      'Input file is too large to process',13,10,'$'  ; err5
err_msg_6       db      'Unable to compress input file enough',13,10,'$'; err6

logo            db      13,10
                db      'ķ',13,10
                db      ' SHRINK 2.0  Copyright (c) 1988-95  Kevin Tseng ',13,10
                db      '        E-Mail: s8203143@simon.pu.edu.tw        ',13,10
                db      'ͼ',13,10, '$'

usage           db      13,10, ' usage : SHRINK2 [option] filename'
                db      13,10
                db      13,10, ' option: '
                db      13,10, '         -h = display Help documentation'
                db      13,10
                db      13,10, ' (ya can use SHRINK2 -h> SHRINK2.DOC to save )'
                db      13,10, ' (        or SHRINK2 -h| MORE to view by page)'
                db      13,10, '$'

compressing$    db      13,10,' Compressing: $'

errorlevel      db      0

;comfile        db      80 dup (0)

tmpfile         db      '\',13 dup (0)

handle          dw      0
com_size        dw      0

freq_table      dw      256 dup(0)

;=============================================================================;

output_segment  dw      ? ;
input_segment   dw      ? ;

dta         DB      80h DUP(0) ;
argc        DW      0          ; argument ------------------------------------;
argv        DW      40h DUP(?) ;                                              ;
                                                                              ;
;------- argument ------------------------------------------------------------;

;********************************************************
;* function:analyze command line argument,make C-string *
;* usage:                                               *
;*          push    <command line argument offset>      *
;*          push    <command line argument segment>     *
;*          push    <argument count offset>             *
;*          push    <argument pointer offset>           *
;*          call    argument                            *
;*          add     sp,8                                *
;* ps:                                                  *
;*       (1) better copy DTA to a buffer first          *
;*       (2) this procedure demo call by address        *
;********************************************************
          ; .286
          ; TITLE   analyze command line, make C-string
          ; .MODEL  small
          ; PUBLIC  argument
          ; .CODE
argument    PROC
            push    bp
            mov     bp,sp
argu_offset EQU     word PTR [bp+10]    ;command line argument offset
argu_seg    EQU     word PTR [bp+8]     ;command line argument segment
ptr_argc    EQU     word PTR [bp+6]     ;argument count offset
ptr_argv    EQU     word PTR [bp+4]     ;argument pointer offset
            sub     sp,2
flag        EQU     word PTR [bp-2]
            push    ax
            push    bx
            push    cx
            push    si
            push    di
            push    es

            mov     flag,-1
            mov     si,argu_offset
            mov     es,argu_seg
            mov     di,ptr_argv
            mov     bx,ptr_argc
            mov     es:byte PTR [bx],0  ;argc=0
            mov     cl,es:[si]          ;load PSP' dta' first bytes
            xor     ch,ch               ;record char count
            mov     al,' '              ;space char = scan char
scanloop:                               ;
            jcxz    exit_arg            ;WHILE(cx!=0)
            inc     si                  ;  si point to next char
            cmp     al,es:[si]          ;  IF ([si]=space char)
            jne     @f_arg ;            ;  THEN
            mov     es:byte PTR [si],0  ;    set NULL char
            mov     flag,-1             ;    flag==-1 mean no string found
            jmp     next                ;
@f_arg:;@@:                             ;  ELSE
            cmp     flag,0              ;    IF (flag<=0)
            jg      next                ;    THEN
            mov     flag,1              ;      set flag==1 mean string found
            inc     es:word PTR [bx]    ;      argc++ (argument count+1)
            mov     [di],si             ;      save string offset to argv
            inc     di                  ;      point to argv' next position
            inc     di                  ;
next:                                   ;    ENDIF
                                        ;  ENDIF
            dec     cx                  ;  count-1
            jmp     scanloop            ;ENDWHILE
exit_arg: ;
            inc     si
            mov     es:byte PTR [si],0  ;last char = NULL char
            pop     es
            pop     di
            pop     si
            pop     cx
            pop     bx
            pop     ax
            mov     sp,bp
            pop     bp
            ret
argument    ENDP
         ;  END

;-----------------------------------------------------------------------------;
;               SUBROUTINE: print                                             ;
;-----------------------------------------------------------------------------;

print           proc    near
                push    ax
                push    bx
                push    cx
                push    si
                mov     bh,0
                mov     si,dx
                mov     cx,1
print_loop:
                mov     bl,1Bh          ; char color
                mov     ah,9
                mov     al,[si]
                inc     si
                cmp     al,'$'
                je      short end_print
                cmp     al,' '
                jb      short print_tty
                int     10h

                inc     dl
                mov     ah,2
                int     10h

                jmp     short print_loop
print_tty:
                mov     ah,0Eh
                int     10h

                cmp     al,10
                jne     print_loop
                mov     al,' '
                int     10h

                push    cx
                mov     ah,3
                int     10h

                pop     cx

                jmp     short print_loop
end_print:
                pop     si
                pop     cx
                pop     bx
                pop     ax
                retn
print           endp

;- puts ----------------------------------------------------------------------;
;***************************************************;
;PUTS procedure                                     ;
;function : put asciiz-string                       ;
;adapter  : (1) DS:SI point to asciiz-string to put.;
;           (2) no return value.                    ;
;***************************************************;
puts        PROC
            push    dx
            push    ax
            push    si
            pushf
            cld
            mov     ah,2
looptop_puts:
            lodsb
            cmp     al,0
            je      exit_puts
            mov     dl,al
            int     21h
            jmp     looptop_puts
exit_puts:
            popf
            pop     si
            pop     ax
            pop     dx
            ret
puts        ENDP

;----------------------------- SUBROUTINE: chk_dup

chk_dup         proc    near
                lodsb ;ds:si
                xor     ah,ah
                cmp     ax,dx
                je      short calu_dup
                jcxz    short chk_dup_store;
                call    store_dup
chk_dup_store: ;
                call    store_nodup
chk_dup_ret:
                mov     dx,ax
                retn
calu_dup:
                inc     cx
                cmp     cl,0FFh ; max dup;255
                jne     chk_dup_ret
                call    store_dup
                jmp     short chk_dup_ret
chk_dup         endp

;----------------------------- SUBROUTINE: store_nodup

store_nodup     proc    near
                mov     es:[bx],al;[bx],al ;es:
                inc     bx
                inc     cs:shrink_size;cs:

                cmp     al,byte ptr cs:rle_key ; cs:
                jne     short store_nodup_ret

                mov     byte ptr es:[bx],0;[bx],0 ; dup 0 = rle_key ;es:
                inc     bx
                                       ;ķ
                inc     cs:shrink_size ; bug: (miss n bytes) of 1.0 fixed 
                       ;cs:            ; by adjust shrink_size            
                                       ;ͼ
store_nodup_ret:
                retn
store_nodup     endp

;----------------------------- SUBROUTINE: store_dup

store_dup       proc    near
                cmp     cl,2 ; dup > 2 ?
                ja      short ok_store_dup

                cmp     dx,cs:rle_key;cs:
                ja      short ok_store_dup
                xchg    ax,dx

store_nodup_better:
                call    store_nodup

                loop    store_nodup_better

                xchg    ax,dx
store_dup_ret:
                xor     cx,cx
                retn
ok_store_dup:
                mov     ch,cl
                mov     cl,byte ptr cs:rle_key;cs:
                mov     es:[bx],cx;[bx],cx;es:
                add     bx,2
                add     cs:shrink_size,2;cs:

                jmp     short store_dup_ret

store_dup       endp

;-----------------------------------------------------------------------------;

main:
                mov     word ptr ds:[start+1],0;init sfx

                mov     sp,offset stack_top;

                cld
                mov     cx,80h         ; -+
                mov     si,80h         ;  |copy PSP' DTA to
                mov     di,OFFSET dta  ;  |data segment' dta;
                rep     movsb          ; -+

                push    OFFSET dta     ; -+
                push    ds             ;  |
                push    OFFSET argc    ;  |call argument procedure to make dta
                push    OFFSET argv    ;  |to C- string;
                call    argument       ;  |
                add     sp,8           ; -+

                lea     dx,logo
                call    print

                cmp     argc,1 ;chk
                jae     chk_parms

                mov     ah,9
                mov     dx,offset usage ;;
                int     21h

                mov     ax,4cffh ;-1
                jmp     clean_out
chk_parms:
                mov     bx,1 ;arg#1
                dec     bx   ;-1
                shl     bx,1 ;x2
                mov     bx,argv[bx]
                mov     ax,[bx]

               ;mov     expand,0
               ;cmp     ax,'x-';'-x' expand
               ;jne     chk_f
               ;mov     expand,1
               ;jmp     short parms_ok
chk_f:         ;
               ;mov     force,0
               ;cmp     ax,'f-';'-f' force (output)
               ;jne     chk_h
               ;mov     force,1
               ;jmp     short parms_ok
chk_h:
                cmp     ax,'h-';'-h' help
                jne     parms_ok

                lea     si,shrink2doc ;
                call    puts

                mov     ax,4c07h ;errorlevel 7
                jmp     clean_out

parms_ok:
                mov     bx,argc ;arg#1 or #2
                dec     bx   ;-1
                shl     bx,1 ;x2
                mov     bx,argv[bx]
                xor     si,si
@store_filename:
                mov     al,[bx+si]
                or      al,al
                jz      @adj_filename
                mov     filename[si],al
                inc     si
                jmp     short @store_filename
@adj_filename:
                mov     bx,argc ;arg#1 or #2
                dec     bx   ;-1
                shl     bx,1 ;x2
                mov     si,argv[bx]
                lea     di,filename ; #128
                mov     ah,60h
                int     21h

@add_com_ext:
                lea     di,ext_com
                lea     si,filename

                pushf
                mov     bx,di           ;bx = di (input) = ext to be added from
                mov     di,si           ;di = si (input) = path to be added ext
                xor     al,al
                mov     cx,64
                cld
                repne   scasb           ;scan end of path

                mov     dx,si   ; begin of path buffer
                dec     di      ; end of path buffer

                mov     si,di
                dec     si              ;si = end of path (last char)

                mov     cx,4 ;'.???'
                std                     ;direction down
if_ext:
                cmp     si,dx
                je      is_ext
                lodsb
                cmp     al,'.'
                je      ext_done
                cmp     al,'\'
                je      is_ext
                cmp     al,':'
                je      is_ext
                loop    if_ext
is_ext:
                mov     si,bx           ;si = bx = ext to be added from
                cld                     ;direction up
ext_link:
                lodsb
                or      al,al
                je      ext_stop
                stosb
                jmp     short ext_link

ext_com         db      '.COM',0

ext_stop:
                stosb
ext_done:
                popf

pack_or_extra:
                lea     dx,compressing$

               ;cmp     expand,1
               ;jne     display_filename
               ;lea     dx,expanding$
display_filename:
                mov     ah,9
                int     21h
                lea     si,filename
                call    puts

                mov     ax,offset end_shrink2 ;;
                mov     cl,4
                shr     ax,cl ;;offset to segment
                inc     ax
                mov     dx,cs
                add     dx,ax
                inc     dx
                mov     word ptr input_segment,dx  ;
                add     dx,1000h ; next 64k        ;
                mov     word ptr output_segment,dx ;

                mov     ax,3D00h
                mov     dx,offset filename
                int     21h

               ;mov     word ptr cs:[start+1],0 ; make start at sfx
               ;
               ;cld
               ;xor     dx,dx
               ;mov     cx,dx
               ;
               ;mov     errorlevel,cl
               ;
               ;mov     cl,ds:[80h] ; command size
               ;jcxz    short main_6
               ;
               ;mov     si,81h ; command tail
               ;
main_1:        ;
               ;lodsb
               ;cmp     al,' '
               ;jbe     short main_3
               ;mov     di,offset comfile
               ;inc     dx
               ;cmp     dx,1
               ;
               ;ja      short main_6
main_2:        ;
               ;stosb
               ;dec     cx
               ;jz      short main_4
               ;
               ;lodsb
               ;cmp     al,' '
               ;ja      main_2
main_3:        ;
               ;loop    main_1
main_4:        ;
               ;or      dx,dx
               ;jz      short main_6
               ;
               ;mov     si,offset comfile
main_5:        ;
               ;lodsb
               ;or      al,al
               ;jz      short main_7
               ;
               ;cmp     al,'.'
               ;jne     main_5
               ;jmp     short main_8
main_6:        ;
               ;mov     dx,offset logo ; (='SHRINK 2.0..')
               ;call    print
               ;
               ;mov     byte ptr errorlevel,-1;logo(usage)
               ;jmp     exit_main
main_7:        ;
               ;dec     si
               ;mov     di,si
               ;mov     ax,'C.';dw;db'.C';db'.COM';432Eh
               ;stosw
               ;mov     ax,'MO';dw;db'OM';db'.COM';4D4Fh
               ;stosw
               ;jmp     short main_8
main_8:
               ;mov     ax,3D00h
               ;mov     dx,offset comfile
               ;int     21h

                jnc     short main_9

                mov     bl,1
                jmp     display_err_msg
main_9:
                mov     bx,ax
                mov     handle,ax

                xor     cx,cx
                mov     dx,cx
                mov     ax,4201h
                int     21h

                push    dx
                push    ax
                mov     dx,cx

                mov     ax,4202h ; seek eof
                int     21h

                or      dx,dx ; chk fsize high
                jnz     short main_10

                cmp     ax,60000;(shrink2);;30000;7530h;(shrink1)
                jbe     short main_11

main_10:
                mov     bl,5
                jmp     display_err_msg
main_11:
                mov     com_size,ax ;
                pop     dx
                pop     cx
                mov     ax,4200h ; seek bof
                int     21h

                push    ds ;-------------------------;
                                                     ;
                mov     bx,cs:handle ;               ;
                mov     ah,3Fh                       ;
                mov     cx,cs:com_size ;             ;
                mov     dx,0;offset end_of_program ; ;
                                                     ;
                mov     ds,cs:input_segment ;        ;
                                                     ;
                int     21h                          ;
                                                     ;
                pop     ds ;-------------------------;

                jnc     short main_12

                mov     bl,3
                jmp     display_err_msg
main_12:
                mov     ah,3Eh ; close
                int     21h

;------------------------------------------------------------------------------

                mov     si,dx ;-------------------;
                mov     cx,cs:com_size ;          ;
                xor     ax,ax                     ;
                                                  ;
                push    ds ;--------------------;-;
                mov     ds,cs:input_segment ;   ;
calu_freq:                                      ;
                lodsb                           ;
                mov     bx,ax                   ;
                shl     bx,1                    ;
                inc     cs:freq_table[bx] ;     ;
                loop    calu_freq               ;
                                                ;
                pop     ds ;--------------------;

                mov     si,offset freq_table ;-;
                mov     cx,100h ;256           ;
                mov     dx,cs:com_size         ;
                xor     bx,bx                  ;
calu_rle_key: ;-----------------------------;--;
                lodsw                       ;
                cmp     ax,dx               ;
                jae     short next_rle_key  ;
                mov     dx,ax               ;
                mov     bl,bh               ;
next_rle_key:                               ;
                inc     bh                  ;
                loop    calu_rle_key ;------;-;
                                              ;
                mov     byte ptr rle_key,bl ;-;

                push    ds es ;--------------------------------------;
                                                                     ;
                mov     si,0;offset end_of_program; ;----------;     ;
                mov     ds,cs:input_segment ;                  ;     ;
                mov     bx,0;offset end_of_program+30000+      ;     ;
                mov     es,cs:output_segment ;                 ;     ;
                                                               ;     ;
                mov     di,cs:com_size                         ;     ;
                xor     cx,cx ;--------------------;           ;     ;
                mov     cs:shrink_size,cx ;init0 ;-;           ;     ;
                                                               ;     ;
                mov     dx,0FFFFh ; init dh != 0 ;--;          ;     ;
main_16: ;------------------------;----;------------;----------;     ;
                call    chk_dup   ;    ;                             ;
                dec     di        ;    ;                             ;
                jnz     main_16 ;-;    ;                             ;
                jcxz    short main_17  ;                             ;
                call    store_dup      ;                             ;
main_17: ;-----------------------------;                             ;
                                                                     ;
                pop     es ds ;--------------------------------------;

                mov     ax,cs:shrink_size

                add     ax,sfx_size ;equ

                cmp     ax,cs:com_size
                jb      short main_18

                mov     bl,6
                jmp     short display_err_msg
main_18:
                mov     dx,offset tmpfile
                mov     ah,5Ah ; create temp file, name @ds:dx
                int     21h    ; cx=file attribute bits
                jnc     short main_19

                mov     bl,2
                jmp     short display_err_msg
main_19:
                mov     handle,ax
                mov     bx,ax

                mov     dx,offset start ;
                mov     cx,sfx_size

                mov     ah,40h
                int     21h
                jc      short main_20

                push    ds ;---------------------------------------;
                                                                   ;
                mov     cx,cs:shrink_size                          ;
                                                                   ;
                mov     dx,0;offset end_of_program+30000 ;         ;
                mov     ds,cs:output_segment ;                     ;
                                                                   ;
                mov     ah,40h                                     ;
                int     21h                                        ;
                                                                   ;
                pop     ds ;---------------------------------------;

                jnc     short main_25
main_20:
                mov     bl,4
display_err_msg:
                mov     errorlevel,bl

                mov     ah,9
                mov     dx,offset fatalerr ; (='Fatal error: $')
                int     21h

                mov     si,offset err_msg_1
main_22:
                dec     bl
                jz      short main_24
main_23:
                lodsb
                cmp     al,'$'
                jne     main_23
                jmp     short main_22
main_24:
                mov     dx,si
                mov     ah,9
                int     21h

                cmp     byte ptr errorlevel,2
                jbe     short exit_main ;

                cmp     byte ptr errorlevel,6
                je      short exit_main ;
main_25:
                mov     ah,3Eh ; close
                mov     bx,handle
                int     21h

                cmp     byte ptr errorlevel,0
                jne     short exit_main ;

                mov     ah,41h ; unlink
                mov     dx,offset filename;comfile;
                int     21h
                jc      short main_26 ; 'Unable to create output file'

                mov     ah,56h ; rename file @ds:dx to @es:di
                mov     dx,offset tmpfile
                mov     di,offset filename;comfile;
                int     21h
                jnc     short dispratio;exit_main ;
main_26:
                mov     bl,2 ; 'Unable to create output file'
                jmp     short display_err_msg

dispratio:
                call    display_eff ;

               ;cmp     force,1
               ;jne     display_size_in
               ;lea     dx,forceenabled$
               ;mov     ah,9
               ;int     21h
display_size_in:
                lea     dx,originalsize$  ;
                mov     ah,9              ;
                int     21h               ;
                                          ;
                xor     dx,dx             ;
                mov     ax,com_size ;; in ;
                mov     bh,0
                call    outdec32 ;

                lea     dx,compressedsize$
               ;cmp     expand,1
               ;jne     display_size_out$
               ;lea     dx,expandedsize$
display_size_out$:
                mov     ah,9
                int     21h

                xor     dx,dx
                mov     ax,shrink_size;;

               ;cmp     expand,1
               ;je      adj_ok
                add     ax,sfx_size ;
adj_ok:
                mov     bh,0
                call    outdec32

               ;cmp     expand,1
               ;je      exit_lzcom

             ;  lea     dx,decodersize$ ;
             ;  mov     ah,9            ;
             ;  int     21h             ;
             ;                          ;
             ;  xor     dx,dx           ;
             ;  mov     ax,sfx_size     ;
             ;  mov     bh,0            ;
             ;  call    outdec32        ;
exit_lzcom:
                call    crlf ;

;----------------------------------------

exit_main:
                mov     ah,4Ch ; exit
                mov     al,errorlevel
               ;int     21h
clean_out:
                clean_process end_shrink2

;-----------------------------------------------------------------------------;

;----------------------------- display_eff -----------------------------------;

display_eff     proc    near
                mov     ax,shrink_size;; out
                add     ax,sfx_size;;

                mov     bx,64h ;;100 ;
                mul     bx           ;

                mov     bx,com_size ;;; in
                div     bx            ;

                mov     bl,0Ah ;;10
                div     bl
                mov     dl,ah
                xor     ah,ah
                div     bl
                add     dl,'0'
                add     ax,'00';3030h
                cmp     al,'0'
                ja      short set_eff123
                mov     al,0
                cmp     ah,'0'
                ja      short set_eff123
                mov     ah,0
set_eff123:
                mov     eff_12,ax
                mov     byte ptr eff_3,dl

                mov     ah,9
                mov     dx,offset eff
                int     21h

                retn
display_eff     endp

;- crlf ----------------------------------------------------------------------;
crlf    proc    near
        push    ax
        push    dx
        mov     dl,13
        mov     ah,2
        int     21h
        mov     dl,10
        int     21h
        pop     dx
        pop     ax
        retn
crlf    endp

;- outdec32 ------------------------------------------------------------------;
;****************************************************************             ;
;*procedure:                                                    *             ;
;*      OUTDEC32                                                *             ;
;*function:                                                     *             ;
;*      this procedure will put DX:AX'32 bit unsigned value     *             ;
;*             to screen                                        *             ;
;*usage:                                                        *             ;
;*      input  :DX:AX = value to put                            *             ;
;*              BH < 0 width |BH| left start                    *             ;
;*              BH = 0 don't put space char                     *             ;
;*              BH > 0 width |BH| right start                   *             ;
;*      call   :call outdec32                                   *             ;
;*      return :no,no register destroyed.                       *             ;
;*      note   :if number'width > |bh| then result=(input BH=0) *             ;
;****************************************************************             ;
         ;; .286                                                              ;
                                                                              ;
outdec32    PROC    NEAR                                                      ;
            push    bp                                                        ;
            push    dx                                                        ;
            push    cx                                                        ;
            push    bx                                                        ;
            push    ax                                                        ;
            mov     bp,sp                    ;۰ܼƪŶC          ;
            sub     sp,10                    ;make auto variable in stack     ;
            push    bx                                                        ;
            mov     cx,0                     ; cx = char count                ;
top:                                                                          ;
            call    div10                    ;氣kAtill=0              ;
            dec     bp                       ;bpVU@Ӧ۰ܼƪŶ        ;
            mov     [bp],bl                  ;lƦsJbpҫm          ;
            inc     cx                       ; cx (char count)+1              ;
            cmp     dx,0                     ;                                ;
            jne     top                      ;test dx:ax Ӽ if 0            ;
            cmp     ax,0                     ;yes then leave,else continue    ;
            jne     top                                                       ;
                                                                              ;
            pop     bx                                                        ;
            cmp     bh,0                     ;test bh value                   ;
            jle     display$                 ; <= 0, left start,put number 1st;
            call    putspace                 ;otherwise put space first       ;
            mov     bh,0                                                      ;
display$:                                                                     ;
            push    cx                       ;keep char count in stack        ;
top2:                                        ;this part output digit          ;
            mov     dl,[bp]                                                   ;
            add     dl,'0'                                                    ;
            mov     ah,2                                                      ;
            int     21h                                                       ;
            inc     bp                                                        ;
            loop    top2                                                      ;
                                                                              ;
            pop     cx                       ;restore char count              ;
            cmp     bh,0                     ;test bh with 0                  ;
            jnl     exit                     ;>=0 mean no right space out     ;
            neg     bh                       ;                                ;
            call    putspace                 ;put space char                  ;
exit:                                                                         ;
            add     sp,10                    ;restore sp                      ;
            pop     ax                                                        ;
            pop     bx                                                        ;
            pop     cx                                                        ;
            pop     dx                                                        ;
            pop     bp                                                        ;
            ret                                                               ;
outdec32    ENDP                                                              ;
;************************************************************                 ;
;*function:                                                 *                 ;
;*      this procedure exec 32 bit unsigned value div by 10 *                 ;
;*      and return quotient and remainder                   *                 ;
;*usage:                                                    *                 ;
;*      input  :DX:AX = value to div by 10                  *                 ;
;*      call   :call div10                                  *                 ;
;*      return :quotient in DX:AX Aremainder in BX       *                 ;
;************************************************************                 ;
div10       PROC    NEAR                                                      ;
            push    cx                    ;BX = dividen as unsigned expand &  ;
            mov     bx,0                  ;test value'high part,also remainder;
            mov     cx,32                 ;loop exec = bits of dividen        ;
            sub     bx,10                 ;try sub once                       ;
looptop:                                                                      ;
            test    bx,8000h              ;check test value' sign (+, -)      ;
            jz      positive                                                  ;
            shl     ax,1                  ;-:  (1) quotient'LSB = 0           ;
            rcl     dx,1                  ;    (2) dividend * 2               ;
            rcl     bx,1                  ;                                   ;
            add     bx,10                 ;    (3) + divisor = next test value;
            jmp     @@_div10_a ;; @f                                          ;
positive:                                                                     ;
            add     ax,1                  ;+:  (1) quotient'LSB = 1           ;
            shl     ax,1                  ;    (2) dividend * 2               ;
            rcl     dx,1                  ;                                   ;
            rcl     bx,1                  ;                                   ;
            sub     bx,10                 ;    (3) - divisor = next test value;
@@_div10_a:                                                                   ;
            loop    looptop                                                   ;
            test    bx,8000h              ;check last test value'sign (+,-)   ;
            jnz     negative                                                  ;
            add     ax,1                  ;+:quotient+1Aremainder= test value;
            jmp     @@_div10_b ;; @f                                          ;
negative:                                                                     ;
            add     bx,10                 ;-:let test value + divisor         ;
@@_div10_b:                               ;   to recover remainder            ;
            pop     cx                                                        ;
            ret                                                               ;
div10       ENDP                                                              ;
                                                                              ;
;*********************************************                                ;
;*this procedure put space char              *                                ;
;*********************************************                                ;
putspace    PROC    NEAR                                                      ;
            push    ax                                                        ;
            push    bx                                                        ;
            push    cx                                                        ;
            push    dx                                                        ;
            xchg    bh,bl                                                     ;
            xor     bh,bh                                                     ;
            sub     cx,bx                                                     ;
            jnl     exit1                                                     ;
            neg     cx                                                        ;
            jcxz    exit1                                                     ;
            mov     ah,2                                                      ;
            mov     dl,' '                                                    ;
@@_putspace:                                                                  ;
            int     21h                                                       ;
            loop    @@_putspace ;; @b                                         ;
exit1:                                                                        ;
            pop     dx                                                        ;
            pop     cx                                                        ;
            pop     bx                                                        ;
            pop     ax                                                        ;
            ret                                                               ;
putspace    ENDP ;;-----------------------------------------------------------;

;-----------------------------------------------------------------------------;

end_of_program  equ     $              ;
end_shrink2     equ     end_of_program ;

shrink          ends
                end     start
