
; MOV_ES macro
; this macro moves bytes/words/dwords from a specified segment to
; the extra segment [ES]
;
; example: mov_es word,cs        will move a WORD from CS:SI to ES:DI
;          mov_es byte,ss        will move a BYTE from SS:Si to ES:DI
;          repz mov_es byte,ss   will move CX BYTES from SS:SI to ES:DI


mov_es          macro   size,tseg

                ifidn   <tseg>,<ss>
                  db 00110110b
                endif

                ifidn   <tseg>,<cs>
                  db 00101110b
                endif

                ifidn   <tseg>,<ds>
                  db 00111110b
                endif

                ifidn <size>,<word>
                  movsw
                endif

                ifidn <size>,<byte>
                  movsb
                endif

                ifidn <size>,<dword>
                  db 066h,0a5h
                endif

                endm

; Standart EXE startupcode

                nosmart

stapel          segment para stack

                db 128 dup (0)

stapel          ends

code            segment page 'CODE'

                assume  cs:code ; es:code ; ss:stack ; ds:code

main            proc near

start:          xor     si,si
                test    byte ptr cs:[loadfix],0ffh
                jz      okbegin
                push    cs
                pop     ax
                mov     bx,ax
                and     bx,0f000h
                jnz     okbegin
                mov     cl,04h
                shl     ax,cl
                sub     si,ax
                shr     si,cl

okbegin:        push    es
                pop     bx
                push    cs
                pop     ax
                sub     ax,bx
                mov     cl,04h
                mov     bx,offset ecode
                mov     dx,bx
                shr     bx,cl
                and     dx,0000fh
                jz      oksize
                inc     bx
oksize:         sub     si,bx
                jnl     nocorrect
                add     si,bx
nocorrect:      add     bx,ax
                add     bx,si
                mov     ax,04a00h
                int     21h
                jnc     allright
error_exit:     mov     ah,04ch
                int     21h
allright:  

; ************************************************************************
;
; Begin of main program
;
; ************************************************************************

                mov     ax,ds:[02ch]
                mov     word ptr cs:[enviro],ax
                mov     word ptr cs:[lsegment],ds

                mov     bx,ds
                sub     bx,ax
                push    bx                      ;enviro. size

                push    ds
                xor     ax,ax
                mov     ds,ax
                mov     ax,cs

                mov     ax,word ptr ds:[0084h]
                mov     word ptr cs:[org21],ax
                mov     ax,word ptr ds:[0086h]
                mov     word ptr cs:[org21+2],ax
                pop     ds

                pop     bx
                mov     cx,bx
                mov     ah,048h
                int     21h
                jb      error_exit
                push    ax
                mov     es,ax
                mov     ds,word ptr cs:[enviro]
                xor     di,di
                xor     si,si
                shl     cx,1
                shl     cx,1
                shl     cx,1
                shl     cx,1
                cld
                repnz   movsb                   ;copy environment
                pop     ax
                mov     word ptr cs:[enviro],ax

                mov     bx,0ffffh
alloc:          mov     ah,048h
                int     21h
                jb      alloc
                push    ax
                mov     es,ax
                mov     ds,word ptr cs:[lsegment]
                xor     di,di
                xor     si,si
                mov     cx,0100h
                cld
                repnz   movsb
                mov     ax,word ptr cs:[enviro]
                mov     word ptr es:[02ch],ax
                pop     ax
                mov     word ptr es:[036h],ax
                mov     word ptr cs:[lsegment],ax

; ---------------------------------------------------------------------------

                mov     ds,word ptr cs:[enviro]
                xor     si,si
                cld
no_str1:        lodsb
                cmp     al,0
                jnz     no_str1
                lodsb
                cmp     al,0h
                jnz     no_str1
                add     si,02h
                mov     dx,si
                mov     word ptr cs:[namestart],si
                mov     ax,03d40h
                int     21h
                jnc     okgo1
go_errout:      jmp     error_out
okgo1:          mov     word ptr cs:[handle],ax
                mov     bp,ax
                mov     bx,ax
                mov     ax,04200h                       ;seek to end of loader
                xor     cx,cx
                mov     dx,4096d                         ;FIXED OFFSET !
                int     21h
                mov     word ptr cs:[wadd+02h],00000h
                mov     word ptr cs:[wadd+06h],00000h
;               call    nextprog
                push    dx                              ;hi
                push    ax                              ;lo
                call    loadprog
                mov     bx,0ffffh
                mov     ah,048h
                int     21h
                mov     cx,word ptr cs:[lsegment]
                dec     cx
                mov     es,cx
                add     bx,word ptr es:[03h]
                inc     cx
                mov     es,cx
                mov     ah,04ah
                int     21h
                jnc     okalloc_1
                mov     ah,04ah
                int     21h
okalloc_1:      mov     bp,word ptr cs:[handle]
                not     byte ptr cs:[loadflag]
                pop     dx
                pop     cx
                mov     bx,bp
                mov     byte ptr cs:[wflip+01h],0h
                call    wflip
                mov     byte ptr cs:[wflip+01h],01h
                mov     word ptr cs:[wadd+02h],01ch
                mov     word ptr cs:[wadd+06h],000h
                call    nextprog
                mov     word ptr cs:[start_hi],dx
                mov     word ptr cs:[start_lo],ax

                call    loadprog

error_out:      mov     bx,word ptr cs:[handle]
                or      bx,bx
                jz      alreadyclosed
                mov     ah,03eh
                int     21h
alreadyclosed:  cli
                xor     ax,ax
                mov     ds,ax
                mov     ax,word ptr cs:[org21]
                mov     word ptr ds:[0084h],ax
                mov     ax,word ptr cs:[org21+2]
                mov     word ptr ds:[0086h],ax
                sti
errorexit:      push    ax
                push    es
                mov     es,word ptr cs:[enviro]
                mov     ah,049h
                int     21h
                mov     ax,word ptr cs:[lsegment]
                mov     es,ax
                mov     ah,049h
                int     21h
                pop     es
                pop     ax

                mov     ah,09h
                push    cs
                pop     ds
                mov     dx,[offset text]
                int     21h

                mov     ax,04c00h
                int     21h


nextprog:       call    getheader
                push    dx
                pop     si
                cmp     word ptr cs:[si],'ZM'
                jnz     error_out
                mov     ax,word ptr cs:[si+04h]
                mov     bx,word ptr cs:[si+02h]
                or      bx,bx
                jz      no_dec1
                dec     ax
no_dec1:        mov     cx,08h
                shl     ax,cl
                adc     ch,0
                add     ch,ch
                shl     ax,1
                xchg    ch,cl
                adc     cl,0
                xor     ch,ch
                add     ax,bx
                mov     dx,ax                           ;lo
                mov     bx,bp                           ;handle
wadd:           sub     dx,0deadh
                sbb     cx,0deadh
wflip:          mov     ax,04201h
                int     21h
                ret

loadprog:       push    dx
                push    ax
                call    getheader
                push    dx
                pop     si
                cmp     word ptr cs:[si],'ZM'
                jz      no_err1
                jmp     error_out
no_err1:        mov     cx,0ffffh
                mov     dx,(0-1ch)
                mov     bx,bp
                mov     ax,04201h
                int     21h
                mov     dx,word ptr cs:[si+08h]
                xor     ax,ax
                mov     cx,04h
shift1:         shl     dx,1
                rcl     ax,1
                loop    shift1
                mov     cx,ax
                push    dx                      ;header lo
                push    cx                      ;header hi
                mov     ax,04201h
                int     21h
                mov     cx,9
                mov     ax,[si+4]
                test    word ptr ds:[si+2],0ffffh
                jz      fullpage
                dec     ax
fullpage:       xor     bx,bx
                xor     dx,dx
full:           shl     ax,1                            ;*512
                rcl     bx,1
                loop    full
                add     ax,word ptr [si+2]              ;plus rest
                adc     bx,0
                pop     dx
                pop     cx
                sub     ax,cx
                sbb     bx,dx
                mov     word ptr cs:[prglength+2],bx
                mov     word ptr cs:[prglength],ax
                push    ax                                      ;save length
                push    bx                                      ;for later use

                mov     ax,word ptr cs:[lsegment]
                add     ax,10h
                mov     ds,ax
                xor     dx,dx
                mov     word ptr cs:[_clength],dx
                mov     word ptr cs:[_clength+2],dx
                mov     word ptr cs:[_cload+2],ds
                mov     word ptr cs:[_cload],dx
readloop1:      mov     ah,03fh
                mov     ds,word ptr cs:[_cload+2]
                mov     dx,word ptr cs:[_cload]
                mov     bx,bp
                mov     cx,0f000h
                int     21h
                mov     bx,ax
                mov     cl,04h
                shr     bx,cl
                add     word ptr cs:[_cload+2],bx
                mov     bx,ax
                and     bx,000fh
                add     word ptr cs:[_cload],bx
                add     ax,word ptr cs:[_clength]
                adc     word ptr cs:[_clength+2],0
                mov     word ptr cs:[_clength],ax
                mov     bx,word ptr cs:[prglength]
                cmp     ax,bx
                mov     ax,word ptr cs:[_clength+2]
                sbb     ax,word ptr cs:[prglength+2]
                jl      readloop1
allread1:
                pop     word ptr cs:[prglength+2]
                pop     word ptr cs:[prglength]

                pop     dx
                pop     cx
                push    cx
                push    dx
                mov     ax,04200h
                mov     bx,bp
                int     21h
                xor     cx,cx
                mov     dx,word ptr cs:[headerbuf+18h]
                mov     ax,04201h
                int     21h
whole_reloc:    test    word ptr cs:[headerbuf+06h],0ffffh
                jz      end_reloc
                mov     ah,03fh
                mov     bx,bp
                mov     cx,04h
                push    cs
                pop     ds
                mov     dx,offset (_cload)
                int     21h
                mov     bx,word ptr cs:[_cload+2]
                mov     ax,word ptr cs:[lsegment]
                add     ax,010h
                add     bx,ax
                mov     es,bx
                mov     di,word ptr cs:[_cload]
                add     word ptr es:[di],ax
                dec     word ptr cs:[headerbuf+06h]
                jmp     short whole_reloc
end_reloc:
                test    byte ptr cs:[loadflag],0ffh
                jz      noclose
                mov     bx,word ptr cs:[handle]
                mov     ah,03eh
                int     21h
                mov     word ptr cs:[handle],0h
noclose:        mov     ax,word ptr cs:[lsegment]
                add     ax,010h
                cli
                mov     word ptr cs:[_cload],sp
                mov     word ptr cs:[_cload+2],ss
                xor     bx,bx
                mov     ds,bx
                mov     bx,cs
                mov     word ptr ds:[0086h],bx
                mov     word ptr ds:[0084h],(offset myint3)
nomy3:          mov     sp,word ptr cs:[headerbuf+010h]
                mov     bx,word ptr cs:[headerbuf+0eh]
                add     bx,ax
                mov     ss,bx
                sti

                mov     bx,word ptr cs:[headerbuf+016h]
                add     bx,ax
                mov     word ptr cs:[gogo+3h],bx
                mov     bx,word ptr cs:[headerbuf+014h]
                mov     word ptr cs:[gogo+1h],bx

                sub     ax,10h
                mov     ds,ax
                mov     es,ax
                jmp     gogo_1
gogo_1:         xor     ax,ax
                xor     bx,bx
                xor     cx,cx
                xor     dx,dx
                xor     si,si
                xor     di,di
                xor     bp,bp
                cld
gogo:           db      0eah,0,0,0,0
go_on:
                pop     ax
                pop     dx
                ret

getheader:      mov     bx,bp
                mov     ah,03fh
                mov     cx,01ch
                push    cs
                pop     ds
                mov     dx,[offset headerbuf]
                int     21h
                ret

; file handling routines of int21h


myint3:         test    byte ptr cs:[openflag],0ffh
                jz      notyetopen
                cmp     bx,word ptr cs:[open_handle]
                jnz     notyetopen
                cmp     ah,03eh
                jnz     check_cont1
                not     byte ptr cs:[openflag]
                mov     word ptr cs:[open_handle],0h
                jmp     go21
check_cont1:    cmp     ah,03fh
                jnz     no_read
                jmp     readhandle
no_read:        cmp     ah,042h
                jnz     go21
                jmp     seekhandle
notyetopen:     test    byte ptr cs:[childflag],0ffh
                jz      normalcheck
                cmp     ah,04ch
                jnz     go21
                dec     byte ptr cs:[childflag]
                jmp     go21
normalcheck:    test    byte ptr cs:[loadflag],0ffh
                jz      no_open
                cmp     ah,03dh
                jnz     secondend
                jmp     intercept
secondend:      cmp     ah,04ch
                jz      got_end
                cmp     ax,04b00h
                jnz     check4btwo
                inc     byte ptr cs:[childflag]
check4btwo:     cmp     ax,04b03h
                jnz     go21
                inc     byte ptr cs:[childflag]
                jmp     go21
no_open:        cmp     ah,04ch
                jz      got_end
                cmp     ah,048h
                jz      savelist
go21:           db      0eah
org21:          dw      0,0
got_end:        mov     sp,word ptr cs:[_cload]
                mov     ss,word ptr cs:[_cload+2]
                xor     ax,ax
                mov     ds,ax
                mov     ax,word ptr cs:[org21]
                mov     word ptr ds:[0084h],ax
                mov     ax,word ptr cs:[org21+2]
                mov     word ptr ds:[0086h],ax
                mov     di,offset memlist
freeall:        mov     ah,049h
                mov     bx,word ptr cs:[di]
                mov     word ptr cs:[di],ds
                add     di,02h
                or      bx,bx
                jz      allfreed
                mov     es,bx
                int     21h
                jmp     freeall
allfreed:       jmp     go_on

savelist:       cli
                mov     word ptr cs:[save_bp],bp
                mov     bp,sp
                push    word ptr [bp+4]
                push    cs
                mov     bp,word ptr cs:[save_bp]
                call    go21
                pushf
                mov     word ptr cs:[save_bp],bp
                mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[save_di],di
                pop     ax
                mov     bp,sp
                mov     word ptr [bp+4],ax
                test    ax,01h
                jnz     no_save
                mov     ax,word ptr cs:[save_ax]
                mov     di,word ptr cs:[mempnt]
                mov     word ptr cs:[di],ax
                add     di,02h
                mov     word ptr cs:[mempnt],di
no_save:        mov     di,word ptr cs:[save_di]
                mov     ax,word ptr cs:[save_ax]
                mov     bp,word ptr cs:[save_bp]
                iret

; ------------------------------------------------------------------------

intercept:      mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[save_bx],bx
                mov     word ptr cs:[save_cx],cx
                mov     word ptr cs:[save_dx],dx
                mov     word ptr cs:[save_es],es
                mov     word ptr cs:[save_ds],ds
                mov     word ptr cs:[save_si],si
                mov     word ptr cs:[save_di],di
                mov     word ptr cs:[save_bp],bp

                push    ds
                pop     es
                mov     di,dx
                cld
                xor     ax,ax
                mov     cx,040h
                repnz   scasb
                jcxz    secondcxz
                mov     al,040h-1h
                sub     al,cl
                xchg    ax,cx
                mov     ds,word ptr cs:[enviro]
                mov     si,word ptr cs:[namestart]
                mov     di,dx
                repz    cmpsb
                jz      okname

                push    ds
                pop     es
                mov     di,word ptr cs:[namestart]
                mov     cx,040h
                xor     al,al
                repnz   scasb
secondcxz:      jcxz    no_same
                std
                mov     al,'\'
                mov     cx,0ch
                sub     di,02h
                repnz   scasb
                jcxz    no_same
                add     di,02h
                mov     ch,0ch
                sub     ch,cl
                xchg    cl,ch
                xor     ch,ch
                mov     ds,word ptr cs:[save_ds]
                mov     si,word ptr cs:[save_dx]
                cld
                repz    cmpsb
                jnz     no_same

okname:         push    es
                pop     ds
                mov     ax,word ptr cs:[save_ax]
                mov     bp,sp
                push    word ptr [bp+04h]
                push    cs
                call    go21
                pushf
                pop     word ptr [bp+04h]
                mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[open_handle],ax
                not     byte ptr cs:[openflag]
                mov     bx,ax
                mov     ax,04200h
                mov     cx,word ptr cs:[start_hi]
                mov     dx,word ptr cs:[start_lo]
                push    word ptr [bp+04h]
                push    cs
                call    go21
                pushf
                pop     word ptr [bp+04h]
                mov     word ptr cs:[real_hi],dx
                mov     word ptr cs:[real_lo],ax
                xor     ax,ax
                mov     word ptr cs:[virt_hi],ax
                mov     word ptr cs:[virt_lo],ax
                jmp     intreturn

no_same:        mov     ax,word ptr cs:[save_ax]
                mov     bx,word ptr cs:[save_bx]
                mov     cx,word ptr cs:[save_cx]
                mov     dx,word ptr cs:[save_dx]
                mov     es,word ptr cs:[save_es]
                mov     ds,word ptr cs:[save_ds]
                mov     si,word ptr cs:[save_si]
                mov     di,word ptr cs:[save_di]
                mov     bp,word ptr cs:[save_bp]
                jmp     go21

intreturn:      mov     ax,word ptr cs:[save_ax]
                mov     bx,word ptr cs:[save_bx]
                mov     cx,word ptr cs:[save_cx]
                mov     dx,word ptr cs:[save_dx]
                mov     es,word ptr cs:[save_es]
                mov     ds,word ptr cs:[save_ds]
                mov     si,word ptr cs:[save_si]
                mov     di,word ptr cs:[save_di]
                mov     bp,word ptr cs:[save_bp]
                iret

readhandle:     mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[save_bx],bx
                mov     word ptr cs:[save_cx],cx
                mov     word ptr cs:[save_dx],dx
                mov     word ptr cs:[save_es],es
                mov     word ptr cs:[save_ds],ds
                mov     word ptr cs:[save_si],si
                mov     word ptr cs:[save_di],di
                mov     word ptr cs:[save_bp],bp

                mov     bp,sp
                push    word ptr [bp+4]
                push    cs
                call    go21
                pushf
                pop     word ptr [bp+4]
                mov     word ptr cs:[save_ax],ax
                jc      intreturn
                add     word ptr cs:[real_lo],ax
                adc     word ptr cs:[real_hi],0
                add     word ptr cs:[virt_lo],ax
                adc     word ptr cs:[virt_hi],0
                jmp     intreturn

seekhandle:     mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[save_bx],bx
                mov     word ptr cs:[save_cx],cx
                mov     word ptr cs:[save_dx],dx
                mov     word ptr cs:[save_es],es
                mov     word ptr cs:[save_ds],ds
                mov     word ptr cs:[save_si],si
                mov     word ptr cs:[save_di],di
                mov     word ptr cs:[save_bp],bp

                cmp     al,01h
                jz      from_current
                cmp     al,02h
                jnz     not_from_end
from_current:   mov     bp,sp
                push    word ptr [bp+4]
                push    cs
                call    go21
                pushf
                pop     word ptr [bp+4]
                jnc     okseek0
                jmp     intreturn
okseek0:
                mov     word ptr cs:[real_lo],ax
                mov     word ptr cs:[real_hi],dx
                sub     ax,word ptr cs:[start_lo]
                sbb     dx,word ptr cs:[start_hi]
                mov     word ptr cs:[virt_lo],ax
                mov     word ptr cs:[virt_hi],dx
                mov     word ptr cs:[save_ax],ax
                mov     word ptr cs:[save_dx],dx
                jmp     intreturn
not_from_end:
                cmp     al,0h
                jz      from_start
                jmp     no_same
from_start:
                add     dx,word ptr cs:[start_lo]
                adc     cx,word ptr cs:[start_hi]
                jmp     from_current

; -------------------------------------------------------------------------

loadfix:        db      0

; -------------------------------------------------------------------------

save_bp:        dw      0
save_ax:        dw      0
save_bx:        dw      0
save_cx:        dw      0
save_dx:        dw      0
save_ds:        dw      0
save_es:        dw      0
save_si:        dw      0
save_di:        dw      0

mempnt:         dw      offset memlist
memlist:        dw      10 dup (0)
text:           db      0ah,0dh,'V-Load v0.9 [June 1994]   ',0ah,0dh,'$'
loadflag:       db      0
prglength:      dd      0
_cload:         dd      0
_clength:       dd      0

handle:         dw      0
lsegment:       dw      0
enviro:         dw      0
namestart:      dw      0
headerbuf:      db      1ch dup (0)

childflag:      db      0
openflag:       db      0
open_handle:    dw      0
start_hi:       dw      0               ;start of exefile INSIDE my-exe-file
start_lo:       dw      0
real_hi:        dw      0               ;real position of filepointer
real_lo:        dw      0
virt_hi:        dw      0               ;virtual position of filepointer
virt_lo:        dw      0               ;reported to calling program
end_sprog:

ecode           db      0

main            endp

code            ends

data            segment para 'DATA'

                db      (2048-16*36) dup (0)

data            ends

                end     start

