;=============================================================================
;                 Some example code for the DTU API...
;=============================================================================

Code Segment
     Assume Cs:Code,Ds:Code
     Org 100h
     .386
Start:
     Mov      Ah,9
     Mov      Dx,Offset Welcome
     Int      21h                      ;Print the Welcome String...
     Sub      Ax,Ax                    ;Start checking Multiplex Number 0
CheckLoop:
     Push     Ax                       ;Save current Mux Number
     Int      2Dh                      ;Installation check
     Or       Al,Al                    ;Is there a program installed here ?
     Pop      Ax                       ;Restore Mux Number
     Jnz      ProgramInstalled         ;Program installed -> Jump
NextCheck:
     Inc      Ah                       ;No program installed -> Try next Mux
     Jnz      CheckLoop                ;Loop max. 256 times...
DTUNotInstalled:
     Mov      Ah,9                     ;DTU not found at one of 256 Mux's
     Mov      Dx,Offset NoDTUStr
     Int      21h                      ;Print DTU not installed
     Int      20h                      ;End program...
ProgramInstalled:
     Pusha                             ;Save all registers
     Mov      Es,Dx                    ;Set ES:DI to program signature
     Mov      Si,Offset DTUSignature   ;Compare to DTU's signature
     Mov      Cx,16
     Rep      Cmpsb                    ;Compare strings
     Popa                              ;Restore all registers
     Jnz      NextCheck                ;Strings not equal -> Scan next program
DTUFound:
     Mov      [DTUNumber],Ah           ;Save Multiplex Number
     Mov      Ah,9
     Mov      Dx,Offset DTUFoundStr
     Int      21h                      ;Print DTU found
     Mov      Al,Ch                    ;Move Major Version Number into AL
     Call     PrintBCD                 ;Print Major Version Number
     Mov      Ah,2                     ;Subfunction 2: Print character
     Mov      Dl,'.'                   ;The character...
     Int      21h                      ;Print...
     Mov      Al,Cl                    ;Move Minor Version Number into AL
     Call     PrintBCD                 ;Print Minor Version Number
     Mov      Ah,9
     Mov      Dx,Offset ExtAPIStr
     Int      21h
     Mov      Ah,[DTUNumber]
     Mov      Al,10h
     Int      2Dh
     Mov      Al,Bl
     Mov      [ExtendedAPI],Al
     Call     PrintYesNo
     Cmp      [ExtendedAPI],1
     Jnz      NoExtAPIInfo
     Mov      Ah,9
     Mov      Dx,Offset NumUnitsStr
     Int      21h
     Mov      Ah,[DTUNumber]
     Mov      Al,11h
     Sub      Bl,Bl
     Int      2Dh                      ;Get # of units
     Mov      Al,Bl
     Movzx    Cx,Al                    ;Load number of units in CX
     Call     PrintBCD
     Mov      Ah,[DTUNumber]
     Mov      Al,11h
     Mov      Bl,1
     Mov      Dx,Cs
     Mov      Di,Offset UnitBuf
     Int      2Dh
     Mov      Ah,9
     Mov      Dx,Offset InstallStr
     Int      21h
     Mov      Si,Offset UnitBuf
PrintLoop:
     Lodsb
     Call     PrintBCD
     Mov      Ah,2
     Mov      Dl,' '
     Int      21h
     Loop     PrintLoop
NoExtAPIInfo:
     Mov      Ah,9
     Mov      Dx,Offset Int3Str
     Int      21h
     Int      03h                      ;Call DTU through INT 03
     Cmp      [ExtendedAPI],1
     Jnz      NoExtAPIPopup
     Mov      Ah,9
     Mov      Dx,Offset Sub3Str
     Int      21h
     Mov      Ah,[DTUNumber]
     Mov      Al,3
     Int      2Dh                      ;Call DTU through INT 2D/03
     Mov      Ah,9
     Mov      Dx,Offset Sub21Str
     Int      21h
     Mov      Ah,[DTUNumber]
     Mov      Al,51h                   ;Function 51 -> Set memory reference
     Mov      Bl,0                     ;Set reference 0
     Mov      Cx,40h                   ;To 0040:006C, the clock counter...
     Mov      Dx,6Ch
     Int      2Dh                      ;Set the reference
     Mov      Ah,[DTUNumber]
     Mov      Al,21h
     Mov      Bl,11h                   ;Popup with Memory View active
     Int      2Dh                      ;Call DTU through INT 2D/21
                                       ;Press 0 to check out memory
                                       ;reference 0 here...
NoExtAPIPopup:
     Mov      Ah,9
     Mov      Dx,Offset EndStr
     Int      21h
     Int      20h

PrintYesNo Proc Near
     Pusha
     Mov      Dx,Offset YesNo
     Not      Al
     And      Al,1
     Shl      Al,2
     Sub      Ah,Ah
     Add      Dx,Ax
     Mov      Ah,9
     Int      21h
     Popa
     Ret
Endp

PrintBCD Proc Near
     Pusha                             ;Save all registers
     Push     Ax                       ;Save AX
     Shr      Al,4                     ;Move upper BCD Number into low bits
     Add      Al,'0'                   ;Add '0' to become number in ASCII
     Mov      Ah,2                     ;Print character with DOS Function 2
     Mov      Dl,Al
     Int      21h                      ;Print...
     Pop      Ax                       ;Restore AX
     And      Al,0Fh                   ;Mask out lower BCD Number
     Add      Al,'0'                   ;Add '0' to become number in ASCII
     Mov      Ah,2                     ;Print character with DOS Function 2
     Mov      Dl,Al
     Int      21h                      ;Print...
     Popa                              ;Restore all registers
     Ret                               ;Return...
Endp

Welcome       Db    13,10,'Demoprogramm fr das API der DTown Utilities.',13,10,13,10,'$'
NoDTUStr      Db          'DTU ist nicht installiert...',13,10,'$'
DTUFoundStr   Db          'DTU installiert: Versionsnummer              : $'
ExtAPIStr     Db    13,10,'                 Erweitertes API installiert : $'
NumUnitsStr   Db    13,10,'                 Einheiten insgesamt         : $'
InstallStr    Db    13,10,'                 Einheiten installiert       : $'
Int3Str       Db    13,10,'                 Aufruf von DTU mit INT 03h...$'
Sub3Str       Db    13,10,'                 Aufruf von DTU mit INT 2Dh, Funktion 03h...$'
Sub21Str      Db    13,10,'                 Aufruf von DTU mit INT 2Dh, Funktion 21h...$'
EndStr        Db    13,10,13,10,'DTU erfolgreich getestet...',13,10,13,10,'$'

ExtendedAPI   Db    0                  ;1=Extended API installed, 0=not...
HandlerOfs    Dw    0                  ;Stored Pop-up Handler Offset
HandlerSeg    Dw    0                  ;Stored Pop-up Handler Segment
DTUNumber     Db    0                  ;Multiplex Number for DTU
DTUSignature  Db    'DTown SDDTU     ' ;DTU's Signature
UnitBuf       Db    100 Dup(0)
YesNo         Db    'Ja$Nein$'

Code Ends
     End Start
