;
;  mutare.asm (C) 1997 by Stefan Esser
;

;  generates mutating decryptors of the form
;
;     MOV          counterreg, countervalue
; /-> XOR/SUB/ADD  CS:[counterreg+counteradjust], ckey
; |   INC/DEC      counterreg
; \-- JNZ       

.286

GetRandom macro
    PUSH bx
    IN   ax, 40h     ; Simple in ax, 40h is not enough! 
    OR   ax, ax      ; only numbers <~3500
    JZ   $-4
    MOV  bx, ax
    IN   ax, 40h
    OR   ax, ax
    JZ   $-4
    MOV  ah, bl
    POP  bx
endm

GetRnd macro
    IN  ax, 40h
    ROR ax, 1
endm

;  
; BEGIN MUTARE
;  
;   Mutates your stuff
;   IN:  CX    = number bytes to encrypt
;        DS:SI = bytes to encrypt
;        ES:DI = buffer for encrypted bytes 
;                and decryptor
;   OUT: buffer filled
;--------------------------------------------------
Beginmutare proc
           CALL   init_variables
           CALL   choose_counterreg
           CALL   choose_cryptingroutine
           CALL   choose_direction
           CALL   gen_fillup
           CALL   gen_cryptline
           GetRnd
           AND    AL, 1
           JZ     pqcfirst
pqcsecond: CALL   gen_incdec
           CALL   gen_pqc
           JMP    passpqc
pqcfirst:  CALL   gen_pqc
           CALL   gen_incdec
passpqc:   CALL   gen_loopback
           CALL   encrypt_rest
           RET
endp
;--------------------------------------------------

;  
; INIT VARIABLES
;  
;   Initialising of all necessary vars
;--------------------------------------------------
Init_Variables proc
    MOV    cs:countervalue, cx
findkey:
    GetRnd
    OR     al, al
    JZ     findkey
    MOV    cs:ckey, al
    RET
endp
;--------------------------------------------------

;  
; CHOOSE COUNTERREG
;  
;   OUT: counterreg = 0(SI), 1(DI), 2(BP), 3(BX)
;--------------------------------------------------
Choose_Counterreg proc
    GetRnd
    AND    ax, 3
    MOV    cs:counterreg, ax
    RET
endp
;--------------------------------------------------

;  
; CHOOSE DIRECTION          
;  
;   OUT: direction filled with 0 or 1
;--------------------------------------------------
Choose_Direction proc
    GetRnd
    AND    ax, 1
    MOV    cs:direction, al
    RET
endp
;--------------------------------------------------

;  
; CHOOSE CRYPTINGROUTINE
;  
;   OUT: cryptrout = 0(XOR), 1(SUB), 2(ADD)
;--------------------------------------------------
Choose_Cryptingroutine proc
ui:    
    GetRnd
    AND    ax, 3
    JZ     ui
    DEC    ax
    MOV    cs:cryptrout, al
    RET
endp
;--------------------------------------------------

;  
; GEN FILLUP
;  
;   Generates a counterregister fillup sequence
;--------------------------------------------------
Gen_FillUp proc
    MOV    ax, cs:countervalue
    CMP    cs:direction, 1
    JE     nit1
    NEG    ax
nit1:
    MOV    dx, ax
    MOV    bx, cs:counterreg
    MOV    al, cs:reg_inc[bx]
    MOV    cs:regist, al
    MOV    cx, ax
    
    GetRnd
    MOV    bl, al
    AND    bl, 3
    JZ     WriteMove  ; only MOVE!
    CMP    bl, 3      ; MOV creg, ??? / XOR creg, ???
    JNZ    nextMOVSUB

    GetRandom
    XOR    dx, ax
    PUSH   dx
    MOV    dx, ax
    CALL   WriteMove
    POP    dx
    MOV    al, cs:regist
    CALL   GetXORopcode
    STOSW
    MOV    ax, dx
    STOSW
    RET

nextMOVSUB:
    CMP    bl, 2          ; MOV creg, ??? / SUB creg, ???
    JNZ    nextMOVADD

    MOV    al, cs:regist
    CALL   GetSUBopcode
    MOV    cx, ax
    GetRandom
    NEG    dx
    ADD    dx, ax
    JMP    continue

nextMOVADD:               ; MOV creg, ??? / ADD creg, ???
    MOV    al, cs:regist
    CALL   GetADDopcode
    MOV    cx, ax
    GetRandom
    SUB    dx, ax
continue:    
    PUSH   dx
    MOV    dx, ax
    CALL   WriteMove
    POP    dx
    MOV    ax, cx
    STOSW
    MOV    ax, dx
    STOSW
    RET

WriteMove:    ; generates a simple MOV creg, ????
    MOV    al, cs:regist
    ADD    al, 0b8h
    STOSB
    MOV    ax, dx
    STOSW
    RET
;--------------------------------------------------

;  
; GETADD(SUB/XOR)OPCODE     
;  
;    IN:  AX=register 
;    OUT: AX=opcode for ADD(SUB/XOR) rm16, imm16
;--------------------------------------------------
GetADDopcode proc
    SHL    ax, 8
    ADD    ax, 0c081h
    RET
endp
;--------------------------------------------------
GetSUBopcode proc
    SHL    ax, 8
    ADD    ax, 0e881h
    RET
endp
;--------------------------------------------------
GetXORopcode proc
    SHL    ax, 8
    ADD    ax, 0f081h
    RET
endp
;--------------------------------------------------

;  
; GEN CRYPTLINE
;  
;   Generates depending on direction and cryptrout
;   a decryptorline for one byte
;   exampl.:   XOR  [SI+30h], 40h
;--------------------------------------------------
Gen_Cryptline:
    MOV    ax, 802eh
    STOSW
    XOR    bx, bx
    MOV    bl, cs:cryptrout
    MOV    al, cs:cryptmen[bx]
    ADD    al, byte ptr cs:counterreg
    STOSB
    MOV    ax, di
    ADD    ax, 7
    CMP    cs:direction, 1
    JE     nit2
    INC    ax
    ADD    ax, cs:countervalue
nit2:STOSW
    MOV    al, cs:ckey
    STOSB
    RET
;--------------------------------------------------

;  
; GEN INCDEC
;  
;   Generates depending on the direction either 
;   INC counterreg   or   DEC counterreg
;--------------------------------------------------
Gen_IncDec:
    MOV    al, cs:direction
    SHL    al, 3
    MOV    bx, cs:counterreg
    ADD    al, cs:reg_inc[bx]
    ADD    al, 40h
    STOSB
    RET
endp
;--------------------------------------------------

;  
; GEN Prefetch Que Clearer
;  
;   Generates a simple JMP $+2 to clear the PQ
;--------------------------------------------------
Gen_Pqc proc
    MOV    ax, 00ebh
    STOSW
    RET
endp
;--------------------------------------------------

;  
; GEN LOOPBACK
;  
;   Generates a simple JMP $-7 for the decr. loop
;--------------------------------------------------
Gen_Loopback proc
    MOV    ax, 0f575h
    STOSW
    RET
endp
;--------------------------------------------------

;  
; ENCRYPT REST
;  
;   Encrypts the code
;--------------------------------------------------
encrypt_rest proc
    MOV    cx, cs:countervalue
    XOR    bx, bx
    MOV    bl, cs:cryptrout
    SHL    bx, 1
    MOV    dx, cs:encrypt[bx]
    MOV    bl, cs:ckey
looping:
    LODSB
    CALL   dx
    STOSB
    LOOP   looping
    RET
endp
;--------------------------------------------------
; The encryption routines
;--------------------------------------------------
routine1:  XOR al, bl   ; for XOR x,y
           RET
routine2:  ADD al, bl   ; for SUB x,y  <- yes for SUB
           RET
routine3:  SUB al, bl   ; for ADD x,y  <- yes for ADD
           RET
;--------------------------------------------------


;  
; Variables and Constantes
;  
           ;    SI   DI   BP   BX
reg_inc      db 06h, 07h, 05h, 03h
cryptmen     db 0b4h, 0ach, 084h  ; XOR / SUB / ADD
direction    db 0                 ; 1 decrease, 0 increase
cryptrout    db 0                 ; 0, 1, 2
counterreg   dw 0                 ; 0 SI - 1 DI - 2 BP - 3 BX
regist       db 0
countervalue dw 0
ckey         db 0
encrypt      dw offset routine1 
             dw offset routine2
             dw offset routine3

