{
  RELOCations handler 1.00       by Piotr Warezak, warezak@kolos.uni.lodz.pl
                                                 awarezak@krysia.uni.lodz.pl

  This program is public domain, but that would be nice if you add some
  greetings when using a part of it's code :)

  It was written for educational purposes in september 1997 :)
}

{$I-}                           {we have our own I/O error handler}
program reloc;

uses dos,crt;

type header=object              {DOS EXE header type def}
       mz:array[1..2] of char;           {EXE mark}
       last_page:word;                   {number of bytes on last page}
       number_of_pages:word;             {number of 512-bytes pages}
       number_of_relocations:word;       {number of relocations in EXE}
       header_size:word;                 {size of EXE header in paraghraphs}
       min_mem:word;                     {???}
       max_mem:word;                     {???}
       ss:word;                          {stack segment}
       sp:word;                          {stack pointer}
       crc:word;                         {not interesting really :)}
       ip:word;                          {instruction pointer}
       cs:word;                          {start segment}
       rel_table_offset:word;            {relocation table offset}
       ovl:word;                         {???}
       unused:array[1..4] of char;       {filler to 32 bytes :)}
       procedure size(const a:LongInt);
     end;


{ HANDLER array will contain assembled relocations handler }

var hdr:header;
    pl,pl2:file;                {pl - source file, p2 - destination file}
    t:array[1..60000] of byte;  {temporary array (feel free to modify size)}
    i,ile:word;
    handler:array[1..1024] of byte;
    handler_size:word;


{ header.size procedure sets image size in the header (modifies
  hdr.last_page and hdr.number_of_pages fields. It's required
  for creating out file! }

procedure header.size(const a:longint);
var l3:longint;
begin
  l3:=(a mod 512);
  hdr.last_page:=l3;
  if l3=0 then l3:=(a div 512) else l3:=(a div 512)+1;
  hdr.number_of_pages:=l3;
end;


{ this function returns image size of EXE file (size_of_EXE-size_of_overlay) }

function image_size:longint;
var l:longint;
begin
  if (hdr.last_page)=0 then l:=hdr.number_of_pages
                       else l:=hdr.number_of_pages-1;
  l:=(l*512)+hdr.last_page;
  image_size:=l;
end;


{ Some I/O error handler :) }

procedure error(n:byte);
begin
  write(#7);
  case n of
    0: writeln('HANDLER.COM file not found!');
    1: writeln('File open error!');
    2: writeln('This is not EXE file!');
    3: writeln('This file has no relocations!');
    4: writeln('Out file create error!');
    5: writeln('File contains overlay!');
  end;
  halt;
end;


{ Here main code begins! }

begin
{ Write label when no parameters }
  if paramcount=0 then
  begin
    writeln('');
    write('');textcolor(white);write(' RELOCations handler 1.00 ');textcolor(lightgray);writeln('');
    writeln('by Piotr Warezak, Lodz, Poland');
    writeln('http://kolos.uni.lodz.pl/warezak');
    writeln('');
    writeln('This program is public domain!');
    writeln('Written for educational purposes :)');
    halt;
  end;

{ Read relocations handler }
  assign(pl,'HANDLER.COM');reset(pl,1);
  handler_size:=filesize(pl);blockread(pl,handler,handler_size);close(pl);
  if ioresult<>0 then error(0);

{ Open source file and read 32-bytes header, check if EXE file }
  assign(pl,paramstr(1));reset(pl,1);
  if ioresult<>0 then error(1);
  if filesize(pl)<32 then error(2);
  blockread(pl,hdr,32);
  if (hdr.mz<>'MZ') and (hdr.mz<>'ZM') then error(2);
  if (hdr.number_of_relocations=0) then error(3);
  if (image_size<filesize(pl)) then error(5);


{ Create out file, write temporary header }
  assign(pl2,'out.exe');rewrite(pl2,1);
  if ioresult<>0 then error(4);
  blockwrite(pl2,hdr,32);

{ Copy program's code (everything except header and relocation table) }
  seek(pl,hdr.header_size*16);
  repeat
    blockread(pl,t,32000,i);
    blockwrite(pl2,t,i);
  until i=0;

{ Filler in out file - it's required since we want our ASM procedure to
  run from CS:0000 address! }
  t[1]:=0;for i:=15 downto (filesize(pl2) mod 16) do blockwrite(pl2,t,1);

{set number of relocations }
  handler[handler_size-1]:=lo(hdr.number_of_relocations);
  handler[handler_size]:=hi(hdr.number_of_relocations);

{ set where image begins }
  handler[handler_size-5]:=lo((filesize(pl2)-32) div 16);
  handler[handler_size-4]:=hi((filesize(pl2)-32) div 16);
  handler[handler_size-3]:=0;
  handler[handler_size-2]:=0;

{ save original stack - we don't change the original stack now, but I decided
  to add this piece of code since it can be useful in future }
  handler[handler_size-9]:=lo((filesize(pl2)-32) div 16-hdr.ss);
  handler[handler_size-8]:=hi((filesize(pl2)-32) div 16-hdr.ss);
  handler[handler_size-7]:=lo(hdr.sp);
  handler[handler_size-6]:=hi(hdr.sp);

{ save original cs:ip start address }
  handler[handler_size-13]:=lo((filesize(pl2)-32) div 16-hdr.cs);
  handler[handler_size-12]:=hi((filesize(pl2)-32) div 16-hdr.cs);
  handler[handler_size-11]:=lo(hdr.ip);
  handler[handler_size-10]:=hi(hdr.ip);

{ set new cs:ip start address }
  hdr.ip:=0;hdr.cs:=(filesize(pl2)-32) div 16;

{ save our own relocations handler }
  blockwrite(pl2,handler,handler_size);

{ save reloaction table at the end of EXE image }
  seek(pl,hdr.rel_table_offset);ile:=0;
  repeat
    blockread(pl,t,4);
    blockwrite(pl2,t,4);
    inc(ile);
  until ile=hdr.number_of_relocations;

{ save new header in out file }
  hdr.number_of_relocations:=0;
  hdr.rel_table_offset:=28;
  hdr.header_size:=2;
  hdr.size(filesize(pl2));
  seek(pl2,0);blockwrite(pl2,hdr,28);

{ close in and out files }
  close(pl);close(pl2);
end.