#define WIN32_LEAN_AND_MEAN
#define STRICT
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>


extern "C" 
{
	__declspec(dllimport) DWORD SetMapHook(HANDLE hMap, DWORD nSize, DWORD dwThread);
}

int main (int argc, char* argv[]) {
	
	HANDLE hFileMap=0;
	HANDLE hFile=0;
	LPVOID pMappedFile=0;
	DWORD mySize=0;
	DWORD dwRemoteId=0;
	MSG msg;
	DWORD* lpdwResult=0;
	
	char* crap;
	char waste[80];
	
	if (argc!=4)
	{
		printf ("Usage:\n");
		printf ("%s <Target's thread id> <filename> <file size in bytes>\n", argv[0]);
		printf ("\nPlease note that the thread id and file size must specified\n");
		printf ("in hexadecimal notation without any prefixes or suffixes.\n\n");
		printf ("Example:\nsoftdump EC testdump.dat 20000\n");
		return 1;
	}
	
	dwRemoteId = strtol( argv[1], &crap, 16);
	
	mySize = strtol( argv[3], &crap, 16 );
	
	if (mySize < 1 || mySize > 1024*4096)
	{
		printf ("Size error. Size must be between 1 byte and 4MB.\n");
		return 0;
	}
	
	hFile = CreateFile ( (LPCTSTR) argv[2], GENERIC_READ | GENERIC_WRITE, 
		FILE_SHARE_WRITE, 0, CREATE_ALWAYS, 0, 0);
	
	if (!hFile)
	{
		printf ("Cannot open file %s.\nTerminating.", argv[2]);
		return 0;
	}
	
	hFileMap = CreateFileMapping ( hFile, 0, PAGE_READWRITE | SEC_COMMIT, 0, mySize, "softmap");
	
	if (!hFileMap)
	{
		printf("Unable to create file mapping.  Error Code: %d.  Terminating.\n", GetLastError());
		CloseHandle (hFile);
		return 0;
	}
	
	pMappedFile = MapViewOfFile ( hFileMap, FILE_MAP_WRITE, 0, 0, 0);
	
	if (!pMappedFile)
	{
		printf ("MapViewOfFile failed.  Error code: %d.  Terminating.\n", GetLastError());
		CloseHandle (hFileMap);
		CloseHandle (hFile);
		return 0;
	}
	
	// Force the pages into memory, and stick in identifier
	for (BYTE* i=(BYTE*)pMappedFile; i<(BYTE*)((DWORD)pMappedFile+mySize); i++)
		*i = 0xCC;
	strcpy((char*)pMappedFile, "mappedfile");
	
	// Write it to the disk
	FlushViewOfFile(pMappedFile,0);
	
	if (SetMapHook (hFileMap, mySize, dwRemoteId) == 0)
	{
		// Encourage the hook to activate
		PostThreadMessage(dwRemoteId, WM_NULL, 0, 0);
		
		// Wait for it to map the file
		GetMessage (&msg, NULL, WM_APP, WM_APP);
		
		if (msg.wParam == 0)
		{
			printf ("Mapping address in this process:  \t0x%x.\n", (DWORD)pMappedFile);
			printf ("Mapping address in target process:\t0x%x.\n\n", msg.lParam);
			printf ("The hook has been successfully installed.  Go into SoftICE and do your thing!\n");
			printf ("Hit return when you are ready for the file to be written to disk.\n");
			gets (waste);
		} else {
			printf ("Target process failed to map file.  Error code: 0x%x.\n", msg.wParam);
			printf ("Terminating.\n\n");
		}
		// Tell dll to close up shop
		SendMessage(FindWindow(NULL, "Soft - Dump"), WM_CLOSE, 0, 0);
		//SendMessageTimeout(FindWindow(NULL, "Soft - Dump"), WM_CLOSE, 0, 0, SMTO_BLOCK, 3000, lpdwResult)
		//if (GetLastError() == ERROR_TIMEOUT)
		//	printf ("Could not close hook.  Target may be unstable.\n");
	} else {
		printf ("Hook installation failed.  Terminating.\n");
	}
	
	// Flush file -- probably not necessary
	if (!FlushViewOfFile(pMappedFile,0))
		printf("FlushViewOfFile failed.  Check to make sure file is ok.\n");
	
	// Clean up
	UnmapViewOfFile ( pMappedFile);
	CloseHandle ( hFileMap );
	CloseHandle ( hFile );
	printf ("Done.\n");
	return 1;
	
}
