#ifndef DNSLIB_H
#define DNSLIB_H
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <arpa/nameser.h>

#define DNSHDRSIZE sizeof(HEADER)

int makequery(char *name, u_int16_t type, u_int8_t *buffer, u_int16_t id);
int makeqbody(char *name, u_int16_t type, u_int8_t *buffer);
int formatname(char *in, u_int8_t *out);
int uncompress(u_int8_t *in, char *out, u_int8_t *msg);

typedef struct {
	u_int16_t type;
	u_int16_t class;
	u_int32_t ttl;
	u_int16_t rdlength;
} rrec_body;

int	makeRR (char *name, u_int16_t type, u_int16_t class, u_int32_t ttl,
			char *rdata, char *buf);

#endif /* DNSLIB_H */
