
/* reverb - connection relay utility
 *
 * use it to bounce a connection (datapipe), chat with your friends,
 * interactivly use a active service, tunnel a firewall, bridge a proxy
 * from a protected net together with httptunnel, playing around,
 * ... use it for whatever you want :)
 *
 * 1999 (c) scut of amazing team teso
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "network.h"


#define	VERSION	"v0.0.2"
#define	AUTHORS	"scut of team teso"

void	usage (void);
void	banner (void);
void	quit (void);
void	relay (int s1, int s2);
int	rly_buff (int srcsock, int dstsock);

#define	ACTIVE	1
#define	PASSIVE	2
#define	RELAY	3

int	o_mode;

/* active data
 */
char			*a_ip1, *a_ip2;
unsigned short int	a_p1, a_p2;
int			s_1, s_2;
struct sockaddr_in	sa_1, sa_2;

/* passive data
 */
bound			*b1, *b2;

int
main (int argc, char **argv)
{
	int	n;	/* temporary return value */

	banner ();

	if (argc != 3)
		usage ();


	/* smack arguments
	 */

	if (strchr (argv[1], ':') != NULL && strchr (argv[2], ':') != NULL)
		o_mode = ACTIVE;
	else if (strchr (argv[1], ':') == NULL && strchr (argv[2], ':') == NULL)
		o_mode = PASSIVE;
	else if (strchr (argv[1], ':') == NULL && strchr (argv[2], ':') != NULL)
		o_mode = RELAY;
	else
		usage ();


	/* build to connected sockets, then pass them to relay function
	 */

	if (o_mode == ACTIVE) {
		if (net_parseip (argv[1], &a_ip1, &a_p1) == 0 ||
			net_parseip (argv[2], &a_ip2, &a_p2) == 0)
			usage ();

		printf ("connecting to %s:%hu\n", a_ip1, a_p1);
		s_1 = net_connect (&sa_1, a_ip1, a_p1, 10);

		if (s_1 != -1) {
			printf ("connecting to %s:%hu\n", a_ip2, a_p2);
			s_2 = net_connect (&sa_2, a_ip2, a_p2, 10);
		}

		if (s_1 == -1 || s_2 == -1)
			perror ("connections failed: ");

	} else if (o_mode == PASSIVE) {

		fd_set		ac_s;
		int		acp_sock, rj_sock;

		b1 = net_bind (NULL, atoi (argv[1]));
		if (b1 != NULL)
			b2 = net_bind (NULL, atoi (argv[2]));

		if (b1 == NULL || b2 == NULL)
			perror ("binding failed: ");

		FD_ZERO (&ac_s);
		FD_SET (b1->bs, &ac_s);
		FD_SET (b2->bs, &ac_s);

		n = select ((b1->bs > b2->bs) ? (b1->bs + 1) : (b2->bs + 1), &ac_s, NULL, NULL, NULL);
		if (n <= 0)
			perror ("passive sleeping failed: ");
		acp_sock = FD_ISSET (b1->bs, &ac_s) ? b1->bs : b2->bs;
		rj_sock = acp_sock == b1->bs ? b2->bs : b1->bs;

		printf ("waiting for connection [%d] on port %hu\n", b1->bs, atoi (argv[1]));
		s_1 = net_accept (acp_sock, &sa_1, 0);
		printf ("connection 1 established\n");
		if (s_1 > 0) {
			printf ("waiting for connection [%d] on port %hu\n", b2->bs, atoi (argv[2]));
			s_2 = net_accept (rj_sock, &sa_2, 0);
			printf ("connection 2 established\n");
		}

		if (s_1 <= 0 || s_2 <= 0)
			perror ("failed to accept connection: ");

	} else {
		if (net_parseip (argv[2], &a_ip1, &a_p1) == 0)
			usage ();

		b1 = net_bind (NULL, atoi (argv[1]));
		if (b1 == NULL)
			perror ("binding failed: ");
		printf ("waiting for connection [%d] on port %hu\n", b1->bs, atoi (argv[1]));
		s_1 = net_accept (b1->bs, &sa_1, 0);
		if (s_1 <= 0)
			perror ("accepting of an incoming connection failed: ");
		printf ("connection 1 established\n");
		s_2 = net_connect (&sa_2, a_ip1, a_p1, 10);
		if (s_2 == -1)
			perror ("connectin failed: ");
	}

	printf ("connections successfully established\n");
	printf ("relaying initiated\n");

	relay (s_1, s_2);

	/* should never happen */
	return (0);
}


void
usage (void)
{
	printf ("usage: reverb [ip1:]<port1> [ip2:]<port2>\n\n"
		"1. case: create a connection between ip1:port and ip2:port\n"
		"2. case: accept a connection from port1 and from port2 and relay\n"
		"3. case: accept a connection from port1 and relay it to ip2 on port2 (datapipe)\n\n");

	exit (EXIT_FAILURE);
}

void
banner (void)
{
	printf("reverb "VERSION" by "AUTHORS"\n\n");

	return;
}


void
relay (int s_1, int s_2)
{
	int		n, i = 0, maxfd;
	int		bc = 1;
	fd_set		chainset;

	while (bc) {
		FD_ZERO (&chainset);
		FD_SET (s_1, &chainset);
		FD_SET (s_2, &chainset);
		maxfd = ((s_1 > s_2) ? s_1 : s_2) + 1;

		n = select (maxfd, &chainset, NULL, NULL, NULL);
		switch (n) {
		case (0):	break;
		case (-1):	goto bncclss;
		default:	if (FD_ISSET (s_1, &chainset)) {
					i = rly_buff (s_1, s_2);
					if (i <= 0)
						bc = 0;
				} else if (FD_ISSET (s_2, &chainset)) {
					i = rly_buff (s_2, s_1);
					if (i <= 0)
						bc = 0;
				}
				break;
		}
	}

bncclss:
	close (s_1);
	close (s_2);
	return;
}

int
rly_buff (int srcsock, int dstsock)
{
	int		n = 1;
	unsigned char	tbuff[1024];

	n = read (srcsock, tbuff, sizeof (tbuff));
	if (n == 0)
		return (0);
	if (n == -1) {
		exit (EXIT_FAILURE);
	}
	write (dstsock, tbuff, n);

	return (n);
}



