/**************************************************************************** 
**
** File: iplayer.h
**
** Author: Mike Borella
**
** Comments: Macros and stuff
**
*****************************************************************************/

typedef struct _ipg_stats
{
  u_int32_t pkts_rcvd;
} ipg_stats;

char *copy_argv(char **argv);

/*
 * This is a typecast to avoid stupid warning messages.  The PCAP library
 * assumes that a call to a function that parses data lonk layer packets
 * includes a const in the third argument.  Actually doing so is a pain
 * because it makes the higher layer protocols much harder to parse because
 * you can't assign a pointer to the packet data.  So this tricks PCAP
 * into thinking you're using the const when you really are not.
 * Bleah.
 */

typedef void (*pcap_func_t)(u_char *, const struct pcap_pkthdr *, 
			    const u_char *);
