/*****************************************************************************
**
** parse_cl.c
**
** Thu Mar 25 07:42:05 1999
** mborella@stratos (Mike Borella)
**
** Main command line parsing routines
**
** Automatically created by genparse v0.2.2
**
** See http://www.xnet.com/~cathmike/MSB/Software/ for details
**
*****************************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include "parse_cl.h"

/*----------------------------------------------------------------------------
 *
 * usage()
 *
 *----------------------------------------------------------------------------
 */

void usage(char *exc)
{
  printf("usage: %s [ -cibplntm -s[012] ]\n", exc);
  printf("  [ -c ] ");
  printf("[ --count ] ");
  printf("Exit after receiving 'count' packets");
  printf("\n");
  printf("  [ -i ] ");
  printf("[ --interface ] ");
  printf("Listen on interface 'interface'");
  printf("\n");
  printf("  [ -b ] ");
  printf("Make stdout buffered");
  printf("\n");

  printf("  [ -j ] ");
  printf("No line breaks within packet (assumes -X)");
  printf("\n");

  printf("  [ -x ] ");
  printf("Dump hex values (default)\n");

  printf("\n");
  printf("  [ -X ] ");
  printf("Only dump hex values (no header labels)\n");

  printf("  [ -s level ]");
  printf("Hex format where level is: \n");
  printf("\t0\t- no spacing between bytes (for sendip)\n");
  printf("\t1\t- a single space between (default)\n");
  printf("\t2\t- comma between bytes i.e. 0x00,0x00 (for nasl)\n");
  printf("\t3\t- \\x style i.e. \\x00\\x00 (for python and C)\n");


  printf("\n");
  printf("  [ -l ] ");
  printf("Don't print link-layer headers");
  printf("\n");
  printf("  [ -n ] ");
  printf("Don't print network-layer headers");
  printf("\n");
  printf("  [ -t ] ");
  printf("Don't print transport-layer headers");
  printf("\n");
  printf("  [ -p ] ");
  printf("Don't print packet payloads\n");


  printf("  [ -r file ]\n");
  printf("Read tcpdump file\n");

  exit(1);
}

/*----------------------------------------------------------------------------
 *
 * free_args()
 *
 *----------------------------------------------------------------------------
 */

void free_args(struct arg_t *my_arg)
{
  if (my_arg->i != NULL) free(my_arg->i);
  free(my_arg);
}

/*----------------------------------------------------------------------------
 *
 * parse_cl()
 *
 *----------------------------------------------------------------------------
 */

struct arg_t *parse_cl(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  char c;
  struct arg_t *my_arg;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"count", 1, 0, 'c'},
    {"interface", 1, 0, 'i'},
    {"", 1, 0, 'b'},
    {"", 1, 0, 'p'},
    {"", 1, 0, 'l'},
    {"", 1, 0, 'n'},
    {"", 1, 0, 't'},
    {"", 1, 0, 'm'},
    {0, 0, 0, 0}
  };


  my_arg = (struct arg_t *) malloc (sizeof(struct arg_t));

  my_arg->i = NULL;
  my_arg->r = NULL;
  my_arg->x = 1;
  my_arg->X = 0;
  my_arg->j = 0;
  my_arg->b = 0;
  my_arg->p = 1;
  my_arg->l = 0;
  my_arg->n = 0;
  my_arg->t = 0;
  my_arg->m = 0;
  my_arg->s = 1;

  while ((c = getopt_long(argc, argv, "jXs:r:c:i:bplntmx", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'c':
          my_arg->c = atoi(optarg);
          if (my_arg->c < 1)
            {
              fprintf(stderr, "parameter range error: c must be >= 1\n");
              errflg ++;
            }
          break;

        case 's':
          my_arg->s = atoi(optarg);
          if (my_arg->s < 0)
            {
              fprintf(stderr, "parameter range error: s must be >= 1\n");
              errflg ++;
            }
          break;

        case 'i':
          my_arg->i = strdup(optarg);
          break;

        case 'r':
          my_arg->r = strdup(optarg);
          break;

        case 'x':
          my_arg->x++;
          break;

        case 'j':
          my_arg->X++;
	  my_arg->j++;
          break;

        case 'X':
          my_arg->x++;
          my_arg->x++;
          my_arg->X++;
          break;

        case 'b':
          my_arg->b++;
          break;

        case 'p':
          my_arg->p = 0;
          break;

        case 'l':
          my_arg->l ++;
          break;

        case 'n':
          my_arg->n ++;
          break;

        case 't':
          my_arg->t ++;
          break;

        case 'm':
          my_arg->m ++;
          break;

        default:
          usage(argv[0]);

        }
    } /* while */

    if (errflg)
      usage(argv[0]);

    if (!(my_arg))
      usage(argv[0]);

  my_arg->optind = optind;
  return my_arg;
}
