/**************************************************************************** 
** File: arp.c
**
** Author: Mike Borella
**
** Comments: Dump ICMP header information
**
** $Log: arp.c,v $
** Revision 1.2  1998/06/12 21:00:57  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "config.h"
#include "arp.h"

extern struct arg_t *my_args;
extern u_char *packet_end;

void dump_arp(u_char *bp, int length, int caplen)
{
	EtherARP *ap;
	u_short pro, hrd, op;
	struct in_addr spa, tpa;
	char *etheraddr_string(u_char *ep);
  
	// ARP header announcement

	if ( !my_args-> j)
		printf("[--- ARP\n");

	// Check for truncated packet
  
	ap = (EtherARP *) bp;
 	if (length < sizeof(EtherARP)) {
		printf("Truncated packet\n");
    	return;
    }

// Dump ARP header fields 

	hrd = ntohs(ap->ea_hdr.ar_hrd);
	pro = ntohs(ap->ea_hdr.ar_pro);
	op = ntohs(ap->ea_hdr.ar_op);

	if ( !my_args->X ) {
		printf("HW: %d  ", hrd);
		printf("PROTO: %d  ", pro);
		printf("OP: %d  ", op);

// Figure out type of ARP

	switch (op) {    

		case ARPOP_REQUEST:
    		printf("(REQUEST)\n");
      		break;
      
		case ARPOP_REPLY:
    		printf("(REPLY)\n");
      		break;
      
    	case ARPOP_RREQUEST:
    		printf("(RARP REQUEST)\n");
      		break;
      
    	case ARPOP_RREPLY:
    		printf("(RARP RARP)\n");
      		break;
      
    	default:
    		printf("(UNKNOWN)\n");

      return;

	}
  
// Dump hardware and IP addresses
  
	memcpy((void *) &spa, (void *) &ap->arp_spa, sizeof (struct in_addr));
	memcpy((void *) &tpa, (void *) &ap->arp_tpa, sizeof (struct in_addr));

	if ( ! my_args->X ) {
		printf("SRCHW: %s  ", etheraddr_string(ap->arp_sha));
		printf("SRCIP: %s  ", inet_ntoa(spa));
		printf("DSTHW: %s  ", etheraddr_string(ap->arp_tha));
		printf("DSTIP: %s\n", inet_ntoa(tpa));
 	} 
	}
}
