/**************************************************************************** 
** File: payload.c
**
** Author: Mike Borella
**
** Comments: Dump packet payload
**
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include "config.h"
#include "payload.h"

#define BUF_SIZE 128

extern u_char *packet_end;
extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_payload()
**
** Dump printable portions of packet payload
**
**----------------------------------------------------------------------------
*/

void dump_header (u_char *bp, int length)
{
	unsigned char *buf_ptr = bp;
	int i;

	for (i=0; i<length; i++) {
		if ( my_args->s == 3)
			 printf("\\x");

		if ( my_args->s == 2)
			 printf("0x");

		printf ("%.2X",*buf_ptr);
                
		if ( my_args->s == 2)
			printf(",");

		if ( my_args->s == 1 )
         	printf (" ");

		buf_ptr++;
	}                

	if (! my_args->j)
		printf ("\n");
}


void dump_payload(u_char *bp, int length)
{
	u_char *ep = bp + length;
	u_char *buf_ptr, *buf_end;
	int col;
	int i;
	char hexbuf[BUF_SIZE], charbuf[BUF_SIZE];


	// Make sure we don't run off the end of the packet

	if (ep > packet_end) 
	    ep = packet_end;

	if (! my_args->j)
		printf("\n[--- DATA\n");

	buf_ptr = bp;
	buf_end = ep;

	do {
		if ( my_args->s == 3)
 			printf("\\x");

		if ( my_args->s == 2)
 			printf("0x");

    	printf ("%.2X",*buf_ptr);

		if ( my_args->s == 1 )
         	printf (" ");

		if ( my_args->s == 2)
			printf(",");

    	 buf_ptr++;

	} while(buf_ptr < buf_end);

}
