/**************************************************************************** 
**
** File: tcp.c
**
** Author: Mike Borella
**
** Comments: Dump TCP header information.  TCP options section lifted from 
** tcpdump.
**
*****************************************************************************/

#include <stdio.h>
#include <arpa/inet.h>
#include <unistd.h>
#include "config.h"
#include "tcp.h"
#include "addrtoname.h"
#include "payload.h"

/*
 * TCP options
 */

#ifndef TCPOPT_WSCALE
#define TCPOPT_WSCALE           3       /* window scale factor (rfc1072) */
#endif
#ifndef TCPOPT_ECHO
#define TCPOPT_ECHO             6       /* echo (rfc1072) */
#endif
#ifndef TCPOPT_ECHOREPLY
#define TCPOPT_ECHOREPLY        7       /* echo (rfc1072) */
#endif
#ifndef TCPOPT_TIMESTAMP
#define TCPOPT_TIMESTAMP        8       /* timestamps (rfc1323) */
#endif

extern u_char *packet_end;
extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_tcp()
**
** Parse TCP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_tcp(u_char *bp, int length)
{
	TCPHdr *tp;
	u_char flags;
	int hlen, total_hlen;
	u_short sport, dport, win, urp;
	u_int seq, ack;

// Overlay TCP header

	tp = (TCPHdr *) bp;
  
// Dump TCP header announcement
  
  
	if (length < sizeof(TCPHdr)) {

		printf("Truncated TCP header: %d bytes\n", length);
		return;
    }

// Grab ports and some fields

	sport = ntohs(tp->th_sport);
	dport = ntohs(tp->th_dport);
	hlen = tp->th_off * 4;
	seq = ntohl(tp->th_seq);
	ack = ntohl(tp->th_ack);
	win = ntohs(tp->th_win);
	urp = ntohs(tp->th_urp);
	flags = tp->th_flags;

// Dump TCP header info

	if (!my_args->t && !my_args->X ) {

		if (!my_args->j)
			printf("\n[---- TCP\n");

		printf("SRC: %d ", sport);
		printf("DST: %d ", dport);
		printf("SEQ: %u ", seq);
		printf("ACK: %u ", ack);
		printf("HLEN: %d ", hlen);
		printf("FlAGS: ");
		if (flags & TH_SYN) printf("S");
		if (flags & TH_FIN) printf("F");
		if (flags & TH_RST) printf("R");
		if (flags & TH_PUSH) printf("P");
		if (flags & TH_ACK) printf("A");
		if (flags & TH_URG) printf("U");

		printf(" WIN: %d\n", win);
		printf("CSUM: %d\n", ntohs(tp->th_sum));

	}


	// Check header length

	if (hlen > length) {

		printf("none\nBad header length\n");
		return;

    }

	// Header length and payload length bookkeeping

	length -= hlen;
	total_hlen = hlen;

	// print payload if there is one

	if (my_args->x)
		dump_header(bp,hlen);


	if (my_args->p && length > 0) 
		dump_payload((u_char *) bp + total_hlen, length);

	return;

}
