/**************************************************************************** 
** File: udp.c
**
** Author: Mike Borella
**
** Comments: Dump UDP header information
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "config.h"
#include "udp.h"
#include "addrtoname.h"
#include "error.h"

extern u_char *packet_end;
extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_udp()
**
** Parse UDP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_udp(u_char *bp, int length)
{
	UDPHdr *up;
	u_char *ep = bp + length;
	u_short sport, dport, len;
	struct servent *se;
  
// Make sure we don't run off the end of the packet

	if (ep > packet_end) 
		ep = packet_end;

// Check for truncated packet

	if (length < sizeof(UDPHdr)) {
		printf("Truncated header, length = %d bytes\n", length);
    	return;
	}

  	up = (UDPHdr *) bp;
	sport = ntohs(up->uh_src);
	dport = ntohs(up->uh_dst);
	len = ntohs(up->uh_len);

	// Dump UDP header info
 
	if ( ! my_args->X) { 

		if ( !my_args->j)
			 printf("[--- UDP Header\n");

		if (!my_args->t) {  

			printf("SRC: %d ", sport);
			printf("DST: %d", dport);
			printf("LEN: %d", len);
			printf("CSUM: %d\n", ntohs(up->uh_chk));

		}
	}

  	if (my_args->x || my_args->X ) 
		dump_header(bp,sizeof(UDPHdr) );

// print payload if there is one

	if ( ( my_args->p || my_args->X) && len > 0) 
		dump_payload((u_char *) bp + sizeof(UDPHdr), len);

	return;
}
