/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ASCIIInputStream;
import net.wimpi.modbus.io.ASCIIOutputStream;
import net.wimpi.modbus.io.ModbusSerialTransport;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;

public class ModbusASCIITransport
implements ModbusSerialTransport {
    private InputStream m_InputStream;
    private OutputStream m_OutputStream;
    public static final int FRAME_START = 1000;
    public static final int FRAME_END = 2000;

    public void close() throws IOException {
        this.m_InputStream.close();
        this.m_OutputStream.close();
    }

    public void writeMessage(ModbusMessage modbusMessage) throws ModbusIOException {
        try {
            byte[] byArray = modbusMessage.getMessage();
            int n = this.getLRC(byArray, 0);
            this.m_OutputStream.write(1000);
            this.m_OutputStream.write(byArray);
            this.m_OutputStream.write(n);
            this.m_OutputStream.write(2000);
            this.m_OutputStream.flush();
        }
        catch (Exception exception) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    public ModbusRequest readRequest() throws ModbusIOException {
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataInputStream dataInputStream = null;
        ModbusRequest modbusRequest = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            while (true) {
                if ((n = this.m_InputStream.read()) != 1000) {
                    continue;
                }
                n3 = this.m_InputStream.read();
                if (ModbusCoupler.getReference().getUnitID() == n3) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream.write(n3);
                    n2 = this.m_InputStream.read();
                    byteArrayOutputStream.write(n2);
                    while ((n = this.m_InputStream.read()) != 2000) {
                        byteArrayOutputStream.write(n);
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (byArray[byArray.length - 1] == this.getLRC(byArray, 1)) {
                        dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 2, byArray.length - 1));
                        bl = true;
                    }
                }
                if (bl) break;
            }
            modbusRequest = ModbusRequest.createModbusRequest(n2, dataInputStream, true);
            modbusRequest.setUnitID(n3);
            return modbusRequest;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    public ModbusResponse readResponse() throws ModbusIOException {
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ModbusResponse modbusResponse = null;
        DataInputStream dataInputStream = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            while (true) {
                if ((n = this.m_InputStream.read()) != 1000) {
                    continue;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                n3 = this.m_InputStream.read();
                byteArrayOutputStream.write(n3);
                n2 = this.m_InputStream.read();
                byteArrayOutputStream.write(n2);
                while ((n = this.m_InputStream.read()) != 2000) {
                    byteArrayOutputStream.write(n);
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray[byArray.length - 1] == this.getLRC(byArray, 1)) {
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 2, byArray.length - 1));
                    bl = true;
                }
                if (bl) break;
            }
            modbusResponse = ModbusResponse.createModbusResponse(n2, dataInputStream, true);
            modbusResponse.setUnitID(n3);
            return modbusResponse;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    public void prepareStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.m_InputStream = new ASCIIInputStream(inputStream);
        this.m_OutputStream = new ASCIIOutputStream(outputStream);
    }

    private final int getLRC(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length - n) {
            n2 = (byte)(n2 + byArray[n3]);
            ++n3;
        }
        return -n2;
    }
}

