/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;

public class ModbusSerialTransaction
implements ModbusTransaction {
    private static int c_TransactionID = 0;
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private SerialConnection m_SerialCon;

    public ModbusSerialTransaction() {
    }

    public ModbusSerialTransaction(ModbusRequest modbusRequest) {
        this.setRequest(modbusRequest);
    }

    public ModbusSerialTransaction(SerialConnection serialConnection) {
        this.setSerialConnection(serialConnection);
    }

    public void setSerialConnection(SerialConnection serialConnection) {
        this.m_SerialCon = serialConnection;
        this.m_IO = serialConnection.getModbusTransport();
    }

    public int getTransactionID() {
        return c_TransactionID;
    }

    public void setRequest(ModbusRequest modbusRequest) {
        this.m_Request = modbusRequest;
        this.m_Response = modbusRequest.getResponse();
    }

    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    public void setCheckingValidity(boolean bl) {
        this.m_ValidityCheck = bl;
    }

    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    public int getRetries() {
        return this.m_Retries;
    }

    public void setRetries(int n) {
        this.m_Retries = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        ModbusTransport modbusTransport = this.m_IO;
        synchronized (modbusTransport) {
            this.m_IO.writeMessage(this.m_Request);
            this.m_Response = this.m_IO.readResponse();
        }
        if (this.m_Response instanceof ExceptionResponse) {
            throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
        }
        if (this.isCheckingValidity()) {
            this.checkValidity();
        }
        this.toggleTransactionID();
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_Response == null || this.m_SerialCon == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    private void checkValidity() throws ModbusException {
    }

    private void toggleTransactionID() {
        if (this.isCheckingValidity()) {
            c_TransactionID = c_TransactionID == 65534 ? 0 : ++c_TransactionID;
        }
        this.m_Request.setTransactionID(this.getTransactionID());
    }
}

