/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.IllegalFunctionRequest;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;

public class ModbusTCPTransport
implements ModbusTransport {
    private DataInputStream m_Input;
    private OutputStream m_Output;

    public ModbusTCPTransport(Socket socket) {
        try {
            this.setSocket(socket);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Socket not functional.");
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.prepareStreams(socket);
    }

    public void close() throws IOException {
        this.m_Input.close();
        this.m_Output.close();
    }

    public void writeMessage(ModbusMessage modbusMessage) throws ModbusIOException {
        try {
            modbusMessage.writeTo(this.m_Output);
            this.m_Output.flush();
        }
        catch (Exception exception) {
            throw new ModbusIOException("I/O exception - failed to write.");
        }
    }

    public ModbusRequest readRequest() throws ModbusIOException {
        try {
            int n = this.m_Input.readUnsignedShort();
            int n2 = this.m_Input.readUnsignedShort();
            int n3 = this.m_Input.readUnsignedShort();
            if (n2 != 0 || n3 > 256) {
                throw new ModbusIOException();
            }
            int n4 = this.m_Input.readUnsignedByte();
            int n5 = this.m_Input.readUnsignedByte();
            ModbusRequest modbusRequest = ModbusRequest.createModbusRequest(n5, this.m_Input, false);
            if (modbusRequest instanceof IllegalFunctionRequest) {
                int n6 = 0;
                while (n6 < n3 - 2) {
                    this.m_Input.readByte();
                    ++n6;
                }
            }
            modbusRequest.setTransactionID(n);
            modbusRequest.setProtocolID(n2);
            modbusRequest.setUnitID(n4);
            return modbusRequest;
        }
        catch (EOFException eOFException) {
            throw new ModbusIOException(true);
        }
        catch (SocketException socketException) {
            throw new ModbusIOException(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    public ModbusResponse readResponse() throws ModbusIOException {
        try {
            int n = this.m_Input.readUnsignedShort();
            int n2 = this.m_Input.readUnsignedShort();
            int n3 = this.m_Input.readUnsignedShort();
            int n4 = this.m_Input.readUnsignedByte();
            int n5 = this.m_Input.readUnsignedByte();
            ModbusResponse modbusResponse = ModbusResponse.createModbusResponse(n5, this.m_Input, false);
            if (modbusResponse instanceof ExceptionResponse) {
                int n6 = 0;
                while (n6 < n3 - 2) {
                    this.m_Input.readByte();
                    ++n6;
                }
            }
            modbusResponse.setTransactionID(n);
            modbusResponse.setProtocolID(n2);
            modbusResponse.setUnitID(n4);
            return modbusResponse;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ModbusIOException("I/O exception - failed to read.");
        }
    }

    private void prepareStreams(Socket socket) throws IOException {
        this.m_Input = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.m_Output = socket.getOutputStream();
    }
}

