/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import net.wimpi.modbus.msg.ModbusMessage;
import net.wimpi.modbus.util.ModbusUtil;

public abstract class ModbusMessageImpl
implements ModbusMessage {
    private int m_TransactionID = 0;
    private int m_ProtocolID = 0;
    private int m_DataLength;
    private int m_UnitID = 0;
    private int m_FunctionCode;
    private boolean m_Changed = true;
    private boolean m_Headless = false;
    protected ByteArrayOutputStream m_ByteOut = new ByteArrayOutputStream(256);
    protected DataOutputStream m_DataOut = new DataOutputStream(this.m_ByteOut);

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public void setHeadless() {
        this.m_Headless = true;
    }

    protected void setHeadless(boolean bl) {
        this.m_Headless = bl;
    }

    public int getTransactionID() {
        return this.m_TransactionID;
    }

    public void setTransactionID(int n) {
        this.m_TransactionID = n;
        this.setChanged(true);
    }

    public int getProtocolID() {
        return this.m_ProtocolID;
    }

    public void setProtocolID(int n) {
        this.m_ProtocolID = n;
        this.setChanged(true);
    }

    public int getDataLength() {
        return this.m_DataLength;
    }

    public void setDataLength(int n) {
        this.m_DataLength = n + 2;
    }

    public int getUnitID() {
        return this.m_UnitID;
    }

    public void setUnitID(int n) {
        this.m_UnitID = n;
        this.setChanged(true);
    }

    public int getFunctionCode() {
        return this.m_FunctionCode;
    }

    protected void setFunctionCode(int n) {
        this.m_FunctionCode = n;
        this.setChanged(true);
    }

    public int length() {
        return this.m_ByteOut.size();
    }

    public byte[] getMessage() {
        try {
            this.assembleMessage();
            return this.m_ByteOut.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public String getHexMessage() {
        return ModbusUtil.toHex(this.getMessage());
    }

    protected void assembleMessage() throws IOException {
        if (this.isChanged()) {
            this.m_ByteOut.reset();
            if (!this.isHeadless()) {
                this.m_DataOut.writeShort(this.getTransactionID());
                this.m_DataOut.writeShort(this.getProtocolID());
                this.m_DataOut.writeShort(this.getDataLength());
            }
            this.m_DataOut.writeByte(this.getUnitID());
            this.m_DataOut.writeByte(this.getFunctionCode());
            this.assembleData();
            this.m_DataOut.flush();
            this.setChanged(false);
        }
    }

    protected abstract void assembleData() throws IOException;

    protected abstract void readData(DataInputStream var1) throws EOFException, IOException;

    public void writeTo(OutputStream outputStream) throws EOFException, IOException {
        this.assembleMessage();
        try {
            this.m_ByteOut.writeTo(outputStream);
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    protected void setChanged(boolean bl) {
        this.m_Changed = bl;
    }

    protected boolean isChanged() {
        return this.m_Changed;
    }
}

