/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.IllegalFunctionRequest;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsRequest;
import net.wimpi.modbus.msg.ReadInputDiscretesRequest;
import net.wimpi.modbus.msg.ReadInputRegistersRequest;
import net.wimpi.modbus.msg.ReadMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteCoilRequest;
import net.wimpi.modbus.msg.WriteMultipleRegistersRequest;
import net.wimpi.modbus.msg.WriteSingleRegisterRequest;

public abstract class ModbusRequest
extends ModbusMessageImpl {
    public abstract ModbusResponse getResponse();

    public abstract ModbusResponse createResponse();

    public ModbusResponse createExceptionResponse(int n) {
        ExceptionResponse exceptionResponse = new ExceptionResponse(this.getFunctionCode(), n);
        if (!this.isHeadless()) {
            exceptionResponse.setTransactionID(this.getTransactionID());
            exceptionResponse.setProtocolID(this.getProtocolID());
        } else {
            exceptionResponse.setHeadless();
        }
        return exceptionResponse;
    }

    public static ModbusRequest createModbusRequest(int n, DataInputStream dataInputStream, boolean bl) throws IOException, EOFException {
        ModbusRequest modbusRequest = null;
        switch (n) {
            case 3: {
                modbusRequest = new ReadMultipleRegistersRequest();
                break;
            }
            case 2: {
                modbusRequest = new ReadInputDiscretesRequest();
                break;
            }
            case 4: {
                modbusRequest = new ReadInputRegistersRequest();
                break;
            }
            case 1: {
                modbusRequest = new ReadCoilsRequest();
                break;
            }
            case 16: {
                modbusRequest = new WriteMultipleRegistersRequest();
                break;
            }
            case 6: {
                modbusRequest = new WriteSingleRegisterRequest();
                break;
            }
            case 5: {
                modbusRequest = new WriteCoilRequest();
                break;
            }
            default: {
                modbusRequest = new IllegalFunctionRequest(n);
                modbusRequest.setHeadless(bl);
                return modbusRequest;
            }
        }
        modbusRequest.setHeadless(bl);
        modbusRequest.setFunctionCode(n);
        modbusRequest.readData(dataInputStream);
        return modbusRequest;
    }
}

