/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusMessageImpl;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.msg.ReadInputRegistersResponse;
import net.wimpi.modbus.msg.ReadMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteCoilResponse;
import net.wimpi.modbus.msg.WriteMultipleRegistersResponse;
import net.wimpi.modbus.msg.WriteSingleRegisterResponse;

public abstract class ModbusResponse
extends ModbusMessageImpl {
    protected void setMessage(byte[] byArray) {
        try {
            this.readData(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static ModbusResponse createModbusResponse(int n, DataInputStream dataInputStream, boolean bl) throws IOException, EOFException {
        ModbusResponse modbusResponse = null;
        switch (n) {
            case 3: {
                modbusResponse = new ReadMultipleRegistersResponse();
                break;
            }
            case 2: {
                modbusResponse = new ReadInputDiscretesResponse();
                break;
            }
            case 4: {
                modbusResponse = new ReadInputRegistersResponse();
                break;
            }
            case 1: {
                modbusResponse = new ReadCoilsResponse();
                break;
            }
            case 16: {
                modbusResponse = new WriteMultipleRegistersResponse();
                break;
            }
            case 6: {
                modbusResponse = new WriteSingleRegisterResponse();
                break;
            }
            case 5: {
                modbusResponse = new WriteCoilResponse();
                break;
            }
            default: {
                modbusResponse = new ExceptionResponse(n, 1);
                modbusResponse.setHeadless(bl);
                return modbusResponse;
            }
        }
        modbusResponse.setHeadless(bl);
        modbusResponse.setFunctionCode(n);
        modbusResponse.readData(dataInputStream);
        return modbusResponse;
    }
}

