/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadCoilsResponse;
import net.wimpi.modbus.procimg.DigitalOut;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadCoilsRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadCoilsRequest() {
        this.setFunctionCode(1);
        this.setDataLength(4);
    }

    public ReadCoilsRequest(int n, int n2) {
        this.setFunctionCode(1);
        this.setDataLength(4);
        this.setReference(n);
        this.setBitCount(n2);
    }

    public ModbusResponse getResponse() {
        ReadCoilsResponse readCoilsResponse = new ReadCoilsResponse(this.getBitCount());
        readCoilsResponse.setHeadless(this.isHeadless());
        return readCoilsResponse;
    }

    public ModbusResponse createResponse() {
        ReadCoilsResponse readCoilsResponse = null;
        DigitalOut[] digitalOutArray = null;
        ProcessImage processImage = ModbusCoupler.getReference().getProcessImage();
        try {
            digitalOutArray = processImage.getDigitalOutRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException illegalAddressException) {
            return this.createExceptionResponse(2);
        }
        readCoilsResponse = new ReadCoilsResponse(digitalOutArray.length);
        if (!this.isHeadless()) {
            readCoilsResponse.setTransactionID(this.getTransactionID());
            readCoilsResponse.setProtocolID(this.getProtocolID());
        } else {
            readCoilsResponse.setHeadless();
        }
        readCoilsResponse.setUnitID(this.getUnitID());
        readCoilsResponse.setFunctionCode(this.getFunctionCode());
        int n = 0;
        while (n < digitalOutArray.length) {
            readCoilsResponse.setCoilStatus(n, digitalOutArray[n].isSet());
            ++n;
        }
        return readCoilsResponse;
    }

    public void setReference(int n) {
        this.m_Reference = n;
        this.setChanged(true);
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int n) {
        this.m_BitCount = n;
        this.setChanged(true);
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    protected void assembleData() throws IOException {
        this.m_DataOut.writeShort(this.m_Reference);
        this.m_DataOut.writeShort(this.m_BitCount);
    }

    public void readData(DataInputStream dataInputStream) throws IOException, EOFException {
        this.m_Reference = dataInputStream.readUnsignedShort();
        this.m_BitCount = dataInputStream.readUnsignedShort();
    }
}

